//---------------------------------------------------------------------------
//	AVFile - library for audio and video files processing
//	2002 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	bmpfile.h
//	bmp files sequence reader and writer
//---------------------------------------------------------------------------

#ifndef _BMPFILE_H
#define _BMPFILE_H

#include <string>
#include "avfile.h"

class TBMPFile: public TAVFile
{
private:
	unsigned int ScanLineWidth, AlignedScanLineWidth;
	unsigned int Length, FrameInBuffer, BaseFileNumbers, StartNumber;
	std::string BaseFileName, BaseFileExtension;

	BITMAPINFO *Bitmap;
	BYTE *FrameBuffer;

	std::string GetFileName(unsigned int Position);

protected:
	void OpenA(const char *FileName, int Mode, int Type, bool ThrowExceptions);
	BITMAPINFO* DIBGetFrameA();
	BYTE* GetFrameA();
	void GetFrameA2(BYTE *Buffer);

public:
	TBMPFile();
	~TBMPFile();

	void Close();

	void PutFrame(BYTE *Buffer);
	unsigned int GetVideoLength();

	BITMAPINFO* ReadBMP(const char *FileName);
	bool WriteBMP(const char *FileName, BITMAPINFO *Bitmap);
};

#endif

