//---------------------------------------------------------------------------
//	AVFile - library for audio and video files processing
//	2002 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	avfile_utils.h
//---------------------------------------------------------------------------

#ifndef avfile_utilsH
#define avfile_utilsH

#include <vector>
#include "avfile.h"

//---------------------------------------------------------------------------
struct TAVFileDevice
{
	int Device;
	TAVFile::TDescription Description;
};
typedef std::vector<TAVFileDevice> TAVFileDeviceList;

//---------------------------------------------------------------------------
TAVFile* AVFileOpen(const char *FileName, int Type);
TAVFile* AVFileCreate(const char *FileName);

//---------------------------------------------------------------------------
TAVFileDeviceList AVFileGetDeviceList();
void AVFileSetDevicePriority(int Device, int Priority);
int AVFileGetDevicePriority(int Device);

#endif

