#include "stringTools/tokeniser.h"

using namespace stringTools;

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	tokeniser::tokeniser(std::istream *stream)
///
/// \brief	Constructor. 
////////////////////////////////////////////////////////////////////////////////////////////////////

tokeniser::tokeniser(std::istream *stream):
input(stream)
{

}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	bool tokeniser::getNextToken(strToken &token, long &numchar, long maxlength,
/// 	bool seekIfFailed)
///
/// \brief	Gets the next token from the stream. 
///
/// \param [out]	token	the token. 
/// \param [out]	numchar	the num of chars readed. 
/// \param	maxlength		The maximal data length. 
/// \param	seekIfFailed	true to seek back if reading has failed. 
///
/// \return	true if it succeeds, false if it fails. 
////////////////////////////////////////////////////////////////////////////////////////////////////

bool tokeniser::getNextToken(strToken &token, long &numchar, long maxlength, bool seekIfFailed){

	// no input is set
	if(!input)
		return false;

	// number of white characters, number of characters readed 
	long whites, readed = 0l;

	// string buffer
	std::string str("");

	// at first read white characters
	if(!readWhiteChars(whites, maxlength))
		return false;

	// char buffer
	int character;

	// get first character
	character = input->get();

	// process character
	while(testNum(readed, maxlength)&&(!input->eof())&&(!input->bad())){

		readed++;

		if(specialChars.isIn(character)){
			
			if(readed == 1){
				// special char is our token
				token.data = character;
				numchar = readed + whites;
				return true;
			}else{
				//special character is next token
				input->putback(character);
				token.data = str;
				numchar = readed + whites - 1;
				return true;
			}
		}

		if(whiteChars.isIn(character)){
			
			// white character was readed before, so str is longer than zero
			input->putback(character);
			token.data = str;
			numchar = readed + whites - 1;
			return true;
		}

		str += character;

		// get next character
		character = input->get();

	}

	numchar = readed + whites;

	// is readed string longer then 0?
	if(str.length() > 0){
		token.data = str;
		return true;
	}

	return false;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	bool tokeniser::readWhiteChars(long &numchar, long maxlength)
///
/// \brief	Read white characters from stream beginning. 
///
/// \param [out]	numchar	the num of char readed. 
/// \param	maxlength		The maximal length. 
///
/// \return	true if it succeeds, false if it fails. 
////////////////////////////////////////////////////////////////////////////////////////////////////

bool tokeniser::readWhiteChars(long &numchar, long maxlength){


	if(!input)
		return false;

	numchar = 0l;
	long readed = 0l;

	int character;

	while(testNum(readed, maxlength)&&(!input->bad())&&(!input->eof())){

		character = input->get();
		
		if(!whiteChars.isIn(character)){

			// nonwhite character readed
			input->putback(character);
			numchar = readed;
			return true;
		}

		// white character passed
		readed++;
	}

	return !input->bad();
}
