/******************************************************************************
	Http form encapsulation
******************************************************************************/
#include "curlTools/form.h"

using namespace comm;

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	void curlForm::addVariable(const std::string & name, const char * data, const long length)
///
/// \brief	Adds a variable to the form. 
///
/// \param	name	The name. 
/// \param	data	The data. 
/// \param	length	The length of data. 
////////////////////////////////////////////////////////////////////////////////////////////////////

void curlForm::addVariable(const std::string & name, const char * data, const long length){

	curl_formadd(&formpost,
		&lastptr,
		CURLFORM_COPYNAME, name.c_str(), 
		CURLFORM_COPYCONTENTS, data,
		CURLFORM_CONTENTSLENGTH, length,
		CURLFORM_END);
}

