#include <curlTools/CCurlShared.h>

using namespace comm;

namespace comm
{
namespace curlTools
{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \fn	void lockFunc(CURL *handle, curl_lock_data data, curl_lock_access access,void *useptr )
	///
	/// \brief	Locking function. 
	///
	/// \param [in]	handle	If non-null, the handle of curl interface to be locked. 
	/// \param	data		The data. 
	/// \param	access		The access. 
	/// \param [in]	useptr	If non-null, the user data pointer. 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	void lockFunc(CURL *handle, curl_lock_data data, curl_lock_access access,void *useptr )
	{
		CCurlShared * si = ( CCurlShared * )( useptr );

		if( si == NULL )
			return;


	}

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \fn	void unlockFunc(CURL *handle, curl_lock_data data, void *useptr )
	///
	/// \brief	Unlockin function. 
	///
	/// \param [in]	handle	If non-null, the handle of the curl interface that should be unlocked. 
	/// \param	data		The data. 
	/// \param [in]	useptr	If non-null, the user data pointer. 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	void unlockFunc(CURL *handle, curl_lock_data data, void *useptr )
	{
		CCurlShared * si = ( CCurlShared * )( useptr );

		if( si == NULL )
			return;



	}

} // namespace curlTools
} // namespace comm

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	CCurlShared::CCurlShared()
///
/// \brief	Default constructor. 
////////////////////////////////////////////////////////////////////////////////////////////////////

CCurlShared::CCurlShared()
: handle(NULL)
{
	m_lock.lock();

	handle = curl_share_init();
	assert(handle != NULL);

	// Set sharing options
	CURLSHcode rv = curl_share_setopt(handle, CURLSHOPT_SHARE, CURL_LOCK_DATA_COOKIE );
	assert( rv == CURLSHE_OK );

	m_lock.unlock();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	CCurlShared::~CCurlShared()
///
/// \brief	Destructor. 
////////////////////////////////////////////////////////////////////////////////////////////////////

CCurlShared::~CCurlShared()
{
	curl_share_cleanup(handle);
}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	void CCurlShared::init()
///
/// \brief	Initialises locking functions. 
////////////////////////////////////////////////////////////////////////////////////////////////////

void CCurlShared::init()
{
	m_lock.lock();

	// Set locking function data
	CURLSHcode rv = curl_share_setopt(handle, CURLSHOPT_USERDATA, this );
	rv = curl_share_setopt(handle, CURLSHOPT_USERDATA, this );
	assert( rv == CURLSHE_OK );

	// Set locking function
	rv = curl_share_setopt(handle, CURLSHOPT_LOCKFUNC, &lockFunc );
	assert( rv == CURLSHE_OK );

	// Set unlocking function
	rv = curl_share_setopt(handle, CURLSHOPT_UNLOCKFUNC, &unlockFunc );
	assert( rv == CURLSHE_OK );

	m_lock.unlock();
}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	void CCurlShared::release()
///
/// \brief	Deinitialises locking functions. 
////////////////////////////////////////////////////////////////////////////////////////////////////

void CCurlShared::release()
{
	m_lock.lock();

	// Set locking function data
	CURLSHcode rv = curl_share_setopt(handle, CURLSHOPT_USERDATA, NULL );
	assert( rv == CURLSHE_OK );

	// Set locking function
	rv = curl_share_setopt(handle, CURLSHOPT_LOCKFUNC, NULL );
	assert( rv == CURLSHE_OK );

	// Set unlocking function
	rv = curl_share_setopt(handle, CURLSHOPT_UNLOCKFUNC, NULL );
	assert( rv == CURLSHE_OK );

	m_lock.unlock();
}

