/******************************************************************************
	\brief Header parsing module
******************************************************************************/
#include <comm/hmodule.h>
#include <sstream>

using namespace comm;

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	size_t CHeaderParser::parse(char * data, std::size_t length)
///
/// \brief	Parses header. 
///
/// \param [in]	data	If non-null, the data. 
/// \param	length		The length of the data buffer. 
///
/// \return	parsed length. 
////////////////////////////////////////////////////////////////////////////////////////////////////

size_t CHeaderParser::parse(char * data, std::size_t length) 
{
	tHPLock Lock( *this );

	// Create string from allocated data
	std::string buffer(data, length);

	// create stream from string
	std::stringstream str(buffer);

	// Initialize reader
	parser->setInput(&str);

	// Parse as much as possible
	while(parser->readLine( header_map ));

	return length;
} // parse

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	void CHeaderCreator::setValue(const std::string & parameter, const std::string & value,
/// 	bool bModeAppend )
///
/// \brief	Sets (adds) header line. 
///
/// \param	parameter	The parameter. 
/// \param	value		The value. 
/// \param	bModeAppend	true to mode append. 
////////////////////////////////////////////////////////////////////////////////////////////////////

void CHeaderCreator::setValue(const std::string & parameter, const std::string & value, bool bModeAppend /* = false*/)
{
	// Try to find parameter
	tParameterMap::iterator i( parameter_map.find(parameter) );

	if(i != parameter_map.end())
	{
		// if found append or set value
		if(bModeAppend)
		{
			parameter_map[parameter] = parameter_map[parameter] + ", " + value;
		}else{
			parameter_map[parameter] = value;
		}

	}else{
		// else insert new parameter
		parameter_map.insert(std::make_pair(parameter, value));	
	}

} // setValue

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	CSlist * CHeaderCreator::generateHeader()
///
/// \brief	Generates a header from obtained parameters.. 
///
/// \return	null if it fails, else the header. 
////////////////////////////////////////////////////////////////////////////////////////////////////

CSlist * CHeaderCreator::generateHeader()
{

	CSlist * slist( new CSlist );

	// if no information in map, generate NULL
	if(parameter_map.size() == 0)
		return NULL;

	// else get all info 
	tParameterMap::iterator i;
	for(i = parameter_map.begin(); i != parameter_map.end(); ++i)
	{

		slist->addValue(i->first + " : " + i->second);
	}

	// add info in slist
	return slist;

}
