/******************************************************************************
	\brief Data transfers module
******************************************************************************/
#include <comm/dtmodule.h>

using namespace comm;

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	CReceiverInfo::CReceiverInfo()
///
/// \brief	Default constructor. 
////////////////////////////////////////////////////////////////////////////////////////////////////

CReceiverInfo::CReceiverInfo() :
	m_receiverTypeID( -1 ),
	m_receiver( NULL )
{

}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	CReceiverInfo::CReceiverInfo( long typeID, CReceiver * receiver )
///
/// \brief	Constructor - from type id and receiver. 
///
/// \param	typeID				Identifier for the type. 
/// \param [in,out]	receiver	If non-null, the receiver. 
////////////////////////////////////////////////////////////////////////////////////////////////////

CReceiverInfo::CReceiverInfo( long typeID, CReceiver * receiver ) :
	m_receiverTypeID( typeID ),
	m_receiver( receiver )
{

}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	CReceiverInfo::CReceiverInfo( CReceiver * receiver )
///
/// \brief	Constructor. 
///
/// \param [in,out]	receiver	If non-null, the receiver. 
////////////////////////////////////////////////////////////////////////////////////////////////////

CReceiverInfo::CReceiverInfo( CReceiver * receiver ) :
	m_receiverTypeID( -1 ),
	m_receiver( receiver )
{

}


