/******************************************************************************
	\brief Connections implementation
******************************************************************************/
#include <comm/connections.h>
#include <sstream>

using namespace comm;

#define DEFAULT_TIMEOUT 5l

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	void CToStreamConnection::setOutputStream( std::ostream &stream )
///
/// \brief	Sets an output stream. 
///
/// \param [in,out]	stream	the stream. 
////////////////////////////////////////////////////////////////////////////////////////////////////

void CToStreamConnection::setOutputStream( std::ostream &stream )
{
	CStdOStreamReceiver * receiver = dynamic_cast< CStdOStreamReceiver * >( m_dtinfo.m_receiver );

	if( receiver != 0 )
		receiver->setStream( stream );
	else
	{
		// Compose error info
		std::string strError("setOutputStream: Wrong stream type." );
		// Error - unknown content type
		MDS_SINGLETON( CErrorHandler ).cbError( new CErrorInfo( CErrorInfo::ET_OTHER, CErrorInfo::EP_LOG_AND_CALL, 0, strError, "CFileToStreamConnection" ) );

	}
}

