/******************************************************************************
	\file

	\brief Tokeniser
******************************************************************************/   
#ifndef TOKENISER_H_INCLUDED
#define TOKENISER_H_INCLUDED

#include "stringTools/CSettings.h"
#include <cstring>
#include <istream>

namespace stringTools{

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \class	Token template
	///
	/// \brief	Token. 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	template<class tokensClass> class token{

	public:
		tokensClass data; 
	}; // class token

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \typedef	token<std::string> strToken
	///
	/// \brief	String token type.
	////////////////////////////////////////////////////////////////////////////////////////////////////

	typedef token<std::string> strToken;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \class	tokeniser
	///
	/// \brief	Tokeniser - reads input stream and gets tokens. 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	class tokeniser{

	public:
		//! Constructor - insert input stream
		tokeniser(std::istream * stream = NULL);

		//! Get one token from stream. 
		bool getNextToken(strToken &token, long &numchar, long maxlength = -1, bool seekIfFailed = true);

		//! Add white character to tokeniser
		void addWhiteChar(const char white){
			whiteChars.add(white);
		}

		//! Add multiple white characters to tokeniser
		void addWhiteChars(const char white[], int count){
			whiteChars.add(white, count);
		}

		//! Add special character to tokeniser
		void addSpecialChar(const char special){
			specialChars.add(special);
		}

		//! Add multiple special characters to tokeniser
		void addSpecialChars(const char special[], int count){
			specialChars.add(special, count);
		}

		//! Read white characters from stream beginning, numchar - number of parsed characters, maxlength - maximum characters to read
		bool readWhiteChars(long &numchar, long maxlength = -1);

		//! Set input stream
		void setInput(std::istream *is){
			input = is;
		};

		//! Set string to lower characters
		static std::string toLower(std::string &str)
		{
			for (unsigned int i=0;i<strlen(str.c_str());i++)
				if (str[i] >= 0x41 && str[i] <= 0x5A)
					str[i] = str[i] + 0x20;
		
			return str;
		}
	protected:
		//! input stream
		std::istream *input;

		//! Reading function on input std::istream
		bool istreamReadFunction(int & character){
			character = input->get();

			return (!input->eof())&&(!input->bad());
		}

		//! white characters
		stringTools::charSet whiteChars;

		//! special characters
		stringTools::charSet specialChars;

		//! returns true, if num is smaller then max, or if max == -1
		bool testNum(const long num, const long max){

			if(max == -1)
				return true;

			if(num < max)
				return true;

			return false;
		}

	}; // class tokeniser


}; // namespace stringTools

#endif // TOKENISER_H_INCLUDED
