#ifndef CSETTINGS_HPP_INCLUDED
#define CSETTINGS_HPP_INCLUDED

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	template<class comparable> bool comparablesSet<comparable>::isIn(const comparable &p)
///
/// \brief	Query if paramerer 'p' is comparable with data. 
///
/// \typeparam	comparable data type. 
/// \param	p	The compared data. 
///
/// \return	true if in, false if not. 
////////////////////////////////////////////////////////////////////////////////////////////////////

template<class comparable> bool comparablesSet<comparable>::isIn(const comparable &p){

	return data.count(p) != 0;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	template<class comparable> void comparablesSet<comparable>::add(const comparable &p)
///
/// \brief	Adds data member to the set.
///
/// \author	Wik
/// \date	15.12.2009
///
/// \typeparam	comparable data type. 
/// \param	p	The stored data. 
////////////////////////////////////////////////////////////////////////////////////////////////////

template<class comparable> void comparablesSet<comparable>::add(const comparable &p){

	data.insert(p);
}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	template<class comparable> void comparablesSet<comparable>::add(const comparable *data,
/// 	int count)
///
/// \brief	Add multiple data members.
///
/// \typeparam	comparable	Data element type. 
/// \param	data	The data. 
/// \param	count	Number of elements. 
////////////////////////////////////////////////////////////////////////////////////////////////////

template<class comparable> void comparablesSet<comparable>::add(const comparable *data, int count){

			if(data != NULL)
				for(int i = 0; i < count; i++)
					add(data[i]);
}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	template<class comparable> void comparablesSet<comparable>::remove(const comparable &p)
///
/// \brief	Remove data member.
///
/// \typeparam	comparable	Data element type. 
/// \param	p	The data element that will be removed. 
////////////////////////////////////////////////////////////////////////////////////////////////////

template<class comparable> void comparablesSet<comparable>::remove(const comparable &p){

	if(isIn(p))
		data.erase(p);
}

#endif // CSETTINGS_HPP_INCLUDED


