/******************************************************************************
	\brief Comparable elements set
******************************************************************************/
#ifndef CSETTINGS_H_INCLUDED
#define CSETTINGS_H_INCLUDED

#include <set>
#include <string>

namespace stringTools{

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \class	comparablesSet
	///
	/// \brief	Comparables set. 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	template<class comparable> class comparablesSet{

	public:
		//! Is parameter in set?
		bool isIn(const comparable &p);

		//! Add data member.
		void add(const comparable &p);

		//! Add multiple data members.
		void add(const comparable *data, int count);

		//! Remove data member.
		void remove(const comparable &p);

	protected:
		//! Data set.
		std::set<comparable> data;

	}; //class comparablesSet

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \typedef	comparablesSet<char> charSet
	///
	/// \brief	Comparables set - chars.
	////////////////////////////////////////////////////////////////////////////////////////////////////

	typedef comparablesSet<char> charSet;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \typedef	comparablesSet<std::string> stringSet
	///
	/// \brief	Comparables set - strings.
	////////////////////////////////////////////////////////////////////////////////////////////////////

	typedef comparablesSet<std::string> stringSet;

// Include method bodies
#include "CSettings.hpp"

}; // namespace stringTools



#endif // CSETTINGS_H_INCLUDED

