/******************************************************************************
	\brief Curl slist encapsulation
******************************************************************************/
#ifndef SLIST_H_INCLUDED_
#define SLIST_H_INCLUDED_

#include <curl/curl.h>

namespace comm{

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \class	CSlist
	///
	/// \brief	Curl slist encapsulation
	////////////////////////////////////////////////////////////////////////////////////////////////////

	class CSlist{

	public:

		//! Constructor
		CSlist()
			: slist(NULL)
		{

		}

		//! Free slist data
		void free()
		{
			if(slist != NULL)
				curl_slist_free_all(slist);

			slist = NULL;
		}

		//! Add value to slist
		void addValue(const std::string & value)
		{
			slist = curl_slist_append(slist, value.c_str());
		}

		//! Get slist
		curl_slist * getSlist()
		{

			return slist;
		}


		//! Destructor
		~CSlist()
		{
			free();
		}

	protected:
		//! curl slist pointer
		struct curl_slist * slist;

	}; // class CSlist

} // namespace comm

//SLIST_H_INCLUDED_
#endif
