/******************************************************************************
	\brief Http header encapsulation
******************************************************************************/
#ifndef HEADER_H_INCLUDED
#define HEADER_H_INCLUDED

#include <istream>
#include <string>
#include <map>
#include <vector>
#include "stringTools/CSettings.h"
#include "stringTools/tokeniser.h"

// Smart pointers
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsSharedPtr.h>

namespace comm
{


	//! Header parameter values map - parameter + its value
	typedef std::vector< std::string > tParametersVector;

	//! Header map - header + its parameters ( with values )
	typedef std::map< std::string, tParametersVector > tHeaderMap;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \class	CHeaderReader
	///
	/// \brief	Header reader. 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	class CHeaderReader :
		public mds::base::CObject
	
	{
	public:
		//! Smart pointer type
		//! - declares type tPointer
		MDS_SHAREDPTR(CHeaderReader);

		//! Constructor
		CHeaderReader(std::istream * input = NULL, long maxlength = -1);

		//! Destructor
		virtual ~CHeaderReader();

		//! Set input stream
		void setInput(std::istream * input, long size = -1){
			in = input;
			tokeniser.setInput(in);
			remains = maxCount = size;
		}

		//! Read line, or read to line end.
		bool readLine( tHeaderMap & map );

		//! Get number of remaining characters
		long getRemaining(){
			return remains;
		}

		void resetRemaining(){
			remains = 0l;
		}

	protected:
		//! Initialize tokeniser
		void initTokeniser();

		//! Read value - part after the ":" 
		bool readValues( tParametersVector & values );

		//! Read header name
		bool readHeader(std::string &attribute);

		

		//! Read next token and compare it to given string
		bool compareNextToken(const std::string &str);

		//! Reads tokens from istream.
		stringTools::tokeniser tokeniser;

		//! Maximal length to read
		long maxCount;

		//! Remaining count of characters we can read
		long remains;

		//! Input stream
		std::istream *in;

	}; // class headerReader

	typedef CHeaderReader::tSmartPtr CHeaderReaderPtr;

	//! Set string to lower characters
	//std::string toLower(std::string &str); 

} // namespace comm

#endif // HEADER_H_INCLUDED
