/******************************************************************************
	\brief Http form encapsulation
******************************************************************************/
#ifndef FORM_H_INCLUDED
#define FORM_H_INCLUDED

#include "curlTools/CCurl.h"
#include <MDSTk/Base/mdsSharedPtr.h>
#include <string>

namespace comm{

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \class	curlForm
	///
	/// \brief	Http form encapsulation
	////////////////////////////////////////////////////////////////////////////////////////////////////

	class curlForm :
		public mds::base::CObject
	{
	public:
		//! Smart pointer type
		//! - declares type tPointer
		MDS_SHAREDPTR(curlForm);

	public:
		//! Constructor
		curlForm( bool _delete = true ):
		formpost(NULL), lastptr(NULL), shouldDelete( _delete )	//, headerlist(NULL)
		{


		}

		//! Destructor
		~curlForm(){		}

		//! Add string variable
		void addVariable(const std::string & name, const std::string & data, const long length);

		//! Add buffer variable
		void addVariable(const std::string & name, const char * data, const long length);

		//! Get curl form pointer
		curl_httppost * getForm() const {return formpost;} 

	protected:
		struct curl_httppost *formpost;
		struct curl_httppost *lastptr;
		bool shouldDelete;
		//struct curl_slist *headerlist;

	}; // class curlForm

	typedef curlForm CForm;

	typedef curlForm::tSmartPtr CFormPtr; 

} // namespace comm

#endif // FORM_H_INCLUDED
