/******************************************************************************
	\brief Curl option encapsulation
******************************************************************************/
#ifndef CURL_OPTIONS_H_INCLUDED_
#define CURL_OPTIONS_H_INCLUDED_


#include <curlTools/CCurl.h>
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsSharedPtr.h>
#include <string>
#include <map>

namespace comm
{

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \class	CCurlOptionBase
///
/// \brief	Curl option encapsulation - base object. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class CCurlOptionBase :
	public mds::base::CObject

{
public:
	//! Smart pointer type
	//! - declares type tPointer
	MDS_SHAREDPTR(CCurlOptionBase);

	//! Constructor
	CCurlOptionBase() {}
	
	//! Option code
	CURLoption m_optionCode;
	
	//! Apply method
	virtual void apply( CCurl & curl ) {}
};

//! Smart pointer type
typedef CCurlOptionBase::tSmartPtr CCurlOptionBasePtr;

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \class	CCurlOptionLong
///
/// \brief	Curl option long. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class CCurlOptionLong :
	public CCurlOptionBase
{
public:
	//! Smart pointer type
	//! - declares type tPointer
	MDS_SHAREDPTR(CCurlOptionLong);

	//! Constructor
	CCurlOptionLong( const CURLoption & code, const long & value ) :
		m_optionValue( value )
		{
			m_optionCode = code;
		}

	//! Apply method
	virtual void apply( CCurl & curl )
	{
		curl.setopt( m_optionCode, m_optionValue );
	}
	
	//! Value 
	long m_optionValue;
};

//! Smart pointer type
typedef CCurlOptionLong::tSmartPtr CCurlOptionLongPtr;

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \class	CCurlOptionPtrVoid
///
/// \brief	Curl option - void pointer. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class CCurlOptionPtrVoid :
	public CCurlOptionBase
{
public:
	//! Smart pointer type
	//! - declares type tPointer
	MDS_SHAREDPTR(CCurlOptionPtrVoid);

	//! Constructor
	CCurlOptionPtrVoid( const CURLoption & code, void * value ) :
		m_optionValue( value )
		{
			m_optionCode = code;
		}

	//! Apply method
	virtual void apply( CCurl & curl )
	{
		curl.setopt( m_optionCode, m_optionValue );
	}
	
	//! Value
	void * m_optionValue;
};

//! Smart pointer type
typedef CCurlOptionPtrVoid::tSmartPtr CCurlOptionPtrVoidPtr;

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \class	CCurlOptionString
///
/// \brief	Curl option string. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class CCurlOptionString :
	public CCurlOptionBase
{
public:
	//! Smart pointer type
	//! - declares type tPointer
	MDS_SHAREDPTR(CCurlOptionString);

	//! Constructor
	CCurlOptionString( const CURLoption & code, const std::string value ) :
		m_optionValue( value )
		{
			m_optionCode = code;
		}

	//! Apply method
	virtual void apply( CCurl & curl )
	{
		curl.setopt( m_optionCode, m_optionValue.c_str() );
	}
	
	//! Value
	std::string m_optionValue;
};

//! Smart pointer type
typedef CCurlOptionString::tSmartPtr CCurlOptionStringPtr;

} // namespace comm

// CURL_OPTIONS_H_INCLUDED_
#endif

