/******************************************************************************
	\brief Curl multi interface encapsulation.
******************************************************************************/
#ifndef CURLMULTI_H_INCLUDED
#define CURLMULTI_H_INCLUDED

#include "curlTools/curlEasy.h"
#include <map>

namespace comm
{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \class	CCurlMulti
	///
	/// \brief	Curl multi interface encapsulation. 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	class CCurlMulti : public CCurl{

		//! Map of CCurl objects.
		typedef std::map<long, CCurlEasy *> ccurlMap;


	public:

		//! Constructor
		CCurlMulti();

		//! Add easy interface to multi
		long addCE();

		//! Get interface
		CCurlEasy * getCE(long id);

		//! remove CCurlEasy with given id
		void removeCE(long id);

		//! Perform operation
		virtual bool perform();

		//! stop all operations
		virtual void stop();

		//! reset interface
		virtual bool reset();

		//! Curl callback multi interface addons
		virtual void setCurlCallback(CURLoption cbType, tCurlCallback callback = NULL);

	protected:

		//! Map of easy CURL objects - used with multi interface.
		ccurlMap connections;
		//! Counter
		long idCounter;

	};

} // namespace comm

#endif // CURLMULTI_H_INCLUDED

