/******************************************************************************
	\brief Curl easy interface encapsulation
******************************************************************************/
#ifndef CURLEASY_H_INCLUDED
#define CURLEASY_H_INCLUDED

#include "curlTools/CCurl.h"
#include "curlTools/form.h"

namespace comm{

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \class	CCurlEasy
	///
	/// \brief	Curl easy interface encapsulation. 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	class CCurlEasy : public CCurl{

	public:
		//! Constructor
		CCurlEasy();

		//! Perform operation
		virtual bool perform();

		//! stop all operations
		virtual void stop();

		//! reset interface
		virtual bool reset();

		//! Set URL.
		bool setUrl(const std::string & url);

		//! Get used URL
		std::string getUrl();

		//! Set name and password
		bool setNamePasswd(const std::string &name, const std::string &passwd);

		//! Set curl to upload mode
		void modeUpload();

		//! Set curl to download mode
		void modeDownload();

		//! Prepare for form sending (perform must be then called).
		void setForm(const curlForm * form);

        //! Set cookie data
        void setCookie(const std::string & cookie);

        //! Set cookie file (enables internal cookie parser too!).
        void setCookieFile(const std::string & cookieFileName = std::string(""));


	protected:
		//! Currently used URL address
		std::string sUrl;

		//! Currently used name::pwd
		std::string sNP;

		//! Transfer stage type
		typedef enum{
			TRANSFER_STAGE_UNKNOWN,
			TRANSFER_STAGE_STARTED,
			TRANSFER_STAGE_COMPLETED
		} eTransferStage;

		//! Get current stage
		eTransferStage getStage()
		{
			return transferStage;
		};

		friend class CCurlMulti;		

		//! Transfer stage
		eTransferStage transferStage;

	}; // class CCurlEasy

} // namespace comm

#endif // CURLEASY_H_INCLUDED
