/******************************************************************************
	\brief Shared curl interface encapsulation
******************************************************************************/
#ifndef CCURLSHARED_H_INCLUDED_
#define CCURLSHARED_H_INCLUDED_

#include <curl/curl.h>
#include <MDSTk/Base/mdsLock.h>
#include <MDSTk/System/mdsMutex.h>

namespace comm{

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \class	CCurlShared
	///
	/// \brief	Curl shared interface encapsulation. 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	class CCurlShared : 
		public mds::base::CLockableObject<CCurlShared>,
		public mds::base::CObject
	{
	public:
		//! Smart pointer type
		//! - declares type tPointer
		MDS_SHAREDPTR(CCurlShared);

		//! Constructor
		CCurlShared();

		//! Destructor
		virtual ~CCurlShared();

		//! Initialize locking functions
		void init();

		//! Deinitialize locking functions
		void release();

		CURLSH * getHandle() { return handle; }

	protected:
		//! Curl internal handle
		CURLSH * handle;

		friend class CCurl;

		//! Lock
		mds::sys::CMutex m_lock,
						 m_lockNone,
						 m_lockData,
						 m_lockDNS,
						 m_lockCookies,
						 m_lockSSL,
						 m_lockConnect,
						 m_lockLast;

		//! Locking function
		friend void lockFunc(CURL *handle, curl_lock_data data, curl_lock_access access, void *useptr );

		//! Unlocking function
		friend void unlockFunc(CURL *handle, curl_lock_data data, void *useptr );

	}; // class CSharedCurl

	//! Shared ptr type
	typedef CCurlShared::tSmartPtr CCurlSharedPtr;

	//! Locking function
	void lockFunc(CURL *handle, curl_lock_data data, curl_lock_access access, void *useptr);

	//! Unlocking function
	void unlockFunc(CURL *handle, curl_lock_data data, void *useptr);

} // namespace comm


// CCURLSHARED_H_INCLUDED_
#endif
