/******************************************************************************
	\brief Worker thread
******************************************************************************/
#ifndef VCE_WORKER_H
#define VCE_WORKER_H

#include <MDSTk/System/mdsUserThread.h>
#include <MDSTk/Base/mdsGlobalLog.h>
#include <MDSTk/System/mdsSleep.h>

#include <VCE/comm/commLib/vceManager.h>
#include <VCE/comm/commLib/errorHandler.h>


namespace comm
{

//==============================================================================
/*!
 * Thread processing jobs.
 * - Please, remember to define a default constructor without parameters
 *   for the class Local! 
 */ 
template <class Local>
class CWorker : public mds::sys::CUserThread
{
public:
    //! Templates expecting a parameter derived from the CWorker class
    //! can check existence of this value.
    enum { CLASS_WORKER };

    //! Thread-specific local data.
    typedef Local tLocalData;

public:
    //! Constructor
    //! - Creates a new thread-specific local data.
    CWorker(CManager &Manager)
        : mds::sys::CUserThread(NULL, false)   // Thread stoji
        , m_Manager(Manager)
        , m_NotRunning(true, true)      // Manual reset
    {
       resume(); // Thread bezi
    }

    //! Thread entry point.
    virtual int entry()
    {

#ifdef _WIN32
	//SetThreadAffinityMask(GetCurrentThread(), 1); 
#endif // _WIN32

        while( !isExitSignalled() )
        {
            CJob *pJob = m_Manager.getJob();
            if( !pJob )
            {

                // wait a minute...
                mds::sys::sleep(10);

                continue;
            }

            m_NotRunning.reset();

            if( !pJob->process(&m_LocalData) )
            {
  				MDS_SINGLETON( CErrorHandler ).cbError( new CErrorInfo( CErrorInfo::ET_OTHER, CErrorInfo::EP_LOG_AND_CALL, 0, "Error processing job", "CWorker::entry()" ) );
            }

            delete pJob;    

            m_NotRunning.set();

            // Give a chance to other threads
            mds::sys::sleep(0);
        }
        return 0;
    }

	virtual int reinit()
	{
		return m_LocalData.reinit();
	}

    //! Returns reference to the thread-specifi data.
    tLocalData& getLocalData() { return m_LocalData; }

    //! Is the thread working?
    bool isRunning() { return m_NotRunning.isSet(); }

    //! Waits for finish
    bool waitForFinish() { return m_NotRunning.wait(); }

protected:
    //! Local thread-specific data
    tLocalData m_LocalData;

    //! Jobs manager
    CManager &m_Manager;

    //! Thread is stopped/running event
    mds::sys::CEvent m_NotRunning;
};


} // namespace comm

#endif // VCE_WORKER_H
