#ifndef STDSTREAMDT_H_INCLUDED_
#define STDSTREAMDT_H_INCLUDED_

#include "dtmodule.h"
#include "MDSTk/Base/mdsLock.h"
#include <MDSTk/Base/mdsSetup.h>

namespace comm
{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \property	template< class tpStream > class CStdStreamReceiver : public CReceiver,
	/// 			public mds::base::CLockableObject< CStdStreamReceiver< tpStream > >
	///
	/// \brief	 the recever saves data to the given stream 
	/// \param tpStream output stream type
	////////////////////////////////////////////////////////////////////////////////////////////////////

	template<
		class tpStream
	> 
	class CStdStreamReceiver : 
		public CReceiver,
		public mds::base::CLockableObject< CStdStreamReceiver< tpStream > >
	{
	public:
		//! Smart pointer type
		//! - declares type tPointer
		MDS_SHAREDPTR(CStdStreamReceiver);

		//! Lock type
		typedef typename mds::base::CLockableObject< CStdStreamReceiver< tpStream > >::CLock tSSRLock;

		//! Constructor
		CStdStreamReceiver()
			: stream(NULL)
		{

		}

		//! Create method
		static CReceiver * create()
		{
			return new CStdStreamReceiver;
		}

		//! Receive data
		virtual std::size_t receive(char * data, std::size_t length)
		{
			if(stream == NULL)
				return 0;

			
			tSSRLock Lock( *this );
			stream->write(data, length);

			return length;
		}

		//! Set stream
		void setStream(tpStream * _stream)
		{
			stream = _stream;
		}

		//! Set stream
		void setStream(tpStream & _stream)
		{
			stream = & _stream;
		}

		//! Get stream
		tpStream * getStream()
		{
			return stream;
		}

	protected:
		//! Stream to write
		tpStream * stream;


	}; // class CStdStreamReceiver

	typedef CStdStreamReceiver< std::ostream > CStdOStreamReceiver;
	typedef CStdStreamReceiver< std::ostream >::tSmartPtr CStdOStreamReceiverPtr;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \property	template< class tpStream > class CStdStreamDispatcher : public CDispatcher,
	/// 			public mds::base::CLockableObject< CStdStreamDispatcher< tpStream > >
	///
	/// \brief	 the stream dispatacher sends data from the input stream
	/// \param tpStream input stream type
	////////////////////////////////////////////////////////////////////////////////////////////////////

	template<
		class tpStream
	> 
	class CStdStreamDispatcher : 
		public CDispatcher,
		public mds::base::CLockableObject< CStdStreamDispatcher< tpStream > >
	{
	public:
		//! Smart pointer type
		//! - declares type tPointer
		MDS_SHAREDPTR(CStdStreamDispatcher);

		//! lock type
		typedef typename mds::base::CLockableObject< CStdStreamDispatcher< tpStream > >::CLock tSSDLock;

		//! Constructor
		CStdStreamDispatcher()
			: stream(NULL), maxLength(0), position(0)
		{

		}

		//! Constructor
		CStdStreamDispatcher( tpStream * stream, size_t length = 0, size_t position = 0)
			: stream( stream ), maxLength( length ), position( position )
		{
			assert( stream != NULL );
		}


		//! Dispatch data
		virtual std::size_t dispatch(char * data, std::size_t length)
		{
			if(stream == NULL)
				return 0;

			if(length == 0)
				return 0;


			tSSDLock Lock( *this );
			stream->read(data, length);

			return stream->gcount();
		}

		//! Set stream
		void setStream(tpStream * _stream, size_t _maxLength = 0)
		{
			stream = _stream;
			maxLength = _maxLength;
			position = 0;
		}

		//! Set stream
		void setStream(tpStream & _stream, size_t _maxLength = 0)
		{
			stream = & _stream;
			maxLength = _maxLength;
			position = 0;
		}

		//! Get stream
		tpStream * getStream()
		{
			return stream;
		}

		static CDispatcher * create()
		{
			return new CStdStreamDispatcher< tpStream >;
		}

	protected:
		//! Stream to read
		tpStream * stream;

		//! Length of data
		size_t maxLength;

		//! Current position in transfer
		size_t position;


	}; // class CDispatcher

	typedef CStdStreamDispatcher< std::istream > CStdIStreamDispatcher;
	typedef CStdStreamDispatcher< std::istream >::tSmartPtr CStdIStreamDispatcherPtr;

} // namespace comm

// STDSTREAMDT_H_INCLUDED_
#endif
