#ifndef NETSTREAM_H_INCLUDED_
#define NETSTREAM_H_INCLUDED_

#include <iostream>
#include <sstream>
#include <MDSTk/Base/mdsLock.h>
#include <MDSTk/Module/mdsSignal.h>

namespace comm
{

	/**

	*/
	class CNetStream :
		public mds::base::CLockableObject< CNetStream >
	
	{
	
	public:
		//! Lock type
		typedef mds::base::CLockableObject< CNetStream >::CLock tNSLock;

		//! Type of signal
		typedef mds::mod::CSignal<long, CNetStream *> netsSignal;

		//! Write data.
		void write(char * data, unsigned long size)
		{
			tNSLock Lock( *this );

			if(stream)
				stream.write(data, size);

			signal.invoke(this);
		}

		//! Read data
		void read(char * data, unsigned long size)
		{
			if(!stream)
				return;

			tNSLock Lock( *this );
			stream.read(data, size);

		}

		//! Get count of bytes readed in last operation
		size_t gcount()
		{
			return stream.gcount();
		}

		//! Can I read something so long?
		bool canRead(unsigned long size)
		{
			return stream.str().size() >= size;
		}

		//! Clear stream.
		void clearStream()
		{
			tNSLock Lock( *this );

			// restore stream
			stream.clear();
			stream.seekg(std::ios_base::beg);
			stream.seekp(std::ios_base::beg);
		}

		//! Get stream.
		std::stringstream & getStream()
		{
			lock();
			return stream;
		}

		//! Release stream
		void releaseStream()
		{
			unlock();
		}

		//! Get signal.
		netsSignal & getSignal()
		{
			return signal;
		}

	protected:
		//! Stream.
		std::stringstream stream;

		//! Signal.
		netsSignal signal;
	
	}; // class CNetStream

} // namespace comm

// NETSTREAM_H_INCLUDED_
#endif
