/******************************************************************************
	\brief Local thread data
******************************************************************************/
#ifndef VCE_LOCAL_H
#define VCE_LOCAL_H

#include <MDSTk/Base/mdsSetup.h>


namespace comm
{

//==============================================================================
/*!
 * Local thread-specific data.
 * - Default constructor without parameters must be defined
 *   for all derived classes!
 */ 
class CLocal
{
public:
    //! Templates expecting a parameter derived from the CLocal class
    //! can check existence of this value.
    enum { CLASS_LOCAL };
    
    // Nastavovane parametry
    //typedef mds::base::tNull tParams;

public:
    //! Virtual destructor
    virtual ~CLocal() {}
    
    //! Re-initializaes all the internal data
    virtual int reinit() = 0; 
    
	//! Finalize   	
	virtual bool cancel() = 0;
    
    //! Return true, if thread is cancelled
    virtual bool isCanceled() = 0;
};


} // namespace comm

#endif // VCE_LOCAL_H
