#ifndef VCE_JOB_H
#define VCE_JOB_H

#include <MDSTk/Base/mdsGlobalLog.h>

#include "vceLocal.h"


namespace comm
{
////////////////////////////////////////////////////////////////////////////////////////////////////
/// \enum	EJobError
///
/// \brief	Error codes definition. 
////////////////////////////////////////////////////////////////////////////////////////////////////

enum EJobError
{
    //! Job is ok
	JOB_OK              = 0,

    //! Base processing error
    CANNOT_PROCESS_JOB  = 1,
    
    //! Connection errors
    CONNECTION_TIMEOUT  = 200,
    ERROR_404,
    BAD_FORMAT
};

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \class	CJob
///
/// \brief	Job base class. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class CJob
{
public:
    //! Virtual destructor!
    virtual ~CJob() {}

    //! Clones job
    virtual CJob *clone() = 0;

	//! Compares jobs
    virtual bool checkIdentity(CJob *pJob) = 0;

    //! This method is called by processing thread
    virtual bool process(CLocal *pLocal) = 0;

	//! Called by thread when job is done. Job must not be processed (i.e. when connection has faild...)
	virtual void done()
    {
        MDS_LOG_NOTE("CJob::done() called");
    }

    //! Job error handling
    virtual void error(int Code)
    {
        MDS_LOG_NOTE("CJob::error(): Code = " << Code);
    }
};


} // namespace comm

#endif // VCE_JOB_H
