/******************************************************************************
	\brief Error handler 
******************************************************************************/
#ifndef errorHandler_H_included
#define errorHandler_H_included

#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Base/mdsSingleton.h>
//#include <MDSTk/Base/mdsGlobalLog.h>
#include <MDSTk/Base/mdsLog.h>
#include <MDSTk/Module/mdsSignal.h>
#include <MDSTk/Base/mdsSharedPtr.h>

namespace comm
{
	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \class	CErrorInfo
	///
	/// \brief	Information about the error. 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	class CErrorInfo :
		public mds::base::CObject
	{
	public:
		//! Smart pointer type
		//! - declares type tPointer
		MDS_SHAREDPTR(CErrorInfo);

		//! What to do
		enum eProcessingRoutine
		{
			EP_ONLY_LOG,
			EP_LOG_AND_CALL,
			EP_LOG_AND_EXIT
		};

		//! Type of error
		enum eErrorType
		{
			ET_CONNECTION,
			ET_OTHER
		};


		//! Constructor
		CErrorInfo( eErrorType type, 
					eProcessingRoutine processingType = EP_LOG_AND_CALL, 
					long code = 0, 
					std::string description = std::string(""), 
					std::string caller = std::string("") 
				   );

		//! How to process error...
		eProcessingRoutine m_process;

		//! Error type
		eErrorType m_type;

		//! Error code
		long m_code;

		//! String data - caller info
		std::string m_caller;

		//! String data - description
		std::string m_dataString;

	}; // class CErrorInfo

	//-------------------------------------------
	// Smart pointer on info
	typedef CErrorInfo::tSmartPtr CErrorInfoPtr;

	////////////////////////////////////////////////////////////////////////////////////////////////////
	/// \class	CErrorHandler
	///
	/// \brief	Error handler. 
	////////////////////////////////////////////////////////////////////////////////////////////////////

	class CErrorHandler :
		public mds::base::CLibrarySingleton
	{
	public:
		//! Smart pointer type
		//! - declares type tPointer
		MDS_SHAREDPTR(CErrorHandler);

		//! Error distribution signal
		typedef mds::mod::CSignal< void, CErrorInfo * > tSigError;

		//! Constructor
		CErrorHandler();

		//! Error handling callback. Null pointer means exit!!!
		void cbError( CErrorInfo * error );

		//! Write info macro


		//! Error distribution signal
		tSigError m_sigError;

		//! Enable or disable LOG
		void useLog( bool bUse ) { m_useLog = bUse; }

		//! Set log file name
		void setLogName( const std::string & name );

	protected:
		//! Log entry
		void log( CErrorInfo * error );

		//! Call
		void call( CErrorInfo * error );

		//! Log object
		mds::base::CLog m_log;

		//! Is logging enabled?
		bool m_useLog;

		//! Registered channel
		mds::base::CLogChannelFStreamPtr m_channel;

	}; // class CErrorHandler

}; // namespace comm


// errorHandler_H_included
#endif

