/******************************************************************************
	\brief receiver, dispatcher, headerdt information in the one structure
******************************************************************************/
#ifndef CURLDTINFO_H_INCLUDED_
#define CURLDTINFO_H_INCLUDED_

#include <comm/dtmodule.h>
#include <curlTools/header.h>

namespace comm
{
////////////////////////////////////////////////////////////////////////////////////////////////////
/// \class	CDTInfoBase
///
/// \brief	Data transfer information class base. 
////////////////////////////////////////////////////////////////////////////////////////////////////

class CDTInfoBase
{
public:
	//! Progress stage
	enum eProgressStage
	{
		STAGE_WAITING = 0,
		STAGE_HEADER = 1,
		STAGE_DATA = 2
	};

	//! Connection errors enum
	enum eConnectionErrors
	{
		ALL_OK = 0,
		ERROR_CURL = 1,
		ERROR_CONTENT_TYPE = 2
	};

	//! Default constructor
	CDTInfoBase() :
		m_receiver( 0 ),
		m_dispatcher( 0 ),
		m_headerParser( 0 ),
		m_cancelEvent( 0 ),
		m_stage( STAGE_WAITING ),
		m_error( 0 )
	{

	}

	//! Receiver 
	CReceiver * m_receiver;

	//! Dispatcher
	CDispatcher * m_dispatcher;

	//! Header parser
	CHeaderParser * m_headerParser;

	//! Cancel event
	mds::sys::CEvent * m_cancelEvent;

	//! Test completed header - do you want this data?
	virtual bool testHeader() = 0;

	//! Prepare all for transfer
	virtual void onTransferStart()
	{
		m_dispatcher->onTransferStart();
		m_receiver->onTransferStart( );
		m_stage = STAGE_HEADER;
	}

	//! Tidy up
	virtual void onTransferEnd()
	{
		m_stage = STAGE_WAITING;
		m_receiver->onTransferEnd();
		m_dispatcher->onTransferEnd();
	}

	//! Current stage
	eProgressStage m_stage;

	//! Error code
	int m_error;
};

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \class	CDTInfo
///
/// \brief	Data transfer information - implements header testing by content-type
///
/// \author	Wik
/// \date	15.12.2009
////////////////////////////////////////////////////////////////////////////////////////////////////

class CDTInfo :
	public CDTInfoBase
{
public:
	//! Test header - compare content type
	virtual bool testHeader()
	{
		if( m_contentType != "" )
		{
			tParametersVector * line (m_headerParser->findValue( "content-type" ) );

			if( line == NULL )
			{
				// ERROR - content type not set
				return false;
			}

			// convert line to lower
			std::string ctype = stringTools::tokeniser::toLower( (*line)[ 0 ] );
			std::string etype = stringTools::tokeniser::toLower( m_contentType );

			return ctype == etype;
		}
		
		return true;
	}

	//! Content type
	std::string m_contentType;
	
};

} // namespace comm

// CURLDTINFO_H_INCLUDED_
#endif
