/******************************************************************************
	\brief Connections
******************************************************************************/
#ifndef CONNECTIONS_H_INCLUDED_
#define CONNECTIONS_H_INCLUDED_

#include <comm/connection.h>
#include <comm/stdstreamdt.h>
#include <comm/bufferdt.h>

namespace comm
{
////////////////////////////////////////////////////////////////////////////////////////////////////
/// \class	CToStreamConnection
///
/// \brief	Connection example - all received data are written to the output stream

////////////////////////////////////////////////////////////////////////////////////////////////////

class CToStreamConnection :
	public CConnection< CNullDispatcher, CStdOStreamReceiver >
{
public:
	//! Set output stream
	virtual void setOutputStream( std::ostream & stream );

	//! Download data
	int download() { return perform() ? CDTInfo::ALL_OK : CDTInfo::ERROR_CURL; }

}; // class CFileToStreamConnection


} // namespace comm


#endif

