/******************************************************************************
	Testing interface 
******************************************************************************/
#include <comm/connections.h>
#include <sstream>

////////////////////////////////////////////////////////////////////////////////////////////////////
/// \fn	int main( int argc, char * argv[] )
///
/// \brief	Main entry-point for this application. 
///
/// \param	argc	Number of command-line arguments. 
/// \param	argv	Array of command-line argument strings. 
///
/// \return	Exit-code for the process - 0 for success, else an error code. 
////////////////////////////////////////////////////////////////////////////////////////////////////
int main( int argc, char * argv[] )
{

	// Write to the stream connection. 
	comm::CToStreamConnection connection;

	// Connection parameters object
	comm::CConnectionParams params;

	// Set url
	params.setURL( "www.google.cz" ); 

	// Copy parameters to the connection
	connection.setParams( params );

	// Set output stream - save response to the stdout
	connection.setOutputStream( std::cout );

	// Perform operation - download data
	connection.download();

	// Reinitialize connection
	connection.reinit();

	// Perform operation - download data again
	connection.download();

	// Wait for the key press
	system( "PAUSE" );
	
	return 0;
}
