
#include <stdio.h>
#include <opencv/cv.h>
#include <opencv/highgui.h>
//#include "vplconfig.h"
#include "vplcore.h"


void vplCvtColorRGB2IOO( CvMat * src, CvMat * dst )
{
	uchar * _src, * _dst;
	int i, j;
	if( !src || !dst ) return;
	if( !CV_ARE_SIZES_EQ( src, dst ) ) return;
	if( CV_MAT_TYPE( src->type ) != CV_8UC3 ) return;
	if( CV_MAT_TYPE( dst->type ) != CV_8UC3 ) return;

	for( j = 0; j < src->rows; ++j )
	{
		_src = src->data.ptr + j*src->step;
		_dst = dst->data.ptr + j*dst->step;
		for( i = 0; i < src->cols; _src += 3, _dst += 3, ++i )
		{
			_dst[0] = (uchar)(( _src[0] + _src[1] +   _src[2] ) / 3);
			_dst[1] = (uchar)(( _src[0] + _src[1] - 2*_src[2] ) / 4 + 127.5 );
			_dst[2] = (uchar)(( _src[0] + _src[2] - 2*_src[1] ) / 4 + 127.5 );
		}
	}
	return;
}


void cvMatPrint( CvMat * mat, struct CvMatPrintFormat matPrintFormat )
{
	CV_FUNCNAME( "cvMatPrint" );
	__BEGIN__
	
	//struct CvMatPrintFormat _mpf, * mpf = matPrintFormat;
	struct CvMatPrintFormat * mpf = &matPrintFormat;

	if( !mat ) return;

	//if( !mpf )
	//{
	//	_mpf = cvMatPrintFormat();
	//	mpf = &_mpf;
	//}
	if( strlen(mpf->format) <= 0 )
	{
		//mpf->format = mpf->_format;
        switch( CV_MAT_TYPE( mat->type ) ) {                
			case CV_8U:  sprintf( mpf->format, "%%u%s", mpf->separator ); break;
            case CV_8S:  sprintf( mpf->format, "%%c%s",  mpf->separator ); break;
            case CV_16U: sprintf( mpf->format, "%%ud%s", mpf->separator ); break;
            case CV_16S: sprintf( mpf->format, "%%d%s",  mpf->separator ); break;
            case CV_32S: sprintf( mpf->format, "%%d%s",  mpf->separator ); break;
            case CV_32F: sprintf( mpf->format, "%%f%s",  mpf->separator ); break;
            case CV_64F: sprintf( mpf->format, "%%lf%s", mpf->separator ); break;
            case CV_USRTYPE1: break;
            default: assert(0); EXIT;
        }
	} 

#define cvMatPrintCore( mat, elemType ) { int i, j;							\
	for( j = 0; j < (mat).rows; ++j ) { for( i = 0; i < (mat).cols; ++i ) {		\
		fprintf( mpf->output, mpf->format, *(elemType *)CV_MAT_ELEM_PTR( (mat), j, i ) );				\
	}	fprintf( mpf->output, "\n" ); } }

    switch( CV_MAT_TYPE( mat->type ) ) {                
		case CV_8U:  cvMatPrintCore( *mat, unsigned char ); break;
        case CV_8S:  cvMatPrintCore( *mat, char ); break;
        case CV_16U: cvMatPrintCore( *mat, unsigned short ); break;
        case CV_16S: cvMatPrintCore( *mat, short ); break;
        case CV_32S: cvMatPrintCore( *mat, int ); break;
        case CV_32F: cvMatPrintCore( *mat, float ); break;
        case CV_64F: cvMatPrintCore( *mat, double ); break;
        case CV_USRTYPE1: break;
        default: assert(0); EXIT;
    }


	__END__
}


void vplColorsRand( CvScalar * colors, int count )
{
	int i;
	CvRNG rng_state = cvRNG(-1);
	for( i = 0; i < count; ++i )
		colors[i] = CV_RGB( cvRandInt(&rng_state)%255, cvRandInt(&rng_state)%255, cvRandInt(&rng_state)%255 );
}

static char __string_buffer_sub[__string_buffer_len];
char * strsub( char * src, char pattern, int start, int end, char * dst )
{
	char * pos[__string_buffer_len];
	int n = 0;
	if( !src || strlen(src) >= __string_buffer_len ) return dst;
	strcpy( __string_buffer_sub, src );
	dst = __string_buffer_sub;
	pos[n] = __string_buffer_sub;
	while( pos[n] != '\0' && ( pos[n+1] = strchr( pos[n]+1, (int)pattern ) ) ) n++;
	pos[++n] = __string_buffer_sub+strlen(__string_buffer_sub);
	if( start < 0 ) start = n + start;
	if( end <= 0 ) end = n + end;
	if( start >= end ) { strcpy( dst, "" ); return dst; }
	*pos[end] = '\0';
	strcpy( dst, pos[start]+(start>0) );
	return dst;
}


CvSeq * vplDbSeqFloatToInt( CvSeq * seq, double scale, double shift )
{
    CvSeqReader rdr;
	register int i, j, count;
	float * pt;

	CV_FUNCNAME( "vplDbSeqFloatToInt" );
	__BEGIN__

	if( !seq ) return NULL;

	count = (int)(seq->elem_size/sizeof(float));	
	cvStartReadSeq( seq, &rdr, 0 );
	for( i = 0; i < seq->total; ++i )
	{
		pt = (float *)rdr.ptr;
		for( j = 0; j < count; ++j, ++pt )
			*(int *)pt = cvRound( *pt * scale + shift + 0.5 );
		CV_NEXT_SEQ_ELEM( rdr.seq->elem_size, rdr );
	}

	__END__
	return seq;
}



int vplPathCreate( char * path )
{
    char win_abs=0;
    char linux_abs=0;
    char *temp;
    char win_drive;
    int result = 1; //it is default value (return value from function)

    int split_position = -1;
	#define _FRAGMENTS_COUNT 128
	int		_fragments_pos=0;
	char *	_fragments[_FRAGMENTS_COUNT];

	char current_dir[1024]="";
	int fi, g, a, i;

    char *xpath = (char *) malloc(strlen(path)+10);
	memset(xpath,0,strlen(path)+10);
    strcpy(xpath,path);
    
    if(strlen(path)<2)
    {
	    free(xpath);
		return 0;
    }
    if(path[1]==':')
    {//it is windows absolute path
		win_abs=1;
		temp = xpath+3;
		win_drive = path[0];
    }else
    {
		if(path[0]=='/' || path[0]=='\\')
		{
			linux_abs=1;
			temp = xpath+1;
		}else
			temp = xpath;
	}

	for(fi=0;fi<_FRAGMENTS_COUNT;fi++)
	{
		_fragments[fi] = (char*)malloc(1024);
		memset(_fragments[fi],0,1024);
	}

    while(strlen(temp)>0)
    {
		for( i=0;i<(int)strlen(temp);i++ )
        {
    	    if(temp[i] == '/' || temp[i] == '\\')
			{
				split_position=i;
				break;
			}
	    
		}
		if(split_position != -1)
		{
			//cerr << "temp: " << temp <<endl;
			temp[split_position]='\0';
			//cerr << "check\n"<< split_position<<endl;
			if(temp[0]!='\0')
			{
				if(_FRAGMENTS_COUNT>_fragments_pos)
					memcpy(_fragments[_fragments_pos++],temp,strlen(temp));

			}
			//cerr << temp <<endl;
			temp=&temp[split_position+1];
			split_position = -1;
		}else
		{
			if(temp[0]!='\0')
			{
				if(_FRAGMENTS_COUNT>_fragments_pos)
					memcpy(_fragments[_fragments_pos++],temp,strlen(temp));
			}
			break;
		}
	
    }
    for(g=0;g<_fragments_pos;g++)
    {
		//cout << _fragments[g] << endl;
    }
	
    getcwd(current_dir,1024);
    //cout << current_dir <<endl;
    
    if(win_abs)
    {
		char win_base[] = "c:\\";
		win_base[0] = win_drive;
		if (chdir(win_base) !=0)
			result = 0;
    }
    if(linux_abs)
    {
		if ( chdir("/") != 0 )
			result = 0;
    }
    
 	//do the rest in c-like functions
    for(a=0; a<_fragments_pos && result!=0 ;a++)
    {
		int mr;
		//first try to change dir
		int cr = chdir(_fragments[a]);
		if(cr == 0)
			continue; //all OK
		    
		//now try to create dir	
		#ifdef _WIN32
		mr = mkdir(_fragments[a]);
		#else
		mr = mkdir(_fragments[a],0777);
		#endif
		if(mr != 0)
		{
			result = 0;
			break;
		}else
		{
			int cr = chdir(_fragments[a]);
			if(cr != 0)
			{
				result = 0;
				break;
			}
		}
    }
    
    //change dir back
	chdir(current_dir);
    free(xpath);
	//free buffers
	for(fi=0;fi<_FRAGMENTS_COUNT;fi++)
		free(_fragments[fi]);
	return result; //1 - all OK, 0 - error occurs}
}



void showProgress( const char * wndname, char * text, double val, int rows, int cols )
{
	int bs;
	CvSize fs;
	char buff[64];
	CvMat * canvas = cvCreateMat( rows, cols, CV_8UC3 );
	CvFont font;

	cvInitFont( &font, CV_FONT_HERSHEY_SIMPLEX, 0.7, 0.7, 0., 1, CV_AA );

	cvRectangle( canvas, cvPoint(0,0), cvPoint(canvas->cols-1,canvas->rows-1), CV_RGB(20,20,100), CV_FILLED, 8, 0 );
	cvRectangle( canvas, cvPoint(0,0), cvPoint(cvFloor(canvas->cols*val),canvas->rows-1), CV_RGB(70,70,200), CV_FILLED, 8, 0 );
	cvRectangle( canvas, cvPoint(0,0), cvPoint(canvas->cols-1,canvas->rows-1), CV_RGB(200,200,200), 2, 8, 0 );
	sprintf( buff, "%s %.2f%%", text, 100.*val );
	cvGetTextSize( buff, &font, &fs, &bs );
	cvPutText( canvas, buff, cvPoint((canvas->cols-fs.width)/2, (canvas->rows+fs.height)/2), &font, CV_RGB(190,190,250) );
	cvNamedWindow( wndname, 1 );
	cvShowImage( wndname, canvas );
	cvReleaseMat( &canvas );
}	


void showGraph( const char * wndname, CvMat * data, int rows, int cols )
{
	int i;
	double miv, mav;
	double dh, dw;
	CvMat * canvas = cvCreateMat( rows, cols, CV_8UC3 );
	CvFont font;
	char buff[64];

	cvInitFont( &font, CV_FONT_HERSHEY_SIMPLEX, 0.5, 0.5, 0., 1, CV_AA );

	cvZero( canvas );
	cvMinMaxLoc( data, &miv, &mav, 0, 0, 0 );
	dh = 1.*canvas->rows/((mav-miv)?(mav-miv):1.);
	dw = 1.*canvas->cols/data->cols;

	for( i = 0; i < data->cols; ++i )
		cvRectangle( canvas, cvPoint(cvFloor(dw*i),canvas->rows), cvPoint(cvFloor(dw*(i+1)),canvas->rows-cvFloor(dh*(cvGet2D(data,0,i).val[0]-miv))), CV_RGB(150,50,50), CV_FILLED, 8, 0 );
	//cvLine( canvas, cvPoint(0,canvas->rows-cvFloor(dh*(-miv))), cvPoint(canvas->cols, canvas->rows-cvFloor(dh*(-miv))), CV_RGB(250,250,250), 1, 8, 0 );

	sprintf( buff, "Min[%f] Max[%f]", miv, mav );
	cvPutText( canvas, buff, cvPoint(20,20), &font, CV_RGB(250,250,250) );

	cvNamedWindow( wndname, 1 );
	cvShowImage( wndname, canvas );
	cvReleaseMat( &canvas );
}	



CvMat * cvMatInt2Float( CvMat * mat )
{
	CvMat src, dst;
	if( !mat ) return mat;

	cvConvert( cvInitMatHeader( &src, mat->rows, mat->cols, CV_32SC1, mat->data.ptr, CV_AUTOSTEP ), 
			   cvInitMatHeader( &dst, mat->rows, mat->cols, CV_32FC1, mat->data.ptr, CV_AUTOSTEP ) );

	//cvInitMatHeader( mat, mat->rows, mat->cols, CV_32FC1, mat->data.ptr, CV_AUTOSTEP );
	cvMatRetype( mat, CV_32FC1 );	//mat->type = CV_MAT_MAGIC_VAL | (mat->rows == 1 || mat->step == mat->cols*CV_ELEM_SIZE(CV_32FC1) ? CV_MAT_CONT_FLAG : 0) | CV_32FC1;

	return mat;
}