#include <stdio.h>
#include "cv.h"

#include "vplcore.h"

#include "vplWndPatch.h"



struct cWndPatch * wndPatchCreate( int size, double sigma )
{
	struct cWndPatch * wp = NULL;
	wp = (cWndPatch  *)malloc( sizeof( cWndPatch ) );

	wp->g = cvCreateMat( size, size, CV_32FC1 );					// Gaussian window
	wp->p = cvCloneMat( wp->g );									// data patch
	wp->r = cvCloneMat( wp->g );									// data result
	cvZero( wp->g );
	wp->g->data.fl[ (size+1)*(size/2) ] = 1.;
	cvSmooth( wp->g, wp->g, CV_GAUSSIAN, size, size, sigma, sigma );

	wp->size = size;

	return wp;
}

int wndPatchRelease( struct cWndPatch ** wndPatch )
{
	struct cWndPatch * wp;
	if( !wndPatch || !*wndPatch ) return 1;

	wp = *wndPatch;
	if( wp->g ) cvReleaseMat( &wp->g );
	if( wp->p ) cvReleaseMat( &wp->p );
	if( wp->r ) cvReleaseMat( &wp->r );
	free( wp );
	*wndPatch = NULL;

	return 1;
}


CvMat * wndPatchGet( struct cWndPatch * wndPatch, CvMat * src, CvPoint c, double scale )
{
	CvMat sub;
	cvGetSubRect( src, &sub, cvRect( c.x-wndPatch->size/2, c.y-wndPatch->size/2, wndPatch->size, wndPatch->size ) );
	cvMul( &sub, wndPatch->g, wndPatch->p, scale );
	return wndPatch->p;
}

CvMat * wndPatchGetSubPix( struct cWndPatch * wndPatch, CvMat * src, CvPoint2D32f c, double scale )
{
	cvGetRectSubPix( src, wndPatch->p, c );
	cvMul( wndPatch->p, wndPatch->g, wndPatch->p, scale );
	return wndPatch->p;
}

CvMat * wndPatchRot( struct cWndPatch * wndPatch, double angle )
{
	float rdata[6];
	CvMat rot = cvMat( 2, 3, CV_32FC1, rdata );
	cv2DRotationMatrix( cvPoint2D32f( 0.5*wndPatch->size, 0.5*wndPatch->size ), angle, 1.0, &rot );
	cvWarpAffine( wndPatch->p, wndPatch->r, &rot, CV_WARP_FILL_OUTLIERS, cvScalarAll(0) );
	return wndPatch->r;
}

CvMat * wndPatchSubPixAdd( struct cWndPatch * wndPatch, CvMat * dst, CvPoint base, CvPoint2D32f offset, double angle, double scale )
{
	float rdata[6];
	CvMat sub;
	CvMat rot = cvMat( 2, 3, CV_32FC1, rdata );

	cv2DRotationMatrix( cvPoint2D32f( 0.5*wndPatch->size, 0.5*wndPatch->size ), angle, 1.0, &rot );
	rdata[2] += offset.x;
	rdata[5] += offset.y;

	cvWarpAffine( wndPatch->p, wndPatch->r, &rot, CV_INTER_NN+CV_WARP_FILL_OUTLIERS, cvScalarAll(0) );

	cvGetSubRect( dst, &sub, cvRect( base.x-wndPatch->size/2, base.y-wndPatch->size/2, wndPatch->size, wndPatch->size ) );
	cvAddWeighted( &sub, 1.0, wndPatch->r, scale, 0.0, &sub ); 

	return wndPatch->r;
}

