#ifndef _VPL_SLIDES_H_
#define _VPL_SLIDES_H_

#include "cv.h"
#include <libxml/tree.h>

#ifdef __cplusplus
extern "C" {
#endif


//typedef struct cLocals
//{
//	int type;					// feature type
//	CvMat ftrs;					// reference to the sequence with features
//	int srcID;
//} cLocals;
//static struct cLocals localsInit( int type, int srcID, CvMat ftrs ) { struct cLocals l; l.type = type; l.srcID=srcID; l.ftrs = ftrs; return l; }
//struct cLocals * slideGetLocalOfType( struct cSlide * slide, int type );


typedef struct cSlide
{
	int id;
	CvPoint time;					// start, end
	CvString source;
	double confID;
	struct cSlide * match;
} cSlide;
static struct cSlide slideInit( int id, char * source, CvPoint time, double confID, CvMemStorage * storage )
{
	struct cSlide sl;
	sl.id = id;
	sl.time = time;
	sl.confID = confID;
	if( source ) sl.source = cvMemStorageAllocString( storage, source, -1 );
	else sl.source.ptr = NULL;
	sl.match = NULL;
	return sl;
}


typedef double (* LocalsDistance)(const void * a, const void * b, void * userdata );

typedef struct cSlides
{
	CvMemStorage * storage;
	CvSeq * slides;
	CvString videoSource;
	CvString origsSource;
	CvSeq * matches;
} cSlides;
struct cSlides * slidesCreate( const char * videoSource, const char * origsSource );
struct cSlides * slidesLoadXML( struct cSlides * slides, char * xmlpath );
int slidesSaveXml( struct cSlides * slides, const char * xmlpath );
struct cSlide * slidesRemoveNeighbourDuplicates(  struct cSlides * slides );
void slidesRelease( struct cSlides ** slides );

int slidesGetByID( struct cSlides *, int id );

//int slidesFindClosest(  struct cSlides * slides, int type, CvMat * ftr, double * dist );
//int slidesFindClosest2( struct cSlides * slides, int type, CvMat * ftr, double * dist, LocalsDistance func );
int slidesFindClosestWeightedVoting( CvSeq * gradFtrs, CvMat * ftr, double * confidence, CvMat ** distances );
int slidesFindClosestWeightedVoting2( struct CvFeatureTree * kd, CvMat * ftrsP, CvMat * ftrQ, int docs_count, double * confidence );
int slidesFindClosestWeightedVoting3( struct CvFeatureTree * kd, CvMat * ftr, int docs_count, double * confidence );



//void slidesPrintLocsOfType( struct cSlides * slides, int type );
void slidesPrint( struct cSlides * slides );


void slideShow( struct cSlides * slides,  int i, const char * wndname,struct cSlideDetParams * params, char * storepath );
CvMat * imagePreprocForGrad( CvArr * rgb, CvMat * dst, struct cSlideDetParams * params );
CvSeq * slidesExtractFeaturesGrad( struct cSlides * slides, struct cGradLocals * GL, struct cSlideDetParams * params, CvSeq * gradFtrs, char * storepath );


#ifdef __cplusplus
}
#endif


#endif