#ifndef _VPL_IMAGES_DIFF_H_
#define _VPL_IMAGES_DIFF_H_

#include "cv.h"

#ifdef __cplusplus
extern "C" {
#endif


typedef struct cImagesDiff
{
	CvMat ** buff, ** bufs;
	CvMat  * last,  * ref, * gray;
	int n, a, iLast;
	int rows, cols;
	float diffThresh, ditribThresh;
	CvMat * diffs, * distrs;
} cImagesDiff;

struct cImagesDiff * imagesDiffCreate( void );
struct cImagesDiff * imagesDiffInit( struct cImagesDiff * imd, int rows, int cols, int buff_length, float diffThresh, float ditribThresh );
int imagesDiff( struct cImagesDiff * imd, CvArr * image, double * confidence );
CvMat * imagesDiffGetLast( struct cImagesDiff * imd );
void imagesDiffRelease( struct cImagesDiff ** );


#ifdef __cplusplus
}
#endif


#endif