
#include <stdio.h>
#include <stdlib.h>
#include "highgui.h"

#include "vplcore.h"
#include "vplImgDiff.h"


static char __buff[1024];

void imagesDiffSrcProc( struct cImagesDiff * imd, CvMat * src );

int imagesDiffInitBuffers( struct cImagesDiff * imd, CvArr * image );


struct cImagesDiff * imagesDiffCreate( void )
{
	struct cImagesDiff * imd = NULL;

	imd = (struct cImagesDiff *)malloc( sizeof( struct cImagesDiff ) );
	imd->rows = 0;
	imd->cols = 0;
	imd->n = 0;
	imd->a = 0;
	imd->buff = NULL;
	imd->bufs = NULL;
	imd->last = NULL;
	imd->ref = NULL;
	imd->gray = NULL;
	
	return imd;
}


struct cImagesDiff * imagesDiffInit( struct cImagesDiff * imd, int rows, int cols, int buff_length, float diffThresh, float ditribThresh )
{
	if( !imd ) imd = imagesDiffCreate();

	imagesDiffInitBuffers( imd, NULL );

	imd->rows = rows;
	imd->cols = cols;
	imd->n = buff_length;
	imd->diffThresh   = diffThresh;
	imd->ditribThresh = ditribThresh;

	return imd;
}


//
//int pyrDown( CvMat * src, CvMat * dst, CvMat ** pyr, int c )
//{
//	int i;
//
//	if( !src || !dst ) return -1;
//	if( c == 0 )
//	{
//		cvCopy( src, dst, 0 );
//		return 1;
//	}
//	if( c <= 1 )
//	{
//		cvPyrDown( src, dst, CV_GAUSSIAN_5x5 );
//		return 1;
//	}
//
//	if( !pyr ) return -1;
//
//	cvPyrDown( src, pyr[0], CV_GAUSSIAN_5x5 );
//	for( i = 0; i < c-2; ++i )
//		cvPyrDown( pyr[i], pyr[i+1], CV_GAUSSIAN_5x5 );
//	cvPyrDown( pyr[c-2], dst, CV_GAUSSIAN_5x5 );
//
//	return 1;
//}



int imagesDiffInitBuffers( struct cImagesDiff * imd, CvArr * image )
{
    CvMat srcstub, *src = (CvMat*)image;
	int i;

	assert( imd && "No input parameters." );

	// delete old buffers
	if( imd->buff )
	{
		for( i = 0; i < imd->n; ++i )
		{
			if( imd->buff[i] ) cvReleaseMat( &imd->buff[i] );
			if( imd->bufs[i] ) cvReleaseMat( &imd->bufs[i] );
		}
		//for( i = 0; i < imd->fscale-1; ++i ) if( imd->pyr[i] ) cvReleaseMat( &imd->pyr[i] );

		free( imd->buff );
		//free( imd->pyr );
		imd->buff = NULL;
		imd->bufs = NULL;
		//imd->pyr = NULL;
	}
	if( imd->last ) cvReleaseMat( &imd->last );
	if( imd->ref ) cvReleaseMat( &imd->ref );
	if( imd->gray ) cvReleaseMat( &imd->gray );

	if( !image ) return -1;
	src = cvGetMat( image, &srcstub, &i, 0 );

	if( !imd->buff ) 
	{
		imd->buff = (CvMat **)malloc( sizeof( CvMat *) * 2 * imd->n );
		imd->bufs = imd->buff + imd->n;
		for( i = 0; i < imd->n; ++i )
		{
			imd->buff[i] = cvCloneMat( src );
			imd->bufs[i] = cvCreateMat( imd->rows, imd->cols, CV_8UC1 );
		}
	}

	imd->a = 0;
	imd->iLast = 0;
	imd->diffs  = cvCreateMat( 1, imd->n, CV_32FC1 );
	imd->distrs = cvCreateMat( 1, imd->n, CV_32FC1 );
	cvZero( imd->diffs );
	cvZero( imd->distrs );

	//if( !imd->pyr && imd->fscale > 1 )
	//{
	//	imd->pyr = (CvMat **)malloc( sizeof( CvMat *) * (imd->fscale-1)  );
	//	for( i = 0; i < imd->fscale-1; ++i )
	//		imd->pyr[i] = cvCreateMat( src->rows>>(i+1), src->cols>>(i+1), CV_8UC1 );
	//}
	
	imd->gray = cvCreateMat( src->rows, src->cols, CV_8UC1 );

	imagesDiffSrcProc( imd, src );

	for( i = 1; i < imd->n; ++i )
		cvCopy( imd->bufs[0], imd->bufs[i], 0 );

	imd->last = cvCloneMat( src );
	if( imd->n > 0 )
		imd->ref = cvCloneMat( imd->bufs[0] );

	return 1;
}


/* a < b ? -1 : a > b ? 1 : 0 */
static int sort_median( const void* _a, const void* _b, void* userdata )
{
	return ( *(int*)_a < *(int*)_b ? -1 :  (*(int*)_a > *(int*)_b ? 1 : 0 ) );
}

int imagesMedian( CvMat ** images, int count, CvMat * dst )
{
	// compute ref img from buff median
	int i, j, n, c;
	int * arr = (int *)malloc( sizeof(int)*count );
	int imedian = count/2;
	int cn = CV_MAT_CN( dst->type );
	CvSeq _seq;
	CvSeqBlock _block;
	CvSeq * arr_median = cvMakeSeqHeaderForArray( 0, sizeof( CvSeq ), sizeof(int), arr, count, &_seq, &_block );
	for( j = 0; j < dst->rows; ++j )
		for( i = 0; i < dst->cols; ++i )
		{
			int offset = i*cn + j * dst->step;
			for( c = 0; c < cn; ++c )
			{
				for( n = 0; n < count; ++n )
					arr[n] = (int)( images[n]->data.ptr[offset+c] );
				
				if( i == 100 && j == 100 ) {
					printf( "Median : " ); for( n = 0; n < count; ++n ) printf( "%d ", arr[n]); printf( "\n" );
				}

				cvSeqSort( arr_median, sort_median, NULL );

				if( i == 100 && j == 100 ) {
					printf( "MedianS: " ); for( n = 0; n < count; ++n ) printf( "%d ", arr[n]); printf( " :: %d\n", arr[imedian] );
				}
				dst->data.ptr[offset+c] = arr[imedian];				
			}
		}
	free( arr );
	return 1;
}

#define MODE_DIFF 1
#define MODE_BEST 2
#define MODE_IDX  3
double imagesTwoClasses( CvMat ** images, int count, CvMat * dst, int shift, int start, int length, int mode )
{
	// compute ref img from buff median
	int i, j, n, c;
	int cn = CV_MAT_CN( dst->type );
	long int d = 0;
	int arr_size = 2+(256>>shift);
	CvMat * marr = cvCreateMat( 1, arr_size, CV_8UC1 );
	//CvMat * med  = cvCreateMat( 1, arr_size, CV_8UC1 );
	unsigned char * arr = marr->data.ptr;;

	cvZero( dst );
	if( length <= 0 ) return 0.0;

	for( j = 0; j < dst->rows; ++j )
		for( i = 0; i < dst->cols; ++i )
		{
			int offset = i*cn + j * dst->step;
			for( c = 0; c < cn; ++c )
			{
				int m1 = 0, m2 = 0, n1, n2;
				int i1 = -1, i2 = -1;

				cvZero( marr );
				for( n = 0; n < length; ++n )
				{
					//if( i == 30 && j == 100 ) printf( "%d, ", images[n]->data.ptr[offset+c] );
					marr->data.ptr[1+((images[ (start+n)%count ]->data.ptr[offset+c])>>shift)]++;
				}
				
				//cvSmooth( marr, med, CV_GAUSSIAN, 1, 0, 0, 0 );
				//if( i == 30 && j == 100 ) { printf( "\n" ); cvMatPrint( marr, 0 ); cvMatPrint( med, 0 ); }

				// find local maximas
				for( n1 = 1, n2=arr_size-1; n1 <= n2; )
				{
					if( arr[n1] > m1 && arr[n1-1] <= arr[n1] && arr[n1] >= arr[n1+1] ) { m1 = arr[n1]; i1 = n1; }
					if( n1 == n2 ) break;
					if( arr[n2] > m2 && arr[n2-1] <= arr[n2] && arr[n2] >= arr[n2+1] ) { m2 = arr[n2]; i2 = n2; }
					if( m1 > m2 ) n2--;
					else if( m1 < m2 ) n1++;
					else { n1++; n2--; }
				}

				// two significant peaks
				if( mode == MODE_DIFF && ( abs(i1-i2) > ( 30 / (1<<shift) ) && m1 > 0.2*count && m2 > 0.2*count ) )
				{
					dst->data.ptr[offset+c] = 255;
					d++;
				}
				else if( mode == MODE_BEST )
				{
					dst->data.ptr[offset+c] = ((m1>m2?i1:i2)-1)<<shift;
					//if( dst->data.ptr[offset+c] > 250 || dst->data.ptr[offset+c] < 5 ) printf ( "*%d", dst->data.ptr[offset+c] );
				}
			}
		}

	cvReleaseMat( &marr );
	//cvReleaseMat( &med );
	return 1.0*d/(dst->rows*dst->cols);
}

int imagesDiffMaskStatistics( CvMat * med, float * distr, float * diff )
{
	CvMat * H = cvCreateMat( 1, med->cols, CV_32FC1 ); 
	CvMat * V = cvCreateMat( 1, med->rows, CV_32FC1 ); 
	float sH, sV;
	int i, j;
	cvZero( H );
	cvZero( V );
	for( j = 0; j < med->rows; ++j )
		for( i = 0; i < med->cols; ++i )
		{
			int v = (int)med->data.ptr[i+j*med->cols];
			H->data.fl[i] += v;
			V->data.fl[j] += v;
		}

	// analyze H and V
	cvThreshold( H, H, 5, 1, CV_THRESH_BINARY );
	cvThreshold( V, V, 5, 1, CV_THRESH_BINARY );

	sH = (float)( cvSum( H ).val[0] / med->cols );
	sV = (float)( cvSum( V ).val[0] / med->rows );
	if( distr ) *distr = (float)(sH*sV);
	if( diff )  *diff  = (float)( 1.0*cvCountNonZero( med ) / ( med->cols * med->rows ) );

	#ifdef _DEBUG
	//printf( "H: %f  V: %f  diff: | %f | distr: %f | \n", sH, sV, *diff, *distr );
	#endif

	if( H ) cvReleaseMat( &H );
	if( V ) cvReleaseMat( &V );

	return 1;
}

int imagesDiffFindPeak( CvMat * src, int * idx )
{
	int i, imav, i0, i1;
	float mav = -1;
	CvMat * dst = cvCloneMat( src );

	cvSmooth( src,  dst, CV_GAUSSIAN, 3, 0, 0, 0 );	

	printf( "Vec: " );
	for( i = 0; i < dst->cols; ++i )
	{
		if( dst->data.fl[i] > mav ) { mav = dst->data.fl[i]; imav = i; }
		printf( "%f, ", dst->data.fl[i] );
	}
	printf( "\n" );

	i0 = imav; i1 = imav; 
	while( i0 >= 0        && dst->data.fl[i0] >= 0.95*mav ) i0--;
	while( i1 < dst->cols && dst->data.fl[i1] >= 0.95*mav ) i1++;

	//mav = 1. - 0.5 * ( dst->data.fl[i0]/dst->data.fl[imav] + dst->data.fl[i1]/dst->data.fl[imav] );
	printf( "FindPeak: %d:%f  %d:%f  %d:%f  %f\n", i0, dst->data.fl[i0], imav, dst->data.fl[imav], i1, dst->data.fl[i1], mav );
	cvReleaseMat( &dst );

	if( i0 < 0 || i1 >= src->cols )
		return 0;

	if( idx ) *idx = imav;
	return 1;
}

#define saveImg( img, ptrn, frno ) { sprintf( __buff, ptrn, frno ); cvSaveImage( __buff, img ); }


int imageFilterSobel( CvMat * dst, CvMat * src, int aperture_size, int precise )
{
	CvMat * dx = NULL, * dy = NULL, * mag = NULL;
	int height, width;

	if( !dst || !src ) return 0;
	
	height = src->rows;
	width  = src->cols;
	dx  = cvCreateMat( height, width, CV_32FC1 );
	dy  = cvCreateMat( height, width, CV_32FC1 );
	mag = cvCreateMat( height, width, CV_32FC1 );
	
	cvSobel( src, dx, 1, 0, aperture_size );
	//cvConvertScale( dx, dx, 1./4, 0 );
	cvSobel( src, dy, 0, 1, aperture_size );
	//cvConvertScale( dy, dy, 1./4, 0 );

	/* precise magnitude */
	if( precise )
		cvCartToPolar( dx, dy, mag, NULL, 0 );
	/* approximate magnitude */
	else
	{
		int i;
		for( i = 0; i < height * width; ++i ) 
			mag->data.fl[i] = (float)( fabs( dx->data.fl[i] ) + fabs( dy->data.fl[i] ) );
	}

	//cvThreshold( mag, mag, 255., 255, CV_THRESH_TRUNC );
	cvConvertScaleAbs( mag, dst, sqrt(1./8), 0 );

	cvReleaseMat( &dx );
	cvReleaseMat( &dy );
	cvReleaseMat( &mag );

	return 1;
}

void imagesDiffSrcProc( struct cImagesDiff * imd, CvMat * src )
{
	//CvMat * lapl = NULL;
	cvCvtColor( src, imd->gray, CV_BGR2GRAY );
	cvSmooth( imd->gray, imd->gray, CV_GAUSSIAN, 5, 0, 0, 0 );
	cvResize( imd->gray, imd->bufs[imd->a], CV_INTER_NN );
	//pyrDown( imd->gray, imd->bufs[imd->a], imd->pyr, imd->fscale );

	//cvCvtColor( src, imd->gray, CV_BGR2GRAY );


	//lapl = cvCreateMat( imd->bufs[imd->a]->rows, imd->bufs[imd->a]->cols, CV_16SC1 );
	//cvLaplace( imd->bufs[imd->a], lapl, 3 );
	//cvSobel( imd->bufs[imd->a], lapl, 1, 1, 3 );
	//cvConvertScaleAbs( lapl, imd->bufs[imd->a], 1., 0 );

	imageFilterSobel( imd->bufs[imd->a], imd->bufs[imd->a], 3, 0 );
	cvDilate( imd->bufs[imd->a], imd->bufs[imd->a], 0, 1 );

	//cvReleaseMat( &lapl );
}

int imagesDiff( struct cImagesDiff * imd, CvArr * image, double * confidence )
{
    CvMat tmp, *src = (CvMat*)image;
	int i, count;
	float refDif, refDis;
	CvMat * med = NULL;
	int CHANGE = 0;

	assert( imd && image && "No input parameters." );
	src = cvGetMat( image, &tmp, &i, 0 );

	if( !imd->last ) imagesDiffInitBuffers( imd, image );

	assert( CV_MAT_CN( imd->last->type ) == CV_MAT_CN( src->type ) && "wrong channels number" );

	// add img to buff and pre-process source image (process and down-scale source to buffer of small sources)
	cvCopy( src, imd->buff[imd->a], 0 );
	imagesDiffSrcProc( imd, src );					//  imd->buff[imd->a] -> imd->bufs[imd->a]
	med = cvCloneMat( imd->ref );

	// compute difference between last slide and actual frame
	#ifdef _DEBUG
	//printf( "RefDiff : " );
	#endif
	cvAbsDiff( imd->bufs[imd->a], imd->ref, med );
	cvThreshold( med, med, 30, 255, CV_THRESH_BINARY );
	imagesDiffMaskStatistics( med, &refDis, &refDif );

	// detect local maximum
	count = ( imd->a - imd->iLast ) + ( imd->a <= imd->iLast ? imd->n : 0 );
	if( refDis > 0.3 && refDif > 0.05 )
	{
		// update reference image
		cvCopy( imd->bufs[imd->a], imd->ref, 0 );

		// compute slide image
		imagesTwoClasses( imd->buff, imd->n, imd->last, 0, imd->iLast, count, MODE_BEST );

		CHANGE = 1;

		#ifdef _DEBUG
		//printf( "*****   HIT   frame[%d] count[%d] last[%d] act[%d] *****\n", frameNo, count, imd->iLast, imd->a );
		#endif
		imd->iLast = MAX( i, imd->a );
	}
	else
	{
		// update ref image using last stable images in small buffer
		imagesTwoClasses( imd->bufs, imd->n, imd->ref, 0, imd->iLast, count, MODE_BEST );
	}

	#ifdef _DEBUG
	cvNamedWindow( "Buff", 1 );			cvShowImage( "Buff",    imd->bufs[imd->a] );
	cvNamedWindow( "Ref", 1 );			cvShowImage( "Ref",     imd->ref );
	cvNamedWindow( "RefDiff", 1 );		cvShowImage( "RefDiff", med );
	#endif

	imd->a = ++imd->a % imd->n;

	if( med ) cvReleaseMat( &med );
	if( confidence ) *confidence = refDis*refDif;

	return CHANGE;
}


CvMat * imagesDiffGetLast( struct cImagesDiff * imd )
{
	int count = ( imd->a - imd->iLast ) + ( imd->a <= imd->iLast ? imd->n : 0 );
	imagesTwoClasses( imd->buff, imd->n, imd->last, 0, imd->iLast, count, MODE_BEST );
	return imd->last;
}


void imagesDiffRelease( struct cImagesDiff ** _imd )
{
	struct cImagesDiff * imd = NULL;

	if( !_imd || !*_imd ) return;
	imd = *_imd;

	imagesDiffInitBuffers( imd, NULL );


	free( imd );
	*_imd = NULL;

	return;
}



