#ifndef _VPL_GRAD_LOCALS_H_
#define _VPL_GRAD_LOCALS_H_

#include "cv.h"
#include "vplgllfgraddist.h"
#include "vplWndPatch.h"

#ifdef __cplusplus
extern "C" {
#endif

#define glCount(gl) ((gl)->gw*(gl)->gh)

typedef struct cGradLocals
{
	int ws;										// window size
	float wo;									// window overlap
	int pyrs, bins;

	struct cWndPatch * gaussWnd;				// Gaussian window
	struct cImagePyr * ip;
	CvMat * ftrs;
} cGradLocals;

//#define imagePyrOctSize( ip, o ) 

struct cGradLocals * gradLocalsCreate( );
//int gradLocalsInit( struct cGradLocals * gl, int grid_rows, int grid_cols, int wndSize );
int gradLocalsInit( struct cGradLocals * gl, int pyrs, int bins, float wndOverlap, int wndSize );
CvMat * gradLocalsEval( struct cGradLocals * gl, CvArr * image, CvMat * ftrs CV_DEFAULT(NULL) );
void gradLocalsRelease( struct cGradLocals ** gl );

double gradLocalsDistance( const void * a, const void * b, void * userdata );

int gradLocalsCount( struct cGradLocals * gl, int rows, int cols, int oct, int * gr, int * gc, double * ds );
int gradLocalsDims( struct cGradLocals * gl );



#ifdef __cplusplus
}
#endif

#endif