#include <stdio.h>
#include <stdlib.h>

#include "cv.h"
#include "highgui.h"

#include "cvffmpeg.h"
#include "findrectangle.h"
#include "slideParams.h"

void slideDetParamsRelease( struct cSlideDetParams ** params )
{
	if( !params || !*params ) return;
	if( (*params)->presentHomo ) cvReleaseMat( &(*params)->presentHomo );
	free( *params );
	*params = NULL;
	return;
}

struct cSlideDetParams * slideDetParams( struct cSlideDetParams * params, char * config_file, struct ffMedia * video )
{
	CvFileStorage* fs = NULL;
	CvFileNode * node = NULL;
	int i, k;
	char b[32] = "PXX";
	CvMat * points = NULL;

	if( !config_file ) return params;
	if( !params ) params = (struct cSlideDetParams *)malloc( sizeof( struct cSlideDetParams ) );
	params->presentHomo = NULL;
	

	fs = cvOpenFileStorage( config_file, 0, CV_STORAGE_READ );
	
	node = cvGetFileNodeByName( fs, NULL, "Presentation" );
	params->presentWidth  = cvReadIntByName( fs, node, "presentWidth", 640 );
	params->presentHeight = cvReadIntByName( fs, node, "presentHeight", 480 );
	params->Low  = cvReadIntByName( fs, node, "boardDetLow", 120 );
	params->High = cvReadIntByName( fs, node, "boardDetHigh", 150 );
	params->presentDetCount = cvReadIntByName( fs, node, "presentDetCount", 10 );
	if( fs ) points = (CvMat *)cvReadByName( fs, node, "boardPoints", NULL );

	node = cvGetFileNodeByName( fs, NULL, "SlideDetection" );
	params->slideFrameStep  = cvReadIntByName( fs, node, "slideFrameStep", 25 );
	params->slideDiffBuff   = cvReadIntByName( fs, node, "slideDiffBuff", 10 );
	params->slideDetWidth  = cvReadIntByName( fs, node, "slideDetWidth", 160 );
	params->slideDetHeight = cvReadIntByName( fs, node, "slideDetHeight", 120 );
	params->slideDiffThresh  = (float)cvReadRealByName( fs, node, "slideDiffThresh", 0.01 );
	params->slideDistrThresh = (float)cvReadRealByName( fs, node, "slideDistrThresh", 0.3 );

	node = cvGetFileNodeByName( fs, NULL, "LocalFeatures" );
	params->locWndOverlap = (float)cvReadRealByName( fs, node, "locWndOverlap", 0.3 );
	params->locWndSize    = cvReadIntByName( fs, node, "locWndSize",  31 );
	params->gradBinSize   = cvReadIntByName( fs, node, "gradBinSize", 8 );
	params->localWidth  = cvReadIntByName( fs, node, "localWidth", 320 );
	params->localHeight = cvReadIntByName( fs, node, "localHeight", 240 );
	params->matchLimit  = (float)cvReadRealByName( fs, node, "matchLimit", 0.5 );

	if( fs )cvReleaseFileStorage( &fs );

	// detection of the presentation screen
	// test if presentation board is defined in the config file
	if( !points && video && video->ffFrame )
	{
		int numFrames = ffLength( video ), frame;
		float Max = 0, MaxSize = 0, result, size; 
		CvPoint2D32f * Points, tmpPoints[4];
		IplImage * vFrame = NULL;
		IplImage * gray = NULL, * imgColor = NULL;

		points = cvCreateMat( 1, 4, CV_32FC2 );
		Points = (CvPoint2D32f *)points->data.ptr;
		vFrame = ffCvConvert( video, NULL );
		gray = cvCreateImage( cvSize(vFrame->width,vFrame->height), IPL_DEPTH_8U, 1);
		imgColor = cvCreateImage( cvSize(vFrame->width,vFrame->height), IPL_DEPTH_8U, 3);

		printf("Start presentation detection.\n"); 

		for( i = 0; i < params->presentDetCount; i++ ) 
		{
			frame = numFrames/4+i*(numFrames/2)/params->presentDetCount-2;				// start capturing from a relative position 
			
			printf( "Seek the video position: %d\n", frame );
			if( !( vFrame = ffCvFramePreciseSeek( video, frame ) ) )
				break;
			
			cvCvtColor( vFrame, imgColor, CV_RGBA2RGB );
			cvCvtColor( imgColor,   gray, CV_RGB2GRAY );
			result = FindRectangle( gray, tmpPoints, params->Low, params->High);
			size = (tmpPoints[1].x-tmpPoints[0].x)*(tmpPoints[2].y-tmpPoints[1].y);
			if( ( result>Max*0.99 ) && ( MaxSize<size ) )
			{
				memcpy( Points, tmpPoints, 4*sizeof(CvPoint2D32f) );
				Max = result;
				MaxSize = size;
				// save result image with presentation table

				#ifdef _DEBUG
				
				#endif
			}
			
			//#ifdef _DEBUG 
			if( Max>0 && MaxSize>0 ) for( k=0; k < 4; k++ ) cvLine( imgColor, cvPointFrom32f(Points[k]), cvPointFrom32f(Points[(k+1)%4]), cvScalar(255,0,0), 1 ); 
			cvShowImage( "Video", imgColor );
			if( cvWaitKey(10) == 27 ) break;
			//#endif
		
			//printf("%d from %d - Board : %d %d, %d, %d, %d %d, %d, %d  -  %f\n", i+1, PRESENTATIN_DETECTIONS, (int)params->Points[0].x, (int)params->Points[0].y, (int)params->Points[1].x, (int)params->Points[1].y, (int)params->Points[2].x, (int)params->Points[2].y, (int)params->Points[3].x, (int)params->Points[3].y, result);
			//position += (1-begin)/PRESENTATIN_DETECTIONS;
		}

		printf("Presentation screen was %slocalized.\n", ( Max<=0 ? "NOT " : "" ) );

		if( Max <= 0 && points ) cvReleaseMat( &points );
		if( gray ) cvReleaseImage( &gray );
		if( imgColor ) cvReleaseImage( &imgColor );

		ffClose( video );
	}

	fs = cvOpenFileStorage( config_file, 0, CV_STORAGE_WRITE );
	if( !fs ) return params;

	cvStartWriteStruct( fs, "Presentation", CV_NODE_MAP, NULL, cvAttrList(0,0) );
		cvWriteInt( fs, "presentWidth",  params->presentWidth );
		cvWriteInt( fs, "presentHeight", params->presentHeight );
		cvWriteInt( fs, "boardDetLow",  params->Low );
		cvWriteInt( fs, "boardDetHigh", params->High );
		cvWriteInt( fs, "presentDetCount", params->presentDetCount );
		if( points ) cvWrite( fs, "boardPoints", points, cvAttrList(0,0) );
	cvEndWriteStruct( fs );
	cvStartWriteStruct( fs, "SlideDetection", CV_NODE_MAP, NULL, cvAttrList(0,0) );
		cvWriteInt( fs, "slideFrameStep",  params->slideFrameStep );
		cvWriteInt( fs, "slideDetWidth",   params->slideDetWidth );
		cvWriteInt( fs, "slideDetHeight",  params->slideDetHeight );
		cvWriteInt( fs, "slideDiffBuff",  params->slideDiffBuff );
		cvWriteReal( fs, "slideDiffThresh",  params->slideDiffThresh );
		cvWriteReal( fs, "slideDistrThresh", params->slideDistrThresh );
	cvEndWriteStruct( fs );
	cvStartWriteStruct( fs, "LocalFeatures", CV_NODE_MAP, NULL, cvAttrList(0,0) );
		cvWriteReal( fs, "locWndOverlap", params->locWndOverlap );
		cvWriteInt( fs, "locWndSize",  params->locWndSize );
		cvWriteInt( fs, "gradBinSize", params->gradBinSize );
		cvWriteInt( fs, "localWidth",  params->localWidth );
		cvWriteInt( fs, "localHeight", params->localHeight );
		cvWriteReal( fs, "matchLimit", params->matchLimit );
	cvEndWriteStruct( fs );
	cvReleaseFileStorage( &fs );

	if( points )
	{
		CvPoint2D32f * Points, tmpPoints[4];
		Points = (CvPoint2D32f *)points->data.ptr;
		tmpPoints[0] = cvPoint2D32f( 0., 0. );
		tmpPoints[1] = cvPoint2D32f( params->presentWidth, 0. );
		tmpPoints[2] = cvPoint2D32f( params->presentWidth, params->presentHeight );
		tmpPoints[3] = cvPoint2D32f( 0., params->presentHeight );

		params->presentHomo = cvCreateMat( 3, 3, CV_32FC1 );
		cvGetPerspectiveTransform( Points, tmpPoints, params->presentHomo );
		cvReleaseMat( &points );
	}

	return params;
}








