/*****************************************************************************/
/*                       Image processing functions                          */
/*  Header file : hough transform for line detection                         */
/*  Designed by Igor Potucek (potucek@fit.vutbr.cz)                          */
/*  created 2005                                                             */
/*****************************************************************************/
#include <memory.h>
#ifdef DIGILIB
  #include "Image.h"
#endif
#include <stdlib.h>
// size of matrix axis with angles in hough space
extern const int AXIS_ALPHA_SIZE;
// number of cells in x & y direction for line aproximation
extern const int MATRIX_SURROUND;
// number of cells in x & y direction for erasing the values
extern const float MATRIX_ZERO_SURROUND_X;
extern const float MATRIX_ZERO_SURROUND_Y;

class c_LineHoughTransform
{
  // r = x*cos(alpha)+y*sin(alpha)
  private:
  float *SinFun;
  float *CosFun;
  public:
  float Aspect;
  int XSize;            // max size of R
  int YSize;            // max size of alpha
  int Count;
  int *Array;
  int ZeroWidth;
  int ZeroHeight;
   // constructor & destructor
   c_LineHoughTransform()  { SinFun=NULL; CosFun=NULL; Array=NULL; Count=0; }
   ~c_LineHoughTransform() {
     if (SinFun!=NULL) delete [] SinFun;
     if (CosFun!=NULL) delete [] CosFun;
     if (Array!=NULL) delete [] Array;
   }
   // copy constructor
   c_LineHoughTransform(const c_LineHoughTransform &Hough)
   {
      Count=Hough.Count;
      XSize=Hough.XSize;
      YSize=Hough.YSize;
      if (Hough.Array!=NULL)
      {
         Array=new int[XSize*YSize];
         memcpy(Array,Hough.Array, XSize*YSize*sizeof(int));
      }
      if (Hough.SinFun!=NULL)
      {
         SinFun=new float[YSize];
         memcpy(SinFun,Hough.SinFun, YSize*sizeof(float));
      }
      if (Hough.CosFun!=NULL)
      {
         CosFun=new float[YSize];
         memcpy(CosFun,Hough.CosFun, YSize*sizeof(float));
      }
   }
   int FindMax(int &x, int &y);
   bool AddValue(int x, int y);
   // initialization accumulator array
   void Init(int X, int Y, int Angleparts, float AspectRatio);
   // return maximal value of the r
   int RmaxValue(int ImageXsize, int ImageYSize);
   // return transformed line end points in the image
   void GetLine(float r, float alpha, int Ximage, int Yimage,int &x1, int &y1, int &x2, int &y2);
   // return array with normalized values 0 - 255
   void GetLineSurround(int r, int a, unsigned char *dst, int imXSize, int imYSize);
   // fill the dst image with 1 where lie the lines given by parameters [r,a] in hough space
   unsigned char* NormalizedHoughArray();
   int GetValue(int x, int y);
   long DrawArray(unsigned char *src, int Width, int Height, int Mult);
};


