#include <memory.h>
#include <math.h>

#include "linehough.h"
#include "findrectangle.h"
#include "highgui.h"


#define M_PI 3.14159265358979323846
const float MINIMAL_SIZE = 0.3;
const float MAXIMAL_SIZE = 0.8;

const float MINIMAL_LINE_LENGTH = 0.15;


int GetHoughLine(c_LineHoughTransform *LineDetect, double *R, double *Alpha)
{
   int x,y, Value;
     LineDetect->FindMax(x,y);
     Value = LineDetect->GetValue(x,y);
	 for (int i=x-LineDetect->ZeroWidth; i<x+LineDetect->ZeroWidth; i++)
      for (int j=y-LineDetect->ZeroHeight; j<y+LineDetect->ZeroHeight; j++)
      {
        if ((i>=0) && (i<LineDetect->XSize) && (j>=0) && (j<LineDetect->YSize))
          LineDetect->Array[i+j*LineDetect->XSize]=0;
      }
      *R = x-LineDetect->XSize/2.0;

      *Alpha = 180.0*y/LineDetect->YSize;
    return Value;
}

float FindRectangle(IplImage *grey, CvPoint2D32f *Points, int Low, int High)
{
  c_DetectRectangle FindRectangle;
  c_LineHoughTransform LineDetect;              // line detection class
  // new twice smaller image
  IplImage  *edge = cvCreateImage(cvGetSize(grey), IPL_DEPTH_8U, 1);
  //cvPyrDown(grey, edge, CV_GAUSSIAN_5x5);
  int xsize = edge->width;
  int ysize = edge->height;
  memset(Points,0,sizeof(CvPoint2D32f)*4);
 do 
 {
  cvCanny(grey, edge, Low, High, 3);
  // detekce car
  LineDetect.Init(xsize, ysize, AXIS_ALPHA_SIZE, 1);
  unsigned char *data = (unsigned char *)edge->imageData;
  for (int y=0; y<ysize; y++)
  {
    for (int x=0; x<xsize; x++)
    {
       if (*data>0)
         LineDetect.AddValue(x,y);
       data+=1;
    }
  }
  //  LineDetect.DrawArray((unsigned char*)edge->imageData, edge->width, edge->height,5);
  //  cvSaveImage("canny.jpg", edge);
  // extrakce car

  FindRectangle.Init(xsize, ysize);
  int x,y;
  double Max = LineDetect.FindMax(x,y), value = 0, R, Alpha;

  if (LineDetect.Count>0)
  do
  {
        value = GetHoughLine(&LineDetect, &R, &Alpha);
        if (value < MINIMAL_LINE_LENGTH*xsize) break;
        FindRectangle.PutLine(R, Alpha, value);
  } while (LineDetect.Count>0);
  FindRectangle.Sort();

  // not enough lines for rectangle
  if ((FindRectangle.VerticalPoints<2) || (FindRectangle.HorizontalPoints<2))
    return 0;
  // too much lines for processing
  Low += 20;  High += 20;

} while ((FindRectangle.VerticalPoints*FindRectangle.HorizontalPoints>1000) && (High<255));

  float result = FindRectangle.FindRectangle((unsigned char *)edge->imageData, xsize, ysize, Points);
  if (result == 0)
    return result;
  // size normalization regarding to the original image
  Points[0].x *= grey->width/xsize;   Points[0].y *= grey->height/ysize;
  Points[1].x *= grey->width/xsize;   Points[1].y *= grey->height/ysize;
  Points[2].x *= grey->width/xsize;   Points[2].y *= grey->height/ysize;
  Points[3].x *= grey->width/xsize;   Points[3].y *= grey->height/ysize;

  cvReleaseImage(&edge);
  return result;
}
 






int LinesIntersection(s_Line *Line1, s_Line *Line2, CvPoint2D32f *Point)
{  // 0 - OK, -1 - intersection does not exist
   bool Line1ver = (Line1->Alpha-(int)Line1->Alpha==0) && ((int)Line1->Alpha % 180)==0;
   bool Line2ver = (Line2->Alpha-(int)Line2->Alpha==0) && ((int)Line2->Alpha % 180)==0;
   bool Line1hor = (Line1->Alpha-(int)Line1->Alpha==0) && (((int)Line1->Alpha + 90) % 180)==0;
   bool Line2hor = (Line2->Alpha-(int)Line2->Alpha==0) && (((int)Line2->Alpha + 90) % 180)==0;
   // lines are both horizontal or vertical
   if ((Line1ver && Line2ver) || (Line1hor && Line2hor))
     return -1;
   else
   if ((Line1hor) && (Line2ver))
   {
     Point->x = Line2->R/cos(Line2->Alpha*M_PI/180.0);
     Point->y = Line1->R/sin(Line1->Alpha*M_PI/180.0);
   }
   else
   if ((Line2hor) && (Line1ver))
   {
      Point->x = Line1->R/cos(Line1->Alpha*M_PI/180.0);
      Point->y = Line2->R/sin(Line2->Alpha*M_PI/180.0);
   }
   else
   if (Line1hor)
   {
      Point->y = Line1->R/sin(Line1->Alpha*M_PI/180.0);
      Point->x = (Line2->R-sin(Line2->Alpha*M_PI/180.0)*Point->y)/cos(Line2->Alpha*M_PI/180.0);
   }
   else
   if (Line1ver)
   {
      Point->x = Line1->R/cos(Line1->Alpha*M_PI/180.0);
      Point->y = (Line2->R-cos(Line2->Alpha*M_PI/180.0)*Point->x)/sin(Line2->Alpha*M_PI/180.0);
   }
   else
   if (Line2hor)
   {
      Point->y = Line2->R/sin(Line2->Alpha*M_PI/180.0);
      Point->x = (Line1->R-sin(Line1->Alpha*M_PI/180.0)*Point->y)/cos(Line1->Alpha*M_PI/180.0);
   }
   else
   if (Line2ver)
   {
      Point->x = Line2->R/cos(Line2->Alpha*M_PI/180.0);
      Point->y = (Line1->R-cos(Line1->Alpha*M_PI/180.0)*Point->x)/sin(Line1->Alpha*M_PI/180.0);
   }
   else
   {
     double tmp = (sin(Line2->Alpha*M_PI/180.0)*cos(Line1->Alpha*M_PI/180.0) - sin(Line1->Alpha*M_PI/180.0)*cos(Line2->Alpha*M_PI/180.0));
     if (tmp==0) return -1;       // cary jsou rovnobezne
     Point->y = (Line2->R*cos(Line1->Alpha*M_PI/180.0)-Line1->R*cos(Line2->Alpha*M_PI/180.0))/tmp;
     tmp = cos(Line1->Alpha*M_PI/180.0);
     Point->x = (Line1->R - Point->y*sin(Line1->Alpha*M_PI/180.0))/tmp;
   }
   return 0;
}

void ResizeTwice(unsigned char *source, unsigned char *dst, int Width, int Height)
{   // the final size of output image is twice smaller, rounded down
    int newWidth = Width/2;
    int newHeight = Height/2;
    unsigned char *src = source;
    unsigned char *dest = dst;
    for (int j=0; j<newHeight; j+=1)
    {
      src = source+j*Width*2;
      for (int i=0; i<newWidth; i+=1)
      {
         int sum =(*src+*(src+1)+*(src+Width)+*(src+1+Width))/4;
//             sum+=*(src+Width)+*(src+Width+1)+*(src+Width+2)+*(src+Width+3);
//             sum+=*(src+2*Width)+*(src+2*Width+1)+*(src+2*Width+2)+*(src+2*Width+3);
//             sum+=*(src+3*Width)+*(src+3*Width+1)+*(src+3*Width+2)+*(src+3*Width+3);
         if (sum>255)
           *dest = 255;
         else
         if (sum<0)
           *dest=0;
         else
           *dest = sum;
         src+=2;
         dest+=1;
      }
      //  dest+=newWidth;
    }
}

// definition of the operator for list sorting 
bool operator<(const s_Line &x, const s_Line &y)
{
   return x.R < y.R;
}

void c_DetectRectangle::Init(int XSize, int YSize)
{
  VerticalLines.clear();
  HorizontalLines.clear();
  Width = XSize;
  Height = YSize;
}

void c_DetectRectangle::PutLine(float R, float Alpha, int Weight)
{
   s_Line Line;
     float angle = Alpha;
     while (angle < 0) angle += 180;
     while (angle > 180) angle -= 180;
   Line.Alpha = Alpha;
   Line.R = R;
   if ((angle>=45) && (angle<=135))
      HorizontalLines.push_back(Line);
   else
      VerticalLines.push_back(Line);
}

void c_DetectRectangle::Sort()
{
   VerticalLines.sort();
   HorizontalLines.sort();
   VerticalPoints = VerticalLines.size();
   HorizontalPoints = HorizontalLines.size();
}

bool TestIntersection(CvPoint2D32f *A,int xsize,int ysize)
{
  for (int i=0; i<4; i+=1)
  {
     if ((A[i].x<1) || (A[i].y<1) || (A[i].x>xsize-2) || (A[i].y>ysize-2))
       return false;
  }
  return true;
}

float c_DetectRectangle::FindRectangle(unsigned char *Image, int xsize, int ysize, CvPoint2D32f *BestA)
{
  //////////////////////// compute all intersections //////////////////////////
   t_LineList::iterator lbi = VerticalLines.begin(), lei = VerticalLines.end();
   t_LineList::iterator rbi = HorizontalLines.begin(), rei = HorizontalLines.end();
   t_LineList::iterator rbi2,rei2, lbi2, lei2;
   lei2 = VerticalLines.end();
   rei2 = HorizontalLines.end();
   // compute all intersections
   CvPoint2D32f A[4];
   float BestValue = 0;
   int k1=0, k2=0, k3=0, cnt=0;
   for (; rbi != rei; ++rbi)
   {
      lbi = VerticalLines.begin(); lei = VerticalLines.end();
	  k1++;
      for (; lbi != lei; ++lbi)
      {
         LinesIntersection(&(*lbi), &(*rbi), &A[0]);
         lbi++;
         lbi2 = lbi;
         lbi--;
//         lei2 = VerticalLines.end();
		 k2++;
         for (; lbi2 != lei2; ++lbi2)
		 {
           LinesIntersection(&(*lbi2), &(*rbi), &A[1]);
           rbi++;
           rbi2 = rbi;
           rbi--;
           //rei2 = HorizontalLines.end();
		   k3++;
           for (; rbi2 != rei2; ++rbi2)
		   {
             LinesIntersection(&(*lbi2), &(*rbi2), &A[2]);
             LinesIntersection(&(*lbi), &(*rbi2), &A[3]);
           //  if (TestIntersection(A, Width, Height))
             {
				 float value = HypothesisTest(Image, xsize, ysize, A, 4);
				 cnt++;
              // return 0;
               float Ratio1 = 0, Ratio2 = 0;
               if ((A[2].y-A[1].y)!=0) Ratio1 = (A[1].x-A[0].x)/(float)(A[2].y-A[1].y);
               if ((A[3].y-A[0].y)!=0) Ratio2 = (A[2].x-A[3].x)/(float)(A[3].y-A[0].y);
               if ((A[1].x-A[0].x>MINIMAL_SIZE*Width) && (A[1].x-A[0].x<MAXIMAL_SIZE*Width))
               if ((value>BestValue) && (Ratio1<2.0) && (Ratio1>0.8) && (Ratio2<2.0) && (Ratio2>0.8))
               {
                  BestA[0] = A[0]; BestA[1] = A[1]; BestA[2] = A[2]; BestA[3] = A[3];
                  BestValue = value;
               }
             } //endif
           }
         }
      }
   }
   return BestValue;
}


float c_DetectRectangle::HypothesisTest(unsigned char *Image, int xsize, int ysize, CvPoint2D32f *Lines, int nr)
{  // dodelat testovani mimo okraj obrazku // !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
   float final = 0;
   float constant = 0.4;
   float Rx = (float)xsize/Width;
   float Ry = (float)ysize/Height;
   for (int i=0; i<nr; i++)
   {
      CvPoint2D32f PointX1 = Lines[i];
      CvPoint2D32f PointX2 = Lines[(i+1) % 4];
      int length = 0;
      int count = 0;
      int x1 = PointX1.x*Rx;
      int y1 = PointX1.y*Ry;
      int x0 = PointX2.x*Rx;
      int y0 = PointX2.y*Ry;

      int dx, dy;
      int xinc, yinc;
      register int res1;
      int res2;
      xinc = 1;
      yinc = 1;
       if ((dx = x1-x0) < 0)
       {
           xinc = -1;
           dx = -dx;
       }
       if ((dy = y1-y0) < 0)
       {
           yinc = -1;
           dy = -dy;
       }
       res1 = 0; res2 = 0;
       if (dx > dy)
       {
          while (x0 != x1)
           {
             if ((x0>0) && (y0>0) && (x0<xsize-1) && (y0<ysize-1))
			 {
				 unsigned char *src =  Image+x0+xsize*y0;
	/*             int sum =*src;
				 if (sum>0) { count+=1; }//*src=200;
	*/             int sum =*src+*(src+1)+*(src-1);
				 sum+=*(src+xsize)+*(src+xsize+1)+*(src+xsize-1);
				 sum+=*(src-xsize)+*(src-xsize+1)+*(src-xsize-1);
				 if (sum>256) count+=1;
				 length+=1;
			 }
              if (res1 > res2)
              {
                  res2 += dx - res1;
                  res1 = 0;
                  y0 += yinc;
              }
              res1 += dy;
              x0 += xinc;
          }
      }
      else if (dx < dy)
      {
         while (y0 != y1)
         {
             if ((x0>0) && (y0>0) && (x0<xsize-1) && (y0<ysize-1))
			 {
				 unsigned char *src =  Image+x0+xsize*y0;
	 /*            int sum =*src;
				 if (sum>0) { count+=1; } //*src=200;
	*/           int sum =*src+*(src+1)+*(src-1);
				 sum+=*(src+xsize)+*(src+xsize+1)+*(src+xsize-1);
				 sum+=*(src-xsize)+*(src-xsize+1)+*(src-xsize-1);
				 if (sum>256) count+=1;
				 length+=1;
			 }
              if (res1 > res2)
              {
                  res2 += dy - res1;
                  res1 = 0;
                  x0 += xinc;
              }
               res1 += dx;
               y0 += yinc;
           }
       }
       else
       {
           while (x0 != x1)
           {
             if ((x0>0) && (y0>0) && (x0<xsize-1) && (y0<ysize-1))
			 {
				 unsigned char *src =  Image+x0+xsize*y0;
	/*             int sum =*src;
				 if (sum>0) { count+=1; } //*src=200;
	*/           int sum =*src+*(src+1)+*(src-1);
				 sum+=*(src+xsize)+*(src+xsize+1)+*(src+xsize-1);
				 sum+=*(src-xsize)+*(src-xsize+1)+*(src-xsize-1);
				 if (sum>256) count+=1;
				 length+=1;
			 }
               y0 += yinc;
               x0 += xinc;
           }
       }
       if (length>0)
         final += (float)count/length;
   }
     return final/4.0;
}
