#ifndef CLAPLACIANSMOOTHER_H
#define CLAPLACIANSMOOTHER_H

#include <smoothers/CSmoother.h>

//==============================================================================
/**
 *  LaplacianSmoother class
 * - implements mesh smoothing by classical Laplacian algorithm
 */
class CLaplacianSmoother : public CSmoother
{
    protected :

        //! Smoothing factor
        double  dFactor;

        //! Number of iterations
        int     iIterations;

        //! Number of vertex neighbourhood layers
        int     iLayers;

    public :

        //! Constructor parametrized by smoothing factor and number of iterations
        CLaplacianSmoother( double factor, int iterations, int layers = 1 );

        //! Destructor
        virtual ~CLaplacianSmoother() {}

        //! This method smoothes a mesh by Laplacian algorithm
        virtual bool    smooth( CSmoothingMesh * mesh );
};


#endif // CLAPLACIANSMOOTHER_H
