#ifndef CEIGENSMOOTHER_H
#define CEIGENSMOOTHER_H

#include <smoothers/CSmoother.h>
#include <features/CVertexInfoMV.h>

//==============================================================================
/**
 *  Eigensmoother class
 * - smoothes a mesh by zero-mean covariance algorithm ( eigensmooth )
 * - requires zero-mean covariance to be precomputed on a mesh ( see CVertexInfoGarland class )
 */
class CEigensmoother : public CSmoother
{
    protected :

		//! Additional metric postprocessing parameters
        bool    bInvert, bNormalize;

		//! Smoothing factor
        double  dFactor;

		//! Smoothing exponent ( obsolete - always set to 1.5 )
        double  dExponent;

		//! Number of iterations
        int     iIterations;

    public :

        //! Constructor parametrized by smoothing factor and couple of obsolete flags
        CEigensmoother( double factor = 0.2, bool normalize = true, bool invert = true, int iterations = 1, double exponent = 1.5 );

        //! Destructor
        virtual ~CEigensmoother();

        //! This method smoother a mesh by eigensmooth algorithm
        virtual bool    smooth( CSmoothingMesh * mesh );

        //! This method smoothes one vertex by Eigensmooth algorithm
        bool            smoothVertex( CSmoothingMesh * mesh,
                                      vctl::MCVertex * actual_vertex,
                                      vctl::MCPoint3D & smoothed_point );

};

#endif // CEIGENSMOOTHER_H
