#ifndef CMESH_H
#define CMESH_H

// mdstk includz
#include <MDSTk/Base/mdsSetup.h>
#include <MDSTk/Math/mdsMatrix.h>
#include <MDSTk/Math/mdsVector.h>
#include <MDSTk/Math/mdsMatrixFunctions.h>

#include <features/CVertexInfo.h>

//! Vector of pointers to triangles
typedef std::vector< vctl::MCTri* >     tTriPtrList;

//! Vector of pointers to vertices
typedef std::vector< vctl::MCVertex* >  tVertPtrList;

//==============================================================================
/**
 *  CSmoothingMesh class
 * - defines basic interface of a polygonal mesh
 */
class CSmoothingMesh : public mds::base::CObject, public vctl::MCTriS
{
    public :

			//! Smart pointer declaration
            MDS_SHAREDPTR(CSmoothingMesh);

    protected :

            //! Name of the mesh
            std::string     sMeshName;

            //! Path to the source of the mesh
            std::string     sMeshPath;

    public :

            //! Constructor
            CSmoothingMesh();

            //! Destructor
            virtual ~CSmoothingMesh();

            //! Loads smoothing mesh from a file
            bool    loadFile( const std::string & name );

            //! Saves smoothing mesh to a file
            bool    saveFile( const std::string & name );

            //! Disposes of all the information stored in vertices
            bool    disposeVertexInfo();

            //! Get neighbourhood triangles
            static bool    getNeighbourTri( vctl::MCVertex * actual_vertex, tTriPtrList & neighbour_tri, int neighbour_layers );

            //! Get neighbourhood vertices
            static bool    getNeighbourVert( vctl::MCVertex * actual_vertex, tVertPtrList & neighbour_vertex, int neighbour_layers );

            //! Compute the volume of the mesh
            double  getVolume();

            //! Returns normal of a vertex
            vctl::MCVector3D getNormal( vctl::MCVertex * vert );

			//! Returns normal of a vertex 
            void             getNormal( vctl::MCVertex * actual_vertex, vctl::MCVector3D * new_normal );

			//! Removes precomputed vertex normals
            void             removeVerticesNormals();

			//! Precomputes vertex normals
            void             precomputeVerticesNormals();

};

#endif // CMESH_H
