#ifndef CVERTEXINFOMV_H
#define CVERTEXINFOMV_H

#include <base/basics.h>
#include <features/CVertexInfo.h>

//==============================================================================
/**
 * VertexInfoMV class
 * - instances represent vertex feature consisting of a matrix and a vector
 */
class CVertexInfoMV : public CVertexInfo
{
    protected :

		//! Vector feature
        mds::math::CDVector     mVector;

        //! Matrix feature
        mds::math::CDMatrix     mMatrix;

    public :

        //! Constructor parametrized by vertex and matrix/vector sizes
        CVertexInfoMV( vctl::MCVertex * vertex, int mat_rows = 0, int mat_cols = 0, int vec_size = 0 );

        //! Destructor
        virtual ~CVertexInfoMV();

        //! Returns vertex colouring
        virtual osg::Vec4   getColour();

        //! Sets the matrix
        void    setMatrix( const mds::math::CDMatrix & m )
        {
            mMatrix = m;
        }

        //! Returns the matrix
        mds::math::CDMatrix  getMatrix()
        {
            return mMatrix;
        }

        //! Sets the vector
        void    setVector( const mds::math::CDVector & v )
        {
            mVector.create( v.getSize() );
            for ( int i = 0; i < v.getSize(); i++ )
            {
                mVector.get(i) = v.get(i);
            }
        }            

        //! Returns the vector
        mds::math::CDVector getVector()
        {
            return mVector;
        }



};

#endif // CVERTEXINFOMV_H
