/*
								+----------------------------------+
								|                                  |
								|     ***  VBO wrap class  ***     |
								|                                  |
								|   Copyright  -tHE SWINe- 2005   |
								|                                  |
								|       VertexBufferObject.h       |
								|                                  |
								+----------------------------------+
*/

#ifndef __VERTEX_BUFFER_OBJECT_INCLUDED
#define __VERTEX_BUFFER_OBJECT_INCLUDED

class CVertexBufferObject {
protected:
	unsigned int m_n_buffer_id;
	GLenum m_n_primary_target;
	int m_b_mapped;
	int m_n_size;
	int m_n_usage;
	int m_n_access;

public:
	CVertexBufferObject(GLenum n_target = GL_ARRAY_BUFFER_ARB);
	~CVertexBufferObject();

	static int b_Supported();

	int Bind(); // binding the buffer automatically creates it (have to bind first before alloc)
	int BindAs(GLenum n_target = GL_PIXEL_PACK_BUFFER_ARB);
	// you can copy data using glReadPixels or glGetTexImage with data parameter, returned by calling p_OffsetPointer(0)

	int Alloc(int n_size, const void *p_data = NULL, GLenum n_usage = GL_STATIC_DRAW_ARB);

	void *p_OffsetPointer(int n_offset); // for use in glDrawElements, etc ... !not! for data access!

	void BufferSubData(int n_offset, int n_size, const void *p_data);
	void GetBufferSubData(int n_offset, int n_size, void *p_data);
	void *p_Map(int n_access);
	void *p_BufferPointer(); // return pointer only in case it's been mapped

	int UnMap();

	int n_Size();
	int n_Usage();
	int b_Mapped();
	int n_AccessFlag();
};

class CVBOUnBinder {
public:
	static void UnBind(GLenum n_target = GL_ARRAY_BUFFER_ARB) { glBindBufferARB(n_target, 0); }
};

#endif //__VERTEX_BUFFER_OBJECT_INCLUDED
