/**
 *	@brief some other, less important functions
 */

void PrintRotator()
{
	const char *p_s_rot = "/-\\|";
	static int n_pos = 0;

	printf("working [%c]\r", p_s_rot[n_pos ++ & 3]);
}

class CQPCTimer {
	LARGE_INTEGER m_n_freq;
	//
	unsigned __int64 m_n_time;
	//
	float m_f_time;

public:
	CQPCTimer()
	{
		QueryPerformanceFrequency(&m_n_freq);
		m_n_time = -1;
	}

	void ResetTimer()
	{
		m_f_time = 0;
	}

	float f_Time()
	{
		LARGE_INTEGER n_cur_time;

		QueryPerformanceCounter(&n_cur_time);
		if(m_n_time == -1)
			m_f_time = 0;
		else
			m_f_time += (float)((signed)(n_cur_time.QuadPart - m_n_time)) / m_n_freq.QuadPart;
		m_n_time = n_cur_time.QuadPart;

		return m_f_time;
	}
};

int Save_TrueColor_BMP(const char *filename, const TBmp *p_bmp)
{
	unsigned int n_scanline_size;
	unsigned char *p_buffer;
	BITMAPFILEHEADER bmfh;
	BITMAPINFOHEADER bmih;
	FILE *p_fw;
	int i, j;

	n_scanline_size = ((3 * p_bmp->n_width + 3) >> 2) << 2;
	if(!(p_buffer =  new unsigned char[n_scanline_size]))
		return false;
	// compute lenght of line-buffer

	if(!(p_fw = fopen(filename, "wb")))
		return false;
	// open file

	bmih.biSize = sizeof(BITMAPINFOHEADER);
	bmih.biWidth = p_bmp->n_width;
	bmih.biHeight = p_bmp->n_height;
	bmih.biPlanes = 1;
	bmih.biBitCount = 24;
	bmih.biCompression = BI_RGB;
	bmih.biSizeImage = p_bmp->n_width * p_bmp->n_height * 3;
	bmih.biXPelsPerMeter = 96;
	bmih.biYPelsPerMeter = 96;
	bmih.biClrUsed = 0;
	bmih.biClrImportant = 0;
	//
	bmfh.bfType = ('B' | ('M' << 8));
	bmfh.bfSize = sizeof(BITMAPFILEHEADER) + bmih.biSizeImage +
				  sizeof(BITMAPINFOHEADER);
	bmfh.bfReserved1 = 0;
	bmfh.bfReserved2 = 0;
	bmfh.bfOffBits = sizeof(BITMAPFILEHEADER) +
					 sizeof(BITMAPINFOHEADER);
	// create header

	fwrite(&bmfh, sizeof(BITMAPFILEHEADER), 1, p_fw);
	fwrite(&bmih, sizeof(BITMAPINFOHEADER), 1, p_fw);
	// writing header

	for(i = p_bmp->n_height - 1; i >= 0; i --) {
		for(j = 0; j < p_bmp->n_width; j ++) {
			p_buffer[j * 3] = (char)((p_bmp->p_buffer[i * p_bmp->n_width + j] >> 16) & 0xff);
			p_buffer[j * 3 + 1] = (char)((p_bmp->p_buffer[i * p_bmp->n_width + j] >> 8) & 0xff);
			p_buffer[j * 3 + 2] = (char)(p_bmp->p_buffer[i * p_bmp->n_width + j] & 0xff);
			// saved in BGR, not RGB
		}

		if(fwrite(p_buffer, 1, n_scanline_size, p_fw) != n_scanline_size) {
			delete[] p_buffer;
			fclose(p_fw);

			return false;
		}
	}

	fclose(p_fw);
	delete[] p_buffer;

	return true;
}

char *p_s_ReadFile(const char *p_s_filename)
{
	FILE *p_fr;

	if(!(p_fr = fopen(p_s_filename, "rb")))
		return 0;
	fseek(p_fr, 0, SEEK_END);
	int n_len = ftell(p_fr);
	char *p_s_buffer;
	if(!(p_s_buffer = new char[n_len + 1])) {
		fclose(p_fr);
		return 0;
	}
	fseek(p_fr, 0, SEEK_SET);
	fread(p_s_buffer, n_len, sizeof(char), p_fr);
	p_s_buffer[n_len] = 0;
	fclose(p_fr);

	return p_s_buffer;
}

void Error(const char *p_s_error)
{
	switch(p_tr_ut->n_GetLastError()) {
	case trut_Ok:
		fprintf(stderr, "no error");
		break;
	case trut_Error:
		fprintf(stderr, "generic error - trut kaput");
		break;
	case trut_BadParams:
		fprintf(stderr, "invalid parameters");
		break;
	case trut_NoPaths:
		fprintf(stderr, "no supported paths found");
		break;
	case trut_NoShaders:
		fprintf(stderr, "no shaders found");
		break;
	case trut_NoRenderBuffer:
		fprintf(stderr, "no offscreen render buffers supported");
		break;
	case trut_NoMemory:
		fprintf(stderr, "not enough memory");
		break;
	case trut_GLError:
		fprintf(stderr, "OpenGL error");
		break;
	case trut_NoGL13:
		fprintf(stderr, "need at lest OpenGL 1.3");
		break;
	case trut_NoMultitextureExt:
		fprintf(stderr, "need multitexture extension");
		break;
	case trut_NoShaderExt:
		fprintf(stderr, "need shaders");
		break;
	case trut_BadPixelType:
		fprintf(stderr, "unsupported pixel type");
		break;
	case trut_ShCompileError:
		fprintf(stderr, "shader compile error");
		if(p_tr_ut->p_s_ShaderInfoLog())
			fprintf(stderr, " - see error log:\n%s\n ..", p_tr_ut->p_s_ShaderInfoLog());
		break;
	}

	if(p_s_error)
		fprintf(stderr, " when %s\n", p_s_error);
	else
		fprintf(stderr, "\n");

	exit(-1);
}

int My_Load_Shaders(std::vector<CShaderInfo*> &r_shader_info_list, const char *p_s_path)
{
	if(p_s_shader_file_name) {
		char *p_s_source = p_s_ReadFile(p_s_shader_file_name);
		if(!p_s_source)
			return false;

		CShaderInfo *p_shader_info;

		if(!(p_shader_info = new CShaderInfo(p_s_shader_file_name,
		   sh_lang_HighLevel, sh_type_Fragment)))
			return false;
		// create new shader info, shader name is simple_unwrap,
		// it's gefault language is high level shading language
		// and it is fragment shader (i.e. it's processing pixels)

		TShaderInfo simple_unwrap_glsl_shader;
		char *p_params = "texture"; // texture sampler (automatically set to unit 0 in CGLProgramObject::BindGL)
		simple_unwrap_glsl_shader.n_param_num = 1;
		simple_unwrap_glsl_shader.p_param_name_array = &p_params;
		simple_unwrap_glsl_shader.p_s_code = p_s_source;

		if(!p_shader_info->SetHighLevel_Code(simple_unwrap_glsl_shader)) {
			delete p_shader_info;
			return false;
		}
		// copy shader info into our shader

		r_shader_info_list.push_back(p_shader_info);
		if(!r_shader_info_list.size()) {
			delete p_shader_info;
			return false;
		}
		// put our shader info into the list

		delete[] p_s_source;
		// don't need this any more
	}
	// load shader in file

	/*if(!std_load_sh_function(r_shader_info_list, p_s_path))
		return false;*/
	// load std shader - DON'T do that!! it's mixing pointers created in
	// transformlib.dll and here .. and it doesn't seem to be good

	return true;
}

/*
 *		-end-of-file-
 */
