/*
								+---------------------------------+
								|                                 |
								|  ***   AMI Transform lib   ***  |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|    TransformLib_GlutTest.cpp    |
								|                                 |
								+---------------------------------+
*/

//#define UPLOAD_DOWNLOAD_BENCHMARKS
// run image transfer benchmarks (needs to press a key while
// looking at the console, otherwise looks it's stuck)

//#define DRAW_BORDER_POINTS
// define this if you want to see mirror border points detected by GPU

#include <windows.h>
#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <GL/gl.h>
#include <GL/glut.h>
#include <vector>

#if defined(_MSC_VER) && !defined(__MWERKS__)
#define for if(0) {} else for
#endif
// msvc 'for' scoping hack

#define __declspec(x) // don't want to export any symbols (specified by __declspec(dllexport))
#include "TrUt.h"
// that's all we need form transform-lib

#include "Jpeg.h"

static CTrUt *p_tr_ut; // pointer to transform utility object

static ImageStruct t_src_image; // source image

#ifdef DRAW_BORDER_POINTS
static ImageStruct t_frontline_image; // image with mirror border detections
#endif //DRAW_BORDER_POINTS

static const char *p_s_shader_file_name = 0; // external shaders file name

static const float Pi = 3.1415926535897932384626433832795028841971f;

static int n_tesselate = 1;
static bool b_upside = false, b_geometric = false;
// transformation parameters (set via commandline)

#include "TransformLib_GlutTest_Utils.h" //some utility functions here

static CQPCTimer timer; // application timer

void Render()
{
	float f_time = timer.f_Time();
	static float f_prev_time = 1.0f;
	static int n_frame_counter = 0;
	static float f_transform_time = 0.0f;

	n_frame_counter ++;
	if(f_time >= f_prev_time) {
		float f_fps = (float)n_frame_counter / (f_time - f_prev_time + 1.0f);

		printf("%f FPS, transformation time %f sec\n",
			f_fps, f_transform_time / n_frame_counter);

		f_transform_time = 0.0f;
		n_frame_counter = 0;
		f_prev_time = f_time + 1.0f;
	}

	if(b_geometric) {
		p_tr_ut->Set_GeomParams(.0f, .400f, .508f, .487f, f_time / 4, 1.1f,
		   789.3274f, 548.1440f, 30.0f, 90.0f, -38, 200);
	} else {
		p_tr_ut->Set_SimpleParams(.02f,
			416 / 1440.0f, 690 / 1440.0f, 1.0f - 533 / 1080.0f, f_time, 1.333f);
	}
	// update mirror parameters (here would be feedback from stabilization routine)

	static bool b_first = true;
	if(b_first) {
		b_first = false;

		if(!p_tr_ut->Upload_ImageStruct_Async(&t_src_image))
			Error("uploading image");

		p_tr_ut->WaitUntil_UploadFinished();
	}
	// upload source image

	glClear(GL_COLOR_BUFFER_BIT);

	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);
	glColor3f(1, 1, 1);

	float f_center_x = .5f;
	float f_center_y = .5f;
	// do not know where the mirror is

	float f_radius, f_pixel_ratio, f_image_ratio;
	if(b_geometric) {
		f_radius = .38f;
		f_pixel_ratio = 1.1f;
		f_image_ratio = 1.333f;
	} else {
		f_radius = 416 / 1440.0f;
		f_pixel_ratio = 1.333f;
		f_image_ratio = 1.333f;
	}
	// but we know how big it is, and we know image and pixel ratios

#ifdef DRAW_BORDER_POINTS
	const int n_points = 360; // any number in range 1 to p_tr_ut->n_SourceProcessed_Width()
	// number of edge points to detect (for mirror stabilization)

	{
		float f_width_divisor = (float)p_tr_ut->n_SourceProcessed_Width() / (360 / 2 + 2);

		glScissor(-50 + (int)((f_center_x - f_radius / f_pixel_ratio) * p_tr_ut->n_SourceProcessed_Width()),
				  -50 + (int)((f_center_y - f_radius * f_image_ratio) * p_tr_ut->n_SourceProcessed_Height()),
				  100 + (int)(f_radius * 2 / f_pixel_ratio * p_tr_ut->n_SourceProcessed_Width()), // .5x.5
				  100 + (int)(f_radius * 2 * f_image_ratio * p_tr_ut->n_SourceProcessed_Height()));
		// -25, 50 ... 25 more pixes at both sides
		// limit drawing to useful area save time

		glEnable(GL_SCISSOR_TEST);
		for(int i = 0, n_step = 0; i < p_tr_ut->n_ImgProc_Num(); ++ i, ++ n_step) {
			if(n_step == 1)
				p_tr_ut->Set_Gauss_ImageProcParams(1, 1.0f / (float)p_tr_ut->n_SourceProcessed_Width(), 0.0);
			else if(n_step == 2) {
				p_tr_ut->Set_Gauss_ImageProcParams(1, 0.0, 1.0f / (float)p_tr_ut->n_SourceProcessed_Width());
				// gauss step is two-pass
			} else if(n_step == 3) {
				p_tr_ut->Set_Radial_ImageProcParams(2, f_radius - .03f,
					f_radius + .03f, f_center_x, f_center_y, f_pixel_ratio, .02f); // last param treshold .02 (everything under .01 will be black)
				// set action radius for sobel (no need to evaluate them on the whole image)
			} else if(n_step == 4) {
				glDisable(GL_SCISSOR_TEST);
				glScissor(0, 0, n_points, 1);
				glEnable(GL_SCISSOR_TEST);
				// the last operation is the raytracer, we want it to plot
				// a line of few fragments with found intersections

				p_tr_ut->Set_Radial_ImageProcParams(3, f_radius - .02f,
					f_radius + .02f, f_center_x, f_center_y, f_pixel_ratio, f_width_divisor * 2 * Pi); // radius stretched by 0.01
				// set-up action radius of gauss and soble filters (no need to evaluate them on the whole image)
			}

			p_tr_ut->Swap_ProcessedSource_Textures();
			p_tr_ut->ProcessSourceImage(i, true, (!n_step)? p_tr_ut->n_SrcTexture_OpenGL_Id() :
				p_tr_ut->n_SrcProcessedAuxTexture_OpenGL_Id());

			if(n_step == 1)
				-- i;
			// in case it's two-pass (separable gaussian), we remain at the same index
		}
		glDisable(GL_SCISSOR_TEST);
		// process image trough all imgproc passes

		p_tr_ut->WaitUntil_SIPFinished();
		p_tr_ut->Download_ProcessedSourceImage(&t_frontline_image);
		// wait for it, download it then
	}
	// perform source image processing to detect mirror edge points
#endif //DRAW_BORDER_POINTS

	f_time = timer.f_Time();

	p_tr_ut->Transform(n_tesselate, b_upside);
	p_tr_ut->WaitUntil_TransformFinished();
	// transform mirror image (main function)

	f_transform_time += timer.f_Time() - f_time;

	static int b_first_time = true;
	if(b_first_time) {
		b_first_time = false;

#ifdef DRAW_BORDER_POINTS
		{
			TBmp t_bmp;

			t_bmp.n_width = t_frontline_image.XSize;
			t_bmp.n_height = t_frontline_image.YSize;
			t_bmp.p_buffer = (unsigned __int32*)t_frontline_image.Raster;

			Save_TrueColor_BMP("edge_raytrace.bmp", &t_bmp);
		}
#endif //DRAW_BORDER_POINTS

		{
			TBmp t_bmp;

			t_bmp.n_width = p_tr_ut->n_Transform_Width();
			t_bmp.n_height = p_tr_ut->n_Transform_Height();
			t_bmp.b_alpha = false;
			if(!(t_bmp.p_buffer = new unsigned __int32[t_bmp.n_width * t_bmp.n_height])) {
				fprintf(stderr, "not enough memory when testing Download_ImageStruct()");
				exit(-1);
			}
			// create a new bitmap ...

			ImageStruct t_is;

			t_is.XSize = t_bmp.n_width;
			t_is.YSize = t_bmp.n_height;
			t_is.XOffset = 4;
			t_is.YOffset = t_bmp.n_width * 4;
			t_is.PixelType = ImageRGB;
			t_is.Raster = (unsigned char*)t_bmp.p_buffer;

			for(int i = 0; i <= 360; i += 30) {
				char p_s_filename[64];

				sprintf(p_s_filename, "transform_%03d_.bmp", i);

				p_tr_ut->Download_ImageStruct/*_Async*/(&t_is, (float)i / 180 *
					3.1415926535897932384626433832795028841971f, 0);
				// download image-struct

				Save_TrueColor_BMP(p_s_filename, &t_bmp);
			}

#ifdef UPLOAD_DOWNLOAD_BENCHMARKS
			int n_image_size = t_bmp.n_width * t_bmp.n_height * 4;
			int n_src_image_size = t_src_image.XSize * t_src_image.YSize * 4;
			const int n_megabytes = 1024 * 1048576;
			int n_num_downloads = n_megabytes / n_image_size + 1;
			float f_megs = (n_num_downloads * n_image_size) / (float)1048576;

			printf("press enter ...");
			getchar();

			printf("\t\t=== data download benchmark ===\n");

			printf("now meassure performance by downloading %f GB of data ...\n", f_megs / 1024);

			long n_time = clock();

			for(int i = 0, n = 0; n < n_num_downloads; i += 31, n ++) {
				p_tr_ut->Download_ImageStruct(&t_is, (float)i / 180 *
					3.1415926535897932384626433832795028841971693993f, 0);
				// download image-struct
				PrintRotator();
			}

			float f_time = (float)(clock() - n_time) / (float)CLOCKS_PER_SEC;

			printf("done ... it took %f secs, yielding transfer rate %f MBpS\n",
				f_time, f_megs / f_time);

			printf("now meassure performance by downloading %f GB of data async ...\n", f_megs / 1024);

			n_time = clock();

			float f_saved_time = 0;

			for(int i = 0, n = 0; n < n_num_downloads; i += 31, n ++) {
				p_tr_ut->Download_ImageStruct_Async(&t_is, (float)i / 180 *
					3.1415926535897932384626433832795028841971693993f, 0);
				// download image-struct (first frame is going to be blank)

				long n_sub_time = clock();

				while(!p_tr_ut->b_DownloadFinished()) {
					PrintRotator();
					p_tr_ut->WaitUntil_DownloadFinished();
					if(!p_tr_ut->b_DownloadFinished())
						printf("!!!");
				}
				// test if it's really async (it really is!)

				f_saved_time += (float)(clock() - n_sub_time) / (float)CLOCKS_PER_SEC;
			}

			f_time = (float)(clock() - n_time) / (float)CLOCKS_PER_SEC;

			printf("done ... it took %f secs, yielding transfer rate %f MBpS\n",
				f_time, f_megs / f_time);
			printf("we saved %f secs, yielding theoretical transfer rate %f MBpS\n",
				f_saved_time, f_megs / (f_time - f_saved_time));

			printf("\n\t\t=== data upload benchmark ===\n");

			n_num_downloads = n_megabytes / n_src_image_size + 1;
			f_megs = (n_num_downloads * n_src_image_size) / (float)1048576;

			printf("now meassure performance by uploading %f GB of data ...\n", f_megs / 1024);

			n_time = clock();

			for(int i = 0, n = 0; n < n_num_downloads; i += 31, n ++) {
				p_tr_ut->Upload_ImageStruct(&t_src_image);
				// upload image-struct
				PrintRotator();
			}

			f_time = (float)(clock() - n_time) / (float)CLOCKS_PER_SEC;

			printf("done ... it took %f secs, yielding transfer rate %f MBpS\n",
				f_time, f_megs / f_time);

			printf("now meassure performance by uploading %f GB of data async ...\n", f_megs / 1024);

			n_time = clock();

			f_saved_time = 0;

			for(int i = 0, n = 0; n < n_num_downloads; i += 31, n ++) {
				p_tr_ut->Upload_ImageStruct_Async(&t_src_image);
				// upload image-struct

				long n_sub_time = clock();

				while(!p_tr_ut->b_UploadFinished()) {
					PrintRotator();
					p_tr_ut->WaitUntil_UploadFinished();
					if(!p_tr_ut->b_UploadFinished())
						printf("!!!");
				}
				// test if it's really async (it really is!)

				f_saved_time += (float)(clock() - n_sub_time) / (float)CLOCKS_PER_SEC;
			}

			f_time = (float)(clock() - n_time) / (float)CLOCKS_PER_SEC;

			printf("done ... it took %f secs, yielding transfer rate %f MBpS\n",
				f_time, f_megs / f_time);
			printf("we saved %f secs, yielding theoretical transfer rate %f MBpS\n",
				f_saved_time, f_megs / (f_time - f_saved_time));
#endif // UPLOAD_DOWNLOAD_BENCHMARKS

			delete[] t_bmp.p_buffer;
		}
	}
	// write a bunch of bitmaps, containing unfolded image, rotated 360 degrees with
	// 30 degree step; 360 inclusive -> first and last one should be the same

	p_tr_ut->ReleaseFramebuffer();
	// NOW release framebuffer, because we were transfering data from it
	// (otherwise we'd be reading contents of our glut window)

	if(glGetError() != GL_NO_ERROR)
		return;

	glViewport(25, 25, 800, 600); // fixed size viewport! window will not react to resize
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	// have to call this before every frame (can skip the matrix stuff in second frame and on)

	{
		glPushMatrix();

		glScalef(1.0f, -2.0f / Pi, 0);
		// scale image so proportions are allright

#ifdef DRAW_BORDER_POINTS
		glTranslatef(0, -0.75f, 0);
#endif //DRAW_BORDER_POINTS

		p_tr_ut->GL_TexturedRect(-1, -1, 0, 0,
								  1,  1, 1, 1, p_tr_ut->n_TransformedTexture_OpenGL_Id());

		glPopMatrix();
	}
	// draw a single quad with transformed image

#ifdef DRAW_BORDER_POINTS
	{
		glTranslatef(0, -.6f, 0);
		glScalef(.4, .4, 0);
		p_tr_ut->GL_TexturedRect(-1, -1, 0, 0,
								  1,  1, 1, 1, p_tr_ut->/*n_SrcProcessedAuxTexture_OpenGL_Id*/n_SrcTexture_OpenGL_Id());
		// draw source image (mirror image, as seen by camera)

		float f_x[n_points];
		float f_y[n_points];
		for(int i = 0; i < t_frontline_image.XSize; i ++) {
			f_x[i] = (float)((unsigned short*)t_frontline_image.Raster)[2 * i] / 32640.0f - 1.0;
			f_y[i] = (float)((unsigned short*)t_frontline_image.Raster)[2 * i + 1] / 32640.0f - 1.0;
			f_x[i] *= 1024;
			f_y[i] *= 768;// important to use same scale the image has
		}
		// x, y and scale it to prevent float errors

		glEnable(GL_POINT_SMOOTH);
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		glBegin(GL_POINTS);
		for(int i = 0; i < t_frontline_image.XSize; i ++) {
			if(!((unsigned __int32*)t_frontline_image.Raster)[i])
				continue;
			// not-found points marked as all zeros

			float x = (float)((unsigned short*)t_frontline_image.Raster)[2 * i] / 32640.0f - 1.0;
			float y = (float)((unsigned short*)t_frontline_image.Raster)[2 * i + 1] / 32640.0f - 1.0;
			glVertex2f(f_x[i] / 1024, f_y[i] / 768);
		}
		glEnd();
		glDisable(GL_BLEND);
		// draw mirror border points
	}
#endif //DRAW_BORDER_POINTS

	glBindTexture(GL_TEXTURE_2D, p_tr_ut->n_SrcTexture_OpenGL_Id());
	// TransformLib is actually caching OpenGL state, we need to leave it as it was,
	// the last call to TransformLib, p_tr_ut->Transform() sets source image texture,
	// so we need to put it back.

	if(glGetError() != GL_NO_ERROR)
		return;

	glutSwapBuffers(); // don't use p_tr_ut->GL_PageFlip(); when using glut
}


int main(int argc, char **argv)
{
	int n_transform_type;

	printf("TransformLib example\n"
		   "call with such a parameters:\n"
		   "transformlib_test_glut.exe TT IPP [-sf F]\n"
		   "where TT is transform type (-simple, -geom,  -polynet, -persp or -polypersp)\n"
		   "you may also pass IPP (either -none, -skin or -gray)\n"
		   "you may also pass external shader filename F\n"
		   "(shader must correspond with TT, IPP must be passed as well)\n"
		   "\n"
		   "Note that when specifying external shader filename, it's name is important,\n"
		   "it should begin with transformation name (simple_, geom_, polynet_, persp_ or\n"
		   "polypersp_), continue with immediate image processing it does (noipp_, skin_,\n"
		   "gray_) and the rest of the filename doesn't matter. So, for example, when using\n"
		   "included shader file \'geom_noipp_unwrap.glslang\', one must call:\n"
		   "\n"
		   "transformlib_test_glut.exe -geom -none -sf geom_noipp_unwrap.glslang\n"
		   "\n"
		   "In case shader have wrong name, application ends up with \"no shaders found\n"
		   "when initializing\" message.\n"
		   "\n"
		   "Example will create 800x600 glut window, load jpeg image\n"
		   "and begin loop with transformations. In the first frame, it\n"
		   "creates \'transform_000_.bmp\' - \'transform_360_.bmp\' with purpose\n"
		   "to test image downloading. Then it displays unfolded image via OpenGL\n"
		   "\n"
		   "Note unfolded image is displayed with red and blue channels swapped,\n"
		   "this is due to uploading image data as if it were GL_BGRA, because\n"
		   "that is GeForce's native format, and yields best upload speeds\n");

	b_geometric = true;
	if(argc < 2 || !strcmp(argv[1], "-simple")) {
		n_transform_type = tt_Simple;
		b_geometric = false;
	} else if(!strcmp(argv[1], "-geom"))
		n_transform_type = tt_Geometrical;
	else if(!strcmp(argv[1], "-polynet"))
		n_transform_type = tt_Geom_Polynet;
	else if(!strcmp(argv[1], "-persp"))
		n_transform_type = tt_Geom_Perspective;
	else if(!strcmp(argv[1], "-polypersp"))
		n_transform_type = tt_Geom_PolynetPersp;
	else {
		fprintf(stderr, "first parameter must be either -simple, -geom or -polynet\n");
		return -1;
	}
	// parse params

	int n_ipp_type;

	if(argc < 3 || !strcmp(argv[2], "-none"))
		n_ipp_type = ipp_None;
	else if(!strcmp(argv[2], "-skin"))
		n_ipp_type = ipp_SkinDetect;
	else if(!strcmp(argv[2], "-gray"))
		n_ipp_type = ipp_CalcGrayscale;
	else {
		fprintf(stderr, "second parameter must be either either -none, -skin or -gray\n");
		return -1;
	}
	// parse params

	for(int i = 3; i < argc; i ++) {
		if(!_stricmp(argv[i], "-upside"))
			b_upside = true;
		else if(!strncmp(argv[i], "-t", 2))
			n_tesselate = atol(argv[i] + 2);
		else if(!_stricmp(argv[i], "-sf") && i + 1 < argc)
			p_s_shader_file_name = argv[++ i];
		else
			fprintf(stderr, "warning: unknown argument: %s\n", argv[i]);
	}
	// parse params

	char *p_s_par1[] = {"-simple", "-geom", "-polynet", "-persp", "-polypersp"};
	char *p_s_par2[] = {"-none", "-skin", "-gray"};
	printf("you've chosen %s %s %s, tesselation %d .. moderate choice!\n\n",
		p_s_par1[n_transform_type], p_s_par2[n_ipp_type],
		(b_upside)? "upside-down" : "upside-up", n_tesselate);

    glutInit(&argc, argv);
    glutInitWindowSize(850, 650);
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB);
    glutCreateWindow("Very simple TransformLib demo");

	// ---

	CTrUt my_transform_util;
	p_tr_ut = &my_transform_util;

	tImage *p_bmp;
	if(n_transform_type == tt_Simple)
		p_bmp = LoadJPG("mirror_new.jpg");
	else
		p_bmp = LoadJPG("mirror_h3g.jpg");
	if(!p_bmp) {
		fprintf(stderr, "error loading source image, make sure mirror_new.jpg\n"
						"or mirror_h3g.jpg is in the same folder as .exe\n");
		return -1;
	}
	memset(&t_src_image, 0, sizeof(t_src_image));
	t_src_image.PixelType = ImageRGB;
	if(p_bmp->channels != 4) {
		fprintf(stderr, "source image doesn't have four channels (RGBx)\n"
						"no conversion was implemented .. quitting though\n");
		return -1;
	}
	t_src_image.Raster = p_bmp->data;
	t_src_image.XSize = p_bmp->sizeX;
	t_src_image.YSize = p_bmp->sizeY;
	t_src_image.XOffset = 4;
	t_src_image.YOffset = p_bmp->sizeX * 4;
	delete p_bmp;
	// load source image from jpeg

#ifdef DRAW_BORDER_POINTS
	int p_sip_list[] = {sip_Gray, sip_Gauss5_Mono,
		sip_Sobel_RadialCutoffMono, sip_RaytraceFrontline};
	int n_sip_num = sizeof(p_sip_list) / sizeof(p_sip_list[0]);
	// we want grayscale filter, gauss filter, radial sobel filter and raytracer
#else //DRAW_BORDER_POINTS
	int p_sip_list[] = {0};
	int n_sip_num = 0;
	// no post-processing
#endif //DRAW_BORDER_POINTS

	//std_load_sh_function = my_transform_util.std_Load_Shaders;
	if(!my_transform_util.Init(n_transform_type, n_ipp_type, p_sip_list, n_sip_num, true,
	   t_src_image.XSize, t_src_image.YSize, int(t_src_image.XSize * Pi / 8), t_src_image.XSize / 4,
	   GL_BGRA, GL_UNSIGNED_BYTE, GL_BGRA, GL_UNSIGNED_BYTE,
	   my_transform_util.std_Load_RenderPaths, (!p_s_shader_file_name)?
	   my_transform_util.std_Load_Shaders : My_Load_Shaders))
		Error("initializing");
	// call init (it's important so image type is RGBA ... size of buffer for asynchronous
	// copying is determined from this)

#ifdef DRAW_BORDER_POINTS
	memset(&t_frontline_image, 0, sizeof(t_frontline_image));
	t_frontline_image.PixelType = ImageRGB;
	t_frontline_image.XSize = my_transform_util.n_SourceProcessed_Width() / 4;
	t_frontline_image.Raster = new unsigned char[t_frontline_image.XSize * 4];
	t_frontline_image.YSize = 1;
	t_frontline_image.XOffset = 4;
	t_frontline_image.YOffset = t_frontline_image.XSize * 4;
	// create bitmap for storing "frontline" - output from edge raytracer
#endif //DRAW_BORDER_POINTS

	if(n_ipp_type == ipp_SkinDetect) {
		if(!my_transform_util.Set_SkindetectParams(20.172f / 50.0f, 15.379f / 50.0f))
			Error("setting skin-detection params");
	}
	// set skin-detection params

	if(n_transform_type == tt_Simple) {
		if(!my_transform_util.Set_SimpleParams(.02f,
			416 / 1440.0f, 690 / 1440.0f, 1.0f - 533 / 1080.0f, 0, 1.333f))
			Error("setting transformation params");
		// 416 is radius of the mirror, meassured in vertical direction,
		// 1440 is width, 690 is center-x, 533 is center-y, 1080 is image height
	} else {
		if(!my_transform_util.Set_GeomParams(.033f, .400f, .508f, .487f,
		   -3.141592653589793238462643383279502884197110753993f * .75f, 1.1f,
		   789.3274f, 548.1440f, 30.0f, 90.0f, -38, 200))
			Error("setting transformation params"); // -8.7, 55.0
	}

	// --- ~init open-gl

	glutIdleFunc(Render);
	glutDisplayFunc(Render);
    glutMainLoop();

    return 0;
}

/*
 *		-end-of-file-
 */
