/*
								+---------------------------------+
								|                                 |
								|  ***   AMI Tr. datafiles   ***  |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|         TransformData.h         |
								|                                 |
								+---------------------------------+
*/

#include <crtdbg.h>
#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>
#include <gl/glaux.h>
#include <vector>

//#define __declspec(dllexport)

#include "glext.h"
#include "wglext.h"
#include "opengl20.h"
#include "glstate.h"

#include "RenderPath.h"
#include "shader.h"

#include "transformdata.h"

int __declspec(dllexport) __Load_RenderPaths(std::vector<TPath*> &r_path_list) // may be substituted by some xml parser, for example
{
	TPath *p_path;

	p_path = new TPath;
	if(!p_path->Create("NV_45", "GL_ARB_texture_non_power_of_two", "nvidia *", 0)) {
		delete p_path;
		return false;
	}
	// create path, called "NV_45", requiring GL_ARB_texture_non_power_of_two extension,
	// supporting nvidia and * (=any) vendors, no card models are included / excluded

	r_path_list.push_back(p_path);
	if(!r_path_list.size()) {
		delete p_path;
		return false;
	}
	// put this path into the list

	return true;
}

int CreateTabledShader(int n_index, std::vector<CShaderInfo*> &r_shader_info_list);
int n_TabledShader_Num();

int __declspec(dllexport) __Load_ShaderInfo(std::vector<CShaderInfo*> &r_shader_info_list, const char *p_s_path) // may be substitued by some xml parser that would load all shader infos from directory p_s_path (corresponding to rendering path name, for example "nvidia", "ati", etc...)
{
	if(!_stricmp(p_s_path, "NV_45")) {
		for(int i = 0; i < n_TabledShader_Num(); i ++) {
			if(!CreateTabledShader(i, r_shader_info_list))
				return false;
		}
		// create shaders, placed inside list
	}
	// load shaders for NV_45 rendering path

	return true;
}

static const struct {
	int n_lang;
	int n_type;
	char *p_s_name;
	char *p_s_code;
} p_shader_list[] = {
/*
 *								=== simple_ shaders ===
 */

	{sh_lang_HighLevel, sh_type_Fragment, "simple_noipp_unwrap",
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { r_inner, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"\n"
		"void main() {\n"
		"  vec2 texcoord;\n"
		"  texcoord.x = mirror_area.z + cos(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y);\n"
		"  texcoord.y = mirror_area.w + sin(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y) * offset_ratio.y;\n"
		"  gl_FragColor = texture2D(texture, texcoord)/*.zyxw*/;\n"
		"}\n"
	},

	{sh_lang_HighLevel, sh_type_Fragment, "simple_gray_unwrap",
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { r_inner, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"\n"
		"void main() {\n"
		"  vec2 texcoord;\n"
		"  texcoord.x = mirror_area.z + cos(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y);\n"
		"  texcoord.y = mirror_area.w + sin(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y) * offset_ratio.y;\n"
		"  vec4 color = texture2D(texture, texcoord)/*.zyxw*/;\n"

		"  const vec3 pal = vec3(.299, .587, .114);\n"
		"  color.w = dot(color.xyz, pal);"
		"  gl_FragColor = color;"
		"}\n"
	},

	{sh_lang_HighLevel, sh_type_Fragment, "simple_skin_unwrap",
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { r_inner, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 covariant;\n" // { k11, k21, k12, k22 }
		"uniform vec2 avg_rg;\n" // { R, G }
		"\n"
		"void main() {\n"
		"  vec2 texcoord;\n"
		"  texcoord.x = mirror_area.z + cos(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y);\n"
		"  texcoord.y = mirror_area.w + sin(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y) * offset_ratio.y;\n"
		"  vec4 color = texture2D(texture, texcoord)/*.zyxw*/;\n"

		"  gl_FragColor.xyz = color.xyz;\n"
		"  float sum = color.x + color.y + color.z;\n" // skin-detection
		"  vec2 rg_color; \n"
		"  rg_color = color.zy / sum;\n"
		"  rg_color -= avg_rg;\n"
		"  sum = (rg_color.x * dot(rg_color, covariant.xy) +\n"
		"         rg_color.y * dot(rg_color, covariant.zw)) * -.5;"
		"  gl_FragColor.w = exp(sum);\n"
		"}\n"
	},

/*
 *								=== ~simple_ shaders ===
 */

/*
 *								=== geom_ shaders ===
 */
/*
Vraci x-souradnici pruseciku primky se zrcadlem
  // q - line direction through the pixel on the plane and the mirror focus
   // return X coordinate of the mirror point to compute projection through the projection center
   // computing kvadratic equation and their elements a,b,c and diskriminant D

e = sqrt(a^2 + b^2)
fov = tan(3.14159 * 90.0 / 360.0)

AxisA, AxisB, -2*AxisB*e, AxisA*AxisB,
x_bottom, x_top - x_bottom, AxisB*e*e, fov

   float a=AxisB*q*q-AxisA;
   float b=-2*AxisB*q*e;
   float c=AxisB*e*e-AxisA*AxisB;
   float D=b*b-4*a*c;
   return result=(-b+sqrt(D))/(2*a);
  */

	{sh_lang_HighLevel, sh_type_Fragment, "geom_noipp_unwrap",
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"\n"
		"void main()\n"
		"{\n"
		"  vec3 v_direction;\n"
		"  v_direction.xy = offset_ratio.xx + gl_TexCoord[0].xx * 6.283186;\n"
		"  v_direction.y += 1.570796;\n"
		"  v_direction.xy = sin(v_direction.xy);\n"
		"  v_direction.z = geom_offset.w - (geom_offset.x + geom_offset.y * gl_TexCoord[0].y);\n"
		"\n" // apply rotation
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  v_direction *= f_r * (mirror_area.y - mirror_area.x) + mirror_area.x;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  v_direction.xy += mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  gl_FragColor = texture2D(texture, v_direction.xy);\n"
		"}\n"
	},

	{sh_lang_HighLevel, sh_type_Fragment, "geom_gray_unwrap",
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"\n"
		"void main()\n"
		"{\n"
		"  vec3 v_direction;\n"
		"  v_direction.xy = offset_ratio.xx + gl_TexCoord[0].xx * 6.283186;\n"
		"  v_direction.y += 1.570796;\n"
		"  v_direction.xy = sin(v_direction.xy);\n"
		"  v_direction.z = geom_offset.w - (geom_offset.x + geom_offset.y * gl_TexCoord[0].y);\n"
		"\n" // apply rotation
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  v_direction *= f_r * (mirror_area.y - mirror_area.x) + mirror_area.x;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  v_direction.xy += mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  vec4 color = texture2D(texture, v_direction.xy);\n"

		"  const vec3 pal = vec3(.299, .587, .114);\n"
		"  color.w = dot(color.xyz, pal);"
		"  gl_FragColor = color;"
		"}\n"
	},

	{sh_lang_HighLevel, sh_type_Fragment, "geom_skin_unwrap",
		"uniform vec4 covariant;\n" // { k11, k21, k12, k22 }
		"uniform vec2 avg_rg;\n" // { R, G }
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"\n"
		"void main()\n"
		"{\n"
		"  vec3 v_direction;\n"
		"  v_direction.xy = offset_ratio.xx + gl_TexCoord[0].xx * 6.283186;\n"
		"  v_direction.y += 1.570796;\n"
		"  v_direction.xy = sin(v_direction.xy);\n"
		"  v_direction.z = geom_offset.w - (geom_offset.x + geom_offset.y * gl_TexCoord[0].y);\n"
		"\n" // apply rotation
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  v_direction *= f_r * (mirror_area.y - mirror_area.x) + mirror_area.x;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  v_direction.xy += mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  vec4 color = texture2D(texture, v_direction.xy);\n"

		"  gl_FragColor.xyz = color.xyz;\n"
		"  float sum = color.x + color.y + color.z;\n" // skin-detection
		"  vec2 rg_color; \n"
		"  rg_color = color.zy / sum;\n"
		"  rg_color -= avg_rg;\n"
		"  sum = (rg_color.x * dot(rg_color, covariant.xy) +\n"
		"         rg_color.y * dot(rg_color, covariant.zw)) * -.5;"
		"  gl_FragColor.w = exp(sum);\n"
		"}\n"
	},

	{sh_lang_HighLevel, sh_type_Fragment, "persp_noipp_unwrap",
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"\n"
		"void main()\n"
		"{\n"
		"  vec3 v_direction = vec3(1.0, geom_offset.z * (2.0 * gl_TexCoord[0].x - 1.0),\n"
		"    geom_offset.w - (geom_offset.x + geom_offset.y * gl_TexCoord[0].y));\n"
		"  v_direction /= length(v_direction.xy);\n"
		"\n" // plane -> cylinder projection
		"  vec4 v_base;\n"
		"  v_base.xy = offset_ratio.xx;\n"
		"  v_base.y += 1.570796;\n"
		"  v_base.xyz = sin(v_base.xy).xyy;\n" // doing two sine instructions in a single step
		"  v_base.w = -v_base.x;\n"
		"  v_base *= v_direction.xxyy;\n"
		"  v_direction.xy = v_base.xy + v_base.zw;\n"
		"\n" // apply rotation (t_odo - create v_base using single sin instruction)
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  f_r *= mirror_area.y;\n"
		"  v_direction *= f_r;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  v_direction.xy += mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  gl_FragColor = texture2D(texture, v_direction.xy);\n"
		"}\n"
	},

	{sh_lang_HighLevel, sh_type_Fragment, "persp_gray_unwrap",
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"\n"
		"void main()\n"
		"{\n"
		"  vec3 v_direction = vec3(1.0, geom_offset.z * (2.0 * gl_TexCoord[0].x - 1.0),\n"
		"    geom_offset.w - (geom_offset.x + geom_offset.y * gl_TexCoord[0].y));\n"
		"  v_direction /= length(v_direction.xy);\n"
		"\n" // plane -> cylinder projection
		"  vec4 v_base;\n"
		"  v_base.xy = offset_ratio.xx;\n"
		"  v_base.y += 1.570796;\n"
		"  v_base.xyz = sin(v_base.xy).xyy;\n" // doing two sine instructions in a single step
		"  v_base.w = -v_base.x;\n"
		"  v_base *= v_direction.xxyy;\n"
		"  v_direction.xy = v_base.xy + v_base.zw;\n"
		"\n" // apply rotation (t_odo - create v_base using single sin instruction)
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  f_r *= mirror_area.y;\n"
		"  v_direction *= f_r;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  v_direction.xy += mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  vec4 color = texture2D(texture, v_direction.xy);\n"

		"  const vec3 pal = vec3(.299, .587, .114);\n"
		"  color.w = dot(color.xyz, pal);"
		"  gl_FragColor = color;"
		"}\n"
	},

	{sh_lang_HighLevel, sh_type_Fragment, "persp_skin_unwrap",
		"uniform vec4 covariant;\n" // { k11, k21, k12, k22 }
		"uniform vec2 avg_rg;\n" // { R, G }
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"\n"
		"void main()\n"
		"{\n"
		"  vec3 v_direction = vec3(1.0, geom_offset.z * (2.0 * gl_TexCoord[0].x - 1.0),\n"
		"    geom_offset.w - (geom_offset.x + geom_offset.y * gl_TexCoord[0].y));\n"
		"  v_direction /= length(v_direction.xy);\n"
		"\n" // plane -> cylinder projection
		"  vec4 v_base;\n"
		"  v_base.xy = offset_ratio.xx;\n"
		"  v_base.y += 1.570796;\n"
		"  v_base.xyz = sin(v_base.xy).xyy;\n" // doing two sine instructions in a single step
		"  v_base.w = -v_base.x;\n"
		"  v_base *= v_direction.xxyy;\n"
		"  v_direction.xy = v_base.xy + v_base.zw;\n"
		"\n" // apply rotation (t_odo - create v_base using single sin instruction)
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  f_r *= mirror_area.y;\n"
		"  v_direction *= f_r;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  v_direction.xy += mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  vec4 color = texture2D(texture, v_direction.xy);\n"

		"  gl_FragColor.xyz = color.xyz;\n"
		"  float sum = color.x + color.y + color.z;\n" // skin-detection
		"  vec2 rg_color; \n"
		"  rg_color = color.zy / sum;\n"
		"  rg_color -= avg_rg;\n"
		"  sum = (rg_color.x * dot(rg_color, covariant.xy) +\n"
		"         rg_color.y * dot(rg_color, covariant.zw)) * -.5;"
		"  gl_FragColor.w = exp(sum);\n"
		"}\n"
	},

/*
 *								=== ~geom_ shaders ===
 */

/*
 *								=== polynet_ shaders ===
 */

	{sh_lang_HighLevel, sh_type_Vertex, "polynet_noipp_unwrap",
		"varying vec2 texcoord;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"\n"
		"void main()\n"
		"{\n"
		"  vec2 v_texcoord = gl_MultiTexCoord0.xy * mat2(gl_TextureMatrix[0]);\n" // don't forget to transform texcoords!!!
		"  vec3 v_direction;\n"
		"  v_direction.xy = offset_ratio.xx + v_texcoord.xx * 6.283186;\n"
		"  v_direction.y += 1.570796;\n"
		"  v_direction.xy = sin(v_direction.xy);\n"
		"  v_direction.z = geom_offset.w - (geom_offset.x + geom_offset.y * v_texcoord.y);\n"
		"\n" // apply rotation
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  v_direction *= f_r * (mirror_area.y - mirror_area.x) + mirror_area.x;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  texcoord = v_direction.xy + mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  gl_Position = ftransform();\n"
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "polynet_noipp_unwrap",
		"uniform sampler2D texture;\n"
		"varying vec2 texcoord;\n"
		"\n"
		"void main()\n"
		"{\n"
		"  gl_FragColor = texture2D(texture, texcoord)/*.zyxw*/;\n"
		"}\n"
	},
	
	{sh_lang_HighLevel, sh_type_Vertex, "polynet_skin_unwrap",
		"varying vec2 texcoord;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"\n"
		"void main()\n"
		"{\n"
		"  vec2 v_texcoord = gl_MultiTexCoord0.xy * mat2(gl_TextureMatrix[0]);\n" // don't forget to transform texcoords!!!
		"  vec3 v_direction;\n"
		"  v_direction.xy = offset_ratio.xx + v_texcoord.xx * 6.283186;\n"
		"  v_direction.y += 1.570796;\n"
		"  v_direction.xy = sin(v_direction.xy);\n"
		"  v_direction.z = geom_offset.w - (geom_offset.x + geom_offset.y * v_texcoord.y);\n"
		"\n" // apply rotation
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  v_direction *= f_r * (mirror_area.y - mirror_area.x) + mirror_area.x;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  texcoord = v_direction.xy + mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  gl_Position = ftransform();\n"
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "polynet_skin_unwrap",
		"uniform sampler2D texture;\n"
		"varying vec2 texcoord;\n"
		"uniform vec4 covariant;\n" // { k11, k21, k12, k22 }
		"uniform vec2 avg_rg;\n" // { R, G }
		"\n"
		"void main()\n"
		"{\n"
		"  vec4 color = texture2D(texture, texcoord)/*.zyxw*/;\n"

		"  gl_FragColor.xyz = color.xyz;\n"
		"  float sum = color.x + color.y + color.z;\n" // skin-detection
		"  vec2 rg_color; \n"
		"  rg_color = color.zy / sum;\n"
		"  rg_color -= avg_rg;\n"
		"  sum = (rg_color.x * dot(rg_color, covariant.xy) +\n"
		"         rg_color.y * dot(rg_color, covariant.zw)) * -.5;"
		"  gl_FragColor.w = exp(sum);\n"
		"}\n"
	},

	{sh_lang_HighLevel, sh_type_Vertex, "polynet_gray_unwrap",
		"varying vec2 texcoord;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"\n"
		"void main()\n"
		"{\n"
		"  vec2 v_texcoord = gl_MultiTexCoord0.xy * mat2(gl_TextureMatrix[0]);\n" // don't forget to transform texcoords!!!
		"  vec3 v_direction;\n"
		"  v_direction.xy = offset_ratio.xx + v_texcoord.xx * 6.283186;\n"
		"  v_direction.y += 1.570796;\n"
		"  v_direction.xy = sin(v_direction.xy);\n"
		"  v_direction.z = geom_offset.w - (geom_offset.x + geom_offset.y * v_texcoord.y);\n"
		"\n" // apply rotation
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  v_direction *= f_r * (mirror_area.y - mirror_area.x) + mirror_area.x;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  texcoord = v_direction.xy + mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  gl_Position = ftransform();\n"
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "polynet_gray_unwrap",
		"uniform sampler2D texture;\n"
		"varying vec2 texcoord;\n"
		"\n"
		"void main()\n"
		"{\n"
		"  vec4 color = texture2D(texture, texcoord)/*.zyxw*/;\n"

		"  const vec3 pal = vec3(.299, .587, .114);\n"
		"  color.w = dot(color.xyz, pal);"
		"  gl_FragColor = color;"
		"}\n"
	},


	{sh_lang_HighLevel, sh_type_Vertex, "polypersp_noipp_unwrap",
		"varying vec2 texcoord;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"\n"
		"void main()\n"
		"{\n"
		"  vec2 v_texcoord = gl_MultiTexCoord0.xy * mat2(gl_TextureMatrix[0]);\n" // don't forget to transform texcoords!!!
		"  vec3 v_direction = vec3(1.0, geom_offset.z * (2.0 * v_texcoord.x - 1.0),\n"
		"    geom_offset.w - (geom_offset.x + geom_offset.y * v_texcoord.y));\n"
		"  v_direction /= length(v_direction.xy);\n"
		"\n" // plane -> cylinder projection
		"  vec4 v_base;\n"
		"  v_base.xy = offset_ratio.xx;\n"
		"  v_base.y += 1.570796;\n"
		"  v_base.xyz = sin(v_base.xy).xyy;\n" // doing two sine instructions in a single step
		"  v_base.w = -v_base.x;\n"
		"  v_base *= v_direction.xxyy;\n"
		"  v_direction.xy = v_base.xy + v_base.zw;\n"
		"\n" // apply rotation (t_odo - create v_base using single sin instruction)
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  f_r *= mirror_area.y;\n"
		"  v_direction *= f_r;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  texcoord = v_direction.xy + mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  gl_Position = ftransform();\n"
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "polypersp_noipp_unwrap",
		"uniform sampler2D texture;\n"
		"varying vec2 texcoord;\n"
		"\n"
		"void main()\n"
		"{\n"
		"  gl_FragColor = texture2D(texture, texcoord)/*.zyxw*/;\n"
		"}\n"
	},
	
	{sh_lang_HighLevel, sh_type_Vertex, "polypersp_skin_unwrap",
		"varying vec2 texcoord;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"void main()\n"
		"{\n"
		"  vec2 v_texcoord = gl_MultiTexCoord0.xy * mat2(gl_TextureMatrix[0]);\n" // don't forget to transform texcoords!!!
		"  vec3 v_direction = vec3(1.0, geom_offset.z * (2.0 * v_texcoord.x - 1.0),\n"
		"    geom_offset.w - (geom_offset.x + geom_offset.y * v_texcoord.y));\n"
		"  v_direction /= length(v_direction.xy);\n"
		"\n" // plane -> cylinder projection
		"  vec4 v_base;\n"
		"  v_base.xy = offset_ratio.xx;\n"
		"  v_base.y += 1.570796;\n"
		"  v_base.xyz = sin(v_base.xy).xyy;\n" // doing two sine instructions in a single step
		"  v_base.w = -v_base.x;\n"
		"  v_base *= v_direction.xxyy;\n"
		"  v_direction.xy = v_base.xy + v_base.zw;\n"
		"\n" // apply rotation (t_odo - create v_base using single sin instruction)
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  f_r *= mirror_area.y;\n"
		"  v_direction *= f_r;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  texcoord = v_direction.xy + mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  gl_Position = ftransform();\n"
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "polypersp_skin_unwrap",
		"uniform sampler2D texture;\n"
		"varying vec2 texcoord;\n"
		"uniform vec4 covariant;\n" // { k11, k21, k12, k22 }
		"uniform vec2 avg_rg;\n" // { R, G }
		"\n"
		"void main()\n"
		"{\n"
		"  vec4 color = texture2D(texture, texcoord)/*.zyxw*/;\n"

		"  gl_FragColor.xyz = color.xyz;\n"
		"  float sum = color.x + color.y + color.z;\n" // skin-detection
		"  vec2 rg_color; \n"
		"  rg_color = color.zy / sum;\n"
		"  rg_color -= avg_rg;\n"
		"  sum = (rg_color.x * dot(rg_color, covariant.xy) +\n"
		"         rg_color.y * dot(rg_color, covariant.zw)) * -.5;"
		"  gl_FragColor.w = exp(sum);\n"
		"}\n"
	},

	{sh_lang_HighLevel, sh_type_Vertex, "polypersp_gray_unwrap",
		"varying vec2 texcoord;\n"
		"uniform vec4 mirror_area;\n" // { 0, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { AxisA, AxisB, -2*AxisB*e, 2*(AxisB*e*e-AxisA*AxisB) }
		"uniform vec4 geom_offset;\n" // { x_bottom, x_top - x_bottom, fov, -e }
		"\n"
		"void main()\n"
		"{\n"
		"  vec2 v_texcoord = gl_MultiTexCoord0.xy * mat2(gl_TextureMatrix[0]);\n" // don't forget to transform texcoords!!!
		"  vec3 v_direction = vec3(1.0, geom_offset.z * (2.0 * v_texcoord.x - 1.0),\n"
		"    geom_offset.w - (geom_offset.x + geom_offset.y * v_texcoord.y));\n"
		"  v_direction /= length(v_direction.xy);\n"
		"\n" // plane -> cylinder projection
		"  vec4 v_base;\n"
		"  v_base.xy = offset_ratio.xx;\n"
		"  v_base.y += 1.570796;\n"
		"  v_base.xyz = sin(v_base.xy).xyy;\n" // doing two sine instructions in a single step
		"  v_base.w = -v_base.x;\n"
		"  v_base *= v_direction.xxyy;\n"
		"  v_direction.xy = v_base.xy + v_base.zw;\n"
		"\n" // apply rotation (t_odo - create v_base using single sin instruction)
		"  float f_q = v_direction.z - 2.0 * geom_offset.w;\n"
		"  vec2 v_ab = mirror_geom.yz * f_q;\n"
		"  v_ab.x *= f_q;\n"
		"  v_ab.x -= mirror_geom.x;\n"
		"  v_ab.x *= 2.0;\n"
		"\n" // solve quadratic equation
		"  float f_r = (v_ab.y + sqrt(v_ab.y * v_ab.y - v_ab.x * mirror_geom.w)) / v_ab.x;\n"
		"  f_r *= mirror_area.y;\n"
		"  v_direction *= f_r;\n"
		"  v_direction.y *= offset_ratio.y;\n"
		"  texcoord = v_direction.xy + mirror_area.zw;\n"
		"\n" // solve quadratic equation
		"  gl_Position = ftransform();\n"
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "polypersp_gray_unwrap",
		"uniform sampler2D texture;\n"
		"varying vec2 texcoord;\n"
		"\n"
		"void main()\n"
		"{\n"
		"  vec4 color = texture2D(texture, texcoord)/*.zyxw*/;\n"

		"  const vec3 pal = vec3(.299, .587, .114);\n"
		"  color.w = dot(color.xyz, pal);"
		"  gl_FragColor = color;"
		"}\n"
	},
/*
 *								=== ~polynet_ shaders ===
 */

/*
 *								=== imgproc_ shaders ===
 */

	{sh_lang_HighLevel, sh_type_Fragment, "imgproc_gray_filter",
		"uniform sampler2D texture;\n"
		"\n"
		"void main()\n"
		"{\n"
		"  vec4 color = texture2D(texture, gl_TexCoord[0].xy)/*.zyxw*/;\n"
		"  const vec3 pal = vec3(.299, .587, .114);\n"
		"  color.w = dot(color.xyz, pal);"
		"  gl_FragColor = color.wwww;"
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "imgproc_gauss_7_mono",
		"uniform sampler2D texture;\n"
		"uniform vec2 gauss_dir;\n"
		"const vec4 gauss = vec4(.036633, .111281, .216745, .270682);\n"
		"\n"
		"void main()\n"
		"{\n"
		"  vec4 samples = vec4(\n"
		"    texture2D(texture, gl_TexCoord[0].xy - 3.0 * gauss_dir).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy - 2.0 * gauss_dir).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy - gauss_dir).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy).x);\n"
		"  float gray = dot(samples, gauss);\n"
		"  samples = vec4(\n"
		"    texture2D(texture, gl_TexCoord[0].xy + 3.0 * gauss_dir).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + 2.0 * gauss_dir).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + gauss_dir).x, 0.0);\n"
		"  gray += dot(samples, gauss);\n"
		"  gl_FragColor.x = gray;"
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "imgproc_gauss_5_mono",
		"uniform sampler2D texture;\n"
		"uniform vec2 gauss_dir;\n"
		"const vec4 gauss = vec4(.0, .102041, .244898, .306122);\n" // filter by mr. potucek
		//"const vec4 gauss = vec4(0.004433048, 0.054005583, 0.242036229, .39905028);\n" // gauss.xls
		"\n"
		"void main()\n"
		"{\n"
		"  vec4 samples = vec4(\n"
		"    0.0/*texture2D(texture, gl_TexCoord[0].xy - 3.0 * gauss_dir).x*/,\n"
		"    texture2D(texture, gl_TexCoord[0].xy - 2.0 * gauss_dir).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy - gauss_dir).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy).x);\n"
		"  float gray = dot(samples, gauss);\n"
		"  samples = vec4(\n"
		"    0.0/*texture2D(texture, gl_TexCoord[0].xy + 3.0 * gauss_dir).x*/,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + 2.0 * gauss_dir).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + gauss_dir).x, 0.0);\n"
		"  gray += dot(samples, gauss);\n"
		"  gl_FragColor.x = gray;"
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "imgproc_radialsobel_laplace",
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { r_inner, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { treshold, image_ratio, pixel_w, pixel_h }
		"const vec4 laplace = vec4(-1.0, 4.0, -1.0, -1.0);\n"
		"\n"
		"void main()\n"
		"{\n"
		"  vec2 v_eccentric = gl_TexCoord[0].xy - mirror_area.zw;\n"
		"  v_eccentric.y /= offset_ratio.y;\n"
		"  float f_len = length(v_eccentric);\n"
		"  if(f_len < mirror_area.x || f_len > mirror_area.y) discard;\n"
		"  v_eccentric *= offset_ratio.zw;\n"
		"  v_eccentric /= f_len;\n" // eccentric vector which should cross the edges
		"  vec2 v_tangent = v_eccentric.yx; v_tangent.y *= -1;\n" // tangent vector, prependicular to eccentric

		"  v_eccentric.x = offset_ratio.z; v_eccentric.y = 0.0;\n"
		"  v_tangent.y = offset_ratio.w; v_tangent.x = 0.0;\n"
		"  vec4 samples = vec4(\n"
		"    texture2D(texture, gl_TexCoord[0].xy - v_eccentric).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + v_eccentric).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + v_tangent).x);\n"
		"  float gray = dot(samples, laplace);\n"
		"  gray -= texture2D(texture, gl_TexCoord[0].xy - v_tangent).x;\n"
		"  gl_FragColor.xyz = gray * step(offset_ratio.x, gray);"
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "imgproc_radialsobel_cutoff",
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { r_inner, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { treshold, image_ratio, pixel_w, pixel_h }
		"const vec3 sobel = vec3(1.0, 2.0, 1.0);\n"
		//"const vec2 roberts = vec2(1.0, -1.0);\n"
		"\n"
		"void main()\n"
		"{\n"
		"  vec2 v_eccentric = gl_TexCoord[0].xy - mirror_area.zw;\n"
		"  v_eccentric.y /= offset_ratio.y;\n"
		"  float f_len = length(v_eccentric);\n"
		"  if(f_len < mirror_area.x || f_len > mirror_area.y) discard;\n"
		"  v_eccentric *= offset_ratio.zw;\n"
		"  v_eccentric /= f_len;\n" // eccentric vector which should cross the edges
		"  vec2 v_tangent = v_eccentric.yx; v_tangent.y *= -1;\n" // tangent vector, prependicular to eccentric
		/*"  vec2 samples = vec2(\n"
		"    texture2D(texture, gl_TexCoord[0].xy).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + v_eccentric + v_tangent).x);\n"
		"  vec2 gray; gray.x = dot(samples, roberts);\n"
		"  samples = vec2(\n"
		"    texture2D(texture, gl_TexCoord[0].xy + v_eccentric).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + v_tangent).x);\n"
		"  gray.y = dot(samples, roberts);\n"
		"  gl_FragColor.xyz = dot(gray, gray) * 100.0;"*/ // roberts's edge detector; it's good, but not sensitive to the edges
		"  vec3 samples = vec3(\n"
		"    texture2D(texture, gl_TexCoord[0].xy - v_eccentric).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy - v_eccentric - v_tangent).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy - v_eccentric + v_tangent).x);\n"
		"  float gray = dot(samples, sobel);\n"
		"  samples = vec3(\n"
		"    texture2D(texture, gl_TexCoord[0].xy + v_eccentric).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + v_eccentric - v_tangent).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + v_eccentric + v_tangent).x);\n"
		"  gray -= dot(samples, sobel); /*gray = abs(gray);*/\n"
		"  gl_FragColor.xyz = gray * step(offset_ratio.x, gray);"
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "imgproc_localmax_cutoff",
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { r_inner, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { <undefined>, image_ratio, pixel_w, pixel_h }
		"\n"
		"void main()\n"
		"{\n"
		"  vec2 v_eccentric = gl_TexCoord[0].xy - mirror_area.zw;\n"
		"  v_eccentric.y /= offset_ratio.y;\n" // "narovnat"
		"  float f_len = length(v_eccentric);\n"
		"  if(f_len < mirror_area.x || f_len > mirror_area.y) discard;\n"
		"  v_eccentric /= f_len; v_eccentric *= offset_ratio.zw;\n" // eccentric vector which should cross the edges
		//"  vec2 v_tangent = v_eccentric.yx; v_tangent.y *= -1;\n" // tangent vector, prependicular to eccentric

		/*"  v_eccentric.x = offset_ratio.z; v_eccentric.y = 0.0;\n"
		"  v_tangent.y = offset_ratio.w; v_tangent.x = 0.0;\n"*/
		"  vec2 samples = vec2(\n"
		"    texture2D(texture, gl_TexCoord[0].xy - v_eccentric).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + v_eccentric).x/*,\n"
		"    texture2D(texture, gl_TexCoord[0].xy - v_tangent).x,\n"
		"    texture2D(texture, gl_TexCoord[0].xy + v_tangent).x*/);\n"
		"  bvec2 comparison = greaterThan(texture2D(texture, gl_TexCoord[0].xy).xx, samples);\n" // compare. greater local value means component is set to 1
		"  gl_FragColor.xyz = float(all(comparison));" // if one is zero, it's not maximum
		"}\n"
	},
	{sh_lang_HighLevel, sh_type_Fragment, "imgproc_frontline_sexy",
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { r_inner, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angle_multiplier, image_ratio, pixel_w, pixel_h }
		"\n"
		"void main()\n"
		"{\n"
		"  float f_strip_width = (mirror_area.y - mirror_area.x) * offset_ratio.w / offset_ratio.z;\n"
		"  float f_angle = gl_TexCoord[0].x * offset_ratio.x;\n" // we're drawing tiny horizontal line to calc just a few values
		"  float f_pixel_len = max(length(offset_ratio.zw) * 0.1, f_strip_width * 0.004);\n" // shaders are allowed to have loops of maximal length of 255 loops (watchdog or like that)
		"  f_pixel_len *= offset_ratio.y;\n"
		"  vec3 v_decentric = vec3(sin(f_angle), cos(f_angle) * offset_ratio.y, f_pixel_len);\n"
		"  vec3 v_texcoord = vec3(v_decentric.xy * mirror_area.y + mirror_area.wz, mirror_area.y);\n"
		"  v_decentric.xy *= length(offset_ratio.zw);\n" // t_odo - see if multiply of .xy is faster than substituting f_pixel_len in v_decentric for 1.0; vector, pointing one pixel inside (we're starting at the outer circle)

		/*"  v_decentric.z /= v_texcoord.z;\n"
		"  v_texcoord.z = 1.0;\n"*/ // normalize relative position inside the strip as we may use it to enhance precision of the results

		"  gl_FragColor.xyz = vec3(0.0, 0.0, 0.0);" // suppose we ran trough the whole strip and didn't find it

		/*"  if(gl_TexCoord[0].y * 100 > v_texcoord.z / v_decentric.z) discard;"
		"  gl_FragColor.xyz = texture2D(texture, v_texcoord.xy -\n"
		"    v_decentric.xy * gl_TexCoord[0].y * 100).xyz;"*/

		/*"  vec3 v_prev_texcoord = v_texcoord + v_decentric, v_next_texcoord;"
		"  vec2 samples; float maxsamp = 0; vec2 besttex = v_texcoord.xy;\n"
		"  do {\n"
		"    v_next_texcoord = v_texcoord - v_decentric;\n"
		"    samples = vec2(\n"
		"      texture2D(texture, v_next_texcoord.xy).x,\n"
		"      texture2D(texture, v_prev_texcoord.xy).x);\n"
		"    v_prev_texcoord = v_texcoord;\n" // attempt not to stall cache, see if it's faster to 
		"    float samp = texture2D(texture, v_texcoord.xy);\n"
		"    if(samp > maxsamp && all(greaterThan(texture2D(texture, v_texcoord.xy).xx, samples))) {\n"
		"      maxsamp = samp; besttex = v_texcoord.xy;\n"
		"    }\n"
		"    v_texcoord = v_next_texcoord\n;"
		"  } while(v_next_texcoord.z > mirror_area.x);\n" // are we still inside the strip?
		"      besttex.xy *= 256.0;\n"
		"      gl_FragColor.yw = floor(besttex.xy) / 256.0;\n" // we've found it
		"      gl_FragColor.zx = frac(besttex.xy);\n" // split to HILO so it can be interpreted as two shorts later
		"}\n"*/

		
		"  vec3 v_prev_texcoord = v_texcoord + v_decentric, v_next_texcoord;"
		"  vec2 samples; bvec2 comparison; float maxsamp = 0; vec2 besttex = v_texcoord.xy;\n"
		"  do {\n"
		"    v_next_texcoord = v_texcoord - v_decentric;\n"
		"    samples = vec2(\n"
		"      texture2D(texture, v_next_texcoord.xy).x,\n"
		"      texture2D(texture, v_prev_texcoord.xy).x);\n"
		"    v_prev_texcoord = v_texcoord;\n" // attempt not to stall cache, see if it's faster to 
		"    comparison = greaterThan(texture2D(texture, v_texcoord.xy).xx, samples);\n" // compare. greater local value means component is set to 1
		"    if(all(comparison)) {\n"
	//	"      v_texcoord.xy += offset_ratio.zw * 1.0;\n"
		"      v_texcoord.xy *= 256.0;\n"
		"      gl_FragColor.yw = floor(v_texcoord.xy) / 256.0;\n" // we've found it
		"      gl_FragColor.zx = frac(v_texcoord.xy);\n" // split to HILO so it can be interpreted as two shorts later
		"      break;\n"
		"    }\n"
		"    v_texcoord = v_next_texcoord\n;"
		"  } while(v_next_texcoord.z > mirror_area.x);\n" // are we still inside the strip?
		"}\n"
	}

		/*
		"  float f_strip_width = (mirror_area.y - mirror_area.x) * offset_ratio.w / offset_ratio.z;\n"
		"  float f_angle = gl_TexCoord[0].x * offset_ratio.x;\n" // we're drawing tiny horizontal line to calc just a few values

		"  float f_pixel_len = max(0.70711, f_strip_width * 0.004 / length(offset_ratio.zw));\n" // shaders are allowed to have loops of maximal length of 255 loops (watchdog or like that)
		"  f_pixel_len *= offset_ratio.y;"

		"  vec3 v_decentric = vec3(sin(f_angle), cos(f_angle) * offset_ratio.y, f_pixel_len * length(offset_ratio.zw));\n"

		"  vec3 v_texcoord = vec3(v_decentric.xy * mirror_area.y + mirror_area.wz, f_strip_width);\n"

		"  v_decentric.xy *= length(offset_ratio.zw)/*offset_ratio.zw * f_pixel_len* /;\n" // t_odo - see if multiply of .xy is faster than substituting f_pixel_len in v_decentric for 1.0; vector, pointing one pixel inside (we're starting at the outer circle)

		"  if(gl_TexCoord[0].y * 100 > v_texcoord.z / v_decentric.z) discard;"
		"  gl_FragColor.xyz = texture2D(texture, v_texcoord.xy -\n"
		"    v_decentric.xy * gl_TexCoord[0].y * 100).xyz;" // suppose we ran trough the whole strip and didn't find it
		*/

/*
 *								=== ~imgproc_ shaders ===
 */

};

int n_TabledShader_Num()
{
	return sizeof(p_shader_list) / sizeof(p_shader_list[0]);
}

int CreateTabledShader(int n_index, std::vector<CShaderInfo*> &r_shader_info_list)
{
	CShaderInfo *p_shader_info;

	if(!(p_shader_info = new CShaderInfo(p_shader_list[n_index].p_s_name,
	   p_shader_list[n_index].n_lang, p_shader_list[n_index].n_type)))
		return false;

	TShaderInfo my_shader;
	char *p_params = "texture"; // texture sampler (automatically set to unit 0 in CGLProgramObject::BindGL)
	my_shader.n_param_num = 1;
	my_shader.p_param_name_array = &p_params;
	my_shader.p_s_code = p_shader_list[n_index].p_s_code;

	if(p_shader_list[n_index].n_lang == sh_lang_HighLevel) {
		if(!p_shader_info->SetHighLevel_Code(my_shader)) {
			delete p_shader_info;
			return false;
		}
	} else /*if(p_shader_list[n_index].n_lang == sh_lang_LowLevel)*/ {
		if(!p_shader_info->SetLowLevel_Code(my_shader)) {
			delete p_shader_info;
			return false;
		}
	}
	// copy shader info into our shader

	r_shader_info_list.push_back(p_shader_info);
	if(!r_shader_info_list.size()) {
		delete p_shader_info;
		return false;
	}
	// put our shader info into the list

	return true;
}

/* // old shaders (functional, but now i use the table instead of lots of functions)
int Create__simple_gray_unwrap_glsl__Shader(std::vector<CShaderInfo*> &r_shader_info_list)
{
	CShaderInfo *p_shader_info;

	if(!(p_shader_info = new CShaderInfo("simple_gray_unwrap",
	   sh_lang_HighLevel, sh_type_Fragment)))
		return false;
	// create new shader info, shader name is simple_unwrap,
	// it's gefault language is high level shading language
	// and it is fragment shader (i.e. it's processing pixels)

	TShaderInfo simple_unwrap_glsl_shader;
	char *p_params = "texture"; // texture sampler (automatically set to unit 0 in CGLProgramObject::BindGL)
	simple_unwrap_glsl_shader.n_param_num = 1;
	simple_unwrap_glsl_shader.p_param_name_array = &p_params;
	simple_unwrap_glsl_shader.p_s_code =
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { r_inner, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"\n"
		"void main() {\n"
		"  vec2 texcoord;\n"
		"  texcoord.x = mirror_area.z + cos(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y);\n"
		"  texcoord.y = mirror_area.w + sin(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y) * offset_ratio.y;\n"
		"  vec4 color = texture2D(texture, texcoord);\n"
		"  const vec3 pal = vec3(.299, .587, .114);\n"
		"  color.w = dot(color.xyz, pal);"
		"  gl_FragColor/*.xy* / = color;/*gl_TexCoord[0].xy; gl_FragColor.z = color.x * 0.0001;* /"
		"}\n";
	// glslang shader for simple unwrapping (direct translation of following equations:)
	// s' = center_x + cos(s * 2 * pi + angular_offset) * (r_inner + t)
	// t' = center_y + sin(s * 2 * pi + angular_offset) * (r_inner + t) * image_ratio
	// where s = <0 .. 1>, t = <0 .. r_outer - r_inner>

	if(!p_shader_info->SetHighLevel_Code(simple_unwrap_glsl_shader)) {
		delete p_shader_info;
		return false;
	}
	// copy shader info into our shader

	r_shader_info_list.push_back(p_shader_info);
	if(!r_shader_info_list.size()) {
		delete p_shader_info;
		return false;
	}
	// put our shader info into the list

	return true;
}

int Create__geom_noipp_unwrap_glsl__Shader(std::vector<CShaderInfo*> &r_shader_info_list)
{
	CShaderInfo *p_shader_info;

	if(!(p_shader_info = new CShaderInfo("geom_noipp_unwrap",
	   sh_lang_HighLevel, sh_type_Fragment)))
		return false;
	// create new shader info, shader name is simple_unwrap,
	// it's gefault language is high level shading language
	// and it is fragment shader (i.e. it's processing pixels)

	TShaderInfo simple_unwrap_glsl_shader;
	char *p_params = "texture"; // texture sampler (automatically set to unit 0 in CGLProgramObject::BindGL)
	simple_unwrap_glsl_shader.n_param_num = 1;
	simple_unwrap_glsl_shader.p_param_name_array = &p_params;
	simple_unwrap_glsl_shader.p_s_code =
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { r_inner, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 mirror_geom;\n" // { a^2/b^2, 1/delta^2, 2f/delta, -F^2 = -(a^2 + b^2) }
		"uniform vec4 mirror_geom2;\n" // { a^2, F = sqrt(a^2 + b^2), b^2/a^2, b^4/a^2 }
		"uniform vec2 geom_offset;\n" // { x_bottom, x_top - x_bottom }
		"\n"
		"void main() {\n"
/*		"\n"
		"  float a2 = 789.327, b2 = 548.144, f_scale = mirror_area.y / 30.0;\n" // mirror equation ...
		"  f_scale *= f_scale;\n" // a and b are their respective 2nd powers
		"  a2 *= f_scale, b2 *= f_scale;\n" // scale a and b
		"  float F = sqrt(a2 + b2), delta = 10.0;\n" // calc F, set some delta (in texspace !!)
		"  mirror_geom = vec4(a2 / b2, 1.0 / (delta * delta), 2 * F / delta, -a2 - b2);\n"
		"  mirror_geom2 = vec4(a2, F, b2 / a2, b2 * b2 / a2);\n" // fill geom vectors (could
		// be done in vertex shader, but it's just a debug version, we're going to feed all
		// this trough uniforms)
		"  geom_offset = vec2(-8.7, 55.0);\n" // -5 .. 5* /
		"\n"
		"  float f_F_minus_Y = mirror_geom2.y - (geom_offset.x + geom_offset.y * gl_TexCoord[0].y);\n"
		"  float f_F_minus_Y2 = f_F_minus_Y * f_F_minus_Y;\n"
		"\n"
		"  float f_a = mirror_geom.x - mirror_geom.y * f_F_minus_Y2;\n"
		"  float f_minus_b = mirror_geom.z * f_F_minus_Y;\n"
		"  float f_c = mirror_geom2.x - mirror_geom.w;\n"
		"\n"
		"  float f_x = (f_minus_b + sqrt(f_minus_b * f_minus_b - 4.0 * f_a * f_c)) / (2.0 * f_a);\n"
		"  f_x *= mirror_area.y - mirror_area.x;\n"
		"\n"
		"  vec2 texcoord;\n"
		"  texcoord.x = mirror_area.z + cos(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + f_x);\n"
		"  texcoord.y = mirror_area.w + sin(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + f_x) * offset_ratio.y;\n"
		"\n"
		"  gl_FragColor = texture2D(texture, texcoord)/*.zyxw* /;\n"
		"}\n";
	// glslang shader for simple unwrapping (direct translation of following equations:)
	// s' = center_x + cos(s * 2 * pi + angular_offset) * (r_inner + t)
	// t' = center_y + sin(s * 2 * pi + angular_offset) * (r_inner + t) * image_ratio
	// where s = <0 .. 1>, t = <0 .. r_outer - r_inner>

	if(!p_shader_info->SetHighLevel_Code(simple_unwrap_glsl_shader)) {
		delete p_shader_info;
		return false;
	}
	// copy shader info into our shader

	r_shader_info_list.push_back(p_shader_info);
	if(!r_shader_info_list.size()) {
		delete p_shader_info;
		return false;
	}
	// put our shader info into the list

	return true;
}

int Create__simple_skin_4tap_unwrap_glsl__Shader(std::vector<CShaderInfo*> &r_shader_info_list)
{
	CShaderInfo *p_shader_info;

	if(!(p_shader_info = new CShaderInfo("simple_skin_4tap_unwrap",
	   sh_lang_HighLevel, sh_type_Fragment)))
		return false;
	// create new shader info, shader name is simple_unwrap,
	// it's gefault language is high level shading language
	// and it is fragment shader (i.e. it's processing pixels)

	TShaderInfo simple_unwrap_glsl_shader;
	char *p_params = "texture"; // texture sampler (automatically set to unit 0 in CGLProgramObject::BindGL)
	simple_unwrap_glsl_shader.n_param_num = 1;
	simple_unwrap_glsl_shader.p_param_name_array = &p_params;
	simple_unwrap_glsl_shader.p_s_code =
		"uniform sampler2D texture;\n"
		"uniform vec4 mirror_area;\n" // { r_inner, r_outer, center_x, center_y }
		"uniform vec4 offset_ratio;\n" // { angular_offset, image_ratio, pixel_w, pixel_h }
		"uniform vec4 covariant;\n" // { k11, k21, k12, k22 }
		"uniform vec2 avg_rg;\n" // { R, G }
		"\n"
		"void main() {\n"
		"  vec4 texcoord;\n"
		"  texcoord.x = mirror_area.z + cos(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y);\n"
		"  texcoord.y = mirror_area.w + sin(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y) * offset_ratio.y;\n"
		"  texcoord.z = mirror_area.z + cos((gl_TexCoord[0].x + offset_ratio.z) *\n"
		"    6.28319 + offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y);\n"
		"  texcoord.w = mirror_area.w + sin(gl_TexCoord[0].x * 6.28319 +\n"
		"    offset_ratio.x) * (mirror_area.x + gl_TexCoord[0].y + offset_ratio.w) * offset_ratio.y;\n"
		"  vec4 color; color/*.zyxw* / = (texture2D(texture, texcoord.xy) + texture2D(texture, texcoord.zy) +\n"
		"    texture2D(texture, texcoord.xw) + texture2D(texture, texcoord.zw)) * .25;\n"
		"  gl_FragColor.xyz = color.xyz * 0.0001;\n"
		"  float sum = color.x + color.y + color.z;\n" // skin-detection
		"  vec2 rg_color; \n"
		"  rg_color = color.zy / sum;\n"
		"  rg_color -= avg_rg;\n"
		"  sum = (rg_color.x * dot(rg_color, covariant.xy) +\n"
		"         rg_color.y * dot(rg_color, covariant.zw)) * -.5;"
		"  gl_FragColor.x = exp(sum);\n"
		"}\n";
	// glslang shader for simple unwrapping (direct translation of following equations:)
	// s' = center_x + cos(s * 2 * pi + angular_offset) * (r_inner + t)
	// t' = center_y + sin(s * 2 * pi + angular_offset) * (r_inner + t) * image_ratio
	// where s = <0 .. 1>, t = <0 .. r_outer - r_inner>
	// but samples are averaged from 4 texels, offset by pixel_w and pixel_h to form quad

	if(!p_shader_info->SetHighLevel_Code(simple_unwrap_glsl_shader)) {
		delete p_shader_info;
		return false;
	}
	// copy shader info into our shader

	r_shader_info_list.push_back(p_shader_info);
	if(!r_shader_info_list.size()) {
		delete p_shader_info;
		return false;
	}
	// put our shader info into the list

	return true;
}

*/

/*
 *		-end-of-file-
 */
