/*
								+---------------------------------+
								|                                 |
								|      ***   OpenGL2.0   ***      |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|          RenderBuffer.h         |
								|                                 |
								+---------------------------------+
*/

#ifndef __RENDER_BUFFER_INCLUDED
#define __RENDER_BUFFER_INCLUDED

class __declspec(dllexport) CGLRenderBuffer {
protected:
	CGLState *m_p_state;
	int m_n_width;
	int m_n_height;
	//
	int m_n_format; // GL_RGB / GL_RGBA / GL_INTENSITY / GL_LUMINANCE / GL_ALPHA / GL_LUMINANCE_ALPHA / GL_DEPTH
	int m_n_color_bits; // 4 (ouch!) / 8 / 16 / 32
	int m_b_float_buffer;
	//
	int m_b_depth_buffer;
	int m_n_depth_bits;
	//
	int m_b_stencil_buffer;
	int m_n_stencil_bits;
	//
	int m_n_texture_target; // 0, GL_TEXTURE_1D, GL_TEXTURE_2D, GL_TEXTURE_CUBE_MAP, GL_TEXTURE_RECTANGLE
	int m_b_mipmaps;
	int m_b_depth_texture; // can bind both color texture and depth texture
	//
	unsigned int m_n_bound_texture; // current bound texture or 0
	//
	int m_b_status;
	int m_b_active;

public:
	CGLRenderBuffer(int n_width, int n_height, int n_format, int n_color_bits, int b_float,
		int n_texture_target = 0, int b_mipmap = false, int b_depth_texture_target = false,
		int b_depth_buffer = false, int n_depth_bits = 32, int b_stencil_buffer = false,
		int n_stencil_bits = 8);

	virtual int b_Supported() const = 0;
	virtual int b_Status() const;

	int n_Width() const;
	int n_Height() const;

	virtual int HandleModeSwitch() = 0; // see if we lost render-buffer in mode switch and eventualy create a new one

	virtual int Bind() = 0; // bind render-buffer
	virtual int BindRenderTexture(unsigned int n_texture) = 0; // set texture, we're going to render to
	virtual int ReleaseRenderTexture() = 0; // release texture, we've been rendering to
	virtual CGLState *p_State() = 0; // return gl-state as p-buffers have it's own gl-state
	virtual int CopyTextureData(GLenum n_texture = GL_TEXTURE_2D); // copy texture data (in case direct rendering into texture is not supported - otherwise it returns immediately)
	virtual int b_DirectRenderToTexture() const = 0; // return true if direct rendering to texture is supported
	virtual int Release() = 0; // un-bind render-buffer so you can render into the main window again

	virtual int Destroy() = 0; // destroy render-buffer

protected:
	virtual int Create() = 0;
};

class __declspec(dllexport) CGLRenderBuffer_PBuffer : public CGLRenderBuffer {
protected:
	HPBUFFERARB m_h_buffer;
	HDC m_h_dc;
	HGLRC m_h_glrc;

	int m_b_double_buffer;

	static PFNWGLGETPIXELFORMATATTRIBIVARBPROC wglGetPixelFormatAttribivARB;
	static PFNWGLCHOOSEPIXELFORMATARBPROC wglChoosePixelFormatARB;
	static PFNWGLCREATEPBUFFERARBPROC wglCreatePbufferARB;
	static PFNWGLGETPBUFFERDCARBPROC wglGetPbufferDCARB;
	static PFNWGLRELEASEPBUFFERDCARBPROC wglReleasePbufferDCARB;
	static PFNWGLDESTROYPBUFFERARBPROC wglDestroyPbufferARB;
	static PFNWGLQUERYPBUFFERARBPROC wglQueryPbufferARB;
	static PFNWGLBINDTEXIMAGEARBPROC wglBindTexImageARB;
	static PFNWGLRELEASETEXIMAGEARBPROC wglReleaseTexImageARB;
	// wgl-ext function pointers

	HDC m_h_prev_dc;
	HGLRC m_h_prev_glrc;

public:
	CGLRenderBuffer_PBuffer(int n_width, int n_height, int n_format, int n_color_bits, int b_float,
		int n_texture_target = 0, int b_mipmap = false, int b_depth_texture_target = false,
		int b_double_buffer = false, int b_depth_buffer = false, int n_depth_bits = 32,
		int b_stencil_buffer = false, int n_stencil_bits = 8);
	virtual ~CGLRenderBuffer_PBuffer() { Destroy(); }

	virtual int b_Supported() const;

	virtual int HandleModeSwitch(); // see if we lost render-buffer in mode switch and eventualy create a new one

	virtual int Bind(); // bind render-buffer
	virtual int BindRenderTexture(unsigned int n_texture); // set texture, we're going to render to
	virtual int ReleaseRenderTexture(); // release texture, we've been rendering to
	virtual CGLState *p_State(); // return gl-state as p-buffers have it's own gl-state
	virtual int b_DirectRenderToTexture() const; // return true if direct rendering to texture is supported
	virtual int Release(); // un-bind render-buffer so you can render into the main window again

	virtual int Destroy();

protected:
	virtual int Create();
	int n_GetWGLFunctionPointers();
};

class __declspec(dllexport) CGLRenderBuffer_FBO : public CGLRenderBuffer {
protected:
	unsigned int m_n_framebuffer;
	//
	unsigned int m_n_color_rb;
	unsigned int m_n_depth_rb;
	unsigned int m_n_stencil_rb;

public:
	CGLRenderBuffer_FBO(int n_width, int n_height, int n_format, int n_color_bits, int b_float,
		int n_texture_target = 0, int b_mipmap = false, int b_depth_texture_target = false,
		int b_double_buffer = false, int b_depth_buffer = false, int n_depth_bits = 32,
		int b_stencil_buffer = false, int n_stencil_bits = 8);
	virtual ~CGLRenderBuffer_FBO() { Destroy(); }

	virtual int b_Supported() const;

	virtual int b_Status() const; // call AFTER all textures are bound when calling if active

	virtual int HandleModeSwitch(); // see if we lost render-buffer in mode switch and eventualy create a new one

	virtual int Bind(); // bind render-buffer
	virtual int BindRenderTexture(unsigned int n_texture); // set texture, we're going to render to
	virtual int ReleaseRenderTexture(); // release texture, we've been rendering to
	virtual CGLState *p_State(); // return gl-state as p-buffers have it's own gl-state
	virtual int b_DirectRenderToTexture() const; // return true if direct rendering to texture is supported
	virtual int Release(); // un-bind render-buffer so you can render into the main window again

	virtual int Destroy();

protected:
	virtual int Create();
};

// todo - handle rendering to both color and depth textures
// todo - debug fbo-s
// todo - handle rendering to multiple targets

#endif //__RENDER_BUFFER_INCLUDED

/*
 *		-end-of-file-
 */
