/*
								+---------------------------------+
								|                                 |
								|      ***   OpenGL2.0   ***      |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|            OpenGl20.h           |
								|                                 |
								+---------------------------------+
*/

#ifndef __OPENGL20_TOOL_INCLUDED
#define __OPENGL20_TOOL_INCLUDED

class __declspec(dllexport) CGLExtensionHandler {
public:
	static int b_Support_OpenGL(int n_min_major = 2, int n_min_minor = 0); // return true, if current version of opengl is at least version n_min_major.n_min_minor (i.e. default 2.0)
	static int n_GetGL12FuncPointers(); // OpenGL 1.2 core
	static int n_GetGL13FuncPointers(); // OpenGL 1.3 core
	static int n_GetGL14FuncPointers(); // OpenGL 1.4 core
	static int n_GetGL15FuncPointers(); // OpenGL 1.5 core
	static int n_GetGL20FuncPointers(); // OpenGL 2.0 core
	static int n_GetMultitextureFuncPointers(); // not extension (ARB) multitexture, ale core (1.3) multitexture
	static int n_GetCompressedTextureARBFuncPointers(); // GL_ARB_texture_compression
	static int n_GetVertexBlendARBFuncPointers(); // GL_ARB_vertex_blend
	static int n_GetMatrixPaletteARBFuncPointers(); // GL_ARB_matrix_palette
	static int n_GetFramebufferObjectEXTFuncPointers(); // GL_EXT_framebuffer_object
	static int n_GetCompiledArrayEXTFuncPointers(); // GL_EXT_compiled_vertex_array
	static int n_GetTextureObjectEXTFuncPointers(); // GL_EXT_texture_object
	static int n_GetPolygonOffsetEXTFuncPointers(); // GL_EXT_polygon_offset
	static int n_GetColorBufferFloatARBFuncPointers(); // GL_ARB_color_buffer_float
	static int n_GetVertexArrayEXTFuncPointers(); // GL_EXT_vertex_array
	static int n_GetVertexProgramARBFuncPointers(); // GL_ARB_vertex_program
	static int n_GetFragmentProgramARBFuncPointers(); // GL_ARB_fragment_program
	static int n_GetVertexShaderARBFuncPointers(); // GL_ARB_vertex_shader
	static int n_GetFragmentShaderARBFuncPointers(); // GL_ARB_fragment_shader
	static int n_GetShaderObjectARBFuncPointers(); // GL_ARB_shader_object
	static int n_GetVertexBufferObjectARBFuncPointers(); // GL_ARB_vertex_buffer_object
	static int n_GetFenceNVFuncPointers(); // GL_NV_fence

	static int b_SupportedExtension(const char *p_s_extension_name);
#ifdef WIN32
	static int b_SupportedWGLExtension(const char *p_s_extension_name);
#endif
};
/*
 * init pointers to extension functions so we can use them in our programs
 * return value is number of functions we didn't find (they aren't supported)
 * it currently uses wglGetProcAddres(), however under linux the situation is
 * slightly different. we theoretically could use getproc() or use latest opengl
 * library which would contain required functions so we wouldn't have to look
 * for their pointers
 */

enum {
	num_functions_gl12 = 38,
	num_functions_gl13 = 12,
	num_functions_multitexture = 34,
	num_functions_gl14 = 45,
	num_functions_gl15 = 19,
	num_functions_gl20 = 93,
	num_functions_compressed_texture_arb = 7,
	num_functions_vertex_blend_arb = 10,
	num_functions_matrix_palette_arb = 5,
	num_functions_framebuffer_object_ext = 17,
	num_functions_compiled_vertex_array_ext = 2,
	num_functions_texture_object_ext = 6,
	num_functions_polygon_offset_ext = 1,
	num_functions_color_buffer_float_arb = 1,
	num_functions_vertex_array_ext = 9,
	num_functions_vertex_program_arb = 62,
	num_functions_fragment_program_arb = 19,
	num_functions_vertex_shader_arb = 46,
	num_functions_fragment_shader_arb = 0,
	num_functions_shader_object_arb = 39,
	num_functions_vertex_buffer_object_arb = 11,
	num_functions_fence_nv = 7
};

//							    --- opengl 1.2 core functions ---

extern void (__stdcall *glBlendColor)(GLclampf, GLclampf, GLclampf, GLclampf);
extern void (__stdcall *glBlendEquation)(GLenum);
extern void (__stdcall *glDrawRangeElements)(GLenum, GLuint, GLuint, GLsizei, GLenum, const GLvoid*);
extern void (__stdcall *glColorTable)(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (__stdcall *glColorTableParameterfv)(GLenum, GLenum, const GLfloat*);
extern void (__stdcall *glColorTableParameteriv)(GLenum, GLenum, const GLint*);
extern void (__stdcall *glCopyColorTable)(GLenum, GLenum, GLint, GLint, GLsizei);
extern void (__stdcall *glGetColorTable)(GLenum, GLenum, GLenum, GLvoid*);
extern void (__stdcall *glGetColorTableParameterfv)(GLenum, GLenum, GLfloat*);
extern void (__stdcall *glGetColorTableParameteriv)(GLenum, GLenum, GLint*);
extern void (__stdcall *glColorSubTable)(GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (__stdcall *glCopyColorSubTable)(GLenum, GLsizei, GLint, GLint, GLsizei);
extern void (__stdcall *glConvolutionFilter1D)(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (__stdcall *glConvolutionFilter2D)(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (__stdcall *glConvolutionParameterf)(GLenum, GLenum, GLfloat);
extern void (__stdcall *glConvolutionParameterfv)(GLenum, GLenum, const GLfloat*);
extern void (__stdcall *glConvolutionParameteri)(GLenum, GLenum, GLint);
extern void (__stdcall *glConvolutionParameteriv)(GLenum, GLenum, const GLint*);
extern void (__stdcall *glCopyConvolutionFilter1D)(GLenum, GLenum, GLint, GLint, GLsizei);
extern void (__stdcall *glCopyConvolutionFilter2D)(GLenum, GLenum, GLint, GLint, GLsizei, GLsizei);
extern void (__stdcall *glGetConvolutionFilter)(GLenum, GLenum, GLenum, GLvoid*);
extern void (__stdcall *glGetConvolutionParameterfv)(GLenum, GLenum, GLfloat*);
extern void (__stdcall *glGetConvolutionParameteriv)(GLenum, GLenum, GLint*);
extern void (__stdcall *glGetSeparableFilter)(GLenum, GLenum, GLenum, GLvoid *, GLvoid *, GLvoid*);
extern void (__stdcall *glSeparableFilter2D)(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *, const GLvoid*);
extern void (__stdcall *glGetHistogram)(GLenum, GLboolean, GLenum, GLenum, GLvoid*);
extern void (__stdcall *glGetHistogramParameterfv)(GLenum, GLenum, GLfloat*);
extern void (__stdcall *glGetHistogramParameteriv)(GLenum, GLenum, GLint*);
extern void (__stdcall *glGetMinmax)(GLenum, GLboolean, GLenum, GLenum, GLvoid*);
extern void (__stdcall *glGetMinmaxParameterfv)(GLenum, GLenum, GLfloat*);
extern void (__stdcall *glGetMinmaxParameteriv)(GLenum, GLenum, GLint*);
extern void (__stdcall *glHistogram)(GLenum, GLsizei, GLenum, GLboolean);
extern void (__stdcall *glMinmax)(GLenum, GLenum, GLboolean);
extern void (__stdcall *glResetHistogram)(GLenum);
extern void (__stdcall *glResetMinmax)(GLenum);
extern void (__stdcall *glTexImage3D)(GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const GLvoid*);
extern void (__stdcall *glTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (__stdcall *glCopyTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);

//							    --- opengl 1.3 core functions ---

extern void (__stdcall *glLoadTransposeMatrixf)(const GLfloat*);
extern void (__stdcall *glLoadTransposeMatrixd)(const GLdouble*);
extern void (__stdcall *glMultTransposeMatrixf)(const GLfloat*);
extern void (__stdcall *glMultTransposeMatrixd)(const GLdouble*);
extern void (__stdcall *glSampleCoverage)(GLclampf, GLboolean);
extern void (__stdcall *glCompressedTexImage3D)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*);
extern void (__stdcall *glCompressedTexImage2D)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*);
extern void (__stdcall *glCompressedTexImage1D)(GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const GLvoid*);
extern void (__stdcall *glCompressedTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*);
extern void (__stdcall *glCompressedTexSubImage2D)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*);
extern void (__stdcall *glCompressedTexSubImage1D)(GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const GLvoid*);
extern void (__stdcall *glGetCompressedTexImage)(GLenum, GLint, GLvoid*);

//								  --- multitexture functions ---

extern void (__stdcall *glActiveTexture)(GLenum);
extern void (__stdcall *glClientActiveTexture)(GLenum);
extern void (__stdcall *glMultiTexCoord1d)(GLenum, GLdouble);
extern void (__stdcall *glMultiTexCoord1dv)(GLenum, const GLdouble*);
extern void (__stdcall *glMultiTexCoord1f)(GLenum, GLfloat);
extern void (__stdcall *glMultiTexCoord1fv)(GLenum, const GLfloat*);
extern void (__stdcall *glMultiTexCoord1i)(GLenum, GLint);
extern void (__stdcall *glMultiTexCoord1iv)(GLenum, const GLint*);
extern void (__stdcall *glMultiTexCoord1s)(GLenum, GLshort);
extern void (__stdcall *glMultiTexCoord1sv)(GLenum, const GLshort*);
extern void (__stdcall *glMultiTexCoord2d)(GLenum, GLdouble, GLdouble);
extern void (__stdcall *glMultiTexCoord2dv)(GLenum, const GLdouble*);
extern void (__stdcall *glMultiTexCoord2f)(GLenum, GLfloat, GLfloat);
extern void (__stdcall *glMultiTexCoord2fv)(GLenum, const GLfloat*);
extern void (__stdcall *glMultiTexCoord2i)(GLenum, GLint, GLint);
extern void (__stdcall *glMultiTexCoord2iv)(GLenum, const GLint*);
extern void (__stdcall *glMultiTexCoord2s)(GLenum, GLshort, GLshort);
extern void (__stdcall *glMultiTexCoord2sv)(GLenum, const GLshort*);
extern void (__stdcall *glMultiTexCoord3d)(GLenum, GLdouble, GLdouble, GLdouble);
extern void (__stdcall *glMultiTexCoord3dv)(GLenum, const GLdouble*);
extern void (__stdcall *glMultiTexCoord3f)(GLenum, GLfloat, GLfloat, GLfloat);
extern void (__stdcall *glMultiTexCoord3fv)(GLenum, const GLfloat*);
extern void (__stdcall *glMultiTexCoord3i)(GLenum, GLint, GLint, GLint);
extern void (__stdcall *glMultiTexCoord3iv)(GLenum, const GLint*);
extern void (__stdcall *glMultiTexCoord3s)(GLenum, GLshort, GLshort, GLshort);
extern void (__stdcall *glMultiTexCoord3sv)(GLenum, const GLshort*);
extern void (__stdcall *glMultiTexCoord4d)(GLenum, GLdouble, GLdouble, GLdouble, GLdouble);
extern void (__stdcall *glMultiTexCoord4dv)(GLenum, const GLdouble*);
extern void (__stdcall *glMultiTexCoord4f)(GLenum, GLfloat, GLfloat, GLfloat, GLfloat);
extern void (__stdcall *glMultiTexCoord4fv)(GLenum, const GLfloat*);
extern void (__stdcall *glMultiTexCoord4i)(GLenum, GLint, GLint, GLint, GLint);
extern void (__stdcall *glMultiTexCoord4iv)(GLenum, const GLint*);
extern void (__stdcall *glMultiTexCoord4s)(GLenum, GLshort, GLshort, GLshort, GLshort);
extern void (__stdcall *glMultiTexCoord4sv)(GLenum, const GLshort*);

//							    --- opengl 1.4 core functions ---

extern void (__stdcall *glBlendFuncSeparate)(GLenum, GLenum, GLenum, GLenum);
extern void (__stdcall *glFogCoordf)(GLfloat);
extern void (__stdcall *glFogCoordfv)(const GLfloat*);
extern void (__stdcall *glFogCoordd)(GLdouble);
extern void (__stdcall *glFogCoorddv)(const GLdouble*);
extern void (__stdcall *glFogCoordPointer)(GLenum, GLsizei, const GLvoid*);
extern void (__stdcall *glMultiDrawArrays)(GLenum, GLint *, GLsizei *, GLsizei);
extern void (__stdcall *glMultiDrawElements)(GLenum, const GLsizei *, GLenum, const GLvoid* *, GLsizei);
extern void (__stdcall *glPointParameterf)(GLenum, GLfloat);
extern void (__stdcall *glPointParameterfv)(GLenum, const GLfloat*);
extern void (__stdcall *glPointParameteri)(GLenum, GLint);
extern void (__stdcall *glPointParameteriv)(GLenum, const GLint*);
extern void (__stdcall *glSecondaryColor3b)(GLbyte, GLbyte, GLbyte);
extern void (__stdcall *glSecondaryColor3bv)(const GLbyte*);
extern void (__stdcall *glSecondaryColor3d)(GLdouble, GLdouble, GLdouble);
extern void (__stdcall *glSecondaryColor3dv)(const GLdouble*);
extern void (__stdcall *glSecondaryColor3f)(GLfloat, GLfloat, GLfloat);
extern void (__stdcall *glSecondaryColor3fv)(const GLfloat*);
extern void (__stdcall *glSecondaryColor3i)(GLint, GLint, GLint);
extern void (__stdcall *glSecondaryColor3iv)(const GLint*);
extern void (__stdcall *glSecondaryColor3s)(GLshort, GLshort, GLshort);
extern void (__stdcall *glSecondaryColor3sv)(const GLshort*);
extern void (__stdcall *glSecondaryColor3ub)(GLubyte, GLubyte, GLubyte);
extern void (__stdcall *glSecondaryColor3ubv)(const GLubyte*);
extern void (__stdcall *glSecondaryColor3ui)(GLuint, GLuint, GLuint);
extern void (__stdcall *glSecondaryColor3uiv)(const GLuint*);
extern void (__stdcall *glSecondaryColor3us)(GLushort, GLushort, GLushort);
extern void (__stdcall *glSecondaryColor3usv)(const GLushort*);
extern void (__stdcall *glSecondaryColorPointer)(GLint, GLenum, GLsizei, const GLvoid*);
extern void (__stdcall *glWindowPos2d)(GLdouble, GLdouble);
extern void (__stdcall *glWindowPos2dv)(const GLdouble*);
extern void (__stdcall *glWindowPos2f)(GLfloat, GLfloat);
extern void (__stdcall *glWindowPos2fv)(const GLfloat*);
extern void (__stdcall *glWindowPos2i)(GLint, GLint);
extern void (__stdcall *glWindowPos2iv)(const GLint*);
extern void (__stdcall *glWindowPos2s)(GLshort, GLshort);
extern void (__stdcall *glWindowPos2sv)(const GLshort*);
extern void (__stdcall *glWindowPos3d)(GLdouble, GLdouble, GLdouble);
extern void (__stdcall *glWindowPos3dv)(const GLdouble*);
extern void (__stdcall *glWindowPos3f)(GLfloat, GLfloat, GLfloat);
extern void (__stdcall *glWindowPos3fv)(const GLfloat*);
extern void (__stdcall *glWindowPos3i)(GLint, GLint, GLint);
extern void (__stdcall *glWindowPos3iv)(const GLint*);
extern void (__stdcall *glWindowPos3s)(GLshort, GLshort, GLshort);
extern void (__stdcall *glWindowPos3sv)(const GLshort*);

//							    --- opengl 1.5 core functions ---

extern void (__stdcall *glGenQueries)(GLsizei, GLuint*);
extern void (__stdcall *glDeleteQueries)(GLsizei, const GLuint*);
extern GLboolean (__stdcall *glIsQuery)(GLuint);
extern void (__stdcall *glBeginQuery)(GLenum, GLuint);
extern void (__stdcall *glEndQuery)(GLenum);
extern void (__stdcall *glGetQueryiv)(GLenum, GLenum, GLint*);
extern void (__stdcall *glGetQueryObjectiv)(GLuint, GLenum, GLint*);
extern void (__stdcall *glGetQueryObjectuiv)(GLuint, GLenum, GLuint*);
extern void (__stdcall *glBindBuffer)(GLenum, GLuint);
extern void (__stdcall *glDeleteBuffers)(GLsizei, const GLuint*);
extern void (__stdcall *glGenBuffers)(GLsizei, GLuint*);
extern GLboolean (__stdcall *glIsBuffer)(GLuint);
extern void (__stdcall *glBufferData)(GLenum, GLsizeiptr, const GLvoid *, GLenum);
extern void (__stdcall *glBufferSubData)(GLenum, GLintptr, GLsizeiptr, const GLvoid*);
extern void (__stdcall *glGetBufferSubData)(GLenum, GLintptr, GLsizeiptr, GLvoid*);
extern GLvoid* (__stdcall *glMapBuffer)(GLenum, GLenum);
extern GLboolean (__stdcall *glUnmapBuffer)(GLenum);
extern void (__stdcall *glGetBufferParameteriv)(GLenum, GLenum, GLint*);
extern void (__stdcall *glGetBufferPointerv)(GLenum, GLenum, GLvoid**);

//							   --- compressed texture functions ---

extern void (__stdcall *glCompressedTexImage3DARB)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*);
extern void (__stdcall *glCompressedTexImage2DARB)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*);
extern void (__stdcall *glCompressedTexImage1DARB)(GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const GLvoid*);
extern void (__stdcall *glCompressedTexSubImage3DARB)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*);
extern void (__stdcall *glCompressedTexSubImage2DARB)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*);
extern void (__stdcall *glCompressedTexSubImage1DARB)(GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const GLvoid*);
extern void (__stdcall *glGetCompressedTexImageARB)(GLenum, GLint, GLvoid*);

//								  --- vertex blend functions ---

extern void (__stdcall *glWeightbvARB)(GLint, const GLbyte*);
extern void (__stdcall *glWeightsvARB)(GLint, const GLshort*);
extern void (__stdcall *glWeightivARB)(GLint, const GLint*);
extern void (__stdcall *glWeightfvARB)(GLint, const GLfloat*);
extern void (__stdcall *glWeightdvARB)(GLint, const GLdouble*);
extern void (__stdcall *glWeightubvARB)(GLint, const GLubyte*);
extern void (__stdcall *glWeightusvARB)(GLint, const GLushort*);
extern void (__stdcall *glWeightuivARB)(GLint, const GLuint*);
extern void (__stdcall *glWeightPointerARB)(GLint, GLenum, GLsizei, const GLvoid*);
extern void (__stdcall *glVertexBlendARB)(GLint);

//								  --- matrix palette functions ---

extern void (__stdcall *glCurrentPaletteMatrixARB)(GLint);
extern void (__stdcall *glMatrixIndexubvARB)(GLint, const GLubyte*);
extern void (__stdcall *glMatrixIndexusvARB)(GLint, const GLushort*);
extern void (__stdcall *glMatrixIndexuivARB)(GLint, const GLuint*);
extern void (__stdcall *glMatrixIndexPointerARB)(GLint, GLenum, GLsizei, const GLvoid*);

//							  --- ext framebuffer object functions ---

extern GLboolean (__stdcall *glIsRenderbufferEXT)(GLuint renderbuffer);
extern void (__stdcall *glBindRenderbufferEXT)(GLenum target, GLuint renderbuffer);
extern void (__stdcall *glDeleteRenderbuffersEXT)(GLsizei n, const GLuint *renderbuffers);
extern void (__stdcall *glGenRenderbuffersEXT)(GLsizei n, GLuint *renderbuffers);
extern void (__stdcall *glRenderbufferStorageEXT)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height);
extern void (__stdcall *glGetRenderbufferParameterivEXT)(GLenum target, GLenum pname, GLint* params);
extern GLboolean (__stdcall *glIsFramebufferEXT)(GLuint framebuffer);
extern void (__stdcall *glBindFramebufferEXT)(GLenum target, GLuint framebuffer);
extern void (__stdcall *glDeleteFramebuffersEXT)(GLsizei n, const GLuint *framebuffers);
extern void (__stdcall *glGenFramebuffersEXT)(GLsizei n, GLuint *framebuffers);
extern GLenum (__stdcall *glCheckFramebufferStatusEXT)(GLenum target);
extern void (__stdcall *glFramebufferTexture1DEXT)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
extern void (__stdcall *glFramebufferTexture2DEXT)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
extern void (__stdcall *glFramebufferTexture3DEXT)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
extern void (__stdcall *glFramebufferRenderbufferEXT)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
extern void (__stdcall *glGetFramebufferAttachmentParameterivEXT)(GLenum target, GLenum attachment, GLenum pname, GLint *params);
extern void (__stdcall *glGenerateMipmapEXT)(GLenum target);

//							   --- ext copmiled vertex array functions ---

extern void (__stdcall *glLockArraysEXT)(GLint, GLsizei);
extern void (__stdcall *glUnlockArraysEXT)(void);

//								  --- ext texture object functions ---

extern GLboolean (__stdcall *glAreTexturesResidentEXT)(GLsizei, const GLuint *, GLboolean*);
extern void (__stdcall *glBindTextureEXT)(GLenum, GLuint);
extern void (__stdcall *glDeleteTexturesEXT)(GLsizei, const GLuint*);
extern void (__stdcall *glGenTexturesEXT)(GLsizei, GLuint*);
extern GLboolean (__stdcall *glIsTextureEXT)(GLuint);
extern void (__stdcall *glPrioritizeTexturesEXT)(GLsizei, const GLuint *, const GLclampf*);

//								  --- ext polygon offset functions ---

extern void (__stdcall *glPolygonOffsetEXT)(GLfloat, GLfloat);

//								--- arb color buffer float functions ---

extern void (__stdcall *glClampColorARB)(GLenum, GLenum);

//								  --- ext vertex array functions ---

extern void (__stdcall *glArrayElementEXT)(GLint);
extern void (__stdcall *glColorPointerEXT)(GLint, GLenum, GLsizei, GLsizei, const GLvoid*);
extern void (__stdcall *glDrawArraysEXT)(GLenum, GLint, GLsizei);
extern void (__stdcall *glEdgeFlagPointerEXT)(GLsizei, GLsizei, const GLboolean*);
extern void (__stdcall *glGetPointervEXT)(GLenum, GLvoid**);
extern void (__stdcall *glIndexPointerEXT)(GLenum, GLsizei, GLsizei, const GLvoid*);
extern void (__stdcall *glNormalPointerEXT)(GLenum, GLsizei, GLsizei, const GLvoid*);
extern void (__stdcall *glTexCoordPointerEXT)(GLint, GLenum, GLsizei, GLsizei, const GLvoid*);
extern void (__stdcall *glVertexPointerEXT)(GLint, GLenum, GLsizei, GLsizei, const GLvoid*);

//							  --- opengl 2.0 functions and tokens ---

// shader tokens
#define GL_CURRENT_PROGRAM						0x8B8D
#ifdef GL_SHADER_TYPE
#undef GL_SHADER_TYPE
#endif
#define GL_SHADER_TYPE							0x8B4E
#define GL_DELETE_STATUS						0x8B80
#define GL_COMPILE_STATUS						0x8B81
#define GL_LINK_STATUS							0x8B82
#define GL_VALIDATE_STATUS						0x8B83
#define GL_INFO_LOG_LENGTH						0x8B84
#define GL_ATTACHED_SHADERS						0x8B85
#define GL_ACTIVE_UNIFORMS						0x8B86
#define GL_ACTIVE_UNIFORM_MAX_LENGTH			0x8B87
#define GL_SHADER_SOURCE_LENGTH					0x8B88
#define GL_VERTEX_SHADER						0x8B31
#define GL_ACTIVE_ATTRIBUTES					0x8B89
#define GL_ACTIVE_ATTRIBUTE_MAX_LENGTH			0x8B8A
#define GL_FRAGMENT_SHADER						0x8B30

// uniform types
#define GL_FLOAT_VEC2							0x8B50
#define GL_FLOAT_VEC3							0x8B51
#define GL_FLOAT_VEC4							0x8B52
#define GL_INT_VEC2								0x8B53
#define GL_INT_VEC3								0x8B54
#define GL_INT_VEC4								0x8B55
#define GL_BOOL									0x8B56
#define GL_BOOL_VEC2							0x8B57
#define GL_BOOL_VEC3							0x8B58
#define GL_BOOL_VEC4							0x8B59
#define GL_FLOAT_MAT2							0x8B5A
#define GL_FLOAT_MAT3							0x8B5B
#define GL_FLOAT_MAT4							0x8B5C
#define GL_SAMPLER_1D							0x8B5D
#define GL_SAMPLER_2D							0x8B5E
#define GL_SAMPLER_3D							0x8B5F
#define GL_SAMPLER_CUBE							0x8B60
#define GL_SAMPLER_1D_SHADOW					0x8B61
#define GL_SAMPLER_2D_SHADOW					0x8B62

// vertex attrib arrays
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED			0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE				0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE			0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE				0x8625
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED		0x886A
#define GL_CURRENT_VERTEX_ATTRIB				0x8626
#define GL_VERTEX_ATTRIB_ARRAY_POINTER			0x8645
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING	0x889F

// hints
#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT		0x8B8B

// raster control
#define GL_VERTEX_PROGRAM_POINT_SIZE			0x8642
#define GL_VERTEX_PROGRAM_TWO_SIDE				0x8643

// implementation dependent strings and limits
#define GL_SHADING_LANGUAGE_VERSION				0x8B8C
#define GL_MAX_VERTEX_ATTRIBS					0x8869
#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS		0x8B49
#define GL_MAX_VERTEX_UNIFORM_COMPONENTS		0x8B4A
#define GL_MAX_VARYING_FLOATS					0x8B4B
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS		0x8B4C
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS		0x8B4D
#define GL_MAX_TEXTURE_COORDS					0x8871
#define GL_MAX_TEXTURE_IMAGE_UNITS				0x8872

// multiple render targets
#define GL_MAX_DRAW_BUFFERS						0x8824
#define GL_DRAW_BUFFER0							0x8825
#define GL_DRAW_BUFFER1							0x8826
#define GL_DRAW_BUFFER2							0x8827
#define GL_DRAW_BUFFER3							0x8828
#define GL_DRAW_BUFFER4							0x8829
#define GL_DRAW_BUFFER5							0x882A
#define GL_DRAW_BUFFER6							0x882B
#define GL_DRAW_BUFFER7							0x882C
#define GL_DRAW_BUFFER8							0x882D
#define GL_DRAW_BUFFER9							0x882E
#define GL_DRAW_BUFFER10						0x882F
#define GL_DRAW_BUFFER11						0x8830
#define GL_DRAW_BUFFER12						0x8831
#define GL_DRAW_BUFFER13						0x8832
#define GL_DRAW_BUFFER14						0x8833
#define GL_DRAW_BUFFER15						0x8834

// point sprite
#define GL_POINT_SPRITE 						0x8861
#define GL_COORD_REPLACE 						0x8862
#define GL_POINT_SPRITE_COORD_ORIGIN 			0x8CA0
#define GL_LOWER_LEFT 							0x8CA1
#define GL_UPPER_LEFT 							0x8CA2

// two-sided stencil
#define GL_STENCIL_BACK_FUNC					0x8800
#define GL_STENCIL_BACK_VALUE_MASK 				0x8CA4
#define GL_STENCIL_BACK_REF 					0x8CA3
#define GL_STENCIL_BACK_FAIL 					0x8801
#define GL_STENCIL_BACK_PASS_DEPTH_FAIL 		0x8802
#define GL_STENCIL_BACK_PASS_DEPTH_PASS 		0x8803
#define GL_STENCIL_BACK_WRITEMASK 				0x8CA5

// separate alpha blending
#ifdef GL_BLEND_EQUATION_RGB
#undef GL_BLEND_EQUATION_RGB
#endif
#define GL_BLEND_EQUATION_RGB					0x8009
#define GL_BLEND_EQUATION_ALPHA					0x883D

// shader objects api
extern void (__stdcall *glDeleteShader)(GLuint shader);
extern void (__stdcall *glDetachShader)(GLuint program, GLuint shader);
extern GLuint (__stdcall *glCreateShader)(GLenum type);
extern void (__stdcall *glShaderSource)(GLuint shader, GLsizei count, const GLchar* *string, const GLint *length);
extern void (__stdcall *glCompileShader)(GLuint shader);

// program objects
extern GLuint (__stdcall *glCreateProgram)(void);
extern void (__stdcall *glAttachShader)(GLuint program, GLuint shader);
extern void (__stdcall *glLinkProgram)(GLuint program);
extern void (__stdcall *glUseProgram)(GLuint program);
extern void (__stdcall *glDeleteProgram)(GLuint program);
extern void (__stdcall *glValidateProgram)(GLuint program);

// uniforms
extern void (__stdcall *glUniform1f)(GLint location, GLfloat v0);
extern void (__stdcall *glUniform2f)(GLint location, GLfloat v0, GLfloat v1);
extern void (__stdcall *glUniform3f)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
extern void (__stdcall *glUniform4f)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
extern void (__stdcall *glUniform1i)(GLint location, GLint v0);
extern void (__stdcall *glUniform2i)(GLint location, GLint v0, GLint v1);
extern void (__stdcall *glUniform3i)(GLint location, GLint v0, GLint v1, GLint v2);
extern void (__stdcall *glUniform4i)(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
extern void (__stdcall *glUniform1fv)(GLint location, GLsizei count, const GLfloat *value);
extern void (__stdcall *glUniform2fv)(GLint location, GLsizei count, const GLfloat *value);
extern void (__stdcall *glUniform3fv)(GLint location, GLsizei count, const GLfloat *value);
extern void (__stdcall *glUniform4fv)(GLint location, GLsizei count, const GLfloat *value);
extern void (__stdcall *glUniform1iv)(GLint location, GLsizei count, const GLint *value);
extern void (__stdcall *glUniform2iv)(GLint location, GLsizei count, const GLint *value);
extern void (__stdcall *glUniform3iv)(GLint location, GLsizei count, const GLint *value);
extern void (__stdcall *glUniform4iv)(GLint location, GLsizei count, const GLint *value);
extern void (__stdcall *glUniformMatrix2fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void (__stdcall *glUniformMatrix3fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void (__stdcall *glUniformMatrix4fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);

// attrib locations
extern void (__stdcall *glBindAttribLocation)(GLuint program, GLuint index, const GLchar *name);
extern GLint (__stdcall *glGetAttribLocation)(GLuint program, const GLchar *name);

// vertex attributes
extern void (__stdcall *glVertexAttrib1d)(GLuint index, GLdouble x);
extern void (__stdcall *glVertexAttrib1dv)(GLuint index, const GLdouble *v);
extern void (__stdcall *glVertexAttrib1f)(GLuint index, GLfloat x);
extern void (__stdcall *glVertexAttrib1fv)(GLuint index, const GLfloat *v);
extern void (__stdcall *glVertexAttrib1s)(GLuint index, GLshort x);
extern void (__stdcall *glVertexAttrib1sv)(GLuint index, const GLshort *v);
extern void (__stdcall *glVertexAttrib2d)(GLuint index, GLdouble x, GLdouble y);
extern void (__stdcall *glVertexAttrib2dv)(GLuint index, const GLdouble *v);
extern void (__stdcall *glVertexAttrib2f)(GLuint index, GLfloat x, GLfloat y);
extern void (__stdcall *glVertexAttrib2fv)(GLuint index, const GLfloat *v);
extern void (__stdcall *glVertexAttrib2s)(GLuint index, GLshort x, GLshort y);
extern void (__stdcall *glVertexAttrib2sv)(GLuint index, const GLshort *v);
extern void (__stdcall *glVertexAttrib3d)(GLuint index, GLdouble x, GLdouble y, GLdouble z);
extern void (__stdcall *glVertexAttrib3dv)(GLuint index, const GLdouble *v);
extern void (__stdcall *glVertexAttrib3f)(GLuint index, GLfloat x, GLfloat y, GLfloat z);
extern void (__stdcall *glVertexAttrib3fv)(GLuint index, const GLfloat *v);
extern void (__stdcall *glVertexAttrib3s)(GLuint index, GLshort x, GLshort y, GLshort z);
extern void (__stdcall *glVertexAttrib3sv)(GLuint index, const GLshort *v);
extern void (__stdcall *glVertexAttrib4Nbv)(GLuint index, const GLbyte *v);
extern void (__stdcall *glVertexAttrib4Niv)(GLuint index, const GLint *v);
extern void (__stdcall *glVertexAttrib4Nsv)(GLuint index, const GLshort *v);
extern void (__stdcall *glVertexAttrib4Nub)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
extern void (__stdcall *glVertexAttrib4Nubv)(GLuint index, const GLubyte *v);
extern void (__stdcall *glVertexAttrib4Nuiv)(GLuint index, const GLuint *v);
extern void (__stdcall *glVertexAttrib4Nusv)(GLuint index, const GLushort *v);
extern void (__stdcall *glVertexAttrib4bv)(GLuint index, const GLbyte *v);
extern void (__stdcall *glVertexAttrib4d)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void (__stdcall *glVertexAttrib4dv)(GLuint index, const GLdouble *v);
extern void (__stdcall *glVertexAttrib4f)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void (__stdcall *glVertexAttrib4fv)(GLuint index, const GLfloat *v);
extern void (__stdcall *glVertexAttrib4iv)(GLuint index, const GLint *v);
extern void (__stdcall *glVertexAttrib4s)(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
extern void (__stdcall *glVertexAttrib4sv)(GLuint index, const GLshort *v);
extern void (__stdcall *glVertexAttrib4ubv)(GLuint index, const GLubyte *v);
extern void (__stdcall *glVertexAttrib4uiv)(GLuint index, const GLuint *v);
extern void (__stdcall *glVertexAttrib4usv)(GLuint index, const GLushort *v);
extern void (__stdcall *glVertexAttribPointer)(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer);
extern void (__stdcall *glEnableVertexAttribArray)(GLuint index);
extern void (__stdcall *glDisableVertexAttribArray)(GLuint index);
extern void (__stdcall *glGetVertexAttribdv)(GLuint index, GLenum pname, GLdouble *params);
extern void (__stdcall *glGetVertexAttribfv)(GLuint index, GLenum pname, GLfloat *params);
extern void (__stdcall *glGetVertexAttribiv)(GLuint index, GLenum pname, GLint *params);
extern void (__stdcall *glGetVertexAttribPointerv)(GLuint index, GLenum pname, GLvoid* *pointer);

// queries
extern GLboolean (__stdcall *glIsShader)(GLuint shader);
extern GLboolean (__stdcall *glIsProgram)(GLuint program);
extern void (__stdcall *glGetShaderiv)(GLuint program, GLenum pname, GLint *params);
extern void (__stdcall *glGetProgramiv)(GLuint program, GLenum pname, GLint *params);
extern void (__stdcall *glGetAttachedShaders)(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders);
extern void (__stdcall *glGetShaderInfoLog)(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
extern void (__stdcall *glGetProgramInfoLog)(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
extern GLint (__stdcall *glGetUniformLocation)(GLuint program, const GLchar *name);
extern void (__stdcall *glGetActiveUniform)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
extern void (__stdcall *glGetUniformfv)(GLuint program, GLint location, GLfloat *params);
extern void (__stdcall *glGetUniformiv)(GLuint program, GLint location, GLint *params);
extern void (__stdcall *glGetShaderSource)(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source);
extern void (__stdcall *glGetActiveAttrib)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);

// multiple draw buffers
extern void (__stdcall *glDrawBuffers)(GLsizei n, const GLenum *bufs);

// two-sided stencil
extern void (__stdcall *glStencilFuncSeparate)(GLenum face, GLenum func, GLint ref, GLuint mask);
extern void (__stdcall *glStencilOpSeparate)(GLenum face, GLenum fail, GLenum zfail, GLenum zpass);
extern void (__stdcall *glStencilMaskSeparate)(GLenum face, GLuint mask);

// separate alpha blending
extern void (__stdcall *glBlendEquationSeparate)(GLenum modeRGB, GLenum modeAlpha);

/*
 *				--- GL_ARB_vertex_program ---
 */

#define GL_VERTEX_PROGRAM_ARB                              0x8620

#define GL_VERTEX_PROGRAM_POINT_SIZE_ARB                   0x8642
#define GL_VERTEX_PROGRAM_TWO_SIDE_ARB                     0x8643
#define GL_COLOR_SUM_ARB                                   0x8458

#define GL_PROGRAM_FORMAT_ASCII_ARB                        0x8875

#define GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB                 0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB                    0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB                  0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB                    0x8625
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB              0x886A
#define GL_CURRENT_VERTEX_ATTRIB_ARB                       0x8626

#define GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB                 0x8645

#define GL_PROGRAM_LENGTH_ARB                              0x8627
#define GL_PROGRAM_FORMAT_ARB                              0x8876
#define GL_PROGRAM_BINDING_ARB                             0x8677
#define GL_PROGRAM_INSTRUCTIONS_ARB                        0x88A0
#define GL_MAX_PROGRAM_INSTRUCTIONS_ARB                    0x88A1
#define GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB                 0x88A2
#define GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB             0x88A3
#define GL_PROGRAM_TEMPORARIES_ARB                         0x88A4
#define GL_MAX_PROGRAM_TEMPORARIES_ARB                     0x88A5
#define GL_PROGRAM_NATIVE_TEMPORARIES_ARB                  0x88A6
#define GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB              0x88A7
#define GL_PROGRAM_PARAMETERS_ARB                          0x88A8
#define GL_MAX_PROGRAM_PARAMETERS_ARB                      0x88A9
#define GL_PROGRAM_NATIVE_PARAMETERS_ARB                   0x88AA
#define GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB               0x88AB
#define GL_PROGRAM_ATTRIBS_ARB                             0x88AC
#define GL_MAX_PROGRAM_ATTRIBS_ARB                         0x88AD
#define GL_PROGRAM_NATIVE_ATTRIBS_ARB                      0x88AE
#define GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB                  0x88AF
#define GL_PROGRAM_ADDRESS_REGISTERS_ARB                   0x88B0
#define GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB               0x88B1
#define GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB            0x88B2
#define GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB        0x88B3
#define GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB                0x88B4
#define GL_MAX_PROGRAM_ENV_PARAMETERS_ARB                  0x88B5
#define GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB                 0x88B6

#define GL_PROGRAM_STRING_ARB                              0x8628

#define GL_PROGRAM_ERROR_POSITION_ARB                      0x864B
#define GL_CURRENT_MATRIX_ARB                              0x8641
#define GL_TRANSPOSE_CURRENT_MATRIX_ARB                    0x88B7
#define GL_CURRENT_MATRIX_STACK_DEPTH_ARB                  0x8640
#define GL_MAX_VERTEX_ATTRIBS_ARB                          0x8869
#define GL_MAX_PROGRAM_MATRICES_ARB                        0x862F
#define GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB              0x862E

#define GL_PROGRAM_ERROR_STRING_ARB                        0x8874

#define GL_MATRIX0_ARB                                     0x88C0
#define GL_MATRIX1_ARB                                     0x88C1
#define GL_MATRIX2_ARB                                     0x88C2
#define GL_MATRIX3_ARB                                     0x88C3
#define GL_MATRIX4_ARB                                     0x88C4
#define GL_MATRIX5_ARB                                     0x88C5
#define GL_MATRIX6_ARB                                     0x88C6
#define GL_MATRIX7_ARB                                     0x88C7
#define GL_MATRIX8_ARB                                     0x88C8
#define GL_MATRIX9_ARB                                     0x88C9
#define GL_MATRIX10_ARB                                    0x88CA
#define GL_MATRIX11_ARB                                    0x88CB
#define GL_MATRIX12_ARB                                    0x88CC
#define GL_MATRIX13_ARB                                    0x88CD
#define GL_MATRIX14_ARB                                    0x88CE
#define GL_MATRIX15_ARB                                    0x88CF
#define GL_MATRIX16_ARB                                    0x88D0
#define GL_MATRIX17_ARB                                    0x88D1
#define GL_MATRIX18_ARB                                    0x88D2
#define GL_MATRIX19_ARB                                    0x88D3
#define GL_MATRIX20_ARB                                    0x88D4
#define GL_MATRIX21_ARB                                    0x88D5
#define GL_MATRIX22_ARB                                    0x88D6
#define GL_MATRIX23_ARB                                    0x88D7
#define GL_MATRIX24_ARB                                    0x88D8
#define GL_MATRIX25_ARB                                    0x88D9
#define GL_MATRIX26_ARB                                    0x88DA
#define GL_MATRIX27_ARB                                    0x88DB
#define GL_MATRIX28_ARB                                    0x88DC
#define GL_MATRIX29_ARB                                    0x88DD
#define GL_MATRIX30_ARB                                    0x88DE
#define GL_MATRIX31_ARB                                    0x88DF

// vertex program
extern void (__stdcall *glVertexAttrib1sARB)(GLuint index, short x);
extern void (__stdcall *glVertexAttrib1fARB)(GLuint index, float x);
extern void (__stdcall *glVertexAttrib1dARB)(GLuint index, double x);
extern void (__stdcall *glVertexAttrib2sARB)(GLuint index, short x, short y);
extern void (__stdcall *glVertexAttrib2fARB)(GLuint index, float x, float y);
extern void (__stdcall *glVertexAttrib2dARB)(GLuint index, double x, double y);
extern void (__stdcall *glVertexAttrib3sARB)(GLuint index, short x, short y, short z);
extern void (__stdcall *glVertexAttrib3fARB)(GLuint index, float x, float y, float z);
extern void (__stdcall *glVertexAttrib3dARB)(GLuint index, double x, double y, double z);
extern void (__stdcall *glVertexAttrib4sARB)(GLuint index, short x, short y, short z, short w);
extern void (__stdcall *glVertexAttrib4fARB)(GLuint index, float x, float y, float z, float w);
extern void (__stdcall *glVertexAttrib4dARB)(GLuint index, double x, double y, double z, double w);
extern void (__stdcall *glVertexAttrib4NubARB)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
extern void (__stdcall *glVertexAttrib1svARB)(GLuint index, const short *v);
extern void (__stdcall *glVertexAttrib1fvARB)(GLuint index, const float *v);
extern void (__stdcall *glVertexAttrib1dvARB)(GLuint index, const double *v);
extern void (__stdcall *glVertexAttrib2svARB)(GLuint index, const short *v);
extern void (__stdcall *glVertexAttrib2fvARB)(GLuint index, const float *v);
extern void (__stdcall *glVertexAttrib2dvARB)(GLuint index, const double *v);
extern void (__stdcall *glVertexAttrib3svARB)(GLuint index, const short *v);
extern void (__stdcall *glVertexAttrib3fvARB)(GLuint index, const float *v);
extern void (__stdcall *glVertexAttrib3dvARB)(GLuint index, const double *v);
extern void (__stdcall *glVertexAttrib4bvARB)(GLuint index, const GLbyte *v);
extern void (__stdcall *glVertexAttrib4svARB)(GLuint index, const short *v);
extern void (__stdcall *glVertexAttrib4ivARB)(GLuint index, const int *v);
extern void (__stdcall *glVertexAttrib4ubvARB)(GLuint index, const GLubyte *v);
extern void (__stdcall *glVertexAttrib4usvARB)(GLuint index, const GLushort *v);
extern void (__stdcall *glVertexAttrib4uivARB)(GLuint index, const GLuint *v);
extern void (__stdcall *glVertexAttrib4fvARB)(GLuint index, const float *v);
extern void (__stdcall *glVertexAttrib4dvARB)(GLuint index, const double *v);
extern void (__stdcall *glVertexAttrib4NbvARB)(GLuint index, const GLbyte *v);
extern void (__stdcall *glVertexAttrib4NsvARB)(GLuint index, const short *v);
extern void (__stdcall *glVertexAttrib4NivARB)(GLuint index, const int *v);
extern void (__stdcall *glVertexAttrib4NubvARB)(GLuint index, const GLubyte *v);
extern void (__stdcall *glVertexAttrib4NusvARB)(GLuint index, const GLushort *v);
extern void (__stdcall *glVertexAttrib4NuivARB)(GLuint index, const GLuint *v);
extern void (__stdcall *glVertexAttribPointerARB)(GLuint index, int size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer);
extern void (__stdcall *glEnableVertexAttribArrayARB)(GLuint index);
extern void (__stdcall *glDisableVertexAttribArrayARB)(GLuint index);
extern void (__stdcall *glProgramStringARB)(GLenum target, GLenum format, GLsizei len, const void *string); 
extern void (__stdcall *glBindProgramARB)(GLenum target, GLuint program);
extern void (__stdcall *glDeleteProgramsARB)(GLsizei n, const GLuint *programs);
extern void (__stdcall *glGenProgramsARB)(GLsizei n, GLuint *programs);
extern void (__stdcall *glProgramEnvParameter4dARB)(GLenum target, GLuint index, double x, double y, double z, double w);
extern void (__stdcall *glProgramEnvParameter4dvARB)(GLenum target, GLuint index, const double *params);
extern void (__stdcall *glProgramEnvParameter4fARB)(GLenum target, GLuint index, float x, float y, float z, float w);
extern void (__stdcall *glProgramEnvParameter4fvARB)(GLenum target, GLuint index, const float *params);
extern void (__stdcall *glProgramLocalParameter4dARB)(GLenum target, GLuint index, double x, double y, double z, double w);
extern void (__stdcall *glProgramLocalParameter4dvARB)(GLenum target, GLuint index, const double *params);
extern void (__stdcall *glProgramLocalParameter4fARB)(GLenum target, GLuint index, float x, float y, float z, float w);
extern void (__stdcall *glProgramLocalParameter4fvARB)(GLenum target, GLuint index, const float *params);
extern void (__stdcall *glGetProgramEnvParameterdvARB)(GLenum target, GLuint index, double *params);
extern void (__stdcall *glGetProgramEnvParameterfvARB)(GLenum target, GLuint index, float *params);
extern void (__stdcall *glGetProgramLocalParameterdvARB)(GLenum target, GLuint index, double *params);
extern void (__stdcall *glGetProgramLocalParameterfvARB)(GLenum target, GLuint index, float *params);
extern void (__stdcall *glGetProgramivARB)(GLenum target, GLenum pname, int *params);
extern void (__stdcall *glGetProgramStringARB)(GLenum target, GLenum pname, void *string);
extern void (__stdcall *glGetVertexAttribdvARB)(GLuint index, GLenum pname, double *params);
extern void (__stdcall *glGetVertexAttribfvARB)(GLuint index, GLenum pname, float *params);
extern void (__stdcall *glGetVertexAttribivARB)(GLuint index, GLenum pname, int *params);
extern void (__stdcall *glGetVertexAttribPointervARB)(GLuint index, GLenum pname, void **pointer);
extern GLboolean (__stdcall *glIsProgramARB)(GLuint program);

/*
 *				--- GL_ARB_fragment_program ---
 */

#define GL_FRAGMENT_PROGRAM_ARB                            0x8804

/*
#define GL_PROGRAM_FORMAT_ASCII_ARB                        0x8875

#define GL_PROGRAM_LENGTH_ARB                              0x8627
#define GL_PROGRAM_FORMAT_ARB                              0x8876
#define GL_PROGRAM_BINDING_ARB                             0x8677
#define GL_PROGRAM_INSTRUCTIONS_ARB                        0x88A0
#define GL_MAX_PROGRAM_INSTRUCTIONS_ARB                    0x88A1
#define GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB                 0x88A2
#define GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB             0x88A3
#define GL_PROGRAM_TEMPORARIES_ARB                         0x88A4
#define GL_MAX_PROGRAM_TEMPORARIES_ARB                     0x88A5
#define GL_PROGRAM_NATIVE_TEMPORARIES_ARB                  0x88A6
#define GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB              0x88A7
#define GL_PROGRAM_PARAMETERS_ARB                          0x88A8
#define GL_MAX_PROGRAM_PARAMETERS_ARB                      0x88A9
#define GL_PROGRAM_NATIVE_PARAMETERS_ARB                   0x88AA
#define GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB               0x88AB
#define GL_PROGRAM_ATTRIBS_ARB                             0x88AC
#define GL_MAX_PROGRAM_ATTRIBS_ARB                         0x88AD
#define GL_PROGRAM_NATIVE_ATTRIBS_ARB                      0x88AE
#define GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB                  0x88AF
#define GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB                0x88B4
#define GL_MAX_PROGRAM_ENV_PARAMETERS_ARB                  0x88B5
#define GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB                 0x88B6
*/
#define GL_PROGRAM_ALU_INSTRUCTIONS_ARB                    0x8805
#define GL_PROGRAM_TEX_INSTRUCTIONS_ARB                    0x8806
#define GL_PROGRAM_TEX_INDIRECTIONS_ARB                    0x8807
#define GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB             0x8808
#define GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB             0x8809
#define GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB             0x880A
#define GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB                0x880B
#define GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB                0x880C
#define GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB                0x880D
#define GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB         0x880E
#define GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB         0x880F
#define GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB         0x8810
/*
#define GL_PROGRAM_STRING_ARB                              0x8628

#define GL_PROGRAM_ERROR_POSITION_ARB                      0x864B
#define GL_CURRENT_MATRIX_ARB                              0x8641
#define GL_TRANSPOSE_CURRENT_MATRIX_ARB                    0x88B7
#define GL_CURRENT_MATRIX_STACK_DEPTH_ARB                  0x8640
#define GL_MAX_PROGRAM_MATRICES_ARB                        0x862F
#define GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB              0x862E
*/
#define GL_MAX_TEXTURE_COORDS_ARB                          0x8871
#define GL_MAX_TEXTURE_IMAGE_UNITS_ARB                     0x8872
/*
#define GL_PROGRAM_ERROR_STRING_ARB                        0x8874
*/ // commented-out tokens already defined by GL_ARB_vertex_program

// fragment program
extern void (__stdcall *glProgramStringARB)(GLenum target, GLenum format, GLsizei len, const void *string); 
extern void (__stdcall *glBindProgramARB)(GLenum target, GLuint program);
extern void (__stdcall *glDeleteProgramsARB)(GLsizei n, const GLuint *programs);
extern void (__stdcall *glGenProgramsARB)(GLsizei n, GLuint *programs);
extern void (__stdcall *glProgramEnvParameter4dARB)(GLenum target, GLuint index, double x, double y, double z, double w);
extern void (__stdcall *glProgramEnvParameter4dvARB)(GLenum target, GLuint index, const double *params);
extern void (__stdcall *glProgramEnvParameter4fARB)(GLenum target, GLuint index, float x, float y, float z, float w);
extern void (__stdcall *glProgramEnvParameter4fvARB)(GLenum target, GLuint index, const float *params);
extern void (__stdcall *glProgramLocalParameter4dARB)(GLenum target, GLuint index, double x, double y, double z, double w);
extern void (__stdcall *glProgramLocalParameter4dvARB)(GLenum target, GLuint index, const double *params);
extern void (__stdcall *glProgramLocalParameter4fARB)(GLenum target, GLuint index, float x, float y, float z, float w);
extern void (__stdcall *glProgramLocalParameter4fvARB)(GLenum target, GLuint index, const float *params);
extern void (__stdcall *glGetProgramEnvParameterdvARB)(GLenum target, GLuint index, double *params);
extern void (__stdcall *glGetProgramEnvParameterfvARB)(GLenum target, GLuint index, float *params);
extern void (__stdcall *glGetProgramLocalParameterdvARB)(GLenum target, GLuint index, double *params);
extern void (__stdcall *glGetProgramLocalParameterfvARB)(GLenum target, GLuint index, float *params);
extern void (__stdcall *glGetProgramivARB)(GLenum target, GLenum pname, int *params);
extern void (__stdcall *glGetProgramStringARB)(GLenum target, GLenum pname, void *string);
extern GLboolean (__stdcall *glIsProgramARB)(GLuint program);

/*
 *				--- GL_ARB_vertex_shader ---
 */

#define GL_VERTEX_SHADER_ARB						0x8B31

#define GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB		0x8B4A
#define GL_MAX_VARYING_FLOATS_ARB					0x8B4B
#define GL_MAX_VERTEX_ATTRIBS_ARB					0x8869
#define GL_MAX_TEXTURE_IMAGE_UNITS_ARB				0x8872
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB		0x8B4C
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB		0x8B4D
#define GL_MAX_TEXTURE_COORDS_ARB					0x8871

#define GL_VERTEX_PROGRAM_POINT_SIZE_ARB			0x8642
#define GL_VERTEX_PROGRAM_TWO_SIDE_ARB				0x8643

#define GL_OBJECT_ACTIVE_ATTRIBUTES_ARB				0x8B89
#define GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB	0x8B8A

#define GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB			0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB				0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB			0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB				0x8625
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB		0x886A
#define GL_CURRENT_VERTEX_ATTRIB_ARB				0x8626

#define GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB			0x8645

#define GL_FLOAT									0x1406
#define GL_FLOAT_VEC2_ARB							0x8B50
#define GL_FLOAT_VEC3_ARB							0x8B51
#define GL_FLOAT_VEC4_ARB							0x8B52
#define GL_FLOAT_MAT2_ARB							0x8B5A
#define GL_FLOAT_MAT3_ARB							0x8B5B
#define GL_FLOAT_MAT4_ARB							0x8B5C
// new tokens

// vertex shader
extern void (__stdcall *glVertexAttrib1fARB)(GLuint index, float v0);
extern void (__stdcall *glVertexAttrib1sARB)(GLuint index, short v0);
extern void (__stdcall *glVertexAttrib1dARB)(GLuint index, double v0);
extern void (__stdcall *glVertexAttrib2fARB)(GLuint index, float v0, float v1);
extern void (__stdcall *glVertexAttrib2sARB)(GLuint index, short v0, short v1);
extern void (__stdcall *glVertexAttrib2dARB)(GLuint index, double v0, double v1);
extern void (__stdcall *glVertexAttrib3fARB)(GLuint index, float v0, float v1, float v2);
extern void (__stdcall *glVertexAttrib3sARB)(GLuint index, short v0, short v1, short v2);
extern void (__stdcall *glVertexAttrib3dARB)(GLuint index, double v0, double v1, double v2);
extern void (__stdcall *glVertexAttrib4fARB)(GLuint index, float v0, float v1, float v2, float v3);
extern void (__stdcall *glVertexAttrib4sARB)(GLuint index, short v0, short v1, short v2, short v3);
extern void (__stdcall *glVertexAttrib4dARB)(GLuint index, double v0, double v1, double v2, double v3);
extern void (__stdcall *glVertexAttrib4NubARB)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
extern void (__stdcall *glVertexAttrib1fvARB)(GLuint index, const float *v);
extern void (__stdcall *glVertexAttrib1svARB)(GLuint index, const short *v);
extern void (__stdcall *glVertexAttrib1dvARB)(GLuint index, const double *v);
extern void (__stdcall *glVertexAttrib2fvARB)(GLuint index, const float *v);
extern void (__stdcall *glVertexAttrib2svARB)(GLuint index, const short *v);
extern void (__stdcall *glVertexAttrib2dvARB)(GLuint index, const double *v);
extern void (__stdcall *glVertexAttrib3fvARB)(GLuint index, const float *v);
extern void (__stdcall *glVertexAttrib3svARB)(GLuint index, const short *v);
extern void (__stdcall *glVertexAttrib3dvARB)(GLuint index, const double *v);
extern void (__stdcall *glVertexAttrib4fvARB)(GLuint index, const float *v);
extern void (__stdcall *glVertexAttrib4svARB)(GLuint index, const short *v);
extern void (__stdcall *glVertexAttrib4dvARB)(GLuint index, const double *v);
extern void (__stdcall *glVertexAttrib4ivARB)(GLuint index, const int *v);
extern void (__stdcall *glVertexAttrib4bvARB)(GLuint index, const GLbyte *v);
extern void (__stdcall *glVertexAttrib4ubvARB)(GLuint index, const GLubyte *v);
extern void (__stdcall *glVertexAttrib4usvARB)(GLuint index, const GLushort *v);
extern void (__stdcall *glVertexAttrib4uivARB)(GLuint index, const GLuint *v);
extern void (__stdcall *glVertexAttrib4NbvARB)(GLuint index, const GLbyte *v);
extern void (__stdcall *glVertexAttrib4NsvARB)(GLuint index, const short *v);
extern void (__stdcall *glVertexAttrib4NivARB)(GLuint index, const int *v);
extern void (__stdcall *glVertexAttrib4NubvARB)(GLuint index, const GLubyte *v);
extern void (__stdcall *glVertexAttrib4NusvARB)(GLuint index, const GLushort *v);
extern void (__stdcall *glVertexAttrib4NuivARB)(GLuint index, const GLuint *v);
extern void (__stdcall *glVertexAttribPointerARB)(GLuint index, int size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer);
extern void (__stdcall *glEnableVertexAttribArrayARB)(GLuint index);
extern void (__stdcall *glDisableVertexAttribArrayARB)(GLuint index);
extern void (__stdcall *glBindAttribLocationARB)(GLhandleARB programObj, GLuint index, const GLcharARB *name);
extern void (__stdcall *glGetActiveAttribARB)(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, int *size, GLenum *type, GLcharARB *name);
extern int (__stdcall *glGetAttribLocationARB)(GLhandleARB programObj, const GLcharARB *name);
extern void (__stdcall *glGetVertexAttribdvARB)(GLuint index, GLenum pname, double *params);
extern void (__stdcall *glGetVertexAttribfvARB)(GLuint index, GLenum pname, float *params);
extern void (__stdcall *glGetVertexAttribivARB)(GLuint index, GLenum pname, int *params);
extern void (__stdcall *glGetVertexAttribPointervARB)(GLuint index, GLenum pname, void **pointer);

/*
 *				--- GL_ARB_fragment_shader ---
 */

#define GL_FRAGMENT_SHADER_ARB						0x8B30

#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB		0x8B49
#define GL_MAX_TEXTURE_COORDS_ARB					0x8871
#define GL_MAX_TEXTURE_IMAGE_UNITS_ARB				0x8872

#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB		0x8B8B

// (no new functions ??)

/*
 *				--- GL_ARB_shader_object ---
 */

#define GL_PROGRAM_OBJECT_ARB						0x8B40

#define GL_OBJECT_TYPE_ARB							0x8B4E
#define GL_OBJECT_SUBTYPE_ARB						0x8B4F
#define GL_OBJECT_DELETE_STATUS_ARB					0x8B80
#define GL_OBJECT_COMPILE_STATUS_ARB				0x8B81
#define GL_OBJECT_LINK_STATUS_ARB					0x8B82
#define GL_OBJECT_VALIDATE_STATUS_ARB				0x8B83
#define GL_OBJECT_INFO_LOG_LENGTH_ARB				0x8B84
#define GL_OBJECT_ATTACHED_OBJECTS_ARB				0x8B85
#define GL_OBJECT_ACTIVE_UNIFORMS_ARB				0x8B86
#define GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB		0x8B87
#define GL_OBJECT_SHADER_SOURCE_LENGTH_ARB			0x8B88

#define GL_SHADER_OBJECT_ARB						0x8B48

#define GL_FLOAT									0x1406
#define GL_FLOAT_VEC2_ARB							0x8B50
#define GL_FLOAT_VEC3_ARB							0x8B51
#define GL_FLOAT_VEC4_ARB							0x8B52
#define GL_INT										0x1404
#define GL_INT_VEC2_ARB								0x8B53
#define GL_INT_VEC3_ARB								0x8B54
#define GL_INT_VEC4_ARB								0x8B55
#define GL_BOOL_ARB									0x8B56
#define GL_BOOL_VEC2_ARB							0x8B57
#define GL_BOOL_VEC3_ARB							0x8B58
#define GL_BOOL_VEC4_ARB							0x8B59
#define GL_FLOAT_MAT2_ARB							0x8B5A
#define GL_FLOAT_MAT3_ARB							0x8B5B
#define GL_FLOAT_MAT4_ARB							0x8B5C
#define GL_SAMPLER_1D_ARB							0x8B5D
#define GL_SAMPLER_2D_ARB							0x8B5E
#define GL_SAMPLER_3D_ARB							0x8B5F
#define GL_SAMPLER_CUBE_ARB							0x8B60
#define GL_SAMPLER_1D_SHADOW_ARB					0x8B61
#define GL_SAMPLER_2D_SHADOW_ARB					0x8B62
#define GL_SAMPLER_2D_RECT_ARB						0x8B63
#define GL_SAMPLER_2D_RECT_SHADOW_ARB				0x8B64

// shader objects
extern void (__stdcall *glDeleteObjectARB)(GLhandleARB obj);
extern GLhandleARB (__stdcall *glGetHandleARB)(GLenum pname);
extern void (__stdcall *glDetachObjectARB)(GLhandleARB containerObj, GLhandleARB attachedObj);
extern GLhandleARB (__stdcall *glCreateShaderObjectARB)(GLenum shaderType);
extern void (__stdcall *glShaderSourceARB)(GLhandleARB shaderObj, GLsizei count, const GLcharARB **string, const int *length);
extern void (__stdcall *glCompileShaderARB)(GLhandleARB shaderObj);
extern GLhandleARB (__stdcall *glCreateProgramObjectARB)(void);
extern void (__stdcall *glAttachObjectARB)(GLhandleARB containerObj, GLhandleARB obj);
extern void (__stdcall *glLinkProgramARB)(GLhandleARB programObj);
extern void (__stdcall *glUseProgramObjectARB)(GLhandleARB programObj);
extern void (__stdcall *glValidateProgramARB)(GLhandleARB programObj);
extern void (__stdcall *glUniform1fARB)(int location, float v0);
extern void (__stdcall *glUniform2fARB)(int location, float v0, float v1);
extern void (__stdcall *glUniform3fARB)(int location, float v0, float v1, float v2);
extern void (__stdcall *glUniform4fARB)(int location, float v0, float v1, float v2, float v3);
extern void (__stdcall *glUniform1iARB)(int location, int v0);
extern void (__stdcall *glUniform2iARB)(int location, int v0, int v1);
extern void (__stdcall *glUniform3iARB)(int location, int v0, int v1, int v2);
extern void (__stdcall *glUniform4iARB)(int location, int v0, int v1, int v2, int v3);
extern void (__stdcall *glUniform1fvARB)(int location, GLsizei count, const float *value);
extern void (__stdcall *glUniform2fvARB)(int location, GLsizei count, const float *value);
extern void (__stdcall *glUniform3fvARB)(int location, GLsizei count, const float *value);
extern void (__stdcall *glUniform4fvARB)(int location, GLsizei count, const float *value);
extern void (__stdcall *glUniform1ivARB)(int location, GLsizei count, const int *value);
extern void (__stdcall *glUniform2ivARB)(int location, GLsizei count, const int *value);
extern void (__stdcall *glUniform3ivARB)(int location, GLsizei count, const int *value);
extern void (__stdcall *glUniform4ivARB)(int location, GLsizei count, const int *value);
extern void (__stdcall *glUniformMatrix2fvARB)(int location, GLsizei count, GLboolean transpose, const float *value);
extern void (__stdcall *glUniformMatrix3fvARB)(int location, GLsizei count, GLboolean transpose, const float *value);
extern void (__stdcall *glUniformMatrix4fvARB)(int location, GLsizei count, GLboolean transpose, const float *value);
extern void (__stdcall *glGetObjectParameterfvARB)(GLhandleARB obj, GLenum pname, float *params);
extern void (__stdcall *glGetObjectParameterivARB)(GLhandleARB obj, GLenum pname, int *params);
extern void (__stdcall *glGetInfoLogARB)(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog);
extern void (__stdcall *glGetAttachedObjectsARB)(GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj);
extern int (__stdcall *glGetUniformLocationARB)(GLhandleARB programObj, const GLcharARB *name);
extern void (__stdcall *glGetActiveUniformARB)(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, int *size, GLenum *type, GLcharARB *name);
extern void (__stdcall *glGetUniformfvARB)(GLhandleARB programObj, int location, float *params);
extern void (__stdcall *glGetUniformivARB)(GLhandleARB programObj, int location, int *params);
extern void (__stdcall *glGetShaderSourceARB)(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source);

/*
 *								--- GL_ARB_vertex_buffer_object ---
 */

// Accepted by the <target> parameters of BindBufferARB, BufferDataARB,
// BufferSubDataARB, MapBufferARB, UnmapBufferARB, GetBufferSubDataARB,
// GetBufferParameterivARB, and GetBufferPointervARB:

#define GL_ARRAY_BUFFER_ARB 0x8892
#define GL_ELEMENT_ARRAY_BUFFER_ARB 0x8893

// Accepted by the <pname> parameter of GetBooleanv, GetIntegerv, GetFloatv, and GetDoublev:

#define GL_ARRAY_BUFFER_BINDING_ARB 0x8894
#define GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB 0x8895
#define GL_VERTEX_ARRAY_BUFFER_BINDING_ARB 0x8896
#define GL_NORMAL_ARRAY_BUFFER_BINDING_ARB 0x8897
#define GL_COLOR_ARRAY_BUFFER_BINDING_ARB 0x8898
#define GL_INDEX_ARRAY_BUFFER_BINDING_ARB 0x8899
#define GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB 0x889A
#define GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB 0x889B
#define GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB 0x889C
#define GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB 0x889D
#define GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB 0x889E

// Accepted by the <pname> parameter of GetVertexAttribivARB:

#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB 0x889F

// Accepted by the <usage> parameter of BufferDataARB:

#define GL_STREAM_DRAW_ARB 0x88E0
#define GL_STREAM_READ_ARB 0x88E1
#define GL_STREAM_COPY_ARB 0x88E2
#define GL_STATIC_DRAW_ARB 0x88E4
#define GL_STATIC_READ_ARB 0x88E5
#define GL_STATIC_COPY_ARB 0x88E6
#define GL_DYNAMIC_DRAW_ARB 0x88E8
#define GL_DYNAMIC_READ_ARB 0x88E9
#define GL_DYNAMIC_COPY_ARB 0x88EA

// Accepted by the <access> parameter of MapBufferARB:

#define GL_READ_ONLY_ARB 0x88B8
#define GL_WRITE_ONLY_ARB 0x88B9
#define GL_READ_WRITE_ARB 0x88BA

// Accepted by the <pname> parameter of GetBufferParameterivARB:

#define GL_BUFFER_SIZE_ARB 0x8764
#define GL_BUFFER_USAGE_ARB 0x8765
#define GL_BUFFER_ACCESS_ARB 0x88BB
#define GL_BUFFER_MAPPED_ARB 0x88BC

// Accepted by the <pname> parameter of GetBufferPointervARB:

#define GL_BUFFER_MAP_POINTER_ARB 0x88BD

// new procedures and functions (contained in GL 1.5core as well)
extern void (__stdcall *glBindBufferARB)(GLenum target, GLuint buffer);
extern void (__stdcall *glDeleteBuffersARB)(GLsizei n, const GLuint *buffers);
extern void (__stdcall *glGenBuffersARB)(GLsizei n, GLuint *buffers);
extern GLboolean (__stdcall *glIsBufferARB)(GLuint buffer);
extern void (__stdcall *glBufferDataARB)(GLenum target, GLsizeiptrARB size, const void *data, GLenum usage);
extern void (__stdcall *glBufferSubDataARB)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const void *data);
extern void (__stdcall *glGetBufferSubDataARB)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, void *data);
extern void *(__stdcall *glMapBufferARB)(GLenum target, GLenum access);
extern GLboolean (__stdcall *glUnmapBufferARB)(GLenum target);
extern void (__stdcall *glGetBufferParameterivARB)(GLenum target, GLenum pname, int *params);
extern void (__stdcall *glGetBufferPointervARB)(GLenum target, GLenum pname, void **params);

/*
 *								--- GL_ARB_pixel_buffer_object ---
 */

// Accepted by the <target> parameters of BindBuffer, BufferData,
// BufferSubData, MapBuffer, UnmapBuffer, GetBufferSubData,
// GetBufferParameteriv, and GetBufferPointerv:

#define GL_PIXEL_PACK_BUFFER_ARB                        0x88EB
#define GL_PIXEL_UNPACK_BUFFER_ARB                      0x88EC

// Accepted by the <pname> parameter of GetBooleanv, GetIntegerv,
// GetFloatv, and GetDoublev:

#define GL_PIXEL_PACK_BUFFER_BINDING_ARB                0x88ED
#define GL_PIXEL_UNPACK_BUFFER_BINDING_ARB              0x88EF

/*
 *				--- GL_NV_fence ---
 */

extern void (__stdcall *glGenFencesNV)(GLsizei n, GLuint *fences);
extern void (__stdcall *glDeleteFencesNV)(GLsizei n, const GLuint *fences);
extern void (__stdcall *glSetFenceNV)(GLuint fence, GLenum condition);
extern GLboolean (__stdcall *glTestFenceNV)(GLuint fence);
extern void (__stdcall *glFinishFenceNV)(GLuint fence);
extern GLboolean (__stdcall *glIsFenceNV)(GLuint fence);
extern void (__stdcall *glGetFenceivNV)(GLuint fence, GLenum pname, int *params);

// Accepted by the <condition> parameter of SetFenceNV:
#define GL_ALL_COMPLETED_NV                   0x84F2

// Accepted by the <pname> parameter of GetFenceivNV:
#define GL_FENCE_STATUS_NV                    0x84F3
#define GL_FENCE_CONDITION_NV                 0x84F4

#endif // __OPENGL20_TOOL_INCLUDED

/*
 *		-end-of-file-
 */
