/*
								+---------------------------------+
								|                                 |
								|      ***   OpenGL2.0   ***      |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|           OpenGl20.cpp          |
								|                                 |
								+---------------------------------+
*/

#include <crtdbg.h>
#include <windows.h>
#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <time.h>
#include <gl/gl.h>
#include "glext.h"

#include "opengl20.h"

#include <vector>
#include "callstack.h"

/*
 *								=== CGLExtensionHandler ===
 */

int CGLExtensionHandler::b_Support_OpenGL(int n_min_major, int n_min_minor)
{
	__FuncGuard("CGLExtensionHandler::b_Support_OpenGL");

	const char *p_s_version;
	int n_major, n_minor;

	p_s_version = (const char*)glGetString(GL_VERSION);

	if(sscanf(p_s_version, "%d.%d", &n_major, &n_minor) == 2) {
		if(n_major > n_min_major)
			return true;
		if(n_major == n_min_major && n_minor >= n_min_minor)
			return true;
	} else {
		_ASSERTE(0);
		// error - OpenGL version string malformed!
		return false;
	}

	return false;
}

int CGLExtensionHandler::b_SupportedExtension(const char *p_s_extension_name)
{
	__FuncGuard("CGLExtensionHandler::b_SupportedExtension");

	const char *p_s_extensions, *p_s_search_str;

	p_s_extensions = (const char*)glGetString(GL_EXTENSIONS);
	p_s_search_str = p_s_extensions;

	do {
		if(p_s_search_str = strstr(p_s_search_str, p_s_extension_name)) {
			if(p_s_search_str > p_s_extensions && !isspace(*(p_s_search_str - 1)))
				continue;
			if(strlen(p_s_search_str + strlen(p_s_extension_name)) &&
			   !isspace(*(p_s_search_str + strlen(p_s_extension_name))))
				continue;

			return true;
		}
	} while(p_s_search_str && strlen(++ p_s_search_str));

	return false;
}

#ifdef _WIN32

#include "wglext.h"

int CGLExtensionHandler::b_SupportedWGLExtension(const char *p_s_extension_name)
{
	__FuncGuard("CGLExtensionHandler::b_SupportedWGLExtension");

	const char *p_s_extensions, *p_s_search_str;

	PFNWGLGETEXTENSIONSSTRINGARBPROC wglGetExtensionsStringARB;
	if(!(wglGetExtensionsStringARB = (PFNWGLGETEXTENSIONSSTRINGARBPROC)wglGetProcAddress("wglGetExtensionsStringARB")))
		return false;

	p_s_extensions = (const char*)wglGetExtensionsStringARB(wglGetCurrentDC());
	p_s_search_str = p_s_extensions;

	do {
		if(p_s_search_str = strstr(p_s_search_str, p_s_extension_name)) {
			if(p_s_search_str > p_s_extensions && !isspace(*(p_s_search_str - 1)))
				continue;
			if(strlen(p_s_search_str + strlen(p_s_extension_name)) &&
			   !isspace(*(p_s_search_str + strlen(p_s_extension_name))))
				continue;

			return true;
		}
	} while(p_s_search_str && strlen(++ p_s_search_str));

	return false;
}

#endif

/*
 *		--- opengl 1.2 core func pointers ---
 */

void (__stdcall *glBlendColor)(GLclampf, GLclampf, GLclampf, GLclampf) = 0;
void (__stdcall *glBlendEquation)(GLenum) = 0;
void (__stdcall *glDrawRangeElements)(GLenum, GLuint, GLuint, GLsizei, GLenum, const GLvoid*) = 0;
void (__stdcall *glColorTable)(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*) = 0;
void (__stdcall *glColorTableParameterfv)(GLenum, GLenum, const GLfloat*) = 0;
void (__stdcall *glColorTableParameteriv)(GLenum, GLenum, const GLint*) = 0;
void (__stdcall *glCopyColorTable)(GLenum, GLenum, GLint, GLint, GLsizei) = 0;
void (__stdcall *glGetColorTable)(GLenum, GLenum, GLenum, GLvoid*) = 0;
void (__stdcall *glGetColorTableParameterfv)(GLenum, GLenum, GLfloat*) = 0;
void (__stdcall *glGetColorTableParameteriv)(GLenum, GLenum, GLint*) = 0;
void (__stdcall *glColorSubTable)(GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*) = 0;
void (__stdcall *glCopyColorSubTable)(GLenum, GLsizei, GLint, GLint, GLsizei) = 0;
void (__stdcall *glConvolutionFilter1D)(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*) = 0;
void (__stdcall *glConvolutionFilter2D)(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*) = 0;
void (__stdcall *glConvolutionParameterf)(GLenum, GLenum, GLfloat) = 0;
void (__stdcall *glConvolutionParameterfv)(GLenum, GLenum, const GLfloat*) = 0;
void (__stdcall *glConvolutionParameteri)(GLenum, GLenum, GLint) = 0;
void (__stdcall *glConvolutionParameteriv)(GLenum, GLenum, const GLint*) = 0;
void (__stdcall *glCopyConvolutionFilter1D)(GLenum, GLenum, GLint, GLint, GLsizei) = 0;
void (__stdcall *glCopyConvolutionFilter2D)(GLenum, GLenum, GLint, GLint, GLsizei, GLsizei) = 0;
void (__stdcall *glGetConvolutionFilter)(GLenum, GLenum, GLenum, GLvoid*) = 0;
void (__stdcall *glGetConvolutionParameterfv)(GLenum, GLenum, GLfloat*) = 0;
void (__stdcall *glGetConvolutionParameteriv)(GLenum, GLenum, GLint*) = 0;
void (__stdcall *glGetSeparableFilter)(GLenum, GLenum, GLenum, GLvoid *, GLvoid *, GLvoid*) = 0;
void (__stdcall *glSeparableFilter2D)(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *, const GLvoid*) = 0;
void (__stdcall *glGetHistogram)(GLenum, GLboolean, GLenum, GLenum, GLvoid*) = 0;
void (__stdcall *glGetHistogramParameterfv)(GLenum, GLenum, GLfloat*) = 0;
void (__stdcall *glGetHistogramParameteriv)(GLenum, GLenum, GLint*) = 0;
void (__stdcall *glGetMinmax)(GLenum, GLboolean, GLenum, GLenum, GLvoid*) = 0;
void (__stdcall *glGetMinmaxParameterfv)(GLenum, GLenum, GLfloat*) = 0;
void (__stdcall *glGetMinmaxParameteriv)(GLenum, GLenum, GLint*) = 0;
void (__stdcall *glHistogram)(GLenum, GLsizei, GLenum, GLboolean) = 0;
void (__stdcall *glMinmax)(GLenum, GLenum, GLboolean) = 0;
void (__stdcall *glResetHistogram)(GLenum) = 0;
void (__stdcall *glResetMinmax)(GLenum) = 0;
void (__stdcall *glTexImage3D)(GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const GLvoid*) = 0;
void (__stdcall *glTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*) = 0;
void (__stdcall *glCopyTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei) = 0;

int CGLExtensionHandler::n_GetGL12FuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetGL12FuncPointers");

	int n_failed_functions = 0;

	if(!(glBlendColor = (void(__stdcall*)(GLclampf, GLclampf, GLclampf, GLclampf))wglGetProcAddress("glBlendColor"))) n_failed_functions ++;
	if(!(glBlendEquation = (void(__stdcall*)(GLenum))wglGetProcAddress("glBlendEquation"))) n_failed_functions ++;
	if(!(glDrawRangeElements = (void(__stdcall*)(GLenum, GLuint, GLuint, GLsizei, GLenum, const GLvoid*))wglGetProcAddress("glDrawRangeElements"))) n_failed_functions ++;
	if(!(glColorTable = (void(__stdcall*)(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glColorTable"))) n_failed_functions ++;
	if(!(glColorTableParameterfv = (void(__stdcall*)(GLenum, GLenum, const GLfloat*))wglGetProcAddress("glColorTableParameterfv"))) n_failed_functions ++;
	if(!(glColorTableParameteriv = (void(__stdcall*)(GLenum, GLenum, const GLint*))wglGetProcAddress("glColorTableParameteriv"))) n_failed_functions ++;
	if(!(glCopyColorTable = (void(__stdcall*)(GLenum, GLenum, GLint, GLint, GLsizei))wglGetProcAddress("glCopyColorTable"))) n_failed_functions ++;
	if(!(glGetColorTable = (void(__stdcall*)(GLenum, GLenum, GLenum, GLvoid*))wglGetProcAddress("glGetColorTable"))) n_failed_functions ++;
	if(!(glGetColorTableParameterfv = (void(__stdcall*)(GLenum, GLenum, GLfloat*))wglGetProcAddress("glGetColorTableParameterfv"))) n_failed_functions ++;
	if(!(glGetColorTableParameteriv = (void(__stdcall*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetColorTableParameteriv"))) n_failed_functions ++;
	if(!(glColorSubTable = (void(__stdcall*)(GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glColorSubTable"))) n_failed_functions ++;
	if(!(glCopyColorSubTable = (void(__stdcall*)(GLenum, GLsizei, GLint, GLint, GLsizei))wglGetProcAddress("glCopyColorSubTable"))) n_failed_functions ++;
	if(!(glConvolutionFilter1D = (void(__stdcall*)(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glConvolutionFilter1D"))) n_failed_functions ++;
	if(!(glConvolutionFilter2D = (void(__stdcall*)(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glConvolutionFilter2D"))) n_failed_functions ++;
	if(!(glConvolutionParameterf = (void(__stdcall*)(GLenum, GLenum, GLfloat))wglGetProcAddress("glConvolutionParameterf"))) n_failed_functions ++;
	if(!(glConvolutionParameterfv = (void(__stdcall*)(GLenum, GLenum, const GLfloat*))wglGetProcAddress("glConvolutionParameterfv"))) n_failed_functions ++;
	if(!(glConvolutionParameteri = (void(__stdcall*)(GLenum, GLenum, GLint))wglGetProcAddress("glConvolutionParameteri"))) n_failed_functions ++;
	if(!(glConvolutionParameteriv = (void(__stdcall*)(GLenum, GLenum, const GLint*))wglGetProcAddress("glConvolutionParameteriv"))) n_failed_functions ++;
	if(!(glCopyConvolutionFilter1D = (void(__stdcall*)(GLenum, GLenum, GLint, GLint, GLsizei))wglGetProcAddress("glCopyConvolutionFilter1D"))) n_failed_functions ++;
	if(!(glCopyConvolutionFilter2D = (void(__stdcall*)(GLenum, GLenum, GLint, GLint, GLsizei, GLsizei))wglGetProcAddress("glCopyConvolutionFilter2D"))) n_failed_functions ++;
	if(!(glGetConvolutionFilter = (void(__stdcall*)(GLenum, GLenum, GLenum, GLvoid*))wglGetProcAddress("glGetConvolutionFilter"))) n_failed_functions ++;
	if(!(glGetConvolutionParameterfv = (void(__stdcall*)(GLenum, GLenum, GLfloat*))wglGetProcAddress("glGetConvolutionParameterfv"))) n_failed_functions ++;
	if(!(glGetConvolutionParameteriv = (void(__stdcall*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetConvolutionParameteriv"))) n_failed_functions ++;
	if(!(glGetSeparableFilter = (void(__stdcall*)(GLenum, GLenum, GLenum, GLvoid *, GLvoid *, GLvoid*))wglGetProcAddress("glGetSeparableFilter"))) n_failed_functions ++;
	if(!(glSeparableFilter2D = (void(__stdcall*)(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *, const GLvoid*))wglGetProcAddress("glSeparableFilter2D"))) n_failed_functions ++;
	if(!(glGetHistogram = (void(__stdcall*)(GLenum, GLboolean, GLenum, GLenum, GLvoid*))wglGetProcAddress("glGetHistogram"))) n_failed_functions ++;
	if(!(glGetHistogramParameterfv = (void(__stdcall*)(GLenum, GLenum, GLfloat*))wglGetProcAddress("glGetHistogramParameterfv"))) n_failed_functions ++;
	if(!(glGetHistogramParameteriv = (void(__stdcall*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetHistogramParameteriv"))) n_failed_functions ++;
	if(!(glGetMinmax = (void(__stdcall*)(GLenum, GLboolean, GLenum, GLenum, GLvoid*))wglGetProcAddress("glGetMinmax"))) n_failed_functions ++;
	if(!(glGetMinmaxParameterfv = (void(__stdcall*)(GLenum, GLenum, GLfloat*))wglGetProcAddress("glGetMinmaxParameterfv"))) n_failed_functions ++;
	if(!(glGetMinmaxParameteriv = (void(__stdcall*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetMinmaxParameteriv"))) n_failed_functions ++;
	if(!(glHistogram = (void(__stdcall*)(GLenum, GLsizei, GLenum, GLboolean))wglGetProcAddress("glHistogram"))) n_failed_functions ++;
	if(!(glMinmax = (void(__stdcall*)(GLenum, GLenum, GLboolean))wglGetProcAddress("glMinmax"))) n_failed_functions ++;
	if(!(glResetHistogram = (void(__stdcall*)(GLenum))wglGetProcAddress("glResetHistogram"))) n_failed_functions ++;
	if(!(glResetMinmax = (void(__stdcall*)(GLenum))wglGetProcAddress("glResetMinmax"))) n_failed_functions ++;
	if(!(glTexImage3D = (void(__stdcall*)(GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glTexImage3D"))) n_failed_functions ++;
	if(!(glTexSubImage3D = (void(__stdcall*)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*))wglGetProcAddress("glTexSubImage3D"))) n_failed_functions ++;
	if(!(glCopyTexSubImage3D = (void(__stdcall*)(GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei))wglGetProcAddress("glCopyTexSubImage3D"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- opengl 1.3 core func pointers ---
 */

void (__stdcall *glLoadTransposeMatrixf)(const GLfloat*) = 0;
void (__stdcall *glLoadTransposeMatrixd)(const GLdouble*) = 0;
void (__stdcall *glMultTransposeMatrixf)(const GLfloat*) = 0;
void (__stdcall *glMultTransposeMatrixd)(const GLdouble*) = 0;
void (__stdcall *glSampleCoverage)(GLclampf, GLboolean) = 0;
void (__stdcall *glCompressedTexImage3D)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*) = 0;
void (__stdcall *glCompressedTexImage2D)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*) = 0;
void (__stdcall *glCompressedTexImage1D)(GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const GLvoid*) = 0;
void (__stdcall *glCompressedTexSubImage3D)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*) = 0;
void (__stdcall *glCompressedTexSubImage2D)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*) = 0;
void (__stdcall *glCompressedTexSubImage1D)(GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const GLvoid*) = 0;
void (__stdcall *glGetCompressedTexImage)(GLenum, GLint, GLvoid*) = 0;

int CGLExtensionHandler::n_GetGL13FuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetGL13FuncPointers");

	int n_failed_functions = 0;

	if(!(glLoadTransposeMatrixf = (void(__stdcall*)(const GLfloat*))wglGetProcAddress("glLoadTransposeMatrixf"))) n_failed_functions ++;
	if(!(glLoadTransposeMatrixd = (void(__stdcall*)(const GLdouble*))wglGetProcAddress("glLoadTransposeMatrixd"))) n_failed_functions ++;
	if(!(glMultTransposeMatrixf = (void(__stdcall*)(const GLfloat*))wglGetProcAddress("glMultTransposeMatrixf"))) n_failed_functions ++;
	if(!(glMultTransposeMatrixd = (void(__stdcall*)(const GLdouble*))wglGetProcAddress("glMultTransposeMatrixd"))) n_failed_functions ++;
	if(!(glSampleCoverage = (void(__stdcall*)(GLclampf, GLboolean))wglGetProcAddress("glSampleCoverage"))) n_failed_functions ++;
	if(!(glCompressedTexImage3D = (void(__stdcall*)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexImage3D"))) n_failed_functions ++;
	if(!(glCompressedTexImage2D = (void(__stdcall*)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexImage2D"))) n_failed_functions ++;
	if(!(glCompressedTexImage1D = (void(__stdcall*)(GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexImage1D"))) n_failed_functions ++;
	if(!(glCompressedTexSubImage3D = (void(__stdcall*)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexSubImage3D"))) n_failed_functions ++;
	if(!(glCompressedTexSubImage2D = (void(__stdcall*)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexSubImage2D"))) n_failed_functions ++;
	if(!(glCompressedTexSubImage1D = (void(__stdcall*)(GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexSubImage1D"))) n_failed_functions ++;
	if(!(glGetCompressedTexImage = (void(__stdcall*)(GLenum, GLint, GLvoid*))wglGetProcAddress("glGetCompressedTexImage"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- Multitexture func pointers ---
 */

void (__stdcall *glActiveTexture)(GLenum) = 0;
void (__stdcall *glClientActiveTexture)(GLenum) = 0;
void (__stdcall *glMultiTexCoord1d)(GLenum, GLdouble) = 0;
void (__stdcall *glMultiTexCoord1dv)(GLenum, const GLdouble*) = 0;
void (__stdcall *glMultiTexCoord1f)(GLenum, GLfloat) = 0;
void (__stdcall *glMultiTexCoord1fv)(GLenum, const GLfloat*) = 0;
void (__stdcall *glMultiTexCoord1i)(GLenum, GLint) = 0;
void (__stdcall *glMultiTexCoord1iv)(GLenum, const GLint *) = 0;
void (__stdcall *glMultiTexCoord1s)(GLenum, GLshort) = 0;
void (__stdcall *glMultiTexCoord1sv)(GLenum, const GLshort*) = 0;
void (__stdcall *glMultiTexCoord2d)(GLenum, GLdouble, GLdouble) = 0;
void (__stdcall *glMultiTexCoord2dv)(GLenum, const GLdouble*) = 0;
void (__stdcall *glMultiTexCoord2f)(GLenum, GLfloat, GLfloat) = 0;
void (__stdcall *glMultiTexCoord2fv)(GLenum, const GLfloat*) = 0;
void (__stdcall *glMultiTexCoord2i)(GLenum, GLint, GLint) = 0;
void (__stdcall *glMultiTexCoord2iv)(GLenum, const GLint*) = 0;
void (__stdcall *glMultiTexCoord2s)(GLenum, GLshort, GLshort) = 0;
void (__stdcall *glMultiTexCoord2sv)(GLenum, const GLshort*) = 0;
void (__stdcall *glMultiTexCoord3d)(GLenum, GLdouble, GLdouble, GLdouble) = 0;
void (__stdcall *glMultiTexCoord3dv)(GLenum, const GLdouble*) = 0;
void (__stdcall *glMultiTexCoord3f)(GLenum, GLfloat, GLfloat, GLfloat) = 0;
void (__stdcall *glMultiTexCoord3fv)(GLenum, const GLfloat*) = 0;
void (__stdcall *glMultiTexCoord3i)(GLenum, GLint, GLint, GLint) = 0;
void (__stdcall *glMultiTexCoord3iv)(GLenum, const GLint*) = 0;
void (__stdcall *glMultiTexCoord3s)(GLenum, GLshort, GLshort, GLshort) = 0;
void (__stdcall *glMultiTexCoord3sv)(GLenum, const GLshort*) = 0;
void (__stdcall *glMultiTexCoord4d)(GLenum, GLdouble, GLdouble, GLdouble, GLdouble) = 0;
void (__stdcall *glMultiTexCoord4dv)(GLenum, const GLdouble*) = 0;
void (__stdcall *glMultiTexCoord4f)(GLenum, GLfloat, GLfloat, GLfloat, GLfloat) = 0;
void (__stdcall *glMultiTexCoord4fv)(GLenum, const GLfloat*) = 0;
void (__stdcall *glMultiTexCoord4i)(GLenum, GLint, GLint, GLint, GLint) = 0;
void (__stdcall *glMultiTexCoord4iv)(GLenum, const GLint*) = 0;
void (__stdcall *glMultiTexCoord4s)(GLenum, GLshort, GLshort, GLshort, GLshort) = 0;
void (__stdcall *glMultiTexCoord4sv)(GLenum, const GLshort*) = 0;

int CGLExtensionHandler::n_GetMultitextureFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetMultitextureFuncPointers");

	int n_failed_functions = 0;

	if(!(glActiveTexture = (void(__stdcall*)(GLenum))wglGetProcAddress("glActiveTexture"))) n_failed_functions ++;
	if(!(glClientActiveTexture = (void(__stdcall*)(GLenum))wglGetProcAddress("glClientActiveTexture"))) n_failed_functions ++;
	if(!(glMultiTexCoord1d = (void(__stdcall*)(GLenum, GLdouble))wglGetProcAddress("glMultiTexCoord1d"))) n_failed_functions ++;
	if(!(glMultiTexCoord1dv = (void(__stdcall*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord1dv"))) n_failed_functions ++;
	if(!(glMultiTexCoord1f = (void(__stdcall*)(GLenum, GLfloat))wglGetProcAddress("glMultiTexCoord1f"))) n_failed_functions ++;
	if(!(glMultiTexCoord1fv = (void(__stdcall*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord1fv"))) n_failed_functions ++;
	if(!(glMultiTexCoord1i = (void(__stdcall*)(GLenum, GLint))wglGetProcAddress("glMultiTexCoord1i"))) n_failed_functions ++;
	if(!(glMultiTexCoord1iv = (void(__stdcall*)(GLenum, const GLint *))wglGetProcAddress("glMultiTexCoord1iv"))) n_failed_functions ++;
	if(!(glMultiTexCoord1s = (void(__stdcall*)(GLenum, GLshort))wglGetProcAddress("glMultiTexCoord1s"))) n_failed_functions ++;
	if(!(glMultiTexCoord1sv = (void(__stdcall*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord1sv"))) n_failed_functions ++;
	if(!(glMultiTexCoord2d = (void(__stdcall*)(GLenum, GLdouble, GLdouble))wglGetProcAddress("glMultiTexCoord2d"))) n_failed_functions ++;
	if(!(glMultiTexCoord2dv = (void(__stdcall*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord2dv"))) n_failed_functions ++;
	if(!(glMultiTexCoord2f = (void(__stdcall*)(GLenum, GLfloat, GLfloat))wglGetProcAddress("glMultiTexCoord2f"))) n_failed_functions ++;
	if(!(glMultiTexCoord2fv = (void(__stdcall*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord2fv"))) n_failed_functions ++;
	if(!(glMultiTexCoord2i = (void(__stdcall*)(GLenum, GLint, GLint))wglGetProcAddress("glMultiTexCoord2i"))) n_failed_functions ++;
	if(!(glMultiTexCoord2iv = (void(__stdcall*)(GLenum, const GLint*))wglGetProcAddress("glMultiTexCoord2iv"))) n_failed_functions ++;
	if(!(glMultiTexCoord2s = (void(__stdcall*)(GLenum, GLshort, GLshort))wglGetProcAddress("glMultiTexCoord2s"))) n_failed_functions ++;
	if(!(glMultiTexCoord2sv = (void(__stdcall*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord2sv"))) n_failed_functions ++;
	if(!(glMultiTexCoord3d = (void(__stdcall*)(GLenum, GLdouble, GLdouble, GLdouble))wglGetProcAddress("glMultiTexCoord3d"))) n_failed_functions ++;
	if(!(glMultiTexCoord3dv = (void(__stdcall*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord3dv"))) n_failed_functions ++;
	if(!(glMultiTexCoord3f = (void(__stdcall*)(GLenum, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glMultiTexCoord3f"))) n_failed_functions ++;
	if(!(glMultiTexCoord3fv = (void(__stdcall*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord3fv"))) n_failed_functions ++;
	if(!(glMultiTexCoord3i = (void(__stdcall*)(GLenum, GLint, GLint, GLint))wglGetProcAddress("glMultiTexCoord3i"))) n_failed_functions ++;
	if(!(glMultiTexCoord3iv = (void(__stdcall*)(GLenum, const GLint*))wglGetProcAddress("glMultiTexCoord3iv"))) n_failed_functions ++;
	if(!(glMultiTexCoord3s = (void(__stdcall*)(GLenum, GLshort, GLshort, GLshort))wglGetProcAddress("glMultiTexCoord3s"))) n_failed_functions ++;
	if(!(glMultiTexCoord3sv = (void(__stdcall*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord3sv"))) n_failed_functions ++;
	if(!(glMultiTexCoord4d = (void(__stdcall*)(GLenum, GLdouble, GLdouble, GLdouble, GLdouble))wglGetProcAddress("glMultiTexCoord4d"))) n_failed_functions ++;
	if(!(glMultiTexCoord4dv = (void(__stdcall*)(GLenum, const GLdouble*))wglGetProcAddress("glMultiTexCoord4dv"))) n_failed_functions ++;
	if(!(glMultiTexCoord4f = (void(__stdcall*)(GLenum, GLfloat, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glMultiTexCoord4f"))) n_failed_functions ++;
	if(!(glMultiTexCoord4fv = (void(__stdcall*)(GLenum, const GLfloat*))wglGetProcAddress("glMultiTexCoord4fv"))) n_failed_functions ++;
	if(!(glMultiTexCoord4i = (void(__stdcall*)(GLenum, GLint, GLint, GLint, GLint))wglGetProcAddress("glMultiTexCoord4i"))) n_failed_functions ++;
	if(!(glMultiTexCoord4iv = (void(__stdcall*)(GLenum, const GLint*))wglGetProcAddress("glMultiTexCoord4iv"))) n_failed_functions ++;
	if(!(glMultiTexCoord4s = (void(__stdcall*)(GLenum, GLshort, GLshort, GLshort, GLshort))wglGetProcAddress("glMultiTexCoord4s"))) n_failed_functions ++;
	if(!(glMultiTexCoord4sv = (void(__stdcall*)(GLenum, const GLshort*))wglGetProcAddress("glMultiTexCoord4sv"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- opengl 1.4 core func pointers ---
 */

void (__stdcall *glBlendFuncSeparate)(GLenum, GLenum, GLenum, GLenum) = 0;
void (__stdcall *glFogCoordf)(GLfloat) = 0;
void (__stdcall *glFogCoordfv)(const GLfloat*) = 0;
void (__stdcall *glFogCoordd)(GLdouble) = 0;
void (__stdcall *glFogCoorddv)(const GLdouble*) = 0;
void (__stdcall *glFogCoordPointer)(GLenum, GLsizei, const GLvoid*) = 0;
void (__stdcall *glMultiDrawArrays)(GLenum, GLint *, GLsizei *, GLsizei) = 0;
void (__stdcall *glMultiDrawElements)(GLenum, const GLsizei *, GLenum, const GLvoid* *, GLsizei) = 0;
void (__stdcall *glPointParameterf)(GLenum, GLfloat) = 0;
void (__stdcall *glPointParameterfv)(GLenum, const GLfloat*) = 0;
void (__stdcall *glPointParameteri)(GLenum, GLint) = 0;
void (__stdcall *glPointParameteriv)(GLenum, const GLint*) = 0;
void (__stdcall *glSecondaryColor3b)(GLbyte, GLbyte, GLbyte) = 0;
void (__stdcall *glSecondaryColor3bv)(const GLbyte*) = 0;
void (__stdcall *glSecondaryColor3d)(GLdouble, GLdouble, GLdouble) = 0;
void (__stdcall *glSecondaryColor3dv)(const GLdouble*) = 0;
void (__stdcall *glSecondaryColor3f)(GLfloat, GLfloat, GLfloat) = 0;
void (__stdcall *glSecondaryColor3fv)(const GLfloat*) = 0;
void (__stdcall *glSecondaryColor3i)(GLint, GLint, GLint) = 0;
void (__stdcall *glSecondaryColor3iv)(const GLint*) = 0;
void (__stdcall *glSecondaryColor3s)(GLshort, GLshort, GLshort) = 0;
void (__stdcall *glSecondaryColor3sv)(const GLshort*) = 0;
void (__stdcall *glSecondaryColor3ub)(GLubyte, GLubyte, GLubyte) = 0;
void (__stdcall *glSecondaryColor3ubv)(const GLubyte*) = 0;
void (__stdcall *glSecondaryColor3ui)(GLuint, GLuint, GLuint) = 0;
void (__stdcall *glSecondaryColor3uiv)(const GLuint*) = 0;
void (__stdcall *glSecondaryColor3us)(GLushort, GLushort, GLushort) = 0;
void (__stdcall *glSecondaryColor3usv)(const GLushort*) = 0;
void (__stdcall *glSecondaryColorPointer)(GLint, GLenum, GLsizei, const GLvoid*) = 0;
void (__stdcall *glWindowPos2d)(GLdouble, GLdouble) = 0;
void (__stdcall *glWindowPos2dv)(const GLdouble*) = 0;
void (__stdcall *glWindowPos2f)(GLfloat, GLfloat) = 0;
void (__stdcall *glWindowPos2fv)(const GLfloat*) = 0;
void (__stdcall *glWindowPos2i)(GLint, GLint) = 0;
void (__stdcall *glWindowPos2iv)(const GLint*) = 0;
void (__stdcall *glWindowPos2s)(GLshort, GLshort) = 0;
void (__stdcall *glWindowPos2sv)(const GLshort*) = 0;
void (__stdcall *glWindowPos3d)(GLdouble, GLdouble, GLdouble) = 0;
void (__stdcall *glWindowPos3dv)(const GLdouble*) = 0;
void (__stdcall *glWindowPos3f)(GLfloat, GLfloat, GLfloat) = 0;
void (__stdcall *glWindowPos3fv)(const GLfloat*) = 0;
void (__stdcall *glWindowPos3i)(GLint, GLint, GLint) = 0;
void (__stdcall *glWindowPos3iv)(const GLint*) = 0;
void (__stdcall *glWindowPos3s)(GLshort, GLshort, GLshort) = 0;
void (__stdcall *glWindowPos3sv)(const GLshort*) = 0;

int CGLExtensionHandler::n_GetGL14FuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetGL14FuncPointers");

	int n_failed_functions = 0;

	if(!(glBlendFuncSeparate = (void(__stdcall*)(GLenum, GLenum, GLenum, GLenum))wglGetProcAddress("glBlendFuncSeparate"))) n_failed_functions ++;
	if(!(glFogCoordf = (void(__stdcall*)(GLfloat))wglGetProcAddress("glFogCoordf"))) n_failed_functions ++;
	if(!(glFogCoordfv = (void(__stdcall*)(const GLfloat*))wglGetProcAddress("glFogCoordfv"))) n_failed_functions ++;
	if(!(glFogCoordd = (void(__stdcall*)(GLdouble))wglGetProcAddress("glFogCoordd"))) n_failed_functions ++;
	if(!(glFogCoorddv = (void(__stdcall*)(const GLdouble*))wglGetProcAddress("glFogCoorddv"))) n_failed_functions ++;
	if(!(glFogCoordPointer = (void(__stdcall*)(GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glFogCoordPointer"))) n_failed_functions ++;
	if(!(glMultiDrawArrays = (void(__stdcall*)(GLenum, GLint *, GLsizei *, GLsizei))wglGetProcAddress("glMultiDrawArrays"))) n_failed_functions ++;
	if(!(glMultiDrawElements = (void(__stdcall*)(GLenum, const GLsizei *, GLenum, const GLvoid* *, GLsizei))wglGetProcAddress("glMultiDrawElements"))) n_failed_functions ++;
	if(!(glPointParameterf = (void(__stdcall*)(GLenum, GLfloat))wglGetProcAddress("glPointParameterf"))) n_failed_functions ++;
	if(!(glPointParameterfv = (void(__stdcall*)(GLenum, const GLfloat*))wglGetProcAddress("glPointParameterfv"))) n_failed_functions ++;
	if(!(glPointParameteri = (void(__stdcall*)(GLenum, GLint))wglGetProcAddress("glPointParameteri"))) n_failed_functions ++;
	if(!(glPointParameteriv = (void(__stdcall*)(GLenum, const GLint*))wglGetProcAddress("glPointParameteriv"))) n_failed_functions ++;
	if(!(glSecondaryColor3b = (void(__stdcall*)(GLbyte, GLbyte, GLbyte))wglGetProcAddress("glSecondaryColor3b"))) n_failed_functions ++;
	if(!(glSecondaryColor3bv = (void(__stdcall*)(const GLbyte*))wglGetProcAddress("glSecondaryColor3bv"))) n_failed_functions ++;
	if(!(glSecondaryColor3d = (void(__stdcall*)(GLdouble, GLdouble, GLdouble))wglGetProcAddress("glSecondaryColor3d"))) n_failed_functions ++;
	if(!(glSecondaryColor3dv = (void(__stdcall*)(const GLdouble*))wglGetProcAddress("glSecondaryColor3dv"))) n_failed_functions ++;
	if(!(glSecondaryColor3f = (void(__stdcall*)(GLfloat, GLfloat, GLfloat))wglGetProcAddress("glSecondaryColor3f"))) n_failed_functions ++;
	if(!(glSecondaryColor3fv = (void(__stdcall*)(const GLfloat*))wglGetProcAddress("glSecondaryColor3fv"))) n_failed_functions ++;
	if(!(glSecondaryColor3i = (void(__stdcall*)(GLint, GLint, GLint))wglGetProcAddress("glSecondaryColor3i"))) n_failed_functions ++;
	if(!(glSecondaryColor3iv = (void(__stdcall*)(const GLint*))wglGetProcAddress("glSecondaryColor3iv"))) n_failed_functions ++;
	if(!(glSecondaryColor3s = (void(__stdcall*)(GLshort, GLshort, GLshort))wglGetProcAddress("glSecondaryColor3s"))) n_failed_functions ++;
	if(!(glSecondaryColor3sv = (void(__stdcall*)(const GLshort*))wglGetProcAddress("glSecondaryColor3sv"))) n_failed_functions ++;
	if(!(glSecondaryColor3ub = (void(__stdcall*)(GLubyte, GLubyte, GLubyte))wglGetProcAddress("glSecondaryColor3ub"))) n_failed_functions ++;
	if(!(glSecondaryColor3ubv = (void(__stdcall*)(const GLubyte*))wglGetProcAddress("glSecondaryColor3ubv"))) n_failed_functions ++;
	if(!(glSecondaryColor3ui = (void(__stdcall*)(GLuint, GLuint, GLuint))wglGetProcAddress("glSecondaryColor3ui"))) n_failed_functions ++;
	if(!(glSecondaryColor3uiv = (void(__stdcall*)(const GLuint*))wglGetProcAddress("glSecondaryColor3uiv"))) n_failed_functions ++;
	if(!(glSecondaryColor3us = (void(__stdcall*)(GLushort, GLushort, GLushort))wglGetProcAddress("glSecondaryColor3us"))) n_failed_functions ++;
	if(!(glSecondaryColor3usv = (void(__stdcall*)(const GLushort*))wglGetProcAddress("glSecondaryColor3usv"))) n_failed_functions ++;
	if(!(glSecondaryColorPointer = (void(__stdcall*)(GLint, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glSecondaryColorPointer"))) n_failed_functions ++;
	if(!(glWindowPos2d = (void(__stdcall*)(GLdouble, GLdouble))wglGetProcAddress("glWindowPos2d"))) n_failed_functions ++;
	if(!(glWindowPos2dv = (void(__stdcall*)(const GLdouble*))wglGetProcAddress("glWindowPos2dv"))) n_failed_functions ++;
	if(!(glWindowPos2f = (void(__stdcall*)(GLfloat, GLfloat))wglGetProcAddress("glWindowPos2f"))) n_failed_functions ++;
	if(!(glWindowPos2fv = (void(__stdcall*)(const GLfloat*))wglGetProcAddress("glWindowPos2fv"))) n_failed_functions ++;
	if(!(glWindowPos2i = (void(__stdcall*)(GLint, GLint))wglGetProcAddress("glWindowPos2i"))) n_failed_functions ++;
	if(!(glWindowPos2iv = (void(__stdcall*)(const GLint*))wglGetProcAddress("glWindowPos2iv"))) n_failed_functions ++;
	if(!(glWindowPos2s = (void(__stdcall*)(GLshort, GLshort))wglGetProcAddress("glWindowPos2s"))) n_failed_functions ++;
	if(!(glWindowPos2sv = (void(__stdcall*)(const GLshort*))wglGetProcAddress("glWindowPos2sv"))) n_failed_functions ++;
	if(!(glWindowPos3d = (void(__stdcall*)(GLdouble, GLdouble, GLdouble))wglGetProcAddress("glWindowPos3d"))) n_failed_functions ++;
	if(!(glWindowPos3dv = (void(__stdcall*)(const GLdouble*))wglGetProcAddress("glWindowPos3dv"))) n_failed_functions ++;
	if(!(glWindowPos3f = (void(__stdcall*)(GLfloat, GLfloat, GLfloat))wglGetProcAddress("glWindowPos3f"))) n_failed_functions ++;
	if(!(glWindowPos3fv = (void(__stdcall*)(const GLfloat*))wglGetProcAddress("glWindowPos3fv"))) n_failed_functions ++;
	if(!(glWindowPos3i = (void(__stdcall*)(GLint, GLint, GLint))wglGetProcAddress("glWindowPos3i"))) n_failed_functions ++;
	if(!(glWindowPos3iv = (void(__stdcall*)(const GLint*))wglGetProcAddress("glWindowPos3iv"))) n_failed_functions ++;
	if(!(glWindowPos3s = (void(__stdcall*)(GLshort, GLshort, GLshort))wglGetProcAddress("glWindowPos3s"))) n_failed_functions ++;
	if(!(glWindowPos3sv = (void(__stdcall*)(const GLshort*))wglGetProcAddress("glWindowPos3sv"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- opengl 1.5 core func pointers ---
 */

void (__stdcall *glGenQueries)(GLsizei, GLuint*) = 0;
void (__stdcall *glDeleteQueries)(GLsizei, const GLuint*) = 0;
GLboolean (__stdcall *glIsQuery)(GLuint) = 0;
void (__stdcall *glBeginQuery)(GLenum, GLuint) = 0;
void (__stdcall *glEndQuery)(GLenum) = 0;
void (__stdcall *glGetQueryiv)(GLenum, GLenum, GLint*) = 0;
void (__stdcall *glGetQueryObjectiv)(GLuint, GLenum, GLint*) = 0;
void (__stdcall *glGetQueryObjectuiv)(GLuint, GLenum, GLuint*) = 0;
void (__stdcall *glBindBuffer)(GLenum, GLuint) = 0;
void (__stdcall *glDeleteBuffers)(GLsizei, const GLuint*) = 0;
void (__stdcall *glGenBuffers)(GLsizei, GLuint*) = 0;
GLboolean (__stdcall *glIsBuffer)(GLuint) = 0;
void (__stdcall *glBufferData)(GLenum, GLsizeiptr, const GLvoid *, GLenum) = 0;
void (__stdcall *glBufferSubData)(GLenum, GLintptr, GLsizeiptr, const GLvoid*) = 0;
void (__stdcall *glGetBufferSubData)(GLenum, GLintptr, GLsizeiptr, GLvoid*) = 0;
GLvoid* (__stdcall *glMapBuffer)(GLenum, GLenum) = 0;
GLboolean (__stdcall *glUnmapBuffer)(GLenum) = 0;
void (__stdcall *glGetBufferParameteriv)(GLenum, GLenum, GLint*) = 0;
void (__stdcall *glGetBufferPointerv)(GLenum, GLenum, GLvoid**) = 0;

int CGLExtensionHandler::n_GetGL15FuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetGL15FuncPointers");

	int n_failed_functions = 0;

	if(!(glGenQueries = (void(__stdcall*)(GLsizei, GLuint*))wglGetProcAddress("glGenQueries"))) n_failed_functions ++;
	if(!(glDeleteQueries = (void(__stdcall*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteQueries"))) n_failed_functions ++;
	if(!(glIsQuery = (GLboolean(__stdcall*)(GLuint))wglGetProcAddress("glIsQuery"))) n_failed_functions ++;
	if(!(glBeginQuery = (void(__stdcall*)(GLenum, GLuint))wglGetProcAddress("glBeginQuery"))) n_failed_functions ++;
	if(!(glEndQuery = (void(__stdcall*)(GLenum))wglGetProcAddress("glEndQuery"))) n_failed_functions ++;
	if(!(glGetQueryiv = (void(__stdcall*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetQueryiv"))) n_failed_functions ++;
	if(!(glGetQueryObjectiv = (void(__stdcall*)(GLuint, GLenum, GLint*))wglGetProcAddress("glGetQueryObjectiv"))) n_failed_functions ++;
	if(!(glGetQueryObjectuiv = (void(__stdcall*)(GLuint, GLenum, GLuint*))wglGetProcAddress("glGetQueryObjectuiv"))) n_failed_functions ++;
	if(!(glBindBuffer = (void(__stdcall*)(GLenum, GLuint))wglGetProcAddress("glBindBuffer"))) n_failed_functions ++;
	if(!(glDeleteBuffers = (void(__stdcall*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteBuffers"))) n_failed_functions ++;
	if(!(glGenBuffers = (void(__stdcall*)(GLsizei, GLuint*))wglGetProcAddress("glGenBuffers"))) n_failed_functions ++;
	if(!(glIsBuffer = (GLboolean(__stdcall*)(GLuint))wglGetProcAddress("glIsBuffer"))) n_failed_functions ++;
	if(!(glBufferData = (void(__stdcall*)(GLenum, GLsizeiptr, const GLvoid *, GLenum))wglGetProcAddress("glBufferData"))) n_failed_functions ++;
	if(!(glBufferSubData = (void(__stdcall*)(GLenum, GLintptr, GLsizeiptr, const GLvoid*))wglGetProcAddress("glBufferSubData"))) n_failed_functions ++;
	if(!(glGetBufferSubData = (void(__stdcall*)(GLenum, GLintptr, GLsizeiptr, GLvoid*))wglGetProcAddress("glGetBufferSubData"))) n_failed_functions ++;
	if(!(glMapBuffer = (GLvoid*(__stdcall*)(GLenum, GLenum))wglGetProcAddress("glMapBuffer"))) n_failed_functions ++;
	if(!(glUnmapBuffer = (GLboolean(__stdcall*)(GLenum))wglGetProcAddress("glUnmapBuffer"))) n_failed_functions ++;
	if(!(glGetBufferParameteriv = (void(__stdcall*)(GLenum, GLenum, GLint*))wglGetProcAddress("glGetBufferParameteriv"))) n_failed_functions ++;
	if(!(glGetBufferPointerv = (void(__stdcall*)(GLenum, GLenum, GLvoid**))wglGetProcAddress("glGetBufferPointerv"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- compressed texture arb func pointers ---
 */

void (__stdcall *glCompressedTexImage3DARB)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*) = 0;
void (__stdcall *glCompressedTexImage2DARB)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*) = 0;
void (__stdcall *glCompressedTexImage1DARB)(GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const GLvoid*) = 0;
void (__stdcall *glCompressedTexSubImage3DARB)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*) = 0;
void (__stdcall *glCompressedTexSubImage2DARB)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*) = 0;
void (__stdcall *glCompressedTexSubImage1DARB)(GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const GLvoid*) = 0;
void (__stdcall *glGetCompressedTexImageARB)(GLenum, GLint, GLvoid*) = 0;

int CGLExtensionHandler::n_GetCompressedTextureARBFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetCompressedTextureARBFuncPointers");

	int n_failed_functions = 0;

	if(!(glCompressedTexImage3DARB = (void(__stdcall*)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexImage3DARB"))) n_failed_functions ++;
	if(!(glCompressedTexImage2DARB = (void(__stdcall*)(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexImage2DARB"))) n_failed_functions ++;
	if(!(glCompressedTexImage1DARB = (void(__stdcall*)(GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexImage1DARB"))) n_failed_functions ++;
	if(!(glCompressedTexSubImage3DARB = (void(__stdcall*)(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexSubImage3DARB"))) n_failed_functions ++;
	if(!(glCompressedTexSubImage2DARB = (void(__stdcall*)(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexSubImage2DARB"))) n_failed_functions ++;
	if(!(glCompressedTexSubImage1DARB = (void(__stdcall*)(GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glCompressedTexSubImage1DARB"))) n_failed_functions ++;
	if(!(glGetCompressedTexImageARB = (void(__stdcall*)(GLenum, GLint, GLvoid*))wglGetProcAddress("glGetCompressedTexImageARB"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- vertex blend arb func pointers ---
 */

void (__stdcall *glWeightbvARB)(GLint, const GLbyte*) = 0;
void (__stdcall *glWeightsvARB)(GLint, const GLshort*) = 0;
void (__stdcall *glWeightivARB)(GLint, const GLint*) = 0;
void (__stdcall *glWeightfvARB)(GLint, const GLfloat*) = 0;
void (__stdcall *glWeightdvARB)(GLint, const GLdouble*) = 0;
void (__stdcall *glWeightubvARB)(GLint, const GLubyte*) = 0;
void (__stdcall *glWeightusvARB)(GLint, const GLushort*) = 0;
void (__stdcall *glWeightuivARB)(GLint, const GLuint*) = 0;
void (__stdcall *glWeightPointerARB)(GLint, GLenum, GLsizei, const GLvoid*) = 0;
void (__stdcall *glVertexBlendARB)(GLint) = 0;

int CGLExtensionHandler::n_GetVertexBlendARBFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetVertexBlendARBFuncPointers");

	int n_failed_functions = 0;

	if(!(glWeightbvARB = (void(__stdcall*)(GLint, const GLbyte*))wglGetProcAddress("glWeightbvARB"))) n_failed_functions ++;
	if(!(glWeightsvARB = (void(__stdcall*)(GLint, const GLshort*))wglGetProcAddress("glWeightsvARB"))) n_failed_functions ++;
	if(!(glWeightivARB = (void(__stdcall*)(GLint, const GLint*))wglGetProcAddress("glWeightivARB"))) n_failed_functions ++;
	if(!(glWeightfvARB = (void(__stdcall*)(GLint, const GLfloat*))wglGetProcAddress("glWeightfvARB"))) n_failed_functions ++;
	if(!(glWeightdvARB = (void(__stdcall*)(GLint, const GLdouble*))wglGetProcAddress("glWeightdvARB"))) n_failed_functions ++;
	if(!(glWeightubvARB = (void(__stdcall*)(GLint, const GLubyte*))wglGetProcAddress("glWeightubvARB"))) n_failed_functions ++;
	if(!(glWeightusvARB = (void(__stdcall*)(GLint, const GLushort*))wglGetProcAddress("glWeightusvARB"))) n_failed_functions ++;
	if(!(glWeightuivARB = (void(__stdcall*)(GLint, const GLuint*))wglGetProcAddress("glWeightuivARB"))) n_failed_functions ++;
	if(!(glWeightPointerARB = (void(__stdcall*)(GLint, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glWeightPointerARB"))) n_failed_functions ++;
	if(!(glVertexBlendARB = (void(__stdcall*)(GLint))wglGetProcAddress("glVertexBlendARB"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- matrix palette arb func pointers ---
 */

void (__stdcall *glCurrentPaletteMatrixARB)(GLint) = 0;
void (__stdcall *glMatrixIndexubvARB)(GLint, const GLubyte*) = 0;
void (__stdcall *glMatrixIndexusvARB)(GLint, const GLushort*) = 0;
void (__stdcall *glMatrixIndexuivARB)(GLint, const GLuint*) = 0;
void (__stdcall *glMatrixIndexPointerARB)(GLint, GLenum, GLsizei, const GLvoid*) = 0;

int CGLExtensionHandler::n_GetMatrixPaletteARBFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetMatrixPaletteARBFuncPointers");

	int n_failed_functions = 0;

	if(!(glCurrentPaletteMatrixARB = (void(__stdcall*)(GLint))wglGetProcAddress("glCurrentPaletteMatrixARB"))) n_failed_functions ++;
	if(!(glMatrixIndexubvARB = (void(__stdcall*)(GLint, const GLubyte*))wglGetProcAddress("glMatrixIndexubvARB"))) n_failed_functions ++;
	if(!(glMatrixIndexusvARB = (void(__stdcall*)(GLint, const GLushort*))wglGetProcAddress("glMatrixIndexusvARB"))) n_failed_functions ++;
	if(!(glMatrixIndexuivARB = (void(__stdcall*)(GLint, const GLuint*))wglGetProcAddress("glMatrixIndexuivARB"))) n_failed_functions ++;
	if(!(glMatrixIndexPointerARB = (void(__stdcall*)(GLint, GLenum, GLsizei, const GLvoid*))wglGetProcAddress("glMatrixIndexPointerARB"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- ext framebuffer object func pointers ---
 */

GLboolean (__stdcall *glIsRenderbufferEXT)(GLuint renderbuffer) = 0;
void (__stdcall *glBindRenderbufferEXT)(GLenum target, GLuint renderbuffer) = 0;
void (__stdcall *glDeleteRenderbuffersEXT)(GLsizei n, const GLuint *renderbuffers) = 0;
void (__stdcall *glGenRenderbuffersEXT)(GLsizei n, GLuint *renderbuffers) = 0;
void (__stdcall *glRenderbufferStorageEXT)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height) = 0;
void (__stdcall *glGetRenderbufferParameterivEXT)(GLenum target, GLenum pname, GLint* params) = 0;
GLboolean (__stdcall *glIsFramebufferEXT)(GLuint framebuffer) = 0;
void (__stdcall *glBindFramebufferEXT)(GLenum target, GLuint framebuffer) = 0;
void (__stdcall *glDeleteFramebuffersEXT)(GLsizei n, const GLuint *framebuffers) = 0;
void (__stdcall *glGenFramebuffersEXT)(GLsizei n, GLuint *framebuffers) = 0;
GLenum (__stdcall *glCheckFramebufferStatusEXT)(GLenum target) = 0;
void (__stdcall *glFramebufferTexture1DEXT)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) = 0;
void (__stdcall *glFramebufferTexture2DEXT)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level) = 0;
void (__stdcall *glFramebufferTexture3DEXT)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset) = 0;
void (__stdcall *glFramebufferRenderbufferEXT)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer) = 0;
void (__stdcall *glGetFramebufferAttachmentParameterivEXT)(GLenum target, GLenum attachment, GLenum pname, GLint *params) = 0;
void (__stdcall *glGenerateMipmapEXT)(GLenum target) = 0;

int CGLExtensionHandler::n_GetFramebufferObjectEXTFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetFramebufferObjectEXTFuncPointers");

	int n_failed_functions = 0;

	if(!(glIsRenderbufferEXT = (GLboolean(__stdcall*)(GLuint renderbuffer))wglGetProcAddress("glIsRenderbufferEXT"))) n_failed_functions ++;
	if(!(glBindRenderbufferEXT = (void(__stdcall*)(GLenum target, GLuint renderbuffer))wglGetProcAddress("glBindRenderbufferEXT"))) n_failed_functions ++;
	if(!(glDeleteRenderbuffersEXT = (void(__stdcall*)(GLsizei n, const GLuint *renderbuffers))wglGetProcAddress("glDeleteRenderbuffersEXT"))) n_failed_functions ++;
	if(!(glGenRenderbuffersEXT = (void(__stdcall*)(GLsizei n, GLuint *renderbuffers))wglGetProcAddress("glGenRenderbuffersEXT"))) n_failed_functions ++;
	if(!(glRenderbufferStorageEXT = (void(__stdcall*)(GLenum target, GLenum internalformat, GLsizei width, GLsizei height))wglGetProcAddress("glRenderbufferStorageEXT"))) n_failed_functions ++;
	if(!(glGetRenderbufferParameterivEXT = (void(__stdcall*)(GLenum target, GLenum pname, GLint* params))wglGetProcAddress("glGetRenderbufferParameterivEXT"))) n_failed_functions ++;
	if(!(glIsFramebufferEXT = (GLboolean(__stdcall*)(GLuint framebuffer))wglGetProcAddress("glIsFramebufferEXT"))) n_failed_functions ++;
	if(!(glBindFramebufferEXT = (void(__stdcall*)(GLenum target, GLuint framebuffer))wglGetProcAddress("glBindFramebufferEXT"))) n_failed_functions ++;
	if(!(glDeleteFramebuffersEXT = (void(__stdcall*)(GLsizei n, const GLuint *framebuffers))wglGetProcAddress("glDeleteFramebuffersEXT"))) n_failed_functions ++;
	if(!(glGenFramebuffersEXT = (void(__stdcall*)(GLsizei n, GLuint *framebuffers))wglGetProcAddress("glGenFramebuffersEXT"))) n_failed_functions ++;
	if(!(glCheckFramebufferStatusEXT = (GLenum(__stdcall*)(GLenum target))wglGetProcAddress("glCheckFramebufferStatusEXT"))) n_failed_functions ++;
	if(!(glFramebufferTexture1DEXT = (void(__stdcall*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level))wglGetProcAddress("glFramebufferTexture1DEXT"))) n_failed_functions ++;
	if(!(glFramebufferTexture2DEXT = (void(__stdcall*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level))wglGetProcAddress("glFramebufferTexture2DEXT"))) n_failed_functions ++;
	if(!(glFramebufferTexture3DEXT = (void(__stdcall*)(GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset))wglGetProcAddress("glFramebufferTexture3DEXT"))) n_failed_functions ++;
	if(!(glFramebufferRenderbufferEXT = (void(__stdcall*)(GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer))wglGetProcAddress("glFramebufferRenderbufferEXT"))) n_failed_functions ++;
	if(!(glGetFramebufferAttachmentParameterivEXT = (void(__stdcall*)(GLenum target, GLenum attachment, GLenum pname, GLint *params))wglGetProcAddress("glGetFramebufferAttachmentParameterivEXT"))) n_failed_functions ++;
	if(!(glGenerateMipmapEXT = (void(__stdcall*)(GLenum target))wglGetProcAddress("glGenerateMipmapEXT"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- ext compiled array func pointers ---
 */

void (__stdcall *glLockArraysEXT)(GLint, GLsizei) = 0;
void (__stdcall *glUnlockArraysEXT)(void) = 0;

int CGLExtensionHandler::n_GetCompiledArrayEXTFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetCompiledArrayEXTFuncPointers");

	int n_failed_functions = 0;

	if(!(glLockArraysEXT = (void(__stdcall *)(GLint, GLsizei))wglGetProcAddress("glLockArraysEXT"))) n_failed_functions ++;
	if(!(glUnlockArraysEXT = (void(__stdcall *)(void))wglGetProcAddress("glUnlockArraysEXT"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- ext texture object func pointers ---
 */

GLboolean (__stdcall *glAreTexturesResidentEXT)(GLsizei, const GLuint *, GLboolean*) = 0;
void (__stdcall *glBindTextureEXT)(GLenum, GLuint) = 0;
void (__stdcall *glDeleteTexturesEXT)(GLsizei, const GLuint*) = 0;
void (__stdcall *glGenTexturesEXT)(GLsizei, GLuint*) = 0;
GLboolean (__stdcall *glIsTextureEXT)(GLuint) = 0;
void (__stdcall *glPrioritizeTexturesEXT)(GLsizei, const GLuint *, const GLclampf*) = 0;

int CGLExtensionHandler::n_GetTextureObjectEXTFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetTextureObjectEXTFuncPointers");

	int n_failed_functions = 0;

	if(!(glAreTexturesResidentEXT = (GLboolean(__stdcall*)(GLsizei, const GLuint *, GLboolean*))wglGetProcAddress("glAreTexturesResidentEXT"))) n_failed_functions ++;
	if(!(glBindTextureEXT = (void(__stdcall*)(GLenum, GLuint))wglGetProcAddress("glBindTextureEXT"))) n_failed_functions ++;
	if(!(glDeleteTexturesEXT = (void(__stdcall*)(GLsizei, const GLuint*))wglGetProcAddress("glDeleteTexturesEXT"))) n_failed_functions ++;
	if(!(glGenTexturesEXT = (void(__stdcall*)(GLsizei, GLuint*))wglGetProcAddress("glGenTexturesEXT"))) n_failed_functions ++;
	if(!(glIsTextureEXT = (GLboolean(__stdcall*)(GLuint))wglGetProcAddress("glIsTextureEXT"))) n_failed_functions ++;
	if(!(glPrioritizeTexturesEXT = (void(__stdcall*)(GLsizei, const GLuint *, const GLclampf*))wglGetProcAddress("glPrioritizeTexturesEXT"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- ext polygon offset func pointers ---
 */

void (__stdcall *glPolygonOffsetEXT)(GLfloat, GLfloat) = 0;

int CGLExtensionHandler::n_GetPolygonOffsetEXTFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetPolygonOffsetEXTFuncPointers");

	int n_failed_functions = 0;

	if(!(glPolygonOffsetEXT = (void(__stdcall*)(GLfloat, GLfloat))wglGetProcAddress("glPolygonOffsetEXT"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- arb color buffer float func pointers ---
 */

void (__stdcall *glClampColorARB)(GLenum, GLenum) = 0;

int CGLExtensionHandler::n_GetColorBufferFloatARBFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetColorBufferFloatARBFuncPointers");

	int n_failed_functions = 0;

	if(!(glClampColorARB = (void(__stdcall*)(GLenum, GLenum))wglGetProcAddress("glClampColorARB"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- ext vertex array func pointers ---
 */

void (__stdcall *glArrayElementEXT)(GLint) = 0;
void (__stdcall *glColorPointerEXT)(GLint, GLenum, GLsizei, GLsizei, const GLvoid*) = 0;
void (__stdcall *glDrawArraysEXT)(GLenum, GLint, GLsizei) = 0;
void (__stdcall *glEdgeFlagPointerEXT)(GLsizei, GLsizei, const GLboolean*) = 0;
void (__stdcall *glGetPointervEXT)(GLenum, GLvoid**) = 0;
void (__stdcall *glIndexPointerEXT)(GLenum, GLsizei, GLsizei, const GLvoid*) = 0;
void (__stdcall *glNormalPointerEXT)(GLenum, GLsizei, GLsizei, const GLvoid*) = 0;
void (__stdcall *glTexCoordPointerEXT)(GLint, GLenum, GLsizei, GLsizei, const GLvoid*) = 0;
void (__stdcall *glVertexPointerEXT)(GLint, GLenum, GLsizei, GLsizei, const GLvoid*) = 0;

int CGLExtensionHandler::n_GetVertexArrayEXTFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetVertexArrayEXTFuncPointers");

	int n_failed_functions = 0;

	if(!(glArrayElementEXT = (void(__stdcall*)(GLint))wglGetProcAddress("glArrayElementEXT"))) n_failed_functions ++;
	if(!(glColorPointerEXT = (void(__stdcall*)(GLint, GLenum, GLsizei, GLsizei, const GLvoid*))wglGetProcAddress("glColorPointerEXT"))) n_failed_functions ++;
	if(!(glDrawArraysEXT = (void(__stdcall*)(GLenum, GLint, GLsizei))wglGetProcAddress("glDrawArraysEXT"))) n_failed_functions ++;
	if(!(glEdgeFlagPointerEXT = (void(__stdcall*)(GLsizei, GLsizei, const GLboolean*))wglGetProcAddress("glEdgeFlagPointerEXT"))) n_failed_functions ++;
	if(!(glGetPointervEXT = (void(__stdcall*)(GLenum, GLvoid**))wglGetProcAddress("glGetPointervEXT"))) n_failed_functions ++;
	if(!(glIndexPointerEXT = (void(__stdcall*)(GLenum, GLsizei, GLsizei, const GLvoid*))wglGetProcAddress("glIndexPointerEXT"))) n_failed_functions ++;
	if(!(glNormalPointerEXT = (void(__stdcall*)(GLenum, GLsizei, GLsizei, const GLvoid*))wglGetProcAddress("glNormalPointerEXT"))) n_failed_functions ++;
	if(!(glTexCoordPointerEXT = (void(__stdcall*)(GLint, GLenum, GLsizei, GLsizei, const GLvoid*))wglGetProcAddress("glTexCoordPointerEXT"))) n_failed_functions ++;
	if(!(glVertexPointerEXT = (void(__stdcall*)(GLint, GLenum, GLsizei, GLsizei, const GLvoid*))wglGetProcAddress("glVertexPointerEXT"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *		--- GL20 func pointers ---
 */

// shader objects api
void (__stdcall *glDeleteShader)(GLuint shader) = 0;
void (__stdcall *glDetachShader)(GLuint program, GLuint shader) = 0;
GLuint (__stdcall *glCreateShader)(GLenum type) = 0;
void (__stdcall *glShaderSource)(GLuint shader, GLsizei count, const GLchar* *string, const GLint *length) = 0;
void (__stdcall *glCompileShader)(GLuint shader) = 0;

// program objects
GLuint (__stdcall *glCreateProgram)(void) = 0;
void (__stdcall *glAttachShader)(GLuint program, GLuint shader) = 0;
void (__stdcall *glLinkProgram)(GLuint program) = 0;
void (__stdcall *glUseProgram)(GLuint program) = 0;
void (__stdcall *glDeleteProgram)(GLuint program) = 0;
void (__stdcall *glValidateProgram)(GLuint program) = 0;

// uniforms
void (__stdcall *glUniform1f)(GLint location, GLfloat v0) = 0;
void (__stdcall *glUniform2f)(GLint location, GLfloat v0, GLfloat v1) = 0;
void (__stdcall *glUniform3f)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2) = 0;
void (__stdcall *glUniform4f)(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3) = 0;
void (__stdcall *glUniform1i)(GLint location, GLint v0) = 0;
void (__stdcall *glUniform2i)(GLint location, GLint v0, GLint v1) = 0;
void (__stdcall *glUniform3i)(GLint location, GLint v0, GLint v1, GLint v2) = 0;
void (__stdcall *glUniform4i)(GLint location, GLint v0, GLint v1, GLint v2, GLint v3) = 0;
void (__stdcall *glUniform1fv)(GLint location, GLsizei count, const GLfloat *value) = 0;
void (__stdcall *glUniform2fv)(GLint location, GLsizei count, const GLfloat *value) = 0;
void (__stdcall *glUniform3fv)(GLint location, GLsizei count, const GLfloat *value) = 0;
void (__stdcall *glUniform4fv)(GLint location, GLsizei count, const GLfloat *value) = 0;
void (__stdcall *glUniform1iv)(GLint location, GLsizei count, const GLint *value) = 0;
void (__stdcall *glUniform2iv)(GLint location, GLsizei count, const GLint *value) = 0;
void (__stdcall *glUniform3iv)(GLint location, GLsizei count, const GLint *value) = 0;
void (__stdcall *glUniform4iv)(GLint location, GLsizei count, const GLint *value) = 0;
void (__stdcall *glUniformMatrix2fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) = 0;
void (__stdcall *glUniformMatrix3fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) = 0;
void (__stdcall *glUniformMatrix4fv)(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value) = 0;

// attrib locations
void (__stdcall *glBindAttribLocation)(GLuint program, GLuint index, const GLchar *name) = 0;
GLint (__stdcall *glGetAttribLocation)(GLuint program, const GLchar *name) = 0;

// vertex attributes
void (__stdcall *glVertexAttrib1d)(GLuint index, GLdouble x) = 0;
void (__stdcall *glVertexAttrib1dv)(GLuint index, const GLdouble *v) = 0;
void (__stdcall *glVertexAttrib1f)(GLuint index, GLfloat x) = 0;
void (__stdcall *glVertexAttrib1fv)(GLuint index, const GLfloat *v) = 0;
void (__stdcall *glVertexAttrib1s)(GLuint index, GLshort x) = 0;
void (__stdcall *glVertexAttrib1sv)(GLuint index, const GLshort *v) = 0;
void (__stdcall *glVertexAttrib2d)(GLuint index, GLdouble x, GLdouble y) = 0;
void (__stdcall *glVertexAttrib2dv)(GLuint index, const GLdouble *v) = 0;
void (__stdcall *glVertexAttrib2f)(GLuint index, GLfloat x, GLfloat y) = 0;
void (__stdcall *glVertexAttrib2fv)(GLuint index, const GLfloat *v) = 0;
void (__stdcall *glVertexAttrib2s)(GLuint index, GLshort x, GLshort y) = 0;
void (__stdcall *glVertexAttrib2sv)(GLuint index, const GLshort *v) = 0;
void (__stdcall *glVertexAttrib3d)(GLuint index, GLdouble x, GLdouble y, GLdouble z) = 0;
void (__stdcall *glVertexAttrib3dv)(GLuint index, const GLdouble *v) = 0;
void (__stdcall *glVertexAttrib3f)(GLuint index, GLfloat x, GLfloat y, GLfloat z) = 0;
void (__stdcall *glVertexAttrib3fv)(GLuint index, const GLfloat *v) = 0;
void (__stdcall *glVertexAttrib3s)(GLuint index, GLshort x, GLshort y, GLshort z) = 0;
void (__stdcall *glVertexAttrib3sv)(GLuint index, const GLshort *v) = 0;
void (__stdcall *glVertexAttrib4Nbv)(GLuint index, const GLbyte *v) = 0;
void (__stdcall *glVertexAttrib4Niv)(GLuint index, const GLint *v) = 0;
void (__stdcall *glVertexAttrib4Nsv)(GLuint index, const GLshort *v) = 0;
void (__stdcall *glVertexAttrib4Nub)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) = 0;
void (__stdcall *glVertexAttrib4Nubv)(GLuint index, const GLubyte *v) = 0;
void (__stdcall *glVertexAttrib4Nuiv)(GLuint index, const GLuint *v) = 0;
void (__stdcall *glVertexAttrib4Nusv)(GLuint index, const GLushort *v) = 0;
void (__stdcall *glVertexAttrib4bv)(GLuint index, const GLbyte *v) = 0;
void (__stdcall *glVertexAttrib4d)(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w) = 0;
void (__stdcall *glVertexAttrib4dv)(GLuint index, const GLdouble *v) = 0;
void (__stdcall *glVertexAttrib4f)(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w) = 0;
void (__stdcall *glVertexAttrib4fv)(GLuint index, const GLfloat *v) = 0;
void (__stdcall *glVertexAttrib4iv)(GLuint index, const GLint *v) = 0;
void (__stdcall *glVertexAttrib4s)(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w) = 0;
void (__stdcall *glVertexAttrib4sv)(GLuint index, const GLshort *v) = 0;
void (__stdcall *glVertexAttrib4ubv)(GLuint index, const GLubyte *v) = 0;
void (__stdcall *glVertexAttrib4uiv)(GLuint index, const GLuint *v) = 0;
void (__stdcall *glVertexAttrib4usv)(GLuint index, const GLushort *v) = 0;
void (__stdcall *glVertexAttribPointer)(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer) = 0;
void (__stdcall *glEnableVertexAttribArray)(GLuint index) = 0;
void (__stdcall *glDisableVertexAttribArray)(GLuint index) = 0;
void (__stdcall *glGetVertexAttribdv)(GLuint index, GLenum pname, GLdouble *params) = 0;
void (__stdcall *glGetVertexAttribfv)(GLuint index, GLenum pname, GLfloat *params) = 0;
void (__stdcall *glGetVertexAttribiv)(GLuint index, GLenum pname, GLint *params) = 0;
void (__stdcall *glGetVertexAttribPointerv)(GLuint index, GLenum pname, GLvoid* *pointer) = 0;

// queries
GLboolean (__stdcall *glIsShader)(GLuint shader) = 0;
GLboolean (__stdcall *glIsProgram)(GLuint program) = 0;
void (__stdcall *glGetShaderiv)(GLuint program, GLenum pname, GLint *params) = 0;
void (__stdcall *glGetProgramiv)(GLuint program, GLenum pname, GLint *params) = 0;
void (__stdcall *glGetAttachedShaders)(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders) = 0;
void (__stdcall *glGetShaderInfoLog)(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog) = 0;
void (__stdcall *glGetProgramInfoLog)(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog) = 0;
GLint (__stdcall *glGetUniformLocation)(GLuint program, const GLchar *name) = 0;
void (__stdcall *glGetActiveUniform)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name) = 0;
void (__stdcall *glGetUniformfv)(GLuint program, GLint location, GLfloat *params) = 0;
void (__stdcall *glGetUniformiv)(GLuint program, GLint location, GLint *params) = 0;
void (__stdcall *glGetShaderSource)(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source) = 0;
void (__stdcall *glGetActiveAttrib)(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name) = 0;

// multiple draw buffers
void (__stdcall *glDrawBuffers)(GLsizei n, const GLenum *bufs) = 0;

// two-sided stencil
void (__stdcall *glStencilFuncSeparate)(GLenum face, GLenum func, GLint ref, GLuint mask) = 0;
void (__stdcall *glStencilOpSeparate)(GLenum face, GLenum fail, GLenum zfail, GLenum zpass) = 0;
void (__stdcall *glStencilMaskSeparate)(GLenum face, GLuint mask) = 0;

// separate alpha blending
void (__stdcall *glBlendEquationSeparate)(GLenum modeRGB, GLenum modeAlpha) = 0;

int CGLExtensionHandler::n_GetGL20FuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetGL20FuncPointers");

	int n_failed_functions = 0;

	if(!(glDeleteShader = (void(__stdcall*)(GLuint))wglGetProcAddress("glDeleteShader"))) n_failed_functions ++;
	if(!(glDetachShader = (void(__stdcall*)(GLuint, GLuint))wglGetProcAddress("glDetachShader"))) n_failed_functions ++;
	if(!(glCreateShader = (GLuint(__stdcall*)(GLenum))wglGetProcAddress("glCreateShader"))) n_failed_functions ++;
	if(!(glShaderSource = (void(__stdcall*)(GLuint, GLsizei, const GLchar**, const GLint*))wglGetProcAddress("glShaderSource"))) n_failed_functions ++;
	if(!(glCompileShader = (void(__stdcall*)(GLuint))wglGetProcAddress("glCompileShader"))) n_failed_functions ++;
	if(!(glCreateProgram = (GLuint(__stdcall*)(void))wglGetProcAddress("glCreateProgram"))) n_failed_functions ++;
	if(!(glAttachShader = (void(__stdcall*)(GLuint, GLuint shader))wglGetProcAddress("glAttachShader"))) n_failed_functions ++;
	if(!(glLinkProgram = (void(__stdcall*)(GLuint))wglGetProcAddress("glLinkProgram"))) n_failed_functions ++;
	if(!(glUseProgram = (void(__stdcall*)(GLuint))wglGetProcAddress("glUseProgram"))) n_failed_functions ++;
	if(!(glDeleteProgram = (void(__stdcall*)(GLuint))wglGetProcAddress("glDeleteProgram"))) n_failed_functions ++;
	if(!(glValidateProgram = (void(__stdcall*)(GLuint))wglGetProcAddress("glValidateProgram"))) n_failed_functions ++;
	if(!(glUniform1f = (void(__stdcall*)(GLint, GLfloat))wglGetProcAddress("glUniform1f"))) n_failed_functions ++;
	if(!(glUniform2f = (void(__stdcall*)(GLint, GLfloat, GLfloat))wglGetProcAddress("glUniform2f"))) n_failed_functions ++;
	if(!(glUniform3f = (void(__stdcall*)(GLint, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glUniform3f"))) n_failed_functions ++;
	if(!(glUniform4f = (void(__stdcall*)(GLint, GLfloat, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glUniform4f"))) n_failed_functions ++;
	if(!(glUniform1i = (void(__stdcall*)(GLint, GLint))wglGetProcAddress("glUniform1i"))) n_failed_functions ++;
	if(!(glUniform2i = (void(__stdcall*)(GLint, GLint, GLint))wglGetProcAddress("glUniform2i"))) n_failed_functions ++;
	if(!(glUniform3i = (void(__stdcall*)(GLint, GLint, GLint, GLint))wglGetProcAddress("glUniform3i"))) n_failed_functions ++;
	if(!(glUniform4i = (void(__stdcall*)(GLint, GLint, GLint, GLint, GLint))wglGetProcAddress("glUniform4i"))) n_failed_functions ++;
	if(!(glUniform1fv = (void(__stdcall*)(GLint, GLsizei, const GLfloat*))wglGetProcAddress("glUniform1fv"))) n_failed_functions ++;
	if(!(glUniform2fv = (void(__stdcall*)(GLint, GLsizei, const GLfloat*))wglGetProcAddress("glUniform2fv"))) n_failed_functions ++;
	if(!(glUniform3fv = (void(__stdcall*)(GLint, GLsizei, const GLfloat*))wglGetProcAddress("glUniform3fv"))) n_failed_functions ++;
	if(!(glUniform4fv = (void(__stdcall*)(GLint, GLsizei, const GLfloat*))wglGetProcAddress("glUniform4fv"))) n_failed_functions ++;
	if(!(glUniform1iv = (void(__stdcall*)(GLint, GLsizei, const GLint*))wglGetProcAddress("glUniform1iv"))) n_failed_functions ++;
	if(!(glUniform2iv = (void(__stdcall*)(GLint, GLsizei, const GLint*))wglGetProcAddress("glUniform2iv"))) n_failed_functions ++;
	if(!(glUniform3iv = (void(__stdcall*)(GLint, GLsizei, const GLint*))wglGetProcAddress("glUniform3iv"))) n_failed_functions ++;
	if(!(glUniform4iv = (void(__stdcall*)(GLint, GLsizei, const GLint*))wglGetProcAddress("glUniform4iv"))) n_failed_functions ++;
	if(!(glUniformMatrix2fv = (void(__stdcall*)(GLint, GLsizei, GLboolean transpose, const GLfloat*))wglGetProcAddress("glUniformMatrix2fv"))) n_failed_functions ++;
	if(!(glUniformMatrix3fv = (void(__stdcall*)(GLint, GLsizei, GLboolean transpose, const GLfloat*))wglGetProcAddress("glUniformMatrix3fv"))) n_failed_functions ++;
	if(!(glUniformMatrix4fv = (void(__stdcall*)(GLint, GLsizei, GLboolean transpose, const GLfloat*))wglGetProcAddress("glUniformMatrix4fv"))) n_failed_functions ++;
	if(!(glBindAttribLocation = (void(__stdcall*)(GLuint, GLuint, const GLchar *name))wglGetProcAddress("glBindAttribLocation"))) n_failed_functions ++;
	if(!(glGetAttribLocation = (GLint(__stdcall*)(GLuint, const GLchar *name))wglGetProcAddress("glGetAttribLocation"))) n_failed_functions ++;
	if(!(glVertexAttrib1d = (void(__stdcall*)(GLuint, GLdouble))wglGetProcAddress("glVertexAttrib1d"))) n_failed_functions ++;
	if(!(glVertexAttrib1dv = (void(__stdcall*)(GLuint, const GLdouble*))wglGetProcAddress("glVertexAttrib1dv"))) n_failed_functions ++;
	if(!(glVertexAttrib1f = (void(__stdcall*)(GLuint, GLfloat))wglGetProcAddress("glVertexAttrib1f"))) n_failed_functions ++;
	if(!(glVertexAttrib1fv = (void(__stdcall*)(GLuint, const GLfloat*))wglGetProcAddress("glVertexAttrib1fv"))) n_failed_functions ++;
	if(!(glVertexAttrib1s = (void(__stdcall*)(GLuint, GLshort))wglGetProcAddress("glVertexAttrib1s"))) n_failed_functions ++;
	if(!(glVertexAttrib1sv = (void(__stdcall*)(GLuint, const GLshort*))wglGetProcAddress("glVertexAttrib1sv"))) n_failed_functions ++;
	if(!(glVertexAttrib2d = (void(__stdcall*)(GLuint, GLdouble, GLdouble))wglGetProcAddress("glVertexAttrib2d"))) n_failed_functions ++;
	if(!(glVertexAttrib2dv = (void(__stdcall*)(GLuint, const GLdouble*))wglGetProcAddress("glVertexAttrib2dv"))) n_failed_functions ++;
	if(!(glVertexAttrib2f = (void(__stdcall*)(GLuint, GLfloat, GLfloat))wglGetProcAddress("glVertexAttrib2f"))) n_failed_functions ++;
	if(!(glVertexAttrib2fv = (void(__stdcall*)(GLuint, const GLfloat*))wglGetProcAddress("glVertexAttrib2fv"))) n_failed_functions ++;
	if(!(glVertexAttrib2s = (void(__stdcall*)(GLuint, GLshort, GLshort))wglGetProcAddress("glVertexAttrib2s"))) n_failed_functions ++;
	if(!(glVertexAttrib2sv = (void(__stdcall*)(GLuint, const GLshort*))wglGetProcAddress("glVertexAttrib2sv"))) n_failed_functions ++;
	if(!(glVertexAttrib3d = (void(__stdcall*)(GLuint, GLdouble, GLdouble, GLdouble))wglGetProcAddress("glVertexAttrib3d"))) n_failed_functions ++;
	if(!(glVertexAttrib3dv = (void(__stdcall*)(GLuint, const GLdouble*))wglGetProcAddress("glVertexAttrib3dv"))) n_failed_functions ++;
	if(!(glVertexAttrib3f = (void(__stdcall*)(GLuint, GLfloat, GLfloat, GLfloat z))wglGetProcAddress("glVertexAttrib3f"))) n_failed_functions ++;
	if(!(glVertexAttrib3fv = (void(__stdcall*)(GLuint, const GLfloat*))wglGetProcAddress("glVertexAttrib3fv"))) n_failed_functions ++;
	if(!(glVertexAttrib3s = (void(__stdcall*)(GLuint, GLshort, GLshort, GLshort z))wglGetProcAddress("glVertexAttrib3s"))) n_failed_functions ++;
	if(!(glVertexAttrib3sv = (void(__stdcall*)(GLuint, const GLshort*))wglGetProcAddress("glVertexAttrib3sv"))) n_failed_functions ++;
	if(!(glVertexAttrib4Nbv = (void(__stdcall*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4Nbv"))) n_failed_functions ++;
	if(!(glVertexAttrib4Niv = (void(__stdcall*)(GLuint, const GLint*))wglGetProcAddress("glVertexAttrib4Niv"))) n_failed_functions ++;
	if(!(glVertexAttrib4Nsv = (void(__stdcall*)(GLuint, const GLshort*))wglGetProcAddress("glVertexAttrib4Nsv"))) n_failed_functions ++;
	if(!(glVertexAttrib4Nub = (void(__stdcall*)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte))wglGetProcAddress("glVertexAttrib4Nub"))) n_failed_functions ++;
	if(!(glVertexAttrib4Nubv = (void(__stdcall*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4Nubv"))) n_failed_functions ++;
	if(!(glVertexAttrib4Nuiv = (void(__stdcall*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4Nuiv"))) n_failed_functions ++;
	if(!(glVertexAttrib4Nusv = (void(__stdcall*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4Nusv"))) n_failed_functions ++;
	if(!(glVertexAttrib4bv = (void(__stdcall*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4bv"))) n_failed_functions ++;
	if(!(glVertexAttrib4d = (void(__stdcall*)(GLuint, GLdouble, GLdouble, GLdouble, GLdouble))wglGetProcAddress("glVertexAttrib4d"))) n_failed_functions ++;
	if(!(glVertexAttrib4dv = (void(__stdcall*)(GLuint, const GLdouble*))wglGetProcAddress("glVertexAttrib4dv"))) n_failed_functions ++;
	if(!(glVertexAttrib4f = (void(__stdcall*)(GLuint, GLfloat, GLfloat, GLfloat, GLfloat))wglGetProcAddress("glVertexAttrib4f"))) n_failed_functions ++;
	if(!(glVertexAttrib4fv = (void(__stdcall*)(GLuint, const GLfloat*))wglGetProcAddress("glVertexAttrib4fv"))) n_failed_functions ++;
	if(!(glVertexAttrib4iv = (void(__stdcall*)(GLuint, const GLint*))wglGetProcAddress("glVertexAttrib4iv"))) n_failed_functions ++;
	if(!(glVertexAttrib4s = (void(__stdcall*)(GLuint, GLshort, GLshort, GLshort, GLshort))wglGetProcAddress("glVertexAttrib4s"))) n_failed_functions ++;
	if(!(glVertexAttrib4sv = (void(__stdcall*)(GLuint, const GLshort*))wglGetProcAddress("glVertexAttrib4sv"))) n_failed_functions ++;
	if(!(glVertexAttrib4ubv = (void(__stdcall*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4ubv"))) n_failed_functions ++;
	if(!(glVertexAttrib4uiv = (void(__stdcall*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4uiv"))) n_failed_functions ++;
	if(!(glVertexAttrib4usv = (void(__stdcall*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4usv"))) n_failed_functions ++;
	if(!(glVertexAttribPointer = (void(__stdcall*)(GLuint, GLint, GLenum, GLboolean, GLsizei, const GLvoid*))wglGetProcAddress("glVertexAttribPointer"))) n_failed_functions ++;
	if(!(glEnableVertexAttribArray = (void(__stdcall*)(GLuint index))wglGetProcAddress("glEnableVertexAttribArray"))) n_failed_functions ++;
	if(!(glDisableVertexAttribArray = (void(__stdcall*)(GLuint index))wglGetProcAddress("glDisableVertexAttribArray"))) n_failed_functions ++;
	if(!(glGetVertexAttribdv = (void(__stdcall*)(GLuint, GLenum, GLdouble*))wglGetProcAddress("glGetVertexAttribdv"))) n_failed_functions ++;
	if(!(glGetVertexAttribfv = (void(__stdcall*)(GLuint, GLenum, GLfloat*))wglGetProcAddress("glGetVertexAttribfv"))) n_failed_functions ++;
	if(!(glGetVertexAttribiv = (void(__stdcall*)(GLuint, GLenum, GLint*))wglGetProcAddress("glGetVertexAttribiv"))) n_failed_functions ++;
	if(!(glGetVertexAttribPointerv = (void(__stdcall*)(GLuint, GLenum, GLvoid**))wglGetProcAddress("glGetVertexAttribPointerv"))) n_failed_functions ++;
	if(!(glIsShader = (GLboolean(__stdcall*)(GLuint shader))wglGetProcAddress("glIsShader"))) n_failed_functions ++;
	if(!(glIsProgram = (GLboolean(__stdcall*)(GLuint program))wglGetProcAddress("glIsProgram"))) n_failed_functions ++;
	if(!(glGetShaderiv = (void(__stdcall*)(GLuint, GLenum, GLint*))wglGetProcAddress("glGetShaderiv"))) n_failed_functions ++;
	if(!(glGetProgramiv = (void(__stdcall*)(GLuint, GLenum, GLint*))wglGetProcAddress("glGetProgramiv"))) n_failed_functions ++;
	if(!(glGetAttachedShaders = (void(__stdcall*)(GLuint, GLsizei maxCount, GLsizei *count, GLuint*))wglGetProcAddress("glGetAttachedShaders"))) n_failed_functions ++;
	if(!(glGetShaderInfoLog = (void(__stdcall*)(GLuint shader, GLsizei bufSize, GLsizei*, GLchar*))wglGetProcAddress("glGetShaderInfoLog"))) n_failed_functions ++;
	if(!(glGetProgramInfoLog = (void(__stdcall*)(GLuint, GLsizei bufSize, GLsizei*, GLchar*))wglGetProcAddress("glGetProgramInfoLog"))) n_failed_functions ++;
	if(!(glGetUniformLocation = (GLint(__stdcall*)(GLuint, const GLchar *name))wglGetProcAddress("glGetUniformLocation"))) n_failed_functions ++;
	if(!(glGetActiveUniform = (void(__stdcall*)(GLuint, GLuint, GLsizei bufSize, GLsizei*, GLsizei*, GLenum*, GLchar*))wglGetProcAddress("glGetActiveUniform"))) n_failed_functions ++;
	if(!(glGetUniformfv = (void(__stdcall*)(GLuint, GLint, GLfloat*))wglGetProcAddress("glGetUniformfv"))) n_failed_functions ++;
	if(!(glGetUniformiv = (void(__stdcall*)(GLuint, GLint, GLint*))wglGetProcAddress("glGetUniformiv"))) n_failed_functions ++;
	if(!(glGetShaderSource = (void(__stdcall*)(GLuint, GLsizei bufSize, GLsizei*, GLchar*))wglGetProcAddress("glGetShaderSource"))) n_failed_functions ++;
	if(!(glGetActiveAttrib = (void(__stdcall*)(GLuint, GLuint, GLsizei bufSize, GLsizei*, GLsizei*, GLenum*, GLchar*))wglGetProcAddress("glGetActiveAttrib"))) n_failed_functions ++;
	if(!(glDrawBuffers = (void(__stdcall*)(GLsizei, const GLenum*))wglGetProcAddress("glDrawBuffers"))) n_failed_functions ++;
	if(!(glStencilFuncSeparate = (void(__stdcall*)(GLenum, GLenum, GLint, GLuint))wglGetProcAddress("glStencilFuncSeparate"))) n_failed_functions ++;
	if(!(glStencilOpSeparate = (void(__stdcall*)(GLenum, GLenum, GLenum, GLenum))wglGetProcAddress("glStencilOpSeparate"))) n_failed_functions ++;
	if(!(glStencilMaskSeparate = (void(__stdcall*)(GLenum, GLuint))wglGetProcAddress("glStencilMaskSeparate"))) n_failed_functions ++;
	if(!(glBlendEquationSeparate = (void(__stdcall*)(GLenum, GLenum))wglGetProcAddress("glBlendEquationSeparate"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *				--- GL_ARB_vertex_program ---
 */

void (__stdcall *glVertexAttrib1sARB)(GLuint index, short x) = 0;
void (__stdcall *glVertexAttrib1fARB)(GLuint index, float x) = 0;
void (__stdcall *glVertexAttrib1dARB)(GLuint index, double x) = 0;
void (__stdcall *glVertexAttrib2sARB)(GLuint index, short x, short y) = 0;
void (__stdcall *glVertexAttrib2fARB)(GLuint index, float x, float y) = 0;
void (__stdcall *glVertexAttrib2dARB)(GLuint index, double x, double y) = 0;
void (__stdcall *glVertexAttrib3sARB)(GLuint index, short x, short y, short z) = 0;
void (__stdcall *glVertexAttrib3fARB)(GLuint index, float x, float y, float z) = 0;
void (__stdcall *glVertexAttrib3dARB)(GLuint index, double x, double y, double z) = 0;
void (__stdcall *glVertexAttrib4sARB)(GLuint index, short x, short y, short z, short w) = 0;
void (__stdcall *glVertexAttrib4fARB)(GLuint index, float x, float y, float z, float w) = 0;
void (__stdcall *glVertexAttrib4dARB)(GLuint index, double x, double y, double z, double w) = 0;
void (__stdcall *glVertexAttrib4NubARB)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) = 0;
void (__stdcall *glVertexAttrib1svARB)(GLuint index, const short *v) = 0;
void (__stdcall *glVertexAttrib1fvARB)(GLuint index, const float *v) = 0;
void (__stdcall *glVertexAttrib1dvARB)(GLuint index, const double *v) = 0;
void (__stdcall *glVertexAttrib2svARB)(GLuint index, const short *v) = 0;
void (__stdcall *glVertexAttrib2fvARB)(GLuint index, const float *v) = 0;
void (__stdcall *glVertexAttrib2dvARB)(GLuint index, const double *v) = 0;
void (__stdcall *glVertexAttrib3svARB)(GLuint index, const short *v) = 0;
void (__stdcall *glVertexAttrib3fvARB)(GLuint index, const float *v) = 0;
void (__stdcall *glVertexAttrib3dvARB)(GLuint index, const double *v) = 0;
void (__stdcall *glVertexAttrib4bvARB)(GLuint index, const GLbyte *v) = 0;
void (__stdcall *glVertexAttrib4svARB)(GLuint index, const short *v) = 0;
void (__stdcall *glVertexAttrib4ivARB)(GLuint index, const int *v) = 0;
void (__stdcall *glVertexAttrib4ubvARB)(GLuint index, const GLubyte *v) = 0;
void (__stdcall *glVertexAttrib4usvARB)(GLuint index, const GLushort *v) = 0;
void (__stdcall *glVertexAttrib4uivARB)(GLuint index, const GLuint *v) = 0;
void (__stdcall *glVertexAttrib4fvARB)(GLuint index, const float *v) = 0;
void (__stdcall *glVertexAttrib4dvARB)(GLuint index, const double *v) = 0;
void (__stdcall *glVertexAttrib4NbvARB)(GLuint index, const GLbyte *v) = 0;
void (__stdcall *glVertexAttrib4NsvARB)(GLuint index, const short *v) = 0;
void (__stdcall *glVertexAttrib4NivARB)(GLuint index, const int *v) = 0;
void (__stdcall *glVertexAttrib4NubvARB)(GLuint index, const GLubyte *v) = 0;
void (__stdcall *glVertexAttrib4NusvARB)(GLuint index, const GLushort *v) = 0;
void (__stdcall *glVertexAttrib4NuivARB)(GLuint index, const GLuint *v) = 0;
void (__stdcall *glVertexAttribPointerARB)(GLuint index, int size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer) = 0;
void (__stdcall *glEnableVertexAttribArrayARB)(GLuint index) = 0;
void (__stdcall *glDisableVertexAttribArrayARB)(GLuint index) = 0;
void (__stdcall *glProgramStringARB)(GLenum target, GLenum format, GLsizei len, const void *string) = 0; 
void (__stdcall *glBindProgramARB)(GLenum target, GLuint program) = 0;
void (__stdcall *glDeleteProgramsARB)(GLsizei n, const GLuint *programs) = 0;
void (__stdcall *glGenProgramsARB)(GLsizei n, GLuint *programs) = 0;
void (__stdcall *glProgramEnvParameter4dARB)(GLenum target, GLuint index, double x, double y, double z, double w) = 0;
void (__stdcall *glProgramEnvParameter4dvARB)(GLenum target, GLuint index, const double *params) = 0;
void (__stdcall *glProgramEnvParameter4fARB)(GLenum target, GLuint index, float x, float y, float z, float w) = 0;
void (__stdcall *glProgramEnvParameter4fvARB)(GLenum target, GLuint index, const float *params) = 0;
void (__stdcall *glProgramLocalParameter4dARB)(GLenum target, GLuint index, double x, double y, double z, double w) = 0;
void (__stdcall *glProgramLocalParameter4dvARB)(GLenum target, GLuint index, const double *params) = 0;
void (__stdcall *glProgramLocalParameter4fARB)(GLenum target, GLuint index, float x, float y, float z, float w) = 0;
void (__stdcall *glProgramLocalParameter4fvARB)(GLenum target, GLuint index, const float *params) = 0;
void (__stdcall *glGetProgramEnvParameterdvARB)(GLenum target, GLuint index, double *params) = 0;
void (__stdcall *glGetProgramEnvParameterfvARB)(GLenum target, GLuint index, float *params) = 0;
void (__stdcall *glGetProgramLocalParameterdvARB)(GLenum target, GLuint index, double *params) = 0;
void (__stdcall *glGetProgramLocalParameterfvARB)(GLenum target, GLuint index, float *params) = 0;
void (__stdcall *glGetProgramivARB)(GLenum target, GLenum pname, int *params) = 0;
void (__stdcall *glGetProgramStringARB)(GLenum target, GLenum pname, void *string) = 0;
void (__stdcall *glGetVertexAttribdvARB)(GLuint index, GLenum pname, double *params) = 0;
void (__stdcall *glGetVertexAttribfvARB)(GLuint index, GLenum pname, float *params) = 0;
void (__stdcall *glGetVertexAttribivARB)(GLuint index, GLenum pname, int *params) = 0;
void (__stdcall *glGetVertexAttribPointervARB)(GLuint index, GLenum pname, void **pointer) = 0;
GLboolean (__stdcall *glIsProgramARB)(GLuint program) = 0;

int CGLExtensionHandler::n_GetVertexProgramARBFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetVertexProgramARBFuncPointers");

	int n_failed_functions = 0;

	if(!(glVertexAttrib1sARB = (void(__stdcall*)(GLuint, short))wglGetProcAddress("glVertexAttrib1sARB"))) n_failed_functions ++;
	if(!(glVertexAttrib1fARB = (void(__stdcall*)(GLuint, float))wglGetProcAddress("glVertexAttrib1fARB"))) n_failed_functions ++;
	if(!(glVertexAttrib1dARB = (void(__stdcall*)(GLuint, double))wglGetProcAddress("glVertexAttrib1dARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2sARB = (void(__stdcall*)(GLuint, short, short))wglGetProcAddress("glVertexAttrib2sARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2fARB = (void(__stdcall*)(GLuint, float, float))wglGetProcAddress("glVertexAttrib2fARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2dARB = (void(__stdcall*)(GLuint, double, double))wglGetProcAddress("glVertexAttrib2dARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3sARB = (void(__stdcall*)(GLuint, short, short, short))wglGetProcAddress("glVertexAttrib3sARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3fARB = (void(__stdcall*)(GLuint, float, float, float))wglGetProcAddress("glVertexAttrib3fARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3dARB = (void(__stdcall*)(GLuint, double, double, double))wglGetProcAddress("glVertexAttrib3dARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4sARB = (void(__stdcall*)(GLuint, short, short, short, short))wglGetProcAddress("glVertexAttrib4sARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4fARB = (void(__stdcall*)(GLuint, float, float, float, float))wglGetProcAddress("glVertexAttrib4fARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4dARB = (void(__stdcall*)(GLuint, double, double, double, double))wglGetProcAddress("glVertexAttrib4dARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NubARB = (void(__stdcall*)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte))wglGetProcAddress("glVertexAttrib4NubARB"))) n_failed_functions ++;
	if(!(glVertexAttrib1svARB = (void(__stdcall*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib1svARB"))) n_failed_functions ++;
	if(!(glVertexAttrib1fvARB = (void(__stdcall*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib1fvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib1dvARB = (void(__stdcall*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib1dvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2svARB = (void(__stdcall*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib2svARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2fvARB = (void(__stdcall*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib2fvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2dvARB = (void(__stdcall*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib2dvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3svARB = (void(__stdcall*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib3svARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3fvARB = (void(__stdcall*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib3fvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3dvARB = (void(__stdcall*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib3dvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4bvARB = (void(__stdcall*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4bvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4svARB = (void(__stdcall*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib4svARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4ivARB = (void(__stdcall*)(GLuint, const int*))wglGetProcAddress("glVertexAttrib4ivARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4ubvARB = (void(__stdcall*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4ubvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4usvARB = (void(__stdcall*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4usvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4uivARB = (void(__stdcall*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4uivARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4fvARB = (void(__stdcall*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib4fvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4dvARB = (void(__stdcall*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib4dvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NbvARB = (void(__stdcall*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4NbvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NsvARB = (void(__stdcall*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib4NsvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NivARB = (void(__stdcall*)(GLuint, const int*))wglGetProcAddress("glVertexAttrib4NivARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NubvARB = (void(__stdcall*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4NubvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NusvARB = (void(__stdcall*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4NusvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NuivARB = (void(__stdcall*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4NuivARB"))) n_failed_functions ++;
	if(!(glVertexAttribPointerARB = (void(__stdcall*)(GLuint, int size, GLenum, GLboolean, GLsizei stride, const void*))wglGetProcAddress("glVertexAttribPointerARB"))) n_failed_functions ++;
	if(!(glEnableVertexAttribArrayARB = (void(__stdcall*)(GLuint))wglGetProcAddress("glEnableVertexAttribArrayARB"))) n_failed_functions ++;
	if(!(glDisableVertexAttribArrayARB = (void(__stdcall*)(GLuint))wglGetProcAddress("glDisableVertexAttribArrayARB"))) n_failed_functions ++;
	if(!(glProgramStringARB = (void(__stdcall*)(GLenum, GLenum, GLsizei, const void*))wglGetProcAddress("glProgramStringARB"))) n_failed_functions ++; 
	if(!(glBindProgramARB = (void(__stdcall*)(GLenum, GLuint program))wglGetProcAddress("glBindProgramARB"))) n_failed_functions ++;
	if(!(glDeleteProgramsARB = (void(__stdcall*)(GLsizei, const GLuint *programs))wglGetProcAddress("glDeleteProgramsARB"))) n_failed_functions ++;
	if(!(glGenProgramsARB = (void(__stdcall*)(GLsizei, GLuint *programs))wglGetProcAddress("glGenProgramsARB"))) n_failed_functions ++;
	if(!(glProgramEnvParameter4dARB = (void(__stdcall*)(GLenum, GLuint, double, double, double, double))wglGetProcAddress("glProgramEnvParameter4dARB"))) n_failed_functions ++;
	if(!(glProgramEnvParameter4dvARB = (void(__stdcall*)(GLenum, GLuint, const double*))wglGetProcAddress("glProgramEnvParameter4dvARB"))) n_failed_functions ++;
	if(!(glProgramEnvParameter4fARB = (void(__stdcall*)(GLenum, GLuint, float, float, float, float))wglGetProcAddress("glProgramEnvParameter4fARB"))) n_failed_functions ++;
	if(!(glProgramEnvParameter4fvARB = (void(__stdcall*)(GLenum, GLuint, const float*))wglGetProcAddress("glProgramEnvParameter4fvARB"))) n_failed_functions ++;
	if(!(glProgramLocalParameter4dARB = (void(__stdcall*)(GLenum, GLuint, double, double, double, double))wglGetProcAddress("glProgramLocalParameter4dARB"))) n_failed_functions ++;
	if(!(glProgramLocalParameter4dvARB = (void(__stdcall*)(GLenum, GLuint, const double*))wglGetProcAddress("glProgramLocalParameter4dvARB"))) n_failed_functions ++;
	if(!(glProgramLocalParameter4fARB = (void(__stdcall*)(GLenum, GLuint, float, float, float, float))wglGetProcAddress("glProgramLocalParameter4fARB"))) n_failed_functions ++;
	if(!(glProgramLocalParameter4fvARB = (void(__stdcall*)(GLenum, GLuint, const float*))wglGetProcAddress("glProgramLocalParameter4fvARB"))) n_failed_functions ++;
	if(!(glGetProgramEnvParameterdvARB = (void(__stdcall*)(GLenum, GLuint, double*))wglGetProcAddress("glGetProgramEnvParameterdvARB"))) n_failed_functions ++;
	if(!(glGetProgramEnvParameterfvARB = (void(__stdcall*)(GLenum, GLuint, float*))wglGetProcAddress("glGetProgramEnvParameterfvARB"))) n_failed_functions ++;
	if(!(glGetProgramLocalParameterdvARB = (void(__stdcall*)(GLenum, GLuint, double*))wglGetProcAddress("glGetProgramLocalParameterdvARB"))) n_failed_functions ++;
	if(!(glGetProgramLocalParameterfvARB = (void(__stdcall*)(GLenum, GLuint, float*))wglGetProcAddress("glGetProgramLocalParameterfvARB"))) n_failed_functions ++;
	if(!(glGetProgramivARB = (void(__stdcall*)(GLenum, GLenum, int*))wglGetProcAddress("glGetProgramivARB"))) n_failed_functions ++;
	if(!(glGetProgramStringARB = (void(__stdcall*)(GLenum, GLenum, void*))wglGetProcAddress("glGetProgramStringARB"))) n_failed_functions ++;
	if(!(glGetVertexAttribdvARB = (void(__stdcall*)(GLuint, GLenum, double*))wglGetProcAddress("glGetVertexAttribdvARB"))) n_failed_functions ++;
	if(!(glGetVertexAttribfvARB = (void(__stdcall*)(GLuint, GLenum, float*))wglGetProcAddress("glGetVertexAttribfvARB"))) n_failed_functions ++;
	if(!(glGetVertexAttribivARB = (void(__stdcall*)(GLuint, GLenum, int*))wglGetProcAddress("glGetVertexAttribivARB"))) n_failed_functions ++;
	if(!(glGetVertexAttribPointervARB = (void(__stdcall*)(GLuint, GLenum, void**))wglGetProcAddress("glGetVertexAttribPointervARB"))) n_failed_functions ++;
	if(!(glIsProgramARB = (GLboolean(__stdcall*)(GLuint program))wglGetProcAddress("glIsProgramARB"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *				--- GL_ARB_fragment_program ---
 */

/*
void (__stdcall *glProgramStringARB)(GLenum target, GLenum format, GLsizei len, const void *string) = 0; 
void (__stdcall *glBindProgramARB)(GLenum target, GLuint program) = 0;
void (__stdcall *glDeleteProgramsARB)(GLsizei n, const GLuint *programs) = 0;
void (__stdcall *glGenProgramsARB)(GLsizei n, GLuint *programs) = 0;
void (__stdcall *glProgramEnvParameter4dARB)(GLenum target, GLuint index, double x, double y, double z, double w) = 0;
void (__stdcall *glProgramEnvParameter4dvARB)(GLenum target, GLuint index, const double *params) = 0;
void (__stdcall *glProgramEnvParameter4fARB)(GLenum target, GLuint index, float x, float y, float z, float w) = 0;
void (__stdcall *glProgramEnvParameter4fvARB)(GLenum target, GLuint index, const float *params) = 0;
void (__stdcall *glProgramLocalParameter4dARB)(GLenum target, GLuint index, double x, double y, double z, double w) = 0;
void (__stdcall *glProgramLocalParameter4dvARB)(GLenum target, GLuint index, const double *params) = 0;
void (__stdcall *glProgramLocalParameter4fARB)(GLenum target, GLuint index, float x, float y, float z, float w) = 0;
void (__stdcall *glProgramLocalParameter4fvARB)(GLenum target, GLuint index, const float *params) = 0;
void (__stdcall *glGetProgramEnvParameterdvARB)(GLenum target, GLuint index, double *params) = 0;
void (__stdcall *glGetProgramEnvParameterfvARB)(GLenum target, GLuint index, float *params) = 0;
void (__stdcall *glGetProgramLocalParameterdvARB)(GLenum target, GLuint index, double *params) = 0;
void (__stdcall *glGetProgramLocalParameterfvARB)(GLenum target, GLuint index, float *params) = 0;
void (__stdcall *glGetProgramivARB)(GLenum target, GLenum pname, int *params) = 0;
void (__stdcall *glGetProgramStringARB)(GLenum target, GLenum pname, void *string) = 0;
GLboolean (__stdcall *glIsProgramARB)(GLuint program) = 0;
*/
// declared in vertex shader

int CGLExtensionHandler::n_GetFragmentProgramARBFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetFragmentProgramARBFuncPointers");

	int n_failed_functions = 0;

	if(!(glProgramStringARB = (void(__stdcall*)(GLenum, GLenum, GLsizei, const void*))wglGetProcAddress("glProgramStringARB"))) n_failed_functions ++; 
	if(!(glBindProgramARB = (void(__stdcall*)(GLenum, GLuint program))wglGetProcAddress("glBindProgramARB"))) n_failed_functions ++;
	if(!(glDeleteProgramsARB = (void(__stdcall*)(GLsizei, const GLuint *programs))wglGetProcAddress("glDeleteProgramsARB"))) n_failed_functions ++;
	if(!(glGenProgramsARB = (void(__stdcall*)(GLsizei, GLuint *programs))wglGetProcAddress("glGenProgramsARB"))) n_failed_functions ++;
	if(!(glProgramEnvParameter4dARB = (void(__stdcall*)(GLenum, GLuint, double, double, double, double))wglGetProcAddress("glProgramEnvParameter4dARB"))) n_failed_functions ++;
	if(!(glProgramEnvParameter4dvARB = (void(__stdcall*)(GLenum, GLuint, const double*))wglGetProcAddress("glProgramEnvParameter4dvARB"))) n_failed_functions ++;
	if(!(glProgramEnvParameter4fARB = (void(__stdcall*)(GLenum, GLuint, float, float, float, float))wglGetProcAddress("glProgramEnvParameter4fARB"))) n_failed_functions ++;
	if(!(glProgramEnvParameter4fvARB = (void(__stdcall*)(GLenum, GLuint, const float*))wglGetProcAddress("glProgramEnvParameter4fvARB"))) n_failed_functions ++;
	if(!(glProgramLocalParameter4dARB = (void(__stdcall*)(GLenum, GLuint, double, double, double, double))wglGetProcAddress("glProgramLocalParameter4dARB"))) n_failed_functions ++;
	if(!(glProgramLocalParameter4dvARB = (void(__stdcall*)(GLenum, GLuint, const double*))wglGetProcAddress("glProgramLocalParameter4dvARB"))) n_failed_functions ++;
	if(!(glProgramLocalParameter4fARB = (void(__stdcall*)(GLenum, GLuint, float, float, float, float))wglGetProcAddress("glProgramLocalParameter4fARB"))) n_failed_functions ++;
	if(!(glProgramLocalParameter4fvARB = (void(__stdcall*)(GLenum, GLuint, const float*))wglGetProcAddress("glProgramLocalParameter4fvARB"))) n_failed_functions ++;
	if(!(glGetProgramEnvParameterdvARB = (void(__stdcall*)(GLenum, GLuint, double*))wglGetProcAddress("glGetProgramEnvParameterdvARB"))) n_failed_functions ++;
	if(!(glGetProgramEnvParameterfvARB = (void(__stdcall*)(GLenum, GLuint, float*))wglGetProcAddress("glGetProgramEnvParameterfvARB"))) n_failed_functions ++;
	if(!(glGetProgramLocalParameterdvARB = (void(__stdcall*)(GLenum, GLuint, double*))wglGetProcAddress("glGetProgramLocalParameterdvARB"))) n_failed_functions ++;
	if(!(glGetProgramLocalParameterfvARB = (void(__stdcall*)(GLenum, GLuint, float*))wglGetProcAddress("glGetProgramLocalParameterfvARB"))) n_failed_functions ++;
	if(!(glGetProgramivARB = (void(__stdcall*)(GLenum, GLenum, int*))wglGetProcAddress("glGetProgramivARB"))) n_failed_functions ++;
	if(!(glGetProgramStringARB = (void(__stdcall*)(GLenum, GLenum, void*))wglGetProcAddress("glGetProgramStringARB"))) n_failed_functions ++;
	if(!(glIsProgramARB = (GLboolean(__stdcall*)(GLuint program))wglGetProcAddress("glIsProgramARB"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *				--- GL_ARB_vertex_shader ---
 */

/*void (__stdcall *glVertexAttrib1fARB)(GLuint index, float v0) = 0;
void (__stdcall *glVertexAttrib1sARB)(GLuint index, short v0) = 0;
void (__stdcall *glVertexAttrib1dARB)(GLuint index, double v0) = 0;
void (__stdcall *glVertexAttrib2fARB)(GLuint index, float v0, float v1) = 0;
void (__stdcall *glVertexAttrib2sARB)(GLuint index, short v0, short v1) = 0;
void (__stdcall *glVertexAttrib2dARB)(GLuint index, double v0, double v1) = 0;
void (__stdcall *glVertexAttrib3fARB)(GLuint index, float v0, float v1, float v2) = 0;
void (__stdcall *glVertexAttrib3sARB)(GLuint index, short v0, short v1, short v2) = 0;
void (__stdcall *glVertexAttrib3dARB)(GLuint index, double v0, double v1, double v2) = 0;
void (__stdcall *glVertexAttrib4fARB)(GLuint index, float v0, float v1, float v2, float v3) = 0;
void (__stdcall *glVertexAttrib4sARB)(GLuint index, short v0, short v1, short v2, short v3) = 0;
void (__stdcall *glVertexAttrib4dARB)(GLuint index, double v0, double v1, double v2, double v3) = 0;
void (__stdcall *glVertexAttrib4NubARB)(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w) = 0;
void (__stdcall *glVertexAttrib1fvARB)(GLuint index, const float *v) = 0;
void (__stdcall *glVertexAttrib1svARB)(GLuint index, const short *v) = 0;
void (__stdcall *glVertexAttrib1dvARB)(GLuint index, const double *v) = 0;
void (__stdcall *glVertexAttrib2fvARB)(GLuint index, const float *v) = 0;
void (__stdcall *glVertexAttrib2svARB)(GLuint index, const short *v) = 0;
void (__stdcall *glVertexAttrib2dvARB)(GLuint index, const double *v) = 0;
void (__stdcall *glVertexAttrib3fvARB)(GLuint index, const float *v) = 0;
void (__stdcall *glVertexAttrib3svARB)(GLuint index, const short *v) = 0;
void (__stdcall *glVertexAttrib3dvARB)(GLuint index, const double *v) = 0;
void (__stdcall *glVertexAttrib4fvARB)(GLuint index, const float *v) = 0;
void (__stdcall *glVertexAttrib4svARB)(GLuint index, const short *v) = 0;
void (__stdcall *glVertexAttrib4dvARB)(GLuint index, const double *v) = 0;
void (__stdcall *glVertexAttrib4ivARB)(GLuint index, const int *v) = 0;
void (__stdcall *glVertexAttrib4bvARB)(GLuint index, const GLbyte *v) = 0;
void (__stdcall *glVertexAttrib4ubvARB)(GLuint index, const GLubyte *v) = 0;
void (__stdcall *glVertexAttrib4usvARB)(GLuint index, const GLushort *v) = 0;
void (__stdcall *glVertexAttrib4uivARB)(GLuint index, const GLuint *v) = 0;
void (__stdcall *glVertexAttrib4NbvARB)(GLuint index, const GLbyte *v) = 0;
void (__stdcall *glVertexAttrib4NsvARB)(GLuint index, const short *v) = 0;
void (__stdcall *glVertexAttrib4NivARB)(GLuint index, const int *v) = 0;
void (__stdcall *glVertexAttrib4NubvARB)(GLuint index, const GLubyte *v) = 0;
void (__stdcall *glVertexAttrib4NusvARB)(GLuint index, const GLushort *v) = 0;
void (__stdcall *glVertexAttrib4NuivARB)(GLuint index, const GLuint *v) = 0;
void (__stdcall *glVertexAttribPointerARB)(GLuint index, int size, GLenum type, GLboolean normalized, GLsizei stride, const void *pointer) = 0;
void (__stdcall *glEnableVertexAttribArrayARB)(GLuint index) = 0;
void (__stdcall *glDisableVertexAttribArrayARB)(GLuint index) = 0;*/
void (__stdcall *glBindAttribLocationARB)(GLhandleARB programObj, GLuint index, const GLcharARB *name) = 0;
void (__stdcall *glGetActiveAttribARB)(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, int *size, GLenum *type, GLcharARB *name) = 0;
int (__stdcall *glGetAttribLocationARB)(GLhandleARB programObj, const GLcharARB *name) = 0;
/*void (__stdcall *glGetVertexAttribdvARB)(GLuint index, GLenum pname, double *params) = 0;
void (__stdcall *glGetVertexAttribfvARB)(GLuint index, GLenum pname, float *params) = 0;
void (__stdcall *glGetVertexAttribivARB)(GLuint index, GLenum pname, int *params) = 0;
void (__stdcall *glGetVertexAttribPointervARB)(GLuint index, GLenum pname, void **pointer) = 0;*/
// some functions declared in vertex program

int CGLExtensionHandler::n_GetVertexShaderARBFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetVertexShaderARBFuncPointers");

	int n_failed_functions = 0;

	if(!(glVertexAttrib1fARB = (void(__stdcall*)(GLuint, float))wglGetProcAddress("glVertexAttrib1fARB"))) n_failed_functions ++;
	if(!(glVertexAttrib1sARB = (void(__stdcall*)(GLuint, short))wglGetProcAddress("glVertexAttrib1sARB"))) n_failed_functions ++;
	if(!(glVertexAttrib1dARB = (void(__stdcall*)(GLuint, double))wglGetProcAddress("glVertexAttrib1dARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2fARB = (void(__stdcall*)(GLuint, float, float))wglGetProcAddress("glVertexAttrib2fARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2sARB = (void(__stdcall*)(GLuint, short, short))wglGetProcAddress("glVertexAttrib2sARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2dARB = (void(__stdcall*)(GLuint, double, double))wglGetProcAddress("glVertexAttrib2dARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3fARB = (void(__stdcall*)(GLuint, float, float, float))wglGetProcAddress("glVertexAttrib3fARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3sARB = (void(__stdcall*)(GLuint, short, short, short))wglGetProcAddress("glVertexAttrib3sARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3dARB = (void(__stdcall*)(GLuint, double, double, double))wglGetProcAddress("glVertexAttrib3dARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4fARB = (void(__stdcall*)(GLuint, float, float, float, float))wglGetProcAddress("glVertexAttrib4fARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4sARB = (void(__stdcall*)(GLuint, short, short, short, short))wglGetProcAddress("glVertexAttrib4sARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4dARB = (void(__stdcall*)(GLuint, double, double, double, double))wglGetProcAddress("glVertexAttrib4dARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NubARB = (void(__stdcall*)(GLuint, GLubyte, GLubyte, GLubyte, GLubyte))wglGetProcAddress("glVertexAttrib4NubARB"))) n_failed_functions ++;
	if(!(glVertexAttrib1fvARB = (void(__stdcall*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib1fvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib1svARB = (void(__stdcall*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib1svARB"))) n_failed_functions ++;
	if(!(glVertexAttrib1dvARB = (void(__stdcall*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib1dvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2fvARB = (void(__stdcall*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib2fvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2svARB = (void(__stdcall*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib2svARB"))) n_failed_functions ++;
	if(!(glVertexAttrib2dvARB = (void(__stdcall*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib2dvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3fvARB = (void(__stdcall*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib3fvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3svARB = (void(__stdcall*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib3svARB"))) n_failed_functions ++;
	if(!(glVertexAttrib3dvARB = (void(__stdcall*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib3dvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4fvARB = (void(__stdcall*)(GLuint, const float*))wglGetProcAddress("glVertexAttrib4fvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4svARB = (void(__stdcall*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib4svARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4dvARB = (void(__stdcall*)(GLuint, const double*))wglGetProcAddress("glVertexAttrib4dvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4ivARB = (void(__stdcall*)(GLuint, const int*))wglGetProcAddress("glVertexAttrib4ivARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4bvARB = (void(__stdcall*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4bvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4ubvARB = (void(__stdcall*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4ubvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4usvARB = (void(__stdcall*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4usvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4uivARB = (void(__stdcall*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4uivARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NbvARB = (void(__stdcall*)(GLuint, const GLbyte*))wglGetProcAddress("glVertexAttrib4NbvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NsvARB = (void(__stdcall*)(GLuint, const short*))wglGetProcAddress("glVertexAttrib4NsvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NivARB = (void(__stdcall*)(GLuint, const int*))wglGetProcAddress("glVertexAttrib4NivARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NubvARB = (void(__stdcall*)(GLuint, const GLubyte*))wglGetProcAddress("glVertexAttrib4NubvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NusvARB = (void(__stdcall*)(GLuint, const GLushort*))wglGetProcAddress("glVertexAttrib4NusvARB"))) n_failed_functions ++;
	if(!(glVertexAttrib4NuivARB = (void(__stdcall*)(GLuint, const GLuint*))wglGetProcAddress("glVertexAttrib4NuivARB"))) n_failed_functions ++;
	if(!(glVertexAttribPointerARB = (void(__stdcall*)(GLuint, int size, GLenum, GLboolean, GLsizei, const void*))wglGetProcAddress("glVertexAttribPointerARB"))) n_failed_functions ++;
	if(!(glEnableVertexAttribArrayARB = (void(__stdcall*)(GLuint))wglGetProcAddress("glEnableVertexAttribArrayARB"))) n_failed_functions ++;
	if(!(glDisableVertexAttribArrayARB = (void(__stdcall*)(GLuint))wglGetProcAddress("glDisableVertexAttribArrayARB"))) n_failed_functions ++;
	if(!(glBindAttribLocationARB = (void(__stdcall*)(GLhandleARB, GLuint, const GLcharARB*))wglGetProcAddress("glBindAttribLocationARB"))) n_failed_functions ++;
	if(!(glGetActiveAttribARB = (void(__stdcall*)(GLhandleARB, GLuint, GLsizei, GLsizei*, int*, GLenum*, GLcharARB*))wglGetProcAddress("glGetActiveAttribARB"))) n_failed_functions ++;
	if(!(glGetAttribLocationARB = (int(__stdcall*)(GLhandleARB, const GLcharARB*))wglGetProcAddress("glGetAttribLocationARB"))) n_failed_functions ++;
	if(!(glGetVertexAttribdvARB = (void(__stdcall*)(GLuint, GLenum, double*))wglGetProcAddress("glGetVertexAttribdvARB"))) n_failed_functions ++;
	if(!(glGetVertexAttribfvARB = (void(__stdcall*)(GLuint, GLenum, float*))wglGetProcAddress("glGetVertexAttribfvARB"))) n_failed_functions ++;
	if(!(glGetVertexAttribivARB = (void(__stdcall*)(GLuint, GLenum, int*))wglGetProcAddress("glGetVertexAttribivARB"))) n_failed_functions ++;
	if(!(glGetVertexAttribPointervARB = (void(__stdcall*)(GLuint, GLenum, void**))wglGetProcAddress("glGetVertexAttribPointervARB"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *				--- GL_ARB_fragment_shader ---
 */

int CGLExtensionHandler::n_GetFragmentShaderARBFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetFragmentShaderARBFuncPointers");

	return 0;
}

/*
 *				--- GL_ARB_shader_object ---
 */

void (__stdcall *glDeleteObjectARB)(GLhandleARB obj) = 0;
GLhandleARB (__stdcall *glGetHandleARB)(GLenum pname) = 0;
void (__stdcall *glDetachObjectARB)(GLhandleARB containerObj, GLhandleARB attachedObj) = 0;
GLhandleARB (__stdcall *glCreateShaderObjectARB)(GLenum shaderType) = 0;
void (__stdcall *glShaderSourceARB)(GLhandleARB shaderObj, GLsizei count, const GLcharARB **string, const int *length) = 0;
void (__stdcall *glCompileShaderARB)(GLhandleARB shaderObj) = 0;
GLhandleARB (__stdcall *glCreateProgramObjectARB)(void) = 0;
void (__stdcall *glAttachObjectARB)(GLhandleARB containerObj, GLhandleARB obj) = 0;
void (__stdcall *glLinkProgramARB)(GLhandleARB programObj) = 0;
void (__stdcall *glUseProgramObjectARB)(GLhandleARB programObj) = 0;
void (__stdcall *glValidateProgramARB)(GLhandleARB programObj) = 0;
void (__stdcall *glUniform1fARB)(int location, float v0) = 0;
void (__stdcall *glUniform2fARB)(int location, float v0, float v1) = 0;
void (__stdcall *glUniform3fARB)(int location, float v0, float v1, float v2) = 0;
void (__stdcall *glUniform4fARB)(int location, float v0, float v1, float v2, float v3) = 0;
void (__stdcall *glUniform1iARB)(int location, int v0) = 0;
void (__stdcall *glUniform2iARB)(int location, int v0, int v1) = 0;
void (__stdcall *glUniform3iARB)(int location, int v0, int v1, int v2) = 0;
void (__stdcall *glUniform4iARB)(int location, int v0, int v1, int v2, int v3) = 0;
void (__stdcall *glUniform1fvARB)(int location, GLsizei count, const float *value) = 0;
void (__stdcall *glUniform2fvARB)(int location, GLsizei count, const float *value) = 0;
void (__stdcall *glUniform3fvARB)(int location, GLsizei count, const float *value) = 0;
void (__stdcall *glUniform4fvARB)(int location, GLsizei count, const float *value) = 0;
void (__stdcall *glUniform1ivARB)(int location, GLsizei count, const int *value) = 0;
void (__stdcall *glUniform2ivARB)(int location, GLsizei count, const int *value) = 0;
void (__stdcall *glUniform3ivARB)(int location, GLsizei count, const int *value) = 0;
void (__stdcall *glUniform4ivARB)(int location, GLsizei count, const int *value) = 0;
void (__stdcall *glUniformMatrix2fvARB)(int location, GLsizei count, GLboolean transpose, const float *value) = 0;
void (__stdcall *glUniformMatrix3fvARB)(int location, GLsizei count, GLboolean transpose, const float *value) = 0;
void (__stdcall *glUniformMatrix4fvARB)(int location, GLsizei count, GLboolean transpose, const float *value) = 0;
void (__stdcall *glGetObjectParameterfvARB)(GLhandleARB obj, GLenum pname, float *params) = 0;
void (__stdcall *glGetObjectParameterivARB)(GLhandleARB obj, GLenum pname, int *params) = 0;
void (__stdcall *glGetInfoLogARB)(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *infoLog) = 0;
void (__stdcall *glGetAttachedObjectsARB)(GLhandleARB containerObj, GLsizei maxCount, GLsizei *count, GLhandleARB *obj) = 0;
int (__stdcall *glGetUniformLocationARB)(GLhandleARB programObj, const GLcharARB *name) = 0;
void (__stdcall *glGetActiveUniformARB)(GLhandleARB programObj, GLuint index, GLsizei maxLength, GLsizei *length, int *size, GLenum *type, GLcharARB *name) = 0;
void (__stdcall *glGetUniformfvARB)(GLhandleARB programObj, int location, float *params) = 0;
void (__stdcall *glGetUniformivARB)(GLhandleARB programObj, int location, int *params) = 0;
void (__stdcall *glGetShaderSourceARB)(GLhandleARB obj, GLsizei maxLength, GLsizei *length, GLcharARB *source) = 0;

int CGLExtensionHandler::n_GetShaderObjectARBFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetShaderObjectARBFuncPointers");

	int n_failed_functions = 0;

	if(!(glDeleteObjectARB = (void(__stdcall*)(GLhandleARB))wglGetProcAddress("glDeleteObjectARB"))) n_failed_functions ++;
	if(!(glGetHandleARB = (GLhandleARB(__stdcall*)(GLenum))wglGetProcAddress("glGetHandleARB"))) n_failed_functions ++;
	if(!(glDetachObjectARB = (void(__stdcall*)(GLhandleARB, GLhandleARB))wglGetProcAddress("glDetachObjectARB"))) n_failed_functions ++;
	if(!(glCreateShaderObjectARB = (GLhandleARB(__stdcall*)(GLenum))wglGetProcAddress("glCreateShaderObjectARB"))) n_failed_functions ++;
	if(!(glShaderSourceARB = (void(__stdcall*)(GLhandleARB, GLsizei, const GLcharARB**, const int*))wglGetProcAddress("glShaderSourceARB"))) n_failed_functions ++;
	if(!(glCompileShaderARB = (void(__stdcall*)(GLhandleARB))wglGetProcAddress("glCompileShaderARB"))) n_failed_functions ++;
	if(!(glCreateProgramObjectARB = (GLhandleARB(__stdcall*)(void))wglGetProcAddress("glCreateProgramObjectARB"))) n_failed_functions ++;
	if(!(glAttachObjectARB = (void(__stdcall*)(GLhandleARB, GLhandleARB))wglGetProcAddress("glAttachObjectARB"))) n_failed_functions ++;
	if(!(glLinkProgramARB = (void(__stdcall*)(GLhandleARB))wglGetProcAddress("glLinkProgramARB"))) n_failed_functions ++;
	if(!(glUseProgramObjectARB = (void(__stdcall*)(GLhandleARB))wglGetProcAddress("glUseProgramObjectARB"))) n_failed_functions ++;
	if(!(glValidateProgramARB = (void(__stdcall*)(GLhandleARB))wglGetProcAddress("glValidateProgramARB"))) n_failed_functions ++;
	if(!(glUniform1fARB = (void(__stdcall*)(int, float))wglGetProcAddress("glUniform1fARB"))) n_failed_functions ++;
	if(!(glUniform2fARB = (void(__stdcall*)(int, float, float))wglGetProcAddress("glUniform2fARB"))) n_failed_functions ++;
	if(!(glUniform3fARB = (void(__stdcall*)(int, float, float, float))wglGetProcAddress("glUniform3fARB"))) n_failed_functions ++;
	if(!(glUniform4fARB = (void(__stdcall*)(int, float, float, float, float))wglGetProcAddress("glUniform4fARB"))) n_failed_functions ++;
	if(!(glUniform1iARB = (void(__stdcall*)(int, int))wglGetProcAddress("glUniform1iARB"))) n_failed_functions ++;
	if(!(glUniform2iARB = (void(__stdcall*)(int, int, int))wglGetProcAddress("glUniform2iARB"))) n_failed_functions ++;
	if(!(glUniform3iARB = (void(__stdcall*)(int, int, int, int))wglGetProcAddress("glUniform3iARB"))) n_failed_functions ++;
	if(!(glUniform4iARB = (void(__stdcall*)(int, int, int, int, int))wglGetProcAddress("glUniform4iARB"))) n_failed_functions ++;
	if(!(glUniform1fvARB = (void(__stdcall*)(int, GLsizei, const float*))wglGetProcAddress("glUniform1fvARB"))) n_failed_functions ++;
	if(!(glUniform2fvARB = (void(__stdcall*)(int, GLsizei, const float*))wglGetProcAddress("glUniform2fvARB"))) n_failed_functions ++;
	if(!(glUniform3fvARB = (void(__stdcall*)(int, GLsizei, const float*))wglGetProcAddress("glUniform3fvARB"))) n_failed_functions ++;
	if(!(glUniform4fvARB = (void(__stdcall*)(int, GLsizei, const float*))wglGetProcAddress("glUniform4fvARB"))) n_failed_functions ++;
	if(!(glUniform1ivARB = (void(__stdcall*)(int, GLsizei, const int*))wglGetProcAddress("glUniform1ivARB"))) n_failed_functions ++;
	if(!(glUniform2ivARB = (void(__stdcall*)(int, GLsizei, const int*))wglGetProcAddress("glUniform2ivARB"))) n_failed_functions ++;
	if(!(glUniform3ivARB = (void(__stdcall*)(int, GLsizei, const int*))wglGetProcAddress("glUniform3ivARB"))) n_failed_functions ++;
	if(!(glUniform4ivARB = (void(__stdcall*)(int, GLsizei, const int*))wglGetProcAddress("glUniform4ivARB"))) n_failed_functions ++;
	if(!(glUniformMatrix2fvARB = (void(__stdcall*)(int, GLsizei, GLboolean, const float*))wglGetProcAddress("glUniformMatrix2fvARB"))) n_failed_functions ++;
	if(!(glUniformMatrix3fvARB = (void(__stdcall*)(int, GLsizei, GLboolean, const float*))wglGetProcAddress("glUniformMatrix3fvARB"))) n_failed_functions ++;
	if(!(glUniformMatrix4fvARB = (void(__stdcall*)(int, GLsizei, GLboolean, const float*))wglGetProcAddress("glUniformMatrix4fvARB"))) n_failed_functions ++;
	if(!(glGetObjectParameterfvARB = (void(__stdcall*)(GLhandleARB, GLenum, float*))wglGetProcAddress("glGetObjectParameterfvARB"))) n_failed_functions ++;
	if(!(glGetObjectParameterivARB = (void(__stdcall*)(GLhandleARB, GLenum, int*))wglGetProcAddress("glGetObjectParameterivARB"))) n_failed_functions ++;
	if(!(glGetInfoLogARB = (void(__stdcall*)(GLhandleARB, GLsizei, GLsizei*, GLcharARB*))wglGetProcAddress("glGetInfoLogARB"))) n_failed_functions ++;
	if(!(glGetAttachedObjectsARB = (void(__stdcall*)(GLhandleARB, GLsizei, GLsizei *count, GLhandleARB*))wglGetProcAddress("glGetAttachedObjectsARB"))) n_failed_functions ++;
	if(!(glGetUniformLocationARB = (int(__stdcall*)(GLhandleARB, const GLcharARB*))wglGetProcAddress("glGetUniformLocationARB"))) n_failed_functions ++;
	if(!(glGetActiveUniformARB = (void(__stdcall*)(GLhandleARB, GLuint, GLsizei, GLsizei*, int*, GLenum*, GLcharARB*))wglGetProcAddress("glGetActiveUniformARB"))) n_failed_functions ++;
	if(!(glGetUniformfvARB = (void(__stdcall*)(GLhandleARB, int, float*))wglGetProcAddress("glGetUniformfvARB"))) n_failed_functions ++;
	if(!(glGetUniformivARB = (void(__stdcall*)(GLhandleARB, int, int*))wglGetProcAddress("glGetUniformivARB"))) n_failed_functions ++;
	if(!(glGetShaderSourceARB = (void(__stdcall*)(GLhandleARB, GLsizei, GLsizei*, GLcharARB*))wglGetProcAddress("glGetShaderSourceARB"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *				--- GL_ARB_vertex_buffer_object ---
 */

void (__stdcall *glBindBufferARB)(GLenum target, GLuint buffer) = 0;
void (__stdcall *glDeleteBuffersARB)(GLsizei n, const GLuint *buffers) = 0;
void (__stdcall *glGenBuffersARB)(GLsizei n, GLuint *buffers) = 0;
GLboolean (__stdcall *glIsBufferARB)(GLuint buffer) = 0;
void (__stdcall *glBufferDataARB)(GLenum target, GLsizeiptrARB size, const void *data, GLenum usage) = 0;
void (__stdcall *glBufferSubDataARB)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const void *data) = 0;
void (__stdcall *glGetBufferSubDataARB)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, void *data) = 0;
void *(__stdcall *glMapBufferARB)(GLenum target, GLenum access) = 0;
GLboolean (__stdcall *glUnmapBufferARB)(GLenum target) = 0;
void (__stdcall *glGetBufferParameterivARB)(GLenum target, GLenum pname, int *params) = 0;
void (__stdcall *glGetBufferPointervARB)(GLenum target, GLenum pname, void **params) = 0;

int CGLExtensionHandler::n_GetVertexBufferObjectARBFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetVertexBufferObjectARBFuncPointers");

	int n_failed_functions = 0;

	if(!(glBindBufferARB = (void(__stdcall*)(GLenum target, GLuint buffer))wglGetProcAddress("glBindBufferARB"))) n_failed_functions ++;
	if(!(glDeleteBuffersARB = (void(__stdcall*)(GLsizei n, const GLuint *buffers))wglGetProcAddress("glDeleteBuffersARB"))) n_failed_functions ++;
	if(!(glGenBuffersARB = (void(__stdcall*)(GLsizei n, GLuint *buffers))wglGetProcAddress("glGenBuffersARB"))) n_failed_functions ++;
	if(!(glIsBufferARB = (GLboolean(__stdcall*)(GLuint buffer))wglGetProcAddress("glIsBufferARB"))) n_failed_functions ++;
	if(!(glBufferDataARB = (void(__stdcall*)(GLenum target, GLsizeiptrARB size, const void *data, GLenum usage))wglGetProcAddress("glBufferDataARB"))) n_failed_functions ++;
	if(!(glBufferSubDataARB = (void(__stdcall*)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, const void *data))wglGetProcAddress("glBufferSubDataARB"))) n_failed_functions ++;
	if(!(glGetBufferSubDataARB = (void(__stdcall*)(GLenum target, GLintptrARB offset, GLsizeiptrARB size, void *data))wglGetProcAddress("glGetBufferSubDataARB"))) n_failed_functions ++;
	if(!(glMapBufferARB = (void*(__stdcall*)(GLenum target, GLenum access))wglGetProcAddress("glMapBufferARB"))) n_failed_functions ++;
	if(!(glUnmapBufferARB = (GLboolean(__stdcall*)(GLenum target))wglGetProcAddress("glUnmapBufferARB"))) n_failed_functions ++;
	if(!(glGetBufferParameterivARB = (void(__stdcall*)(GLenum target, GLenum pname, int *params))wglGetProcAddress("glGetBufferParameterivARB"))) n_failed_functions ++;
	if(!(glGetBufferPointervARB = (void(__stdcall*)(GLenum target, GLenum pname, void **params))wglGetProcAddress("glGetBufferPointervARB"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *				--- GL_NV_fence ---
 */

void (__stdcall *glGenFencesNV)(GLsizei n, GLuint *fences);
void (__stdcall *glDeleteFencesNV)(GLsizei n, const GLuint *fences);
void (__stdcall *glSetFenceNV)(GLuint fence, GLenum condition);
GLboolean (__stdcall *glTestFenceNV)(GLuint fence);
void (__stdcall *glFinishFenceNV)(GLuint fence);
GLboolean (__stdcall *glIsFenceNV)(GLuint fence);
void (__stdcall *glGetFenceivNV)(GLuint fence, GLenum pname, int *params);

int CGLExtensionHandler::n_GetFenceNVFuncPointers()
{
	__FuncGuard("CGLExtensionHandler::n_GetFenceNVFuncPointers");

	int n_failed_functions = 0;

	if(!(glGenFencesNV = (void(__stdcall*)(GLsizei n, GLuint *fences))wglGetProcAddress("glGenFencesNV"))) n_failed_functions ++;
	if(!(glDeleteFencesNV = (void(__stdcall*)(GLsizei n, const GLuint *fences))wglGetProcAddress("glDeleteFencesNV"))) n_failed_functions ++;
	if(!(glSetFenceNV = (void(__stdcall*)(GLuint fence, GLenum condition))wglGetProcAddress("glSetFenceNV"))) n_failed_functions ++;
	if(!(glTestFenceNV = (GLboolean(__stdcall*)(GLuint fence))wglGetProcAddress("glTestFenceNV"))) n_failed_functions ++;
	if(!(glFinishFenceNV = (void(__stdcall*)(GLuint fence))wglGetProcAddress("glFinishFenceNV"))) n_failed_functions ++;
	if(!(glIsFenceNV = (GLboolean(__stdcall*)(GLuint fence))wglGetProcAddress("glIsFenceNV"))) n_failed_functions ++;
	if(!(glGetFenceivNV = (void(__stdcall*)(GLuint fence, GLenum pname, int *params))wglGetProcAddress("glGetFenceivNV"))) n_failed_functions ++;

	return n_failed_functions;
}

/*
 *								=== ~CGLExtensionHandler ===
 */

/*
 *		-end-of-file-
 */
