/*
								+---------------------------------+
								|                                 |
								|     ***   Jpeg support   ***    |
								|                                 |
								|  Copyright   -tHE SWINe- 2003  |
								|                                 |
								|            jpeg.cpp             |
								|                                 |
								+---------------------------------+
*/

#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#define __declspec(x)

#include "jpeg.h"
#include "jpeglib.h"

//using namespace jpeglib;

void DecodeJPG(jpeg_decompress_struct* cinfo, tImage *pImageData)
{
	// Read in the header of the jpeg file
	jpeg_read_header(cinfo, TRUE);
	
	// Start to decompress the jpeg file with our compression info
	jpeg_start_decompress(cinfo);

	// Get the image dimensions and channels to read in the pixel data
	pImageData->channels = cinfo->num_components;
	pImageData->sizeX    = cinfo->image_width;
	pImageData->sizeY    = cinfo->image_height;

	// Get the row span in p_buffer for each row
	int rowSpan = cinfo->image_width * cinfo->num_components;
	
	// Allocate memory for the pixel buffer
	pImageData->data = ((unsigned char*)::malloc(sizeof(unsigned char)*rowSpan*pImageData->sizeY));
			
	// Create an array of row pointers
	unsigned char** rowPtr = new unsigned char*[pImageData->sizeY];

	for (int i = 0; i < pImageData->sizeY; i++)
		rowPtr[i] = &(pImageData->data[i * rowSpan]);

	// Now comes the juice of our work, here we extract all the pixel data
	int rowsRead = 0;
	while (cinfo->output_scanline < cinfo->output_height) 
	{
		// Read in the current row of pixels and increase the rowsRead count
		rowsRead += jpeg_read_scanlines(cinfo, 
										&rowPtr[rowsRead], cinfo->output_height - rowsRead);
	}
	
	// Delete the temporary row pointers
	delete [] rowPtr;

	// Finish decompressing the data
	jpeg_finish_decompress(cinfo);
}

tImage *LoadJPG(const char *strFileName)
{
	struct jpeg_decompress_struct cinfo;
	tImage *pImageData = NULL, *p_new;
	FILE *pFile;
	int i;
		
	// Open a file pointer to the jpeg file and check if it was found and opened 
	if((pFile = fopen(strFileName, "rb")) == NULL) 
	{
		// Display an error message saying the file was not found, then return NULL
		//MessageBox(g_hWnd, "Unable to load JPG File!", "Error", MB_OK);
		return NULL;
	}
	
	// Create an error handler
	jpeg_error_mgr jerr;

	// Have our compression info object point to the error handler address
	cinfo.err = jpeg_std_error(&jerr);
	
	// Initialize the decompression object
	jpeg_create_decompress(&cinfo);
	
	// Specify the data source (Our file pointer)	
	jpeg_stdio_src(&cinfo, pFile);
	
	// Allocate the structure that will hold our eventual jpeg data (must ::free it!)
	pImageData = (tImage*)::malloc(sizeof(tImage));

	// Decode the jpeg file and fill in the image data structure to pass back
	DecodeJPG(&cinfo, pImageData);
	
	// This releases all the stored memory for reading and decoding the jpeg
	jpeg_destroy_decompress(&cinfo);
	
	// Close the file pointer that opened the file
	fclose(pFile);

	if(pImageData->channels == 3) {
		p_new = (tImage*)::malloc(sizeof(tImage));
		p_new->channels = 4;
		p_new->sizeX = pImageData->sizeX;
		p_new->sizeY = pImageData->sizeY;
		p_new->data = (unsigned char*)::malloc(pImageData->sizeX * 4 * pImageData->sizeY);
		//
		for(i = 0; i < pImageData->sizeX * pImageData->sizeY; i ++) {
			p_new->data[i * 4 + 2] = pImageData->data[i * 3 + 2];
			p_new->data[i * 4 + 1] = pImageData->data[i * 3 + 1];
			p_new->data[i * 4 + 0] = pImageData->data[i * 3 + 0];
			p_new->data[i * 4 + 3] = 0xff;
		}
		// rgb -> bgra

		::free(pImageData->data);
		::free(pImageData);

		return p_new;
	} else if(pImageData->channels == 4) {
		for(i = 0; i < pImageData->sizeX * pImageData->sizeY; i ++) {
			pImageData->data[i * 4 + 2] = pImageData->data[i * 4 + 2];
			pImageData->data[i * 4 + 1] = pImageData->data[i * 4 + 1];
			pImageData->data[i * 4 + 0] = pImageData->data[i * 4 + 0];
		}
		// rgba -> bgra
	} else {
		::free(pImageData->data);
		::free(pImageData);
		//
		return NULL;
	}

	// Return the jpeg data (remember, you must ::free this data after you are done)
	return pImageData;
}

tImage *LoadJPG(FILE *pFile)
{
	struct jpeg_decompress_struct cinfo;
	tImage *pImageData = NULL, *p_new;
	int i;
	
	// Create an error handler
	jpeg_error_mgr jerr;

	// Have our compression info object point to the error handler address
	cinfo.err = jpeg_std_error(&jerr);
	
	// Initialize the decompression object
	jpeg_create_decompress(&cinfo);
	
	// Specify the data source (Our file pointer)	
	jpeg_stdio_src(&cinfo, pFile);
	
	// Allocate the structure that will hold our eventual jpeg data (must ::free it!)
	pImageData = (tImage*)::malloc(sizeof(tImage));

	// Decode the jpeg file and fill in the image data structure to pass back
	DecodeJPG(&cinfo, pImageData);
	
	// This releases all the stored memory for reading and decoding the jpeg
	jpeg_destroy_decompress(&cinfo);

	if(pImageData->channels == 3) {
		p_new = (tImage*)::malloc(sizeof(tImage));
		p_new->channels = 4;
		p_new->sizeX = pImageData->sizeX;
		p_new->sizeY = pImageData->sizeY;
		p_new->data = (unsigned char*)::malloc(pImageData->sizeX * 4 * pImageData->sizeY);
		//
		for(i = 0; i < pImageData->sizeX * pImageData->sizeY; i ++) {
			p_new->data[i * 4 + 0] = pImageData->data[i * 3 + 2];
			p_new->data[i * 4 + 1] = pImageData->data[i * 3 + 1];
			p_new->data[i * 4 + 2] = pImageData->data[i * 3 + 0];
			p_new->data[i * 4 + 3] = 0xff;
		}
		// rgb -> bgra

		::free(pImageData->data);
		::free(pImageData);

		return p_new;
	} else if(pImageData->channels == 4) {
		for(i = 0; i < pImageData->sizeX * pImageData->sizeY; i ++) {
			pImageData->data[i * 4 + 0] = pImageData->data[i * 4 + 2];
			pImageData->data[i * 4 + 1] = pImageData->data[i * 4 + 1];
			pImageData->data[i * 4 + 2] = pImageData->data[i * 4 + 0];
		}
		// rgba -> bgra
	} else {
		::free(pImageData->data);
		::free(pImageData);
		//
		return NULL;
	}

	// Return the jpeg data (remember, you must ::free this data after you are done)
	return pImageData;
}

/*
 *		-end-of-file-
 */
