//---------------------------------------------------------------------------
//	AVFile - library for audio and video files processing
//  2002 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//  fffile.h
//  ffmpeg file reader and writer
//---------------------------------------------------------------------------

#ifndef _FFFILE_H
#define _FFFILE_H

#include "avfile.h"

class TFFFileI;

class TFFFile: public TAVFile {
private:
  TFFFileI *Internal;
  unsigned int AudioLength, Length, FrameInBuffer, OutputBufferSize, AudioOutputBufferSize, AudioInputFrameSize, AudioInputFramePos, AudioSampleSize;
  BYTE *FrameBuffer, *OutputBuffer, *AudioOutputBuffer, *AudioInputFrame;
 
  bool ReadVideoFrame(bool Skip);
  bool FindVideoFrame();

  static int Count;
  static bool Registered;
  static void Register();
  static void UnRegister();
protected:
	void OpenA(const char *FileName, int Mode, int Type, bool ThrowExceptions);
  BYTE* GetFrameB(unsigned int Position);
public:
  TFFFile();
  ~TFFFile();

  void Close();
  void Seek(unsigned int Frame);

  void SkipFrames(unsigned int Frames);
  void PutFrame(BYTE *Buffer);
  void SeekVideo(unsigned int Frame);
  unsigned int GetVideoLength();

  BYTE* GetAudio(unsigned int &Size);
  void SkipAudio();
  void PutAudio(BYTE *Buffer, unsigned int Size);
  void SeekAudio(unsigned int Sample);
  unsigned int GetAudioLength();

  int GetAudioSkew();
};
#endif
