//---------------------------------------------------------------------------
//	AVFile - library for audio and video files processing
//  2002 - 2007 Stanislav Sumec <sumec@fit.vutbr.cz>
//
//	dsfile.h
//  DirectShow file reader
//---------------------------------------------------------------------------

#ifndef _DSFILE_H
#define _DSFILE_H

#include "avfile.h"

//---------------------------------------------------------------------------
class TDSFileI;

//---------------------------------------------------------------------------
class TDSFile: public TAVFile {
private:
  TDSFileI *Internal;
  bool CoInitialized;

  unsigned int ScanLineWidth, AlignedScanLineWidth, BitmapDataSize, AudioBufferSize;
  unsigned int Length, FrameInBuffer, AudioLength;
  long AudioTransfered, BitmapTransfered;

  BITMAPINFO *Bitmap;
  BYTE *BitmapData, *FrameBuffer, *AudioBuffer;
protected:
	void OpenA(const char *FileName, int Mode, int Type, bool ThrowExceptions);
  BYTE* GetFrameB(unsigned int Position);
  void GetFrameB2(BYTE *Buffer, unsigned int Position);
  BITMAPINFO* DIBGetFrameB(unsigned int Position);
public:
  TDSFile();
  ~TDSFile();

  void Close();
  void Seek(unsigned int Frame);

  void SkipFrames(unsigned int Frames);
  unsigned int GetVideoLength();
  void SeekVideo(unsigned int Frame);

  BYTE* GetAudio(unsigned int &Size);
  void SkipAudio();
  unsigned int GetAudioLength();
  void SeekAudio(unsigned int Sample);
};
#endif

